/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import joptsimple.OptionSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.node.Node;

public class UnsafeBootstrapMasterCommand
extends ElasticsearchNodeCommand {
    static final String CLUSTER_STATE_TERM_VERSION_MSG_FORMAT = "Current node cluster state (term, version) pair is (%s, %s)";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have permanently lost half or more\nof the master-eligible nodes in this cluster, and you cannot restore the\ncluster from a snapshot. This tool can cause arbitrary data loss and its\nuse should be your last resort. If you have multiple surviving master\neligible nodes, you should run this tool on the node with the highest\ncluster state (term, version) pair.\n\nDo you want to proceed?\n";
    static final String NOT_MASTER_NODE_MSG = "unsafe-bootstrap tool can only be run on master eligible node";
    static final String EMPTY_LAST_COMMITTED_VOTING_CONFIG_MSG = "last committed voting voting configuration is empty, cluster has never been bootstrapped?";
    static final String MASTER_NODE_BOOTSTRAPPED_MSG = "Master node was successfully bootstrapped";
    static final Setting<String> UNSAFE_BOOTSTRAP = ClusterService.USER_DEFINED_META_DATA.getConcreteSetting("cluster.metadata.unsafe-bootstrap");

    UnsafeBootstrapMasterCommand() {
        super("Forces the successful election of the current node after the permanent loss of the half or more master-eligible nodes");
    }

    @Override
    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        Settings settings = env.settings();
        terminal.println(Terminal.Verbosity.VERBOSE, "Checking node.master setting");
        Boolean master = Node.NODE_MASTER_SETTING.get(settings);
        if (!master.booleanValue()) {
            throw new ElasticsearchException(NOT_MASTER_NODE_MSG, new Object[0]);
        }
        return true;
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException {
        PersistedClusterStateService persistedClusterStateService = UnsafeBootstrapMasterCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Tuple<Long, ClusterState> state = UnsafeBootstrapMasterCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = (ClusterState)state.v2();
        MetaData metaData = oldClusterState.metaData();
        CoordinationMetaData coordinationMetaData = metaData.coordinationMetaData();
        if (coordinationMetaData == null || coordinationMetaData.getLastCommittedConfiguration() == null || coordinationMetaData.getLastCommittedConfiguration().isEmpty()) {
            throw new ElasticsearchException(EMPTY_LAST_COMMITTED_VOTING_CONFIG_MSG, new Object[0]);
        }
        terminal.println(String.format(Locale.ROOT, CLUSTER_STATE_TERM_VERSION_MSG_FORMAT, coordinationMetaData.term(), metaData.version()));
        CoordinationMetaData newCoordinationMetaData = CoordinationMetaData.builder(coordinationMetaData).clearVotingConfigExclusions().lastAcceptedConfiguration(new CoordinationMetaData.VotingConfiguration(Collections.singleton(persistedClusterStateService.getNodeId()))).lastCommittedConfiguration(new CoordinationMetaData.VotingConfiguration(Collections.singleton(persistedClusterStateService.getNodeId()))).build();
        Settings persistentSettings = Settings.builder().put(metaData.persistentSettings()).put(UNSAFE_BOOTSTRAP.getKey(), true).build();
        MetaData newMetaData = MetaData.builder(metaData).clusterUUID("_na_").generateClusterUuidIfNeeded().clusterUUIDCommitted(true).persistentSettings(persistentSettings).coordinationMetaData(newCoordinationMetaData).build();
        ClusterState newClusterState = ClusterState.builder(oldClusterState).metaData(newMetaData).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + oldClusterState + ", new cluster state = " + newClusterState + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit((Long)state.v1(), newClusterState);
        }
        terminal.println(MASTER_NODE_BOOTSTRAPPED_MSG);
    }
}

