#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 conduit
version:              1.3.4.1
visibility:           public
id:                   conduit-1.3.4.1-1BtK5bRX29l4VANueOokSq
key:                  conduit-1.3.4.1-1BtK5bRX29l4VANueOokSq
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
homepage:             http://github.com/snoyberg/conduit
synopsis:             Streaming data processing library.
description:
    `conduit` is a solution to the streaming data problem, allowing for production,
    transformation, and consumption of streams of data in constant memory. It is an
    alternative to lazy I\/O which guarantees deterministic resource handling.

    For more information about conduit in general, and how this package in
    particular fits into the ecosystem, see [the conduit
    homepage](https://github.com/snoyberg/conduit#readme).

    Hackage documentation generation is not reliable. For up to date documentation, please see: <http://www.stackage.org/package/conduit>.

category:             Data, Conduit
abi:                  07806ed965c01150a7f7c365819a5ee5
exposed:              True
exposed-modules:
    Conduit Data.Conduit Data.Conduit.Combinators
    Data.Conduit.Combinators.Stream Data.Conduit.Internal
    Data.Conduit.Internal.Fusion Data.Conduit.Internal.List.Stream
    Data.Conduit.Lift Data.Conduit.List

hidden-modules:
    Data.Conduit.Internal.Pipe Data.Conduit.Internal.Conduit
    Data.Conduit.Combinators.Unqualified Data.Streaming.FileRead
    Data.Streaming.Filesystem

import-dirs:          /usr/lib/ghc-8.10.5/site-local/conduit-1.3.4.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/conduit-1.3.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/conduit-1.3.4.1
hs-libraries:         HSconduit-1.3.4.1-1BtK5bRX29l4VANueOokSq
depends:
    base-4.14.2.0 bytestring-0.10.12.0 directory-1.3.6.0
    exceptions-0.10.4 filepath-1.4.2.1
    mono-traversable-1.0.15.1-EzQNvlUnxhT4diePDe8JOn mtl-2.2.2
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    resourcet-1.2.4.2-AvaFhfxp8uvAOEEUNRGsFz text-1.2.4.1
    transformers-0.5.6.2 unix-2.7.2.2
    unliftio-core-0.2.0.1-1ibY1oF6Hkc5ZYjZ4yW3Lp
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-conduit/html/conduit.haddock
haddock-html:         /usr/share/doc/haskell-conduit/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

