#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hackage-db
version:              2.1.1
visibility:           public
id:                   hackage-db-2.1.1-GS3i4VnpJzBKCBjS4tRlQ
key:                  hackage-db-2.1.1-GS3i4VnpJzBKCBjS4tRlQ
license:              BSD-3-Clause
maintainer:           Peter Simons <simons@cryp.to>
author:               Peter Simons, Alexander Altman, Ben James, Kevin Quick
homepage:             https://github.com/peti/hackage-db#readme
synopsis:             Access cabal-install'\''s Hackage database via Data.Map
description:
    This library provides convenient access to the local copy of the Hackage
    database that \"cabal update\" creates. Check out
    <https://github.com/peti/hackage-db/tree/master/example/> for a collection
    of simple example programs that demonstrate how to use this code.

category:             Distribution
abi:                  85766edb42259ff5b4fc87b8faa8cebd
exposed:              True
exposed-modules:
    Distribution.Hackage.DB Distribution.Hackage.DB.Builder
    Distribution.Hackage.DB.Errors Distribution.Hackage.DB.MetaData
    Distribution.Hackage.DB.Parsed Distribution.Hackage.DB.Path
    Distribution.Hackage.DB.Unparsed Distribution.Hackage.DB.Utility

hidden-modules:       Paths_hackage_db
import-dirs:          /usr/lib/ghc-8.10.5/site-local/hackage-db-2.1.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hackage-db-2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hackage-db-2.1.1
hs-libraries:         HShackage-db-2.1.1-GS3i4VnpJzBKCBjS4tRlQ
depends:
    Cabal-3.2.1.0 aeson-1.5.6.0-Fw6cTmCp4oOK2plDv84u6I base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1 directory-1.3.6.0
    exceptions-0.10.4 filepath-1.4.2.1
    tar-0.5.1.1-59rMxbo1DhcB07hTSY0rUF time-1.9.3
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du

haddock-interfaces:   /usr/share/doc/haskell-hackage-db/html/hackage-db.haddock
haddock-html:         /usr/share/doc/haskell-hackage-db/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

