#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 incremental-parser
version:              0.5.0.2
visibility:           public
id:                   incremental-parser-0.5.0.2-6Pimv0jS9M421w83VBuWe8
key:                  incremental-parser-0.5.0.2-6Pimv0jS9M421w83VBuWe8
license:              GPL-3.0-only
copyright:            (c) 2011-2018 Mario Blazevic
maintainer:           blamario@yahoo.com
author:               Mario Blazevic
homepage:             https://github.com/blamario/incremental-parser
synopsis:
    Generic parser library capable of providing partial results from partial input.

description:
    This package defines yet another parser combinator library. This one is implemented using the concept of Brzozowski
    derivatives, tweaked and optimized to work with any monoidal input type. Lists, ByteString, and Text are supported out
    of the box, as well as any other data type for which the monoid-subclasses package defines instances. If the parser
    result is also a monoid, its chunks can be extracted incrementally, before the complete input is parsed.

category:             Parsing
abi:                  6aa15662fc4b38084de086ae336b1fe6
exposed:              True
exposed-modules:
    Control.Applicative.Monoid Text.ParserCombinators.Incremental
    Text.ParserCombinators.Incremental.LeftBiasedLocal
    Text.ParserCombinators.Incremental.Symmetric

import-dirs:          /usr/lib/ghc-8.10.5/site-local/incremental-parser-0.5.0.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/incremental-parser-0.5.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/incremental-parser-0.5.0.2
hs-libraries:         HSincremental-parser-0.5.0.2-6Pimv0jS9M421w83VBuWe8
depends:
    base-4.14.2.0 input-parsers-0.2.2-F8ZkLuB7fO2CLH36vofCoy
    monoid-subclasses-1.1-AwFjCNwVwkv9V7v1aD1jp3
    parsers-0.12.10-DGz13yHc7wxB3ssNjoRPte
    rank2classes-1.4.1-87arDcY6M72Ahu2Kg1agTj transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-incremental-parser/html/incremental-parser.haddock

haddock-html:         /usr/share/doc/haskell-incremental-parser/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

