#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 nonce
version:              1.0.7
visibility:           public
id:                   nonce-1.0.7-LkeJFqiRNYv6ZSGRBDrIgT
key:                  nonce-1.0.7-LkeJFqiRNYv6ZSGRBDrIgT
license:              BSD-3-Clause
copyright:            (c) 2014 Prowdsponsor
maintainer:           Prowdsponsor <opensource@prowdsponsor.com>
author:               Felipe Lessa <felipe.lessa@prowdsponsor.com>
homepage:             https://github.com/prowdsponsor/nonce
synopsis:             Generate cryptographic nonces.
description:
    According to the Wikipedia, a nonce is an arbitrary number used
    only once in a cryptographic communication.  This package
    contain helper functions for generating nonces.

    There are many kinds of nonces used in different situations.
    It'\''s not guaranteed that by using the nonces from this package
    you won'\''t have any security issues.  Please make sure that the
    nonces generated via this package are usable on your design.

category:             Cryptography
abi:                  8d43d847eb1fc2c6adaa40202da381a7
exposed:              True
exposed-modules:      Crypto.Nonce
import-dirs:          /usr/lib/ghc-8.10.5/site-local/nonce-1.0.7
library-dirs:         /usr/lib/ghc-8.10.5/site-local/nonce-1.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/nonce-1.0.7
hs-libraries:         HSnonce-1.0.7-LkeJFqiRNYv6ZSGRBDrIgT
depends:
    base-4.14.2.0 base64-bytestring-1.2.0.1-Gn2QlQL7quxDmGBEoLUsKs
    bytestring-0.10.12.0 entropy-0.4.1.6-mwZ4jE2F7MEzr0ctFVs6J
    text-1.2.4.1 transformers-0.5.6.2
    unliftio-0.2.18-2kiHcgI4qdj1XlC6DQIVT2
    unliftio-core-0.2.0.1-1ibY1oF6Hkc5ZYjZ4yW3Lp

haddock-interfaces:   /usr/share/doc/haskell-nonce/html/nonce.haddock
haddock-html:         /usr/share/doc/haskell-nonce/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

