/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.stspool;

import org.picketlink.identity.federation.bindings.stspool.STSClientPoolInternal;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.STSClientPool;

public final class STSClientPoolFactory
implements STSClientPool {
    private STSClientPoolInternal stsClientPoolInternal = new STSClientPoolInternal();

    private STSClientPoolFactory() {
    }

    public static STSClientPool getPoolInstance() {
        STSClientPoolFactory cf = LazySTSClientFactory.INSTANCE;
        STSClientFactory.setInstance((STSClientPool)cf);
        return cf;
    }

    public void createPool(STSClientConfig config) {
        this.createPool(STSClientPoolInternal.DEFAULT_NUM_STS_CLIENTS, config);
    }

    public void createPool(int initialNumberOfClients, STSClientConfig config) {
        this.stsClientPoolInternal.initialize(initialNumberOfClients, config);
    }

    public void createPool(int initialNumberOfClients, STSClientCreationCallBack callBack) {
        this.stsClientPoolInternal.initialize(initialNumberOfClients, callBack);
    }

    public void destroyPool(STSClientConfig config) {
        this.stsClientPoolInternal.destroy(config);
    }

    public void destroyPool(String moduleName) {
        this.stsClientPoolInternal.destroy(moduleName);
    }

    public void returnClient(STSClient stsClient) {
        this.stsClientPoolInternal.putIn(stsClient);
    }

    public STSClient getClient(STSClientConfig config) {
        STSClient client = this.stsClientPoolInternal.takeOut(config);
        if (client == null) {
            return new STSClient(config);
        }
        return client;
    }

    public boolean configExists(STSClientConfig config) {
        return this.stsClientPoolInternal.isConfigInitialized(config);
    }

    private static class LazySTSClientFactory {
        private static final STSClientPoolFactory INSTANCE = new STSClientPoolFactory();

        private LazySTSClientFactory() {
        }
    }
}

