/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jboss.logging.Logger;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultRawSecret;

public class FilesPlainTextVaultProvider
implements VaultProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final Path vaultPath;
    private final String realmName;

    public FilesPlainTextVaultProvider(@Nonnull Path path, @Nonnull String realmName) {
        this.vaultPath = path;
        this.realmName = realmName;
        logger.debugf("PlainTextVaultProvider will operate in %s directory", (Object)this.vaultPath.toAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VaultRawSecret obtainSecret(String vaultSecretId) {
        Path secretPath = this.resolveSecretPath(vaultSecretId);
        if (!Files.exists(secretPath, new LinkOption[0])) {
            logger.warnf("Cannot find secret %s in %s", (Object)vaultSecretId, (Object)secretPath);
            return DefaultVaultRawSecret.forBuffer(Optional.empty());
        }
        try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(secretPath, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            VaultRawSecret vaultRawSecret = DefaultVaultRawSecret.forBuffer(Optional.of(mappedByteBuffer));
            return vaultRawSecret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }

    protected Path resolveSecretPath(String vaultSecretId) {
        return this.vaultPath.resolve(this.realmName.replaceAll("_", "__") + "_" + vaultSecretId.replaceAll("_", "__"));
    }
}

