/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.jms.AbstractJMSRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;

public class PooledConnectionFactoryConfigurationRuntimeHandler
extends AbstractJMSRuntimeHandler<ModelNode> {
    public static final PooledConnectionFactoryConfigurationRuntimeHandler INSTANCE = new PooledConnectionFactoryConfigurationRuntimeHandler();

    private PooledConnectionFactoryConfigurationRuntimeHandler() {
    }

    @Override
    protected void executeReadAttribute(String attributeName, OperationContext context, ModelNode connectionFactory, PathAddress address, boolean includeDefault) {
        if (connectionFactory.hasDefined(attributeName)) {
            context.getResult().set(connectionFactory.get(attributeName));
        } else {
            ConnectionFactoryAttribute attribute = PooledConnectionFactoryDefinition.getAttributesMap().get(attributeName);
            if (attribute.getDefinition().getDefaultValue() != null && attribute.getDefinition().getDefaultValue().isDefined()) {
                context.getResult().set(attribute.getDefinition().getDefaultValue());
            }
        }
    }
}

