/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MACUtil {
    private MACUtil() {
    }

    public static byte[] calculateHmacSHA256(byte[] message, byte[] secret) {
        return MACUtil.calculateHmacSHA256(message, secret, 32);
    }

    public static byte[] calculateHmacSHA256(byte[] message, byte[] secret, int outputLength) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret, "HmacSHA256");
            mac.init(secretKeySpec);
            byte[] hmac = mac.doFinal(message);
            return Arrays.copyOf(hmac, outputLength);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

