"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var chart_1 = require("../../../../state/actions/chart");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var group_by_rollup_1 = require("../../layout/utils/group_by_rollup");
var geometries_1 = require("../../state/selectors/geometries");
var canvas_renderers_1 = require("./canvas_renderers");
var PartitionComponent = (function (_super) {
    __extends(PartitionComponent, _super);
    function PartitionComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.ctx = null;
        _this.devicePixelRatio = window.devicePixelRatio;
        return _this;
    }
    PartitionComponent.prototype.componentDidMount = function () {
        this.tryCanvasContext();
        if (this.props.initialized) {
            this.drawCanvas();
            this.props.onChartRendered();
        }
    };
    PartitionComponent.prototype.componentDidUpdate = function () {
        if (!this.ctx) {
            this.tryCanvasContext();
        }
        if (this.props.initialized) {
            this.drawCanvas();
            this.props.onChartRendered();
        }
    };
    PartitionComponent.prototype.drawCanvas = function () {
        if (this.ctx) {
            var _a = this.props.chartContainerDimensions, width = _a.width, height = _a.height;
            canvas_renderers_1.renderPartitionCanvas2d(this.ctx, this.devicePixelRatio, __assign(__assign({}, this.props.geometries), { config: __assign(__assign({}, this.props.geometries.config), { width: width, height: height }) }));
        }
    };
    PartitionComponent.prototype.tryCanvasContext = function () {
        var canvas = this.props.forwardStageRef.current;
        this.ctx = canvas && canvas.getContext('2d');
    };
    PartitionComponent.prototype.handleMouseMove = function (e) {
        var _a = this.props, initialized = _a.initialized, _b = _a.chartContainerDimensions, width = _b.width, height = _b.height, forwardStageRef = _a.forwardStageRef;
        if (!forwardStageRef.current || !this.ctx || !initialized || width === 0 || height === 0) {
            return;
        }
        var picker = this.props.geometries.pickQuads;
        var box = forwardStageRef.current.getBoundingClientRect();
        var diskCenter = this.props.geometries.diskCenter;
        var x = e.clientX - box.left - diskCenter.x;
        var y = e.clientY - box.top - diskCenter.y;
        var pickedShapes = picker(x, y);
        var datumIndices = new Set();
        pickedShapes.forEach(function (shape) {
            var node = shape.parent;
            var shapeNode = node.children.find(function (_a) {
                var _b = __read(_a, 1), key = _b[0];
                return key === shape.dataName;
            });
            if (shapeNode) {
                var indices = shapeNode[1][group_by_rollup_1.INPUT_KEY] || [];
                indices.forEach(function (i) { return datumIndices.add(i); });
            }
        });
        return pickedShapes;
    };
    PartitionComponent.prototype.render = function () {
        var _a = this.props, forwardStageRef = _a.forwardStageRef, initialized = _a.initialized, _b = _a.chartContainerDimensions, width = _b.width, height = _b.height;
        if (!initialized || width === 0 || height === 0) {
            return null;
        }
        return (react_1.default.createElement("canvas", { ref: forwardStageRef, className: "echCanvasRenderer", width: width * this.devicePixelRatio, height: height * this.devicePixelRatio, onMouseMove: this.handleMouseMove.bind(this), style: {
                width: width,
                height: height,
            } }));
    };
    PartitionComponent.displayName = 'Partition';
    return PartitionComponent;
}(react_1.default.Component));
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        onChartRendered: chart_1.onChartRendered,
    }, dispatch);
};
var DEFAULT_PROPS = {
    initialized: false,
    geometries: viewmodel_types_1.nullShapeViewModel(),
    chartContainerDimensions: {
        width: 0,
        height: 0,
        left: 0,
        top: 0,
    },
};
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return DEFAULT_PROPS;
    }
    return {
        initialized: true,
        geometries: geometries_1.partitionGeometries(state),
        chartContainerDimensions: get_chart_container_dimensions_1.getChartContainerDimensionsSelector(state),
    };
};
exports.Partition = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(PartitionComponent);
//# sourceMappingURL=partition.js.map