"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../../renderers/canvas");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
var rect_1 = require("../primitives/rect");
function renderRectAnnotations(ctx, annotations, rectStyle) {
    var rects = annotations.map(function (_a) {
        var rect = _a.rect;
        return rect;
    });
    var fillColor = color_library_wrappers_1.stringToRGB(rectStyle.fill);
    fillColor.opacity *= rectStyle.opacity;
    var fill = {
        color: fillColor,
    };
    var strokeColor = color_library_wrappers_1.stringToRGB(rectStyle.stroke);
    strokeColor.opacity *= rectStyle.opacity;
    var stroke = {
        color: strokeColor,
        width: rectStyle.strokeWidth,
    };
    var rectsLength = rects.length;
    var _loop_1 = function (i) {
        var rect = rects[i];
        canvas_1.withContext(ctx, function (ctx) {
            rect_1.renderRect(ctx, rect, fill, stroke);
        });
    };
    for (var i = 0; i < rectsLength; i++) {
        _loop_1(i);
    }
}
exports.renderRectAnnotations = renderRectAnnotations;
//# sourceMappingURL=rect.js.map