/*
 * Decompiled with CFR 0.152.
 */
package org.nio4r;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.nio4r.Nio4r;

public class Monitor
extends RubyObject {
    private SelectionKey key;
    private RubyIO io;
    private IRubyObject interests;
    private IRubyObject selector;
    private IRubyObject value;
    private IRubyObject closed;

    public Monitor(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.io = RubyIO.convertToIO((ThreadContext)threadContext, (IRubyObject)iRubyObject);
        this.interests = iRubyObject2;
        this.selector = iRubyObject3;
        this.value = threadContext.nil;
        this.closed = threadContext.getRuntime().getFalse();
        return threadContext.nil;
    }

    public void setSelectionKey(SelectionKey selectionKey) {
        this.key = selectionKey;
        selectionKey.attach((Object)this);
    }

    @JRubyMethod
    public IRubyObject io(ThreadContext threadContext) {
        return this.io;
    }

    @JRubyMethod
    public IRubyObject selector(ThreadContext threadContext) {
        return this.selector;
    }

    @JRubyMethod(name={"interests"})
    public IRubyObject getInterests(ThreadContext threadContext) {
        return this.interests;
    }

    @JRubyMethod(name={"interests="})
    public IRubyObject setInterests(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.closed == threadContext.getRuntime().getTrue()) {
            throw threadContext.getRuntime().newEOFError("monitor is closed");
        }
        Ruby ruby = threadContext.getRuntime();
        SelectableChannel selectableChannel = (SelectableChannel)this.io.getChannel();
        if (iRubyObject != threadContext.nil) {
            this.key.interestOps(Nio4r.symbolToInterestOps(ruby, selectableChannel, iRubyObject));
        } else {
            this.key.interestOps(0);
        }
        this.interests = iRubyObject;
        return this.interests;
    }

    @JRubyMethod(name={"add_interest"})
    public IRubyObject addInterest(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.closed == threadContext.getRuntime().getTrue()) {
            throw threadContext.getRuntime().newEOFError("monitor is closed");
        }
        Ruby ruby = threadContext.getRuntime();
        SelectableChannel selectableChannel = (SelectableChannel)this.io.getChannel();
        int n = this.key.interestOps() | Nio4r.symbolToInterestOps(ruby, selectableChannel, iRubyObject);
        this.key.interestOps(n);
        this.interests = Nio4r.interestOpsToSymbol(ruby, n);
        return this.interests;
    }

    @JRubyMethod(name={"remove_interest"})
    public IRubyObject removeInterest(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.closed == threadContext.getRuntime().getTrue()) {
            throw threadContext.getRuntime().newEOFError("monitor is closed");
        }
        Ruby ruby = threadContext.getRuntime();
        SelectableChannel selectableChannel = (SelectableChannel)this.io.getChannel();
        int n = this.key.interestOps() & ~Nio4r.symbolToInterestOps(ruby, selectableChannel, iRubyObject);
        this.key.interestOps(n);
        this.interests = Nio4r.interestOpsToSymbol(ruby, n);
        return this.interests;
    }

    @JRubyMethod
    public IRubyObject readiness(ThreadContext threadContext) {
        if (!this.key.isValid()) {
            return this.interests;
        }
        return Nio4r.interestOpsToSymbol(threadContext.getRuntime(), this.key.readyOps());
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject isReadable(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        if (!this.key.isValid()) {
            return ruby.getTrue();
        }
        int n = this.key.readyOps();
        if ((n & 1) != 0 || (n & 0x10) != 0) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"writable?", "writeable?"})
    public IRubyObject writable(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        if (!this.key.isValid()) {
            return ruby.getTrue();
        }
        int n = this.key.readyOps();
        if ((n & 4) != 0 || (n & 8) != 0) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"value"})
    public IRubyObject getValue(ThreadContext threadContext) {
        return this.value;
    }

    @JRubyMethod(name={"value="})
    public IRubyObject setValue(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.value = iRubyObject;
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext threadContext) {
        return this.close(threadContext, (IRubyObject)threadContext.getRuntime().getTrue());
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        this.closed = ruby.getTrue();
        if (iRubyObject == ruby.getTrue()) {
            this.selector.callMethod(threadContext, "deregister", (IRubyObject)this.io);
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject isClosed(ThreadContext threadContext) {
        return this.closed;
    }
}

