/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.NameRegister;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.util.ByteWrangler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DNSRecord
extends DNSEntry {
    private static Logger logger = LoggerFactory.getLogger(DNSRecord.class.getName());
    private int _ttl;
    private long _created;
    private int _isStaleAndShouldBeRefreshedPercentage;
    private final int _randomStaleRefreshOffset;
    private InetAddress _source;

    DNSRecord(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl) {
        super(name, type, recordClass, unique);
        this._ttl = ttl;
        this._created = System.currentTimeMillis();
        this._randomStaleRefreshOffset = new Random().nextInt(3);
        this._isStaleAndShouldBeRefreshedPercentage = 80 + this._randomStaleRefreshOffset;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DNSRecord && super.equals(other) && this.sameValue((DNSRecord)other);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean sameType(DNSRecord other) {
        return this.getRecordType() == other.getRecordType();
    }

    abstract boolean handleQuery(JmDNSImpl var1, long var2);

    abstract boolean handleResponse(JmDNSImpl var1);

    abstract DNSOutgoing addAnswer(JmDNSImpl var1, DNSIncoming var2, InetAddress var3, int var4, DNSOutgoing var5) throws IOException;

    boolean suppressedBy(DNSIncoming msg) {
        try {
            for (DNSRecord answer : msg.getAllAnswers()) {
                if (!this.suppressedBy(answer)) continue;
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.warn("suppressedBy() message " + msg + " exception ", e);
            return false;
        }
    }

    boolean suppressedBy(DNSRecord other) {
        return this.equals(other) && other._ttl > this._ttl / 2;
    }

    long getExpirationTime(int percent) {
        return this._created + (long)percent * (long)this._ttl * 10L;
    }

    int getRemainingTTL(long now) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - now) / 1000L);
    }

    @Override
    public boolean isExpired(long now) {
        return this.getExpirationTime(100) <= now;
    }

    @Override
    public boolean isStale(long now) {
        return this.getExpirationTime(50) <= now;
    }

    public boolean isStaleAndShouldBeRefreshed(long now) {
        return this.getExpirationTime(this._isStaleAndShouldBeRefreshedPercentage) <= now;
    }

    public void incrementRefreshPercentage() {
        this._isStaleAndShouldBeRefreshedPercentage += 5;
        if (this._isStaleAndShouldBeRefreshedPercentage > 100) {
            this._isStaleAndShouldBeRefreshedPercentage = 100;
        }
    }

    void resetTTL(DNSRecord other) {
        this._created = other._created;
        this._ttl = other._ttl;
        this._isStaleAndShouldBeRefreshedPercentage = 80 + this._randomStaleRefreshOffset;
    }

    void setWillExpireSoon(long now) {
        this._created = now;
        this._ttl = 1;
    }

    abstract void write(DNSOutgoing.MessageOutputStream var1);

    public abstract boolean isSingleValued();

    public ServiceInfo getServiceInfo() {
        return this.getServiceInfo(false);
    }

    public abstract ServiceInfo getServiceInfo(boolean var1);

    public abstract ServiceEvent getServiceEvent(JmDNSImpl var1);

    public void setRecordSource(InetAddress source2) {
        this._source = source2;
    }

    public InetAddress getRecordSource() {
        return this._source;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        int remaininggTTL = this.getRemainingTTL(System.currentTimeMillis());
        sb.append(" ttl: '").append(remaininggTTL).append('/').append(this._ttl).append('\'');
    }

    public void setTTL(int ttl) {
        this._ttl = ttl;
    }

    public int getTTL() {
        return this._ttl;
    }

    public long getCreated() {
        return this._created;
    }

    public static class HostInformation
    extends DNSRecord {
        String _os;
        String _cpu;

        public HostInformation(String name, DNSRecordClass recordClass, boolean unique, int ttl, String cpu, String os) {
            super(name, DNSRecordType.TYPE_HINFO, recordClass, unique, ttl);
            this._cpu = cpu;
            this._os = os;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        @Override
        boolean sameValue(DNSRecord other) {
            if (!(other instanceof HostInformation)) {
                return false;
            }
            HostInformation hinfo = (HostInformation)other;
            if (this._cpu == null && hinfo._cpu != null) {
                return false;
            }
            if (this._os == null && hinfo._os != null) {
                return false;
            }
            return this._cpu.equals(hinfo._cpu) && this._os.equals(hinfo._os);
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            String hostInfo = this._cpu + " " + this._os;
            out.writeUTF(hostInfo, 0, hostInfo.length());
        }

        @Override
        public ServiceInfo getServiceInfo(boolean persistent) {
            HashMap<String, String> hinfo = new HashMap<String, String>(2);
            hinfo.put("cpu", this._cpu);
            hinfo.put("os", this._os);
            return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, hinfo);
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(" cpu: '").append(this._cpu).append("' os: '").append(this._os).append('\'');
        }
    }

    public static class Service
    extends DNSRecord {
        private static Logger logger1 = LoggerFactory.getLogger(Service.class.getName());
        private final int _priority;
        private final int _weight;
        private final int _port;
        private final String _server;

        public Service(String name, DNSRecordClass recordClass, boolean unique, int ttl, int priority, int weight, int port, String server) {
            super(name, DNSRecordType.TYPE_SRV, recordClass, unique, ttl);
            this._priority = priority;
            this._weight = weight;
            this._port = port;
            this._server = server;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeShort(this._priority);
            out.writeShort(this._weight);
            out.writeShort(this._port);
            if (DNSIncoming.USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET) {
                out.writeName(this._server);
            } else {
                out.writeUTF(this._server, 0, this._server.length());
                out.writeByte(0);
            }
        }

        @Override
        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            dout.writeShort(this._priority);
            dout.writeShort(this._weight);
            dout.writeShort(this._port);
            try {
                dout.write(this._server.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        String getServer() {
            return this._server;
        }

        public int getPriority() {
            return this._priority;
        }

        public int getWeight() {
            return this._weight;
        }

        public int getPort() {
            return this._port;
        }

        @Override
        boolean sameValue(DNSRecord other) {
            if (!(other instanceof Service)) {
                return false;
            }
            Service s2 = (Service)other;
            return this._priority == s2._priority && this._weight == s2._weight && this._port == s2._port && this._server.equals(s2._server);
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.getKey());
            if (!(info == null || !info.isAnnouncing() && !info.isAnnounced() || this._port == info.getPort() && this._server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger1.debug("handleQuery() Conflicting probe detected from: {}", (Object)this.getRecordSource());
                Service localService = new Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, true, DNSConstants.DNS_TTL, info.getPriority(), info.getWeight(), info.getPort(), dns.getLocalHost().getName());
                try {
                    if (dns.getInetAddress().equals(this.getRecordSource())) {
                        logger1.warn("Got conflicting probe from ourselves\nincoming: {}\nlocal   : {}", (Object)this.toString(), (Object)localService.toString());
                    }
                }
                catch (IOException e) {
                    logger1.warn("IOException", e);
                }
                int comparison = this.compareTo(localService);
                if (comparison == 0) {
                    logger1.debug("handleQuery() Ignoring a identical service query");
                    return false;
                }
                if (!info.isProbing() || comparison <= 0) {
                    return false;
                }
                String oldName = info.getQualifiedName().toLowerCase();
                info.setName(NameRegister.Factory.getRegistry().incrementName(dns.getLocalHost().getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
                dns.getServices().remove(oldName);
                dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                logger1.debug("handleQuery() Lost tie break: new unique name chosen:{}", (Object)info.getName());
                info.revertState();
                return true;
            }
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl dns) {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.getKey());
            if (!(info == null || this._port == info.getPort() && this._server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                logger1.debug("handleResponse() Denial detected");
                if (info.isProbing()) {
                    String oldName = info.getQualifiedName().toLowerCase();
                    info.setName(NameRegister.Factory.getRegistry().incrementName(dns.getLocalHost().getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
                    dns.getServices().remove(oldName);
                    dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                    logger1.debug("handleResponse() New unique name chose:{}", (Object)info.getName());
                }
                info.revertState();
                return true;
            }
            return false;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            ServiceInfoImpl info = (ServiceInfoImpl)dns.getServices().get(this.getKey());
            if (info != null && this._port == info.getPort() != this._server.equals(dns.getLocalHost().getName())) {
                return dns.addAnswer(in, addr, port, out, new Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, true, DNSConstants.DNS_TTL, info.getPriority(), info.getWeight(), info.getPort(), dns.getLocalHost().getName()));
            }
            return out;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean persistent) {
            return new ServiceInfoImpl(this.getQualifiedNameMap(), this._port, this._weight, this._priority, persistent, (byte[])null);
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(" server: '").append(this._server).append(':').append(this._port).append('\'');
        }
    }

    public static class Text
    extends DNSRecord {
        private final byte[] _text;

        public Text(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] text) {
            super(name, DNSRecordType.TYPE_TXT, recordClass, unique, ttl);
            this._text = text != null && text.length > 0 ? text : ByteWrangler.EMPTY_TXT;
        }

        byte[] getText() {
            return this._text;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeBytes(this._text, 0, this._text.length);
        }

        @Override
        boolean sameValue(DNSRecord other) {
            if (!(other instanceof Text)) {
                return false;
            }
            Text txt = (Text)other;
            if (this._text == null && txt._text != null) {
                return false;
            }
            if (txt._text.length != this._text.length) {
                return false;
            }
            int i = this._text.length;
            while (i-- > 0) {
                if (txt._text[i] == this._text[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean persistent) {
            return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, this._text);
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(" text: '");
            String text = ByteWrangler.readUTF(this._text);
            if (text != null) {
                if (20 < text.length()) {
                    sb.append(text, 0, 17).append("...");
                } else {
                    sb.append(text);
                }
            }
            sb.append('\'');
        }
    }

    public static class Pointer
    extends DNSRecord {
        private final String _alias;

        public Pointer(String name, DNSRecordClass recordClass, boolean unique, int ttl, String alias) {
            super(name, DNSRecordType.TYPE_PTR, recordClass, unique, ttl);
            this._alias = alias;
        }

        @Override
        public boolean isSameEntry(DNSEntry entry) {
            return super.isSameEntry(entry) && entry instanceof Pointer && this.sameValue((Pointer)entry);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeName(this._alias);
        }

        @Override
        boolean sameValue(DNSRecord other) {
            if (!(other instanceof Pointer)) {
                return false;
            }
            Pointer pointer = (Pointer)other;
            if (this._alias == null && pointer._alias != null) {
                return false;
            }
            return this._alias.equals(pointer._alias);
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }

        @Override
        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl dns) {
            return false;
        }

        String getAlias() {
            return this._alias;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean persistent) {
            if (this.isServicesDiscoveryMetaQuery()) {
                Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(this.getAlias());
                return new ServiceInfoImpl(map, 0, 0, 0, persistent, (byte[])null);
            }
            if (this.isReverseLookup()) {
                return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            }
            if (this.isDomainDiscoveryQuery()) {
                return new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            }
            Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(this.getAlias());
            map.put(ServiceInfo.Fields.Subtype, this.getQualifiedNameMap().get((Object)ServiceInfo.Fields.Subtype));
            return new ServiceInfoImpl(map, 0, 0, 0, persistent, this.getAlias());
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            String domainName = info.getType();
            String serviceName = JmDNSImpl.toUnqualifiedName(domainName, this.getAlias());
            return new ServiceEventImpl(dns, domainName, serviceName, info);
        }

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(" alias: '").append(this._alias != null ? this._alias.toString() : "null").append('\'');
        }
    }

    public static abstract class Address
    extends DNSRecord {
        private static Logger logger1 = LoggerFactory.getLogger(Address.class.getName());
        InetAddress _addr;

        protected Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, type, recordClass, unique, ttl);
            this._addr = addr;
        }

        protected Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, type, recordClass, unique, ttl);
            try {
                this._addr = InetAddress.getByAddress(rawAddress);
            }
            catch (UnknownHostException exception) {
                logger1.warn("Address() exception ", exception);
            }
        }

        boolean same(DNSRecord other) {
            if (!(other instanceof Address)) {
                return false;
            }
            return this.sameName(other) && this.sameValue(other);
        }

        boolean sameName(DNSRecord other) {
            return this.getName().equalsIgnoreCase(other.getName());
        }

        @Override
        boolean sameValue(DNSRecord other) {
            try {
                if (!(other instanceof Address)) {
                    return false;
                }
                Address address = (Address)other;
                if (this.getAddress() == null && address.getAddress() != null) {
                    return false;
                }
                return this.getAddress().equals(address.getAddress());
            }
            catch (Exception e) {
                logger1.info("Failed to compare addresses of DNSRecords", e);
                return false;
            }
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }

        InetAddress getAddress() {
            return this._addr;
        }

        @Override
        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            byte[] buffer = this.getAddress().getAddress();
            for (int i = 0; i < buffer.length; ++i) {
                dout.writeByte(buffer[i]);
            }
        }

        @Override
        boolean handleQuery(JmDNSImpl dns, long expirationTime) {
            Address localAddress;
            if (dns.getLocalHost().conflictWithRecord(this) && (localAddress = dns.getLocalHost().getDNSAddressRecord(this.getRecordType(), this.isUnique(), DNSConstants.DNS_TTL)) != null) {
                int comparison = this.compareTo(localAddress);
                if (comparison == 0) {
                    logger1.debug("handleQuery() Ignoring an identical address query");
                    return false;
                }
                logger1.debug("handleQuery() Conflicting query detected.");
                if (dns.isProbing() && comparison > 0) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfo serviceInfo : dns.getServices().values()) {
                        ServiceInfoImpl info = (ServiceInfoImpl)serviceInfo;
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        @Override
        boolean handleResponse(JmDNSImpl dns) {
            if (dns.getLocalHost().conflictWithRecord(this)) {
                logger1.debug("handleResponse() Denial detected");
                if (dns.isProbing()) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    for (ServiceInfo serviceInfo : dns.getServices().values()) {
                        ServiceInfoImpl info = (ServiceInfoImpl)serviceInfo;
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        @Override
        DNSOutgoing addAnswer(JmDNSImpl dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        public ServiceInfo getServiceInfo(boolean persistent) {
            ServiceInfoImpl info = new ServiceInfoImpl(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            return info;
        }

        @Override
        public ServiceEvent getServiceEvent(JmDNSImpl dns) {
            ServiceInfo info = this.getServiceInfo(false);
            ((ServiceInfoImpl)info).setDns(dns);
            return new ServiceEventImpl(dns, info.getType(), info.getName(), info);
        }

        @Override
        protected void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(" address: '").append(this.getAddress() != null ? this.getAddress().getHostAddress() : "null").append('\'');
        }
    }

    public static class IPv6Address
    extends Address {
        IPv6Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, DNSRecordType.TYPE_AAAA, recordClass, unique, ttl, addr);
        }

        IPv6Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, DNSRecordType.TYPE_AAAA, recordClass, unique, ttl, rawAddress);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            if (this._addr != null) {
                byte[] buffer = this._addr.getAddress();
                if (this._addr instanceof Inet4Address) {
                    byte[] tempbuffer = buffer;
                    buffer = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        buffer[i] = i < 11 ? tempbuffer[i - 12] : (byte)0;
                    }
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        @Override
        public ServiceInfo getServiceInfo(boolean persistent) {
            ServiceInfoImpl info = (ServiceInfoImpl)super.getServiceInfo(persistent);
            info.addAddress((Inet6Address)this._addr);
            return info;
        }
    }

    public static class IPv4Address
    extends Address {
        IPv4Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, DNSRecordType.TYPE_A, recordClass, unique, ttl, addr);
        }

        IPv4Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, DNSRecordType.TYPE_A, recordClass, unique, ttl, rawAddress);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            if (this._addr != null) {
                byte[] buffer = this._addr.getAddress();
                if (!(this._addr instanceof Inet4Address)) {
                    byte[] tempbuffer = buffer;
                    buffer = new byte[4];
                    System.arraycopy(tempbuffer, 12, buffer, 0, 4);
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        @Override
        public ServiceInfo getServiceInfo(boolean persistent) {
            ServiceInfoImpl info = (ServiceInfoImpl)super.getServiceInfo(persistent);
            info.addAddress((Inet4Address)this._addr);
            return info;
        }
    }
}

