/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen.allgemein;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialogEinstellungen.allgemein.TextFieldConfigWriter;
import mediathek.gui.dialogEinstellungen.allgemein.TimedDocumentListener;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.ParallelDownloadNumberChangedEvent;
import mediathek.gui.messages.SenderIconStyleChangedEvent;
import mediathek.gui.messages.TabVisualSettingsChangedEvent;
import mediathek.gui.messages.TrayIconEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;

public class PanelEinstellungen
extends JPanel {
    private static final String ALLE = " Alle ";
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private final JFrame parent;
    private final Daten daten;
    private JCheckBox jCheckBoxTabsTop;
    private JCheckBox jCheckBoxTabIcon;
    private JCheckBox cbAutomaticMenuTabSwitching;
    private JTextField jtfUserAgent;
    private JTextField jtfProxyHost;
    private JTextField jtfProxyPort;
    private JTextField jtfProxyUser;
    private JPasswordField jpfProxyPassword;
    private JSpinner jSpinnerDays;
    private JButton jButtonLoad;
    private JButton jButtonHelpDays;
    private JCheckBox cbUseDatabaseCleaner;
    private JCheckBox cbSaveHumanReadableFilmlist;
    private JCheckBox jCheckBoxTray;
    private JCheckBox cbUseWikipediaSenderLogos;

    private void setupProxySettings() {
        this.jtfProxyHost.setText(this.config.getString("http.proxy.hostname", ""));
        TextFieldConfigWriter listener = new TextFieldConfigWriter(this.jtfProxyHost, "http.proxy.hostname");
        this.jtfProxyHost.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jtfProxyPort.setText(this.config.getString("http.proxy.port", ""));
        listener = new TextFieldConfigWriter(this.jtfProxyPort, "http.proxy.port");
        this.jtfProxyPort.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jtfProxyUser.setText(this.config.getString("http.proxy.user", ""));
        listener = new TextFieldConfigWriter(this.jtfProxyUser, "http.proxy.user");
        this.jtfProxyUser.getDocument().addDocumentListener(new TimedDocumentListener(listener));
        this.jpfProxyPassword.setText(this.config.getString("http.proxy.password", ""));
        listener = new TextFieldConfigWriter(this.jpfProxyPassword, "http.proxy.password");
        this.jpfProxyPassword.getDocument().addDocumentListener(new TimedDocumentListener(listener));
    }

    private void setupUserAgentSettings() {
        this.jtfUserAgent.setText(ApplicationConfiguration.getConfiguration().getString("application.user_agent"));
        TextFieldConfigWriter listener = new TextFieldConfigWriter(this.jtfUserAgent, "application.user_agent");
        this.jtfUserAgent.getDocument().addDocumentListener(new TimedDocumentListener(listener));
    }

    private void cbUseWikipediaSenderLogosActionPerformed(ActionEvent evt) {
        ApplicationConfiguration.getConfiguration().setProperty("application.sender_icons.use_local", !this.cbUseWikipediaSenderLogos.isSelected());
        this.daten.getMessageBus().publishAsync(new SenderIconStyleChangedEvent());
    }

    private void setupDays() {
        this.jButtonHelpDays.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHelpDays.addActionListener(e -> new DialogHilfe(this.parent, true, "\nEs werden nur Filme der letzten\nxx Tage geladen.\nBei \"Alle\" werden alle Filme geladen.\n\n(Eine kleinere Filmliste\nkann bei Rechnern mit wenig\nSpeicher hilfreich sein.)\n\nAuswirkung hat das erst nach dem\nNeuladen der kompletten Filmliste.").setVisible(true));
        SpinnerListModel lm = new SpinnerListModel(new Object[]{ALLE, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "12", "14", "16", "18", "20", "25", "30"});
        this.jSpinnerDays.setModel(lm);
        ((JSpinner.DefaultEditor)this.jSpinnerDays.getEditor()).getTextField().setEditable(false);
        this.initSpinner();
        this.jSpinnerDays.addChangeListener(new BeobSpinnerDays());
    }

    private void setupTabUI() {
        boolean tabPositionTop = this.config.getBoolean("application.ui.tab_position.top", true);
        this.jCheckBoxTabsTop.setSelected(tabPositionTop);
        this.jCheckBoxTabsTop.addActionListener(ae -> {
            this.config.setProperty("application.ui.tab_position.top", this.jCheckBoxTabsTop.isSelected());
            Daten.getInstance().getMessageBus().publishAsync(new TabVisualSettingsChangedEvent());
        });
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.jCheckBoxTabIcon.setSelected(config.getBoolean("application.ui.mainwindow.tab_icons", false));
        this.jCheckBoxTabIcon.addActionListener(ae -> {
            config.setProperty("application.ui.mainwindow.tab_icons", this.jCheckBoxTabIcon.isSelected());
            Daten.getInstance().getMessageBus().publishAsync(new TabVisualSettingsChangedEvent());
        });
    }

    @Handler
    private void handleTrayIconEvent(TrayIconEvent e) {
        SwingUtilities.invokeLater(() -> this.jCheckBoxTray.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_TRAY))));
    }

    private void setupTray() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.jCheckBoxTray.setSelected(false);
            this.jCheckBoxTray.setEnabled(false);
        } else {
            this.daten.getMessageBus().subscribe(this);
            this.jCheckBoxTray.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_TRAY)));
            this.jCheckBoxTray.addActionListener(ae -> {
                MVConfig.add(MVConfig.Configs.SYSTEM_USE_TRAY, Boolean.toString(this.jCheckBoxTray.isSelected()));
                MediathekGui.ui().initializeSystemTray();
            });
        }
    }

    private void setupDatabaseCleanerCheckbox() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.cbUseDatabaseCleaner.setSelected(config.getBoolean("database.cleanup.use_cleaner", false));
        this.cbUseDatabaseCleaner.addActionListener(l -> config.setProperty("database.cleanup.use_cleaner", this.cbUseDatabaseCleaner.isSelected()));
    }

    private void setupSaveHumanReadableFilmlistCheckbox() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.cbSaveHumanReadableFilmlist.setSelected(config.getBoolean("filmlist.save.human_readable", false));
        this.cbSaveHumanReadableFilmlist.addActionListener(l -> config.setProperty("filmlist.save.human_readable", this.cbSaveHumanReadableFilmlist.isSelected()));
    }

    public PanelEinstellungen(Daten d, JFrame parent) {
        this.parent = parent;
        this.daten = d;
        this.initComponents();
        this.setupUserAgentSettings();
        this.setupProxySettings();
        this.setupDatabaseCleanerCheckbox();
        this.setupSaveHumanReadableFilmlistCheckbox();
        this.jButtonLoad.addActionListener(ae -> {
            this.daten.getListeFilme().clear();
            this.daten.getFilmeLaden().loadFilmlist("");
        });
        this.setupDays();
        this.setupTabUI();
        this.setupTray();
        this.setupTabSwitchListener();
        this.cbUseWikipediaSenderLogos.addActionListener(this::cbUseWikipediaSenderLogosActionPerformed);
        boolean useLocalSenderLogos = ApplicationConfiguration.getConfiguration().getBoolean("application.sender_icons.use_local", false);
        this.cbUseWikipediaSenderLogos.setSelected(!useLocalSenderLogos);
    }

    @Handler
    private void handleParallelDownloadNumberChanged(ParallelDownloadNumberChangedEvent e) {
        SwingUtilities.invokeLater(this::initSpinner);
    }

    private void setupTabSwitchListener() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cbAutomaticMenuTabSwitching.setEnabled(false);
            this.config.setProperty("application.ui.install_tab_listeners", false);
        } else {
            boolean installed;
            try {
                installed = this.config.getBoolean("application.ui.install_tab_listeners");
            }
            catch (NoSuchElementException ex) {
                installed = true;
                this.config.setProperty("application.ui.install_tab_listeners", true);
            }
            this.cbAutomaticMenuTabSwitching.setSelected(installed);
            this.cbAutomaticMenuTabSwitching.addActionListener(e -> {
                boolean isOn = this.cbAutomaticMenuTabSwitching.isSelected();
                this.config.setProperty("application.ui.install_tab_listeners", isOn);
                InstallTabSwitchListenerEvent evt = new InstallTabSwitchListenerEvent();
                evt.event = isOn ? InstallTabSwitchListenerEvent.INSTALL_TYPE.INSTALL : InstallTabSwitchListenerEvent.INSTALL_TYPE.REMOVE;
                this.daten.getMessageBus().publishAsync(evt);
            });
        }
    }

    private void initSpinner() {
        String s2;
        if (MVConfig.get(MVConfig.Configs.SYSTEM_ANZ_TAGE_FILMLISTE).isEmpty()) {
            MVConfig.add(MVConfig.Configs.SYSTEM_ANZ_TAGE_FILMLISTE, "0");
        }
        if ((s2 = MVConfig.get(MVConfig.Configs.SYSTEM_ANZ_TAGE_FILMLISTE)).equals("0")) {
            s2 = ALLE;
        }
        this.jSpinnerDays.setValue(s2);
    }

    private void initComponents() {
        JPanel jPanel5 = new JPanel();
        this.jCheckBoxTabsTop = new JCheckBox();
        this.jCheckBoxTabIcon = new JCheckBox();
        this.cbAutomaticMenuTabSwitching = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jtfUserAgent = new JTextField();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.jtfProxyHost = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.jtfProxyPort = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.jtfProxyUser = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.jpfProxyPassword = new JPasswordField();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JLabel jLabel6 = new JLabel();
        this.jSpinnerDays = new JSpinner();
        this.jButtonLoad = new JButton();
        this.jButtonHelpDays = new JButton();
        JPanel jPanel7 = new JPanel();
        this.cbUseDatabaseCleaner = new JCheckBox();
        JPanel jPanel8 = new JPanel();
        this.cbSaveHumanReadableFilmlist = new JCheckBox();
        this.jCheckBoxTray = new JCheckBox();
        this.cbUseWikipediaSenderLogos = new JCheckBox();
        this.setMaximumSize(new Dimension(10, 10));
        jPanel5.setBorder(new TitledBorder("Tab-Verhalten"));
        this.jCheckBoxTabsTop.setText("Tabs oben anzeigen");
        this.jCheckBoxTabIcon.setText("Icons anzeigen");
        this.jCheckBoxTabIcon.setToolTipText("Im Tab keine Icons anzeigen");
        this.cbAutomaticMenuTabSwitching.setText("Tabs schalten automatisch bei Men\u00fcnutzung um");
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jCheckBoxTabsTop).addGap(5, 5, 5).addComponent(this.jCheckBoxTabIcon).addGap(5, 5, 5).addComponent(this.cbAutomaticMenuTabSwitching).addContainerGap(20, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup().addGroup(jPanel5Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel5Layout.createParallelGroup().addComponent(this.jCheckBoxTabsTop).addComponent(this.jCheckBoxTabIcon).addComponent(this.cbAutomaticMenuTabSwitching))));
        jPanel3.setBorder(new TitledBorder("Download"));
        jLabel3.setText("User-Agent:");
        this.jtfUserAgent.setMinimumSize(new Dimension(200, 26));
        this.jtfUserAgent.setPreferredSize(new Dimension(520, 26));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(jLabel3).addGap(5, 5, 5).addComponent(this.jtfUserAgent, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup().addGroup(jPanel3Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(jLabel3)).addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jtfUserAgent, -2, -1, -2)));
        jPanel4.setBorder(new TitledBorder("HTTP-Proxy (Neustart erforderlich!)"));
        jPanel4.setToolTipText("");
        jLabel4.setText("Host:");
        jLabel5.setText("Port:");
        jLabel7.setText("User:");
        jLabel8.setText("Passwort:");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtfProxyHost, -2, 250, -2)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtfProxyUser))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel8).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jtfProxyPort, -2, 72, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jpfProxyPassword)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.jtfProxyHost, -2, -1, -2).addComponent(jLabel5).addComponent(this.jtfProxyPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(this.jtfProxyUser, -2, -1, -2).addComponent(jLabel8).addComponent(this.jpfProxyPassword, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2.setBorder(new TitledBorder(""));
        jLabel6.setText("Nur die Filme der letzten Tage laden:");
        this.jSpinnerDays.setModel(new SpinnerListModel(new String[]{"Alles", "1", "2", "10", "15"}));
        this.jButtonLoad.setText("Filmliste jetzt neu laden");
        this.jButtonHelpDays.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHelpDays.setToolTipText("Hilfe anzeigen");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(jLabel6).addGap(5, 5, 5).addComponent(this.jSpinnerDays, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonHelpDays).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(jLabel6)).addGroup(jPanel6Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel6Layout.createParallelGroup().addComponent(this.jButtonHelpDays).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerDays, -2, -1, -2).addComponent(this.jButtonLoad))))).addGap(2, 2, 2)));
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup().addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(jPanel6, -2, -1, -2)));
        jPanel7.setBorder(new TitledBorder("Datenbank (Neustart erforderlich!)"));
        this.cbUseDatabaseCleaner.setText("Bereinigung w\u00e4hrend Laufzeit");
        this.cbUseDatabaseCleaner.setToolTipText("<html>Wenn aktiviert werden ung\u00fcltige Datenbankeintr\u00e4ge sofort aus der Datenbank gel\u00f6scht um Speicher zu sparen.<br/>Dies wird f\u00fcr Rechner mit wenig Arbeitsspeicher empfohlen, verringert jedoch die Performance von MediathekView deutlich beim Laden einer neuen Filmliste.</html>");
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.cbUseDatabaseCleaner).addContainerGap(408, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup().addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.cbUseDatabaseCleaner).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8.setBorder(new TitledBorder("Speicherung der Filmliste"));
        this.cbSaveHumanReadableFilmlist.setText("in les- und editierbarem Format speichern");
        GroupLayout jPanel8Layout = new GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup().addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.cbSaveHumanReadableFilmlist).addContainerGap(335, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup().addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.cbSaveHumanReadableFilmlist).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxTray.setText("Programm ins Tray minimieren");
        this.cbUseWikipediaSenderLogos.setText("Senderlogos von Wikipedia verwenden");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(jPanel7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(jPanel8, -1, -1, Short.MAX_VALUE).addComponent(jPanel3, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.jCheckBoxTray).addComponent(this.cbUseWikipediaSenderLogos)).addGap(0, 1, Short.MAX_VALUE)).addComponent(jPanel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxTray).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbUseWikipediaSenderLogos).addContainerGap(7, Short.MAX_VALUE)));
    }

    private class BeobSpinnerDays
    implements ChangeListener {
        private BeobSpinnerDays() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            String s2 = PanelEinstellungen.this.jSpinnerDays.getModel().getValue().toString();
            if (s2.equals(PanelEinstellungen.ALLE)) {
                s2 = "0";
            }
            MVConfig.add(MVConfig.Configs.SYSTEM_ANZ_TAGE_FILMLISTE, s2);
        }
    }
}

