/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.AbstractSessionManagementMethodOptionsPanel;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.EncodingUtils;
import org.zaproxy.zap.view.DynamicFieldsPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ScriptBasedSessionManagementMethodType
extends SessionManagementMethodType {
    public static final String CONTEXT_CONFIG_SESSION_MGMT_SCRIPT = "context.session.script";
    public static final String CONTEXT_CONFIG_SESSION_MGMT_SCRIPT_NAME = "context.session.script.name";
    public static final String CONTEXT_CONFIG_SESSION_MGMT_SCRIPT_PARAMS = "context.session.script.params";
    private static final int METHOD_IDENTIFIER = 2;
    private static final Logger LOG = LogManager.getLogger(ScriptBasedSessionManagementMethodType.class);
    private static final String METHOD_NAME = Constant.messages.getString("sessionmanagement.method.sc.name");
    private static final String API_METHOD_NAME = "scriptBasedSessionManagement";
    public static final String SCRIPT_TYPE_SESSION = "session";
    private static final ImageIcon SCRIPT_ICON_SESSION = new ImageIcon(ScriptBasedSessionManagementMethodType.class.getResource("/resource/icon/16/script-session.png"));
    private static ExtensionScript extensionScript;
    private static final String PARAM_SCRIPT_NAME = "scriptName";
    private static final String PARAM_SCRIPT_CONFIG_PARAMS = "scriptConfigParams";

    @Override
    public ScriptBasedSessionManagementMethod createSessionManagementMethod(int contextId) {
        return new ScriptBasedSessionManagementMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public int getUniqueIdentifier() {
        return 2;
    }

    @Override
    public AbstractSessionManagementMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return new ScriptBasedSessionManagementMethodOptionsPanel();
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public boolean isTypeForMethod(SessionManagementMethod method) {
        return method instanceof ScriptBasedSessionManagementMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        if (ScriptBasedSessionManagementMethodType.getScriptsExtension() != null) {
            LOG.debug("Registering Script...");
            ScriptBasedSessionManagementMethodType.getScriptsExtension().registerScriptType(new ScriptType(SCRIPT_TYPE_SESSION, "session.method.script.type", SCRIPT_ICON_SESSION, false, new String[]{"append"}));
        }
    }

    @Override
    public SessionManagementMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        ScriptBasedSessionManagementMethod method = new ScriptBasedSessionManagementMethod();
        List<String> scripts = session.getContextDataStrings(contextId, 221);
        if (scripts.size() > 0) {
            this.loadMethod(method, scripts.get(0), session.getContextDataStrings(contextId, 222));
        }
        return method;
    }

    @Override
    public void exportData(Configuration config, SessionManagementMethod sessionMethod) {
        if (!(sessionMethod instanceof ScriptBasedSessionManagementMethod)) {
            throw new SessionManagementMethodType.UnsupportedSessionManagementMethodException(this, "Script based session management type only supports: " + ScriptBasedSessionManagementMethod.class.getName());
        }
        ScriptBasedSessionManagementMethod method = (ScriptBasedSessionManagementMethod)sessionMethod;
        if (method.script != null) {
            config.setProperty(CONTEXT_CONFIG_SESSION_MGMT_SCRIPT_NAME, (Object)method.script.getName());
        }
        config.setProperty(CONTEXT_CONFIG_SESSION_MGMT_SCRIPT_PARAMS, (Object)EncodingUtils.mapToString(method.paramValues));
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, SessionManagementMethod method) throws DatabaseException {
        if (!(method instanceof ScriptBasedSessionManagementMethod)) {
            throw new SessionManagementMethodType.UnsupportedSessionManagementMethodException(this, "Script based session management type only supports: " + ScriptBasedSessionManagementMethod.class.getName());
        }
        ScriptBasedSessionManagementMethod scriptMethod = (ScriptBasedSessionManagementMethod)method;
        if (scriptMethod.script != null) {
            session.setContextData(contextId, 221, scriptMethod.script.getName());
        }
        session.setContextData(contextId, 222, EncodingUtils.mapToString(scriptMethod.paramValues));
    }

    private void loadMethod(ScriptBasedSessionManagementMethod method, String scriptName, List<String> paramValuesS) {
        if (scriptName != null) {
            ScriptWrapper script = ScriptBasedSessionManagementMethodType.getScriptsExtension().getScript(scriptName);
            if (script == null) {
                LOG.error("Unable to find script while loading Script Based Session Management Method for name: " + scriptName);
                if (View.isInitialised()) {
                    View.getSingleton().showMessageDialog(Constant.messages.getString("session.method.script.load.errorScriptNotFound", scriptName));
                }
                return;
            }
            LOG.info("Loaded script:" + script.getName());
            method.script = script;
            SessionScript s = ScriptBasedSessionManagementMethodType.getScriptInterface(script);
            if (s == null) {
                LOG.error("Unable to load Script Based Session Management method. The script " + scriptName + " does not properly implement the Session Management Script interface.");
                return;
            }
        }
        Map<String, String> paramValues = null;
        if (paramValuesS != null && paramValuesS.size() > 0) {
            paramValues = EncodingUtils.stringToMap(paramValuesS.get(0));
            method.paramValues = paramValues;
        } else {
            method.paramValues = new HashMap();
            LOG.error("Unable to load script parameter values loading Script Based Session Management Method for name: " + scriptName);
        }
    }

    @Override
    public void importData(Configuration config, SessionManagementMethod sessionMethod) throws ConfigurationException {
        if (!(sessionMethod instanceof ScriptBasedSessionManagementMethod)) {
            throw new SessionManagementMethodType.UnsupportedSessionManagementMethodException(this, "Script based session management type only supports: " + ScriptBasedSessionManagementMethod.class.getName());
        }
        ScriptBasedSessionManagementMethod method = (ScriptBasedSessionManagementMethod)sessionMethod;
        this.loadMethod(method, config.getString(CONTEXT_CONFIG_SESSION_MGMT_SCRIPT_NAME), ScriptBasedSessionManagementMethodType.objListToStrList(config.getList(CONTEXT_CONFIG_SESSION_MGMT_SCRIPT_PARAMS)));
    }

    private static List<String> objListToStrList(List<Object> oList) {
        ArrayList<String> sList = new ArrayList<String>(oList.size());
        for (Object o : oList) {
            sList.add(o.toString());
        }
        return sList;
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, new String[]{PARAM_SCRIPT_NAME}, new String[]{PARAM_SCRIPT_CONFIG_PARAMS}){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                String scriptName = ApiUtils.getNonEmptyStringParam(params, ScriptBasedSessionManagementMethodType.PARAM_SCRIPT_NAME);
                ScriptBasedSessionManagementMethod method = ScriptBasedSessionManagementMethodType.this.createSessionManagementMethod(context.getId());
                ScriptWrapper script = ScriptBasedSessionManagementMethodType.getScriptsExtension().getScript(scriptName);
                if (script == null) {
                    LOG.error("Unable to find script while loading Script Based Session Management Method for name: " + scriptName);
                    throw new ApiException(ApiException.Type.SCRIPT_NOT_FOUND, scriptName);
                }
                LOG.info("Loaded script for API:" + script.getName());
                method.script = script;
                SessionScript sessionScript = ScriptBasedSessionManagementMethodType.getScriptInterface(script);
                Object[] requiredParams = sessionScript.getRequiredParamsNames();
                Object[] optionalParams = sessionScript.getOptionalParamsNames();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loaded session management script - required parameters: " + Arrays.toString(requiredParams) + " - optional parameters: " + Arrays.toString(optionalParams));
                }
                HashMap<Object, String> paramValues = new HashMap<Object, String>();
                for (Object rp : requiredParams) {
                    String val = ApiUtils.getNonEmptyStringParam(params, (String)rp);
                    paramValues.put(rp, val);
                }
                for (Object op : optionalParams) {
                    paramValues.put(op, ApiUtils.getOptionalStringParam(params, (String)op));
                }
                method.paramValues = paramValues;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loaded session management script parameters:" + paramValues);
                }
                context.setSessionManagementMethod(method);
            }
        };
    }

    private static ExtensionScript getScriptsExtension() {
        if (extensionScript == null) {
            extensionScript = Control.getSingleton().getExtensionLoader().getExtension(ExtensionScript.class);
        }
        return extensionScript;
    }

    public static void setExtensionScript(ExtensionScript extension) {
        extensionScript = extension;
    }

    private static SessionScript getScriptInterface(ScriptWrapper script) {
        try {
            return ScriptBasedSessionManagementMethodType.getScriptsExtension().getInterface(script, SessionScript.class);
        }
        catch (Exception e) {
            ScriptBasedSessionManagementMethodType.getScriptsExtension().handleFailedScriptInterface(script, Constant.messages.getString("session.method.script.dialog.error.text.interface", script.getName()));
            return null;
        }
    }

    static class SessionMethodApiResponseRepresentation<T>
    extends ApiResponseSet<T> {
        public SessionMethodApiResponseRepresentation(Map<String, T> values) {
            super("method", values);
        }

        @Override
        public JSON toJSON() {
            JSONObject response = new JSONObject();
            response.put((Object)this.getName(), (Object)super.toJSON());
            return response;
        }
    }

    public static interface SessionScript {
        public void extractWebSession(SessionWrapper var1);

        public void clearWebSessionIdentifiers(SessionWrapper var1);

        public void processMessageToMatchSession(SessionWrapper var1);

        public String[] getRequiredParamsNames();

        public String[] getOptionalParamsNames();
    }

    public static class SessionWrapper {
        private ScriptBasedSession session;
        private HttpMessage httpMessage;
        private Map<String, String> paramValues;

        public SessionWrapper(ScriptBasedSession session, HttpMessage msg, Map<String, String> paramValues) {
            this.session = session;
            this.httpMessage = msg;
            this.paramValues = paramValues;
        }

        public ScriptBasedSession getSession() {
            return this.session;
        }

        public HttpMessage getHttpMessage() {
            return this.httpMessage;
        }

        public String getParam(String key) {
            return this.paramValues.get(key);
        }
    }

    private static class ScriptWrapperRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);
        private ScriptBasedSessionManagementMethodOptionsPanel panel;

        public ScriptWrapperRenderer(ScriptBasedSessionManagementMethodOptionsPanel panel) {
            this.panel = panel;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setBorder(BORDER);
                ScriptWrapper item = (ScriptWrapper)value;
                if (this.panel.loadedScript == item) {
                    this.setText("<html><b>" + StringEscapeUtils.unescapeHtml((String)item.getName()) + " (loaded)</b></html>");
                } else {
                    this.setText(item.getName());
                }
            }
            return this;
        }
    }

    public static class ScriptBasedSessionManagementMethodOptionsPanel
    extends AbstractSessionManagementMethodOptionsPanel {
        private static final long serialVersionUID = 7812841049435409987L;
        private final String SCRIPT_NAME_LABEL = Constant.messages.getString("session.method.script.field.label.scriptName");
        private final String LABEL_NOT_LOADED = Constant.messages.getString("session.method.script.field.label.notLoaded");
        private JComboBox<ScriptWrapper> scriptsComboBox;
        private JButton loadScriptButton;
        private ScriptBasedSessionManagementMethod method;
        private ScriptWrapper loadedScript;
        private JPanel dynamicContentPanel;
        private DynamicFieldsPanel dynamicFieldsPanel;

        public ScriptBasedSessionManagementMethodOptionsPanel() {
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(this.SCRIPT_NAME_LABEL), LayoutHelper.getGBC(0, 0, 1, 0.0, 0.0));
            this.scriptsComboBox = new JComboBox();
            this.scriptsComboBox.setRenderer(new ScriptWrapperRenderer(this));
            this.add(this.scriptsComboBox, LayoutHelper.getGBC(1, 0, 1, 1.0, 0.0));
            this.loadScriptButton = new JButton("Load");
            this.add((Component)this.loadScriptButton, LayoutHelper.getGBC(2, 0, 1, 0.0, 0.0));
            this.loadScriptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.loadScript((ScriptWrapper)scriptsComboBox.getSelectedItem(), true);
                }
            });
            this.loadScriptButton.setEnabled(false);
            this.scriptsComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    loadScriptButton.setEnabled(scriptsComboBox.getSelectedIndex() >= 0);
                }
            });
            this.dynamicContentPanel = new JPanel(new BorderLayout());
            this.add((Component)this.dynamicContentPanel, LayoutHelper.getGBC(0, 1, 3, 1.0, 0.0));
            this.dynamicContentPanel.add(new JLabel(this.LABEL_NOT_LOADED));
        }

        @Override
        public void validateFields() throws IllegalStateException {
            if (this.loadedScript == null) {
                this.scriptsComboBox.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("session.method.script.dialog.error.text.notLoadedNorConfigured"));
            }
            this.dynamicFieldsPanel.validateFields();
        }

        @Override
        public void saveMethod() {
            this.method.script = (ScriptWrapper)this.scriptsComboBox.getSelectedItem();
            if (this.dynamicFieldsPanel != null) {
                this.method.paramValues = this.dynamicFieldsPanel.getFieldValues();
            } else {
                this.method.paramValues = Collections.emptyMap();
            }
        }

        private void loadScript(ScriptWrapper scriptW, boolean adaptOldValues) {
            SessionScript script = ScriptBasedSessionManagementMethodType.getScriptInterface(scriptW);
            if (script == null) {
                LOG.warn("The script " + scriptW.getName() + " does not properly implement the Session Script interface.");
                this.warnAndResetPanel(Constant.messages.getString("session.method.script.dialog.error.text.interface", scriptW.getName()));
                return;
            }
            try {
                String[] requiredParams = script.getRequiredParamsNames();
                String[] optionalParams = script.getOptionalParamsNames();
                Map<String, String> oldValues = null;
                if (adaptOldValues && this.dynamicFieldsPanel != null) {
                    oldValues = this.dynamicFieldsPanel.getFieldValues();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Trying to adapt old values: " + oldValues);
                    }
                }
                this.dynamicFieldsPanel = new DynamicFieldsPanel(requiredParams, optionalParams);
                this.loadedScript = scriptW;
                if (adaptOldValues && oldValues != null) {
                    this.dynamicFieldsPanel.bindFieldValues(oldValues);
                }
                this.dynamicContentPanel.removeAll();
                this.dynamicContentPanel.add((Component)this.dynamicFieldsPanel, "Center");
                this.dynamicContentPanel.revalidate();
            }
            catch (Exception e) {
                ScriptBasedSessionManagementMethodType.getScriptsExtension().handleScriptException(scriptW, e);
                LOG.error("Error while calling session management script", (Throwable)e);
                this.warnAndResetPanel(Constant.messages.getString("session.method.script.dialog.error.text.loading", ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        private void warnAndResetPanel(String errorMessage) {
            JOptionPane.showMessageDialog(this, errorMessage, Constant.messages.getString("session.method.script.dialog.error.title"), 0);
            this.loadedScript = null;
            this.scriptsComboBox.setSelectedItem(null);
            this.dynamicFieldsPanel = null;
            this.dynamicContentPanel.removeAll();
            this.dynamicContentPanel.add((Component)new JLabel(this.LABEL_NOT_LOADED), "Center");
            this.dynamicContentPanel.revalidate();
        }

        @Override
        public void bindMethod(SessionManagementMethod method) throws SessionManagementMethodType.UnsupportedSessionManagementMethodException {
            this.method = (ScriptBasedSessionManagementMethod)method;
            List<ScriptWrapper> scripts = ScriptBasedSessionManagementMethodType.getScriptsExtension().getScripts(ScriptBasedSessionManagementMethodType.SCRIPT_TYPE_SESSION);
            DefaultComboBoxModel<ScriptWrapper> model = new DefaultComboBoxModel<ScriptWrapper>(scripts.toArray(new ScriptWrapper[scripts.size()]));
            this.scriptsComboBox.setModel(model);
            this.scriptsComboBox.setSelectedItem(this.method.script);
            this.loadScriptButton.setEnabled(this.method.script != null);
            if (this.method.script != null) {
                this.loadScript(this.method.script, false);
                if (this.dynamicFieldsPanel != null) {
                    this.dynamicFieldsPanel.bindFieldValues(this.method.paramValues);
                }
            }
        }

        @Override
        public SessionManagementMethod getMethod() {
            return this.method;
        }
    }

    public static class ScriptBasedSession
    extends WebSession {
        private static int generatedNameIndex;
        private Map<String, Object> map = new HashMap<String, Object>();

        public ScriptBasedSession(String name) {
            super(name, new HttpState());
        }

        public ScriptBasedSession() {
            super("Script Based Session " + generatedNameIndex++, new HttpState());
        }

        public void setValue(String key, Object value) {
            this.map.put(key, value);
        }

        public Object getValue(String key) {
            return this.map.get(key);
        }
    }

    public class ScriptBasedSessionManagementMethod
    implements SessionManagementMethod {
        private ScriptWrapper script;
        private SessionWrapper session;
        private Map<String, String> paramValues = new HashMap<String, String>();

        private SessionWrapper getSessionWrapper(HttpMessage msg) {
            if (this.session != null) {
                return new SessionWrapper(this.session.getSession(), msg, this.paramValues);
            }
            this.session = new SessionWrapper(new ScriptBasedSession(), msg, this.paramValues);
            return this.session;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        public SessionManagementMethodType getType() {
            return new ScriptBasedSessionManagementMethodType();
        }

        @Override
        public WebSession extractWebSession(HttpMessage msg) {
            SessionScript sessionScript = ScriptBasedSessionManagementMethodType.getScriptInterface(this.script);
            if (sessionScript != null) {
                SessionWrapper wrapper = this.getSessionWrapper(msg);
                try {
                    sessionScript.extractWebSession(wrapper);
                }
                catch (Exception e) {
                    ScriptBasedSessionManagementMethodType.getScriptsExtension().handleScriptException(this.script, e);
                }
                return wrapper.getSession();
            }
            return new ScriptBasedSession();
        }

        @Override
        public WebSession createEmptyWebSession() {
            return new ScriptBasedSession();
        }

        @Override
        public void clearWebSessionIdentifiers(HttpMessage msg) {
            SessionScript sessionScript = ScriptBasedSessionManagementMethodType.getScriptInterface(this.script);
            if (sessionScript != null) {
                try {
                    sessionScript.clearWebSessionIdentifiers(this.getSessionWrapper(msg));
                }
                catch (Exception e) {
                    ScriptBasedSessionManagementMethodType.getScriptsExtension().handleScriptException(this.script, e);
                }
            }
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("methodName", ScriptBasedSessionManagementMethodType.API_METHOD_NAME);
            values.put(ScriptBasedSessionManagementMethodType.PARAM_SCRIPT_NAME, this.script.getName());
            values.putAll(this.paramValues);
            return new SessionMethodApiResponseRepresentation(values);
        }

        @Override
        public void processMessageToMatchSession(HttpMessage message, WebSession session) throws SessionManagementMethod.UnsupportedWebSessionException {
            SessionScript sessionScript = ScriptBasedSessionManagementMethodType.getScriptInterface(this.script);
            if (sessionScript != null) {
                try {
                    sessionScript.processMessageToMatchSession(this.getSessionWrapper(message));
                }
                catch (Exception e) {
                    ScriptBasedSessionManagementMethodType.getScriptsExtension().handleScriptException(this.script, e);
                }
            }
        }

        @Override
        public SessionManagementMethod clone() {
            ScriptBasedSessionManagementMethod method = new ScriptBasedSessionManagementMethod();
            method.script = this.script;
            method.paramValues = new HashMap<String, String>(this.paramValues);
            return method;
        }

        public String toString() {
            return "ScriptBasedSessionManagementMethod [script=" + this.script + ", paramValues=" + this.paramValues + "]";
        }
    }
}

