/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.net.SSLSessionManager;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.res.StringManager;

public class JSSESupport
implements SSLSupport,
SSLSessionManager {
    private static final Log log = LogFactory.getLog(JSSESupport.class);
    private static final StringManager sm = StringManager.getManager(JSSESupport.class);
    private static final Map<String, Integer> keySizeCache = new HashMap<String, Integer>();
    private SSLSession session;
    private Map<String, List<String>> additionalAttributes;

    static void init() {
    }

    public JSSESupport(SSLSession sSLSession, Map<String, List<String>> map) {
        this.session = sSLSession;
        this.additionalAttributes = map;
    }

    @Override
    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    @Override
    public X509Certificate[] getLocalCertificateChain() {
        if (this.session == null) {
            return null;
        }
        return JSSESupport.convertCertificates(this.session.getLocalCertificates());
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws IOException {
        if (this.session == null) {
            return null;
        }
        Certificate[] certificateArray = null;
        try {
            certificateArray = this.session.getPeerCertificates();
        }
        catch (Throwable throwable) {
            log.debug((Object)sm.getString("jsseSupport.clientCertError"), throwable);
            return null;
        }
        return JSSESupport.convertCertificates(certificateArray);
    }

    private static X509Certificate[] convertCertificates(Certificate[] certificateArray) {
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            if (certificateArray[i] instanceof X509Certificate) {
                x509CertificateArray[i] = (X509Certificate)certificateArray[i];
            } else {
                try {
                    byte[] byArray = certificateArray[i].getEncoded();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    x509CertificateArray[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                }
                catch (Exception exception) {
                    log.info((Object)sm.getString("jsseSupport.certTranslationError", new Object[]{certificateArray[i]}), (Throwable)exception);
                    return null;
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Cert #" + i + " = " + x509CertificateArray[i]));
        }
        if (x509CertificateArray.length < 1) {
            return null;
        }
        return x509CertificateArray;
    }

    @Override
    public Integer getKeySize() throws IOException {
        if (this.session == null) {
            return null;
        }
        return keySizeCache.get(this.session.getCipherSuite());
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] byArray = this.session.getId();
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by);
            if (string.length() < 2) {
                stringBuilder.append('0');
            }
            if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void setSession(SSLSession sSLSession) {
        this.session = sSLSession;
    }

    @Override
    public void invalidateSession() {
        this.session.invalidate();
    }

    @Override
    public String getProtocol() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getProtocol();
    }

    @Override
    public String getRequestedProtocols() throws IOException {
        if (this.additionalAttributes == null) {
            return null;
        }
        return StringUtils.join((Collection)this.additionalAttributes.get("org.apache.tomcat.util.net.secure_requested_protocol_versions"));
    }

    @Override
    public String getRequestedCiphers() throws IOException {
        if (this.additionalAttributes == null) {
            return null;
        }
        return StringUtils.join((Collection)this.additionalAttributes.get("org.apache.tomcat.util.net.secure_requested_ciphers"));
    }

    static {
        for (Cipher cipher : Cipher.values()) {
            for (String string : cipher.getJsseNames()) {
                keySizeCache.put(string, cipher.getStrength_bits());
            }
        }
    }
}

