/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBackgroundFetchOptions.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSImageResource.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<BackgroundFetchOptions>> convertDictionary<BackgroundFetchOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    BackgroundFetchOptions result;
    JSValue iconsValue;
    if (isNullOrUndefined)
        iconsValue = jsUndefined();
    else {
        iconsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "icons"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!iconsValue.isUndefined()) {
        auto iconsConversionResult = convert<IDLSequence<IDLDictionary<ImageResource>>>(lexicalGlobalObject, iconsValue);
        if (UNLIKELY(iconsConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.icons = iconsConversionResult.releaseReturnValue();
    }
    JSValue titleValue;
    if (isNullOrUndefined)
        titleValue = jsUndefined();
    else {
        titleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "title"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!titleValue.isUndefined()) {
        auto titleConversionResult = convert<IDLDOMString>(lexicalGlobalObject, titleValue);
        if (UNLIKELY(titleConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.title = titleConversionResult.releaseReturnValue();
    }
    JSValue downloadTotalValue;
    if (isNullOrUndefined)
        downloadTotalValue = jsUndefined();
    else {
        downloadTotalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "downloadTotal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto downloadTotalConversionResult = convertOptionalWithDefault<IDLUnsignedLongLong>(lexicalGlobalObject, downloadTotalValue, [&]() -> ConversionResult<IDLUnsignedLongLong> { return Converter<IDLUnsignedLongLong>::ReturnType { 0 }; });
    if (UNLIKELY(downloadTotalConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.downloadTotal = downloadTotalConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
