/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSMathMax.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSNumericArray.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSMathMaxConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSMathMax_values);

class JSCSSMathMaxPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSMathMaxPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSMathMaxPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSMathMaxPrototype>(vm)) JSCSSMathMaxPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSMathMaxPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSMathMaxPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSMathMaxPrototype, JSCSSMathMaxPrototype::Base);

using JSCSSMathMaxDOMConstructor = JSDOMConstructor<JSCSSMathMax>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSMathMaxDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSMathMaxDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto args = convertVariadicArguments<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = CSSMathMax::create(WTFMove(args));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSMathMax>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSMathMax>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSMathMaxDOMConstructorConstruct, JSCSSMathMaxDOMConstructor::construct);

template<> const ClassInfo JSCSSMathMaxDOMConstructor::s_info = { "CSSMathMax"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMathMaxDOMConstructor) };

template<> JSValue JSCSSMathMaxDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSMathValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSMathMaxDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSMathMax"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSMathMax::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSMathMaxPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSMathMaxConstructor, 0 } },
    { "values"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSMathMax_values, 0 } },
};

const ClassInfo JSCSSMathMaxPrototype::s_info = { "CSSMathMax"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMathMaxPrototype) };

void JSCSSMathMaxPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSMathMax::info(), JSCSSMathMaxPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSMathMax::s_info = { "CSSMathMax"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMathMax) };

JSCSSMathMax::JSCSSMathMax(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSMathMax>&& impl)
    : JSCSSMathValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSMathMax> JSCSSMathMax::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSMathMax>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSMathMax::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSMathMaxPrototype::createStructure(vm, &globalObject, JSCSSMathValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSMathMaxPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSMathMax::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSMathMax>(vm, globalObject);
}

JSValue JSCSSMathMax::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSMathMaxDOMConstructor, DOMConstructorID::CSSMathMax>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSMathMaxConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSMathMaxPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSMathMax::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSMathMax_valuesGetter(JSGlobalObject& lexicalGlobalObject, JSCSSMathMax& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSNumericArray>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.values())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSMathMax_values, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSMathMax>::get<jsCSSMathMax_valuesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSMathMax::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSMathMax, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSMathMax.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSMathMax = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSMathMax.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSMathMax = std::forward<decltype(space)>(space); }
    );
}

void JSCSSMathMax::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSMathMax*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSMathMax@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10CSSMathMaxE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CSSMathMax>, void>> static inline void verifyVTable(CSSMathMax* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSMathMax@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10CSSMathMaxE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSMathMax has subclasses. If CSSMathMax has subclasses that get passed
        // to toJS() we currently require CSSMathMax you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSMathMax>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSMathMax>(impl.ptr());
#endif
    return createWrapper<CSSMathMax>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSMathMax& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
