/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMatrix.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrixInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixConstructorFunction_fromMatrix);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixConstructorFunction_fromFloat32Array);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixConstructorFunction_fromFloat64Array);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_multiplySelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_preMultiplySelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_translateSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_scaleSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_scale3dSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_rotateSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_rotateFromVectorSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_rotateAxisAngleSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_skewXSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_skewYSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_invertSelf);
static JSC_DECLARE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_setMatrixValue);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrixConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_a);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_a);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_b);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_b);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_c);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_c);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_d);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_d);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_e);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_e);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_f);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_f);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m11);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m11);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m12);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m12);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m13);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m13);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m14);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m14);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m21);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m21);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m22);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m22);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m23);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m23);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m24);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m24);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m31);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m31);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m32);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m32);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m33);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m33);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m34);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m34);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m41);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m41);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m42);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m42);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m43);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m43);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMatrix_m44);
static JSC_DECLARE_CUSTOM_SETTER(setJSDOMMatrix_m44);

class JSDOMMatrixPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMMatrixPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMatrixPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMatrixPrototype>(vm)) JSDOMMatrixPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMatrixPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMatrixPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMatrixPrototype, JSDOMMatrixPrototype::Base);

using JSDOMMatrixDOMConstructor = JSDOMConstructor<JSDOMMatrix>;

/* Hash table for constructor */

static const HashTableValue JSDOMMatrixConstructorTableValues[] =
{
    { "fromMatrix"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixConstructorFunction_fromMatrix, 0 } },
    { "fromFloat32Array"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixConstructorFunction_fromFloat32Array, 1 } },
    { "fromFloat64Array"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixConstructorFunction_fromFloat64Array, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDOMMatrixDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDOMMatrixDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "DOMMatrix"_s);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto initConversionResult = convert<IDLOptional<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(initConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = DOMMatrix::create(*context, initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DOMMatrix>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDOMMatrixDOMConstructorConstruct, JSDOMMatrixDOMConstructor::construct);

template<> const ClassInfo JSDOMMatrixDOMConstructor::s_info = { "DOMMatrix"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixDOMConstructor) };

template<> JSValue JSDOMMatrixDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDOMMatrixReadOnly::getConstructor(vm, &globalObject);
}

template<> void JSDOMMatrixDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DOMMatrix"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMMatrix::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDOMMatrix::info(), JSDOMMatrixConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSDOMMatrixPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrixConstructor, 0 } },
    { "a"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_a, setJSDOMMatrix_a } },
    { "b"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_b, setJSDOMMatrix_b } },
    { "c"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_c, setJSDOMMatrix_c } },
    { "d"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_d, setJSDOMMatrix_d } },
    { "e"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_e, setJSDOMMatrix_e } },
    { "f"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_f, setJSDOMMatrix_f } },
    { "m11"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m11, setJSDOMMatrix_m11 } },
    { "m12"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m12, setJSDOMMatrix_m12 } },
    { "m13"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m13, setJSDOMMatrix_m13 } },
    { "m14"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m14, setJSDOMMatrix_m14 } },
    { "m21"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m21, setJSDOMMatrix_m21 } },
    { "m22"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m22, setJSDOMMatrix_m22 } },
    { "m23"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m23, setJSDOMMatrix_m23 } },
    { "m24"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m24, setJSDOMMatrix_m24 } },
    { "m31"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m31, setJSDOMMatrix_m31 } },
    { "m32"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m32, setJSDOMMatrix_m32 } },
    { "m33"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m33, setJSDOMMatrix_m33 } },
    { "m34"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m34, setJSDOMMatrix_m34 } },
    { "m41"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m41, setJSDOMMatrix_m41 } },
    { "m42"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m42, setJSDOMMatrix_m42 } },
    { "m43"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m43, setJSDOMMatrix_m43 } },
    { "m44"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMatrix_m44, setJSDOMMatrix_m44 } },
    { "multiplySelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_multiplySelf, 0 } },
    { "preMultiplySelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_preMultiplySelf, 0 } },
    { "translateSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_translateSelf, 0 } },
    { "scaleSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_scaleSelf, 0 } },
    { "scale3dSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_scale3dSelf, 0 } },
    { "rotateSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_rotateSelf, 0 } },
    { "rotateFromVectorSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_rotateFromVectorSelf, 0 } },
    { "rotateAxisAngleSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_rotateAxisAngleSelf, 0 } },
    { "skewXSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_skewXSelf, 0 } },
    { "skewYSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_skewYSelf, 0 } },
    { "invertSelf"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_invertSelf, 0 } },
    { "setMatrixValue"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMMatrixPrototypeFunction_setMatrixValue, 1 } },
};

const ClassInfo JSDOMMatrixPrototype::s_info = { "DOMMatrix"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixPrototype) };

void JSDOMMatrixPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMatrix::info(), JSDOMMatrixPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!(globalObject())->inherits<JSDOMWindowBase>()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setMatrixValue"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMMatrix::s_info = { "DOMMatrix"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrix) };

JSDOMMatrix::JSDOMMatrix(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMatrix>&& impl)
    : JSDOMMatrixReadOnly(structure, globalObject, WTFMove(impl))
{
}

Ref<DOMMatrix> JSDOMMatrix::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMMatrix>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMMatrix::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMMatrixPrototype::createStructure(vm, &globalObject, JSDOMMatrixReadOnly::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSDOMMatrixPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMMatrix::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMMatrix>(vm, globalObject);
}

JSValue JSDOMMatrix::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMatrixDOMConstructor, DOMConstructorID::DOMMatrix>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrixConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMatrixPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMMatrix::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDOMMatrix_aGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.a())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_aGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_aSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setA(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_aSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_bGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.b())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_bGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_bSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setB(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_bSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_cGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.c())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_c, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_cGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_cSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setC(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_c, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_cSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_dGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.d())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_d, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_dGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_dSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setD(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_d, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_dSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_eGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.e())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_e, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_eGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_eSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setE(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_e, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_eSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_fGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.f())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_f, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_fGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_fSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setF(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_f, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_fSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m11Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m11())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m11, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m11Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m11Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM11(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m11, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m11Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m12Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m12())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m12, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m12Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m12Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM12(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m12, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m12Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m13Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m13())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m13, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m13Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m13Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM13(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m13, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m13Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m14Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m14())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m14, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m14Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m14Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM14(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m14, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m14Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m21Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m21())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m21, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m21Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m21Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM21(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m21, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m21Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m22Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m22())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m22, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m22Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m22Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM22(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m22, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m22Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m23Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m23())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m23, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m23Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m23Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM23(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m23, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m23Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m24Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m24())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m24, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m24Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m24Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM24(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m24, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m24Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m31Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m31())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m31, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m31Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m31Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM31(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m31, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m31Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m32Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m32())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m32, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m32Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m32Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM32(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m32, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m32Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m33Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m33())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m33, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m33Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m33Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM33(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m33, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m33Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m34Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m34())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m34, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m34Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m34Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM34(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m34, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m34Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m41Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m41())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m41, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m41Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m41Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM41(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m41, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m41Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m42Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m42())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m42, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m42Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m42Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM42(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m42, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m42Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m43Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m43())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m43, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m43Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m43Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM43(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m43, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m43Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDOMMatrix_m44Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m44())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMatrix_m44, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrix_m44Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDOMMatrix_m44Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setM44(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDOMMatrix_m44, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrix_m44Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsDOMMatrixConstructorFunction_fromMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto otherConversionResult = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(otherConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrix::fromMatrix(otherConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixConstructorFunction_fromMatrix, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::callStatic<jsDOMMatrixConstructorFunction_fromMatrixBody>(*lexicalGlobalObject, *callFrame, "fromMatrix");
}

static inline JSC::EncodedJSValue jsDOMMatrixConstructorFunction_fromFloat32ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto array32ConversionResult = convert<IDLFloat32Array>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array32"_s, "DOMMatrix"_s, "fromFloat32Array"_s, "Float32Array"_s); });
    if (UNLIKELY(array32ConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrix::fromFloat32Array(array32ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixConstructorFunction_fromFloat32Array, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::callStatic<jsDOMMatrixConstructorFunction_fromFloat32ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat32Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixConstructorFunction_fromFloat64ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto array64ConversionResult = convert<IDLFloat64Array>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array64"_s, "DOMMatrix"_s, "fromFloat64Array"_s, "Float64Array"_s); });
    if (UNLIKELY(array64ConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrix::fromFloat64Array(array64ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixConstructorFunction_fromFloat64Array, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::callStatic<jsDOMMatrixConstructorFunction_fromFloat64ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat64Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_multiplySelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto otherConversionResult = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(otherConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.multiplySelf(otherConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_multiplySelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_multiplySelfBody>(*lexicalGlobalObject, *callFrame, "multiplySelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_preMultiplySelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto otherConversionResult = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(otherConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.preMultiplySelf(otherConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_preMultiplySelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_preMultiplySelfBody>(*lexicalGlobalObject, *callFrame, "preMultiplySelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_translateSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto txConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(txConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto tyConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(tyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto tzConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(tzConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.translateSelf(txConversionResult.releaseReturnValue(), tyConversionResult.releaseReturnValue(), tzConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_translateSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_translateSelfBody>(*lexicalGlobalObject, *callFrame, "translateSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_scaleSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto scaleXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (UNLIKELY(scaleXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto scaleYConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(scaleYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto scaleZConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (UNLIKELY(scaleZConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto originXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(originXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto originYConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(originYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto originZConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(originZConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.scaleSelf(scaleXConversionResult.releaseReturnValue(), scaleYConversionResult.releaseReturnValue(), scaleZConversionResult.releaseReturnValue(), originXConversionResult.releaseReturnValue(), originYConversionResult.releaseReturnValue(), originZConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_scaleSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_scaleSelfBody>(*lexicalGlobalObject, *callFrame, "scaleSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_scale3dSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto scaleConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (UNLIKELY(scaleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto originXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(originXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto originYConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(originYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto originZConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(originZConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.scale3dSelf(scaleConversionResult.releaseReturnValue(), originXConversionResult.releaseReturnValue(), originYConversionResult.releaseReturnValue(), originZConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_scale3dSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_scale3dSelfBody>(*lexicalGlobalObject, *callFrame, "scale3dSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_rotateSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto rotXConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(rotXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto rotYConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(rotYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto rotZConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(rotZConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotateSelf(rotXConversionResult.releaseReturnValue(), rotYConversionResult.releaseReturnValue(), rotZConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_rotateSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_rotateSelfBody>(*lexicalGlobalObject, *callFrame, "rotateSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_rotateFromVectorSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotateFromVectorSelf(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_rotateFromVectorSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_rotateFromVectorSelfBody>(*lexicalGlobalObject, *callFrame, "rotateFromVectorSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_rotateAxisAngleSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto zConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(zConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto angleConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(angleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rotateAxisAngleSelf(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), zConversionResult.releaseReturnValue(), angleConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_rotateAxisAngleSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_rotateAxisAngleSelfBody>(*lexicalGlobalObject, *callFrame, "rotateAxisAngleSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_skewXSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto sxConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(sxConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.skewXSelf(sxConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_skewXSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_skewXSelfBody>(*lexicalGlobalObject, *callFrame, "skewXSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_skewYSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto syConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(syConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.skewYSelf(syConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_skewYSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_skewYSelfBody>(*lexicalGlobalObject, *callFrame, "skewYSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_invertSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.invertSelf())));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_invertSelf, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_invertSelfBody>(*lexicalGlobalObject, *callFrame, "invertSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunction_setMatrixValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto transformListConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(transformListConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setMatrixValueForBindings(transformListConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMMatrixPrototypeFunction_setMatrixValue, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunction_setMatrixValueBody>(*lexicalGlobalObject, *callFrame, "setMatrixValue");
}

JSC::GCClient::IsoSubspace* JSDOMMatrix::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMMatrix, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMMatrix.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMMatrix = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMMatrix.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMMatrix = std::forward<decltype(space)>(space); }
    );
}

void JSDOMMatrix::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMMatrix*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMMatrix@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9DOMMatrixE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, DOMMatrix>, void>> static inline void verifyVTable(DOMMatrix* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMMatrix@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore9DOMMatrixE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMMatrix has subclasses. If DOMMatrix has subclasses that get passed
        // to toJS() we currently require DOMMatrix you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMMatrix>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMMatrix>(impl.ptr());
#endif
    return createWrapper<DOMMatrix>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMMatrix& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMMatrix* JSDOMMatrix::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMMatrix*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
