/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMQuadInit.h"

#include "JSDOMPointInit.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<DOMQuadInit>> convertDictionary<DOMQuadInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    DOMQuadInit result;
    JSValue p1Value;
    if (isNullOrUndefined)
        p1Value = jsUndefined();
    else {
        p1Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p1"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!p1Value.isUndefined()) {
        auto p1ConversionResult = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p1Value);
        if (UNLIKELY(p1ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.p1 = p1ConversionResult.releaseReturnValue();
    }
    JSValue p2Value;
    if (isNullOrUndefined)
        p2Value = jsUndefined();
    else {
        p2Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p2"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!p2Value.isUndefined()) {
        auto p2ConversionResult = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p2Value);
        if (UNLIKELY(p2ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.p2 = p2ConversionResult.releaseReturnValue();
    }
    JSValue p3Value;
    if (isNullOrUndefined)
        p3Value = jsUndefined();
    else {
        p3Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p3"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!p3Value.isUndefined()) {
        auto p3ConversionResult = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p3Value);
        if (UNLIKELY(p3ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.p3 = p3ConversionResult.releaseReturnValue();
    }
    JSValue p4Value;
    if (isNullOrUndefined)
        p4Value = jsUndefined();
    else {
        p4Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p4"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!p4Value.isUndefined()) {
        auto p4ConversionResult = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p4Value);
        if (UNLIKELY(p4ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.p4 = p4ConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
