/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMStringMap.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Element.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAbstractOperations.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSNodeCustom.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMStringMapConstructor);

class JSDOMStringMapPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMStringMapPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMStringMapPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMStringMapPrototype>(vm)) JSDOMStringMapPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMStringMapPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMStringMapPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMStringMapPrototype, JSDOMStringMapPrototype::Base);

using JSDOMStringMapDOMConstructor = JSDOMConstructorNotConstructable<JSDOMStringMap>;

template<> const ClassInfo JSDOMStringMapDOMConstructor::s_info = { "DOMStringMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMStringMapDOMConstructor) };

template<> JSValue JSDOMStringMapDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMStringMapDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DOMStringMap"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMStringMap::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDOMStringMapPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMStringMapConstructor, 0 } },
};

const ClassInfo JSDOMStringMapPrototype::s_info = { "DOMStringMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMStringMapPrototype) };

void JSDOMStringMapPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMStringMap::info(), JSDOMStringMapPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMStringMap::s_info = { "DOMStringMap"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMStringMap) };

JSDOMStringMap::JSDOMStringMap(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMStringMap>&& impl)
    : JSDOMWrapper<DOMStringMap>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMStringMap>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMStringMap::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMStringMapPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMStringMapPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMStringMap::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMStringMap>(vm, globalObject);
}

JSValue JSDOMStringMap::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMStringMapDOMConstructor, DOMConstructorID::DOMStringMap>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMStringMap::destroy(JSC::JSCell* cell)
{
    JSDOMStringMap* thisObject = static_cast<JSDOMStringMap*>(cell);
    thisObject->JSDOMStringMap::~JSDOMStringMap();
}

bool JSDOMStringMap::legacyPlatformObjectGetOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot, bool ignoreNamedProperties)
{
    auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
    auto* thisObject = jsCast<JSDOMStringMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (!ignoreNamedProperties) {
        using GetterIDLType = IDLDOMString;
        auto getterFunctor = visibleNamedPropertyItemAccessorFunctor<GetterIDLType, JSDOMStringMap>([] (JSDOMStringMap& thisObject, PropertyName propertyName) -> decltype(auto) {
            return thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
        });
        if (auto namedProperty = accessVisibleNamedProperty<LegacyOverrideBuiltIns::Yes>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
            auto value = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, WTFMove(namedProperty.value()));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, 0, value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSDOMStringMap::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    bool ignoreNamedProperties = false;
    return legacyPlatformObjectGetOwnProperty(object, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
}

bool JSDOMStringMap::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* thisObject = jsCast<JSDOMStringMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    auto propertyName = Identifier::from(vm, index);
    using GetterIDLType = IDLDOMString;
    auto getterFunctor = visibleNamedPropertyItemAccessorFunctor<GetterIDLType, JSDOMStringMap>([] (JSDOMStringMap& thisObject, PropertyName propertyName) -> decltype(auto) {
        return thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
    });
    if (auto namedProperty = accessVisibleNamedProperty<LegacyOverrideBuiltIns::Yes>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, WTFMove(namedProperty.value()));
        RETURN_IF_EXCEPTION(throwScope, false);
        slot.setValue(thisObject, 0, value);
        return true;
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSDOMStringMap::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, DontEnumPropertiesMode mode)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSDOMStringMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
        propertyNames.add(Identifier::fromString(vm, propertyName));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

bool JSDOMStringMap::put(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, JSValue value, PutPropertySlot& putPropertySlot)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    if (UNLIKELY(thisObject != putPropertySlot.thisValue()))
        return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);
    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    if (!propertyName.isSymbol()) {
        auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, value);
        if (UNLIKELY(nativeValue.hasException(throwScope)))
            return true;
        invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return thisObject->wrapped().setNamedItem(propertyNameToString(propertyName), nativeValue.releaseReturnValue()); });
        return true;
    }

    throwScope.assertNoException();
    PropertyDescriptor ownDescriptor;
    PropertySlot slot(thisObject, PropertySlot::InternalMethodType::GetOwnProperty);;
    bool ignoreNamedProperties = true;
    bool hasOwnProperty = legacyPlatformObjectGetOwnProperty(thisObject, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (hasOwnProperty) {
        ownDescriptor.setPropertySlot(lexicalGlobalObject, propertyName, slot);
        RETURN_IF_EXCEPTION(throwScope, false);
    }
    RELEASE_AND_RETURN(throwScope, ordinarySetWithOwnDescriptor(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), WTFMove(ownDescriptor), putPropertySlot.isStrictMode()));
}

bool JSDOMStringMap::putByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index, JSValue value, bool)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto propertyName = Identifier::from(vm, index);
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, value);
    if (UNLIKELY(nativeValue.hasException(throwScope)))
        return true;
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return thisObject->wrapped().setNamedItem(propertyNameToString(propertyName), nativeValue.releaseReturnValue()); });
    return true;
}

bool JSDOMStringMap::defineOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, const PropertyDescriptor& propertyDescriptor, bool shouldThrow)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    if (!propertyName.isSymbol()) {
        if (!propertyDescriptor.isDataDescriptor())
            return typeError(lexicalGlobalObject, throwScope, shouldThrow, "Cannot set named properties on this object"_s);
        auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, propertyDescriptor.value());
        if (UNLIKELY(nativeValue.hasException(throwScope)))
            return true;
        invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return thisObject->wrapped().setNamedItem(propertyNameToString(propertyName), nativeValue.releaseReturnValue()); });
        return true;
    }

    PropertyDescriptor newPropertyDescriptor = propertyDescriptor;
    throwScope.release();
    return JSObject::defineOwnProperty(object, lexicalGlobalObject, propertyName, newPropertyDescriptor, shouldThrow);
}

bool JSDOMStringMap::deleteProperty(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, DeletePropertySlot& slot)
{
    auto& thisObject = *jsCast<JSDOMStringMap*>(cell);
    auto& impl = thisObject.wrapped();
    if (!propertyName.isSymbol() && impl.isSupportedPropertyName(propertyNameToString(propertyName))) {
        if (isVisibleNamedProperty<LegacyOverrideBuiltIns::Yes>(*lexicalGlobalObject, thisObject, propertyName)) {
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
            using ReturnType = decltype(impl.deleteNamedProperty(propertyNameToString(propertyName)));
            static_assert(std::is_same_v<ReturnType, ExceptionOr<bool>> || std::is_same_v<ReturnType, bool>, "The implementation of named deleters without an identifier must return either bool or ExceptionOr<bool>.");
            return performLegacyPlatformObjectDeleteOperation(*lexicalGlobalObject, [&] { return impl.deleteNamedProperty(propertyNameToString(propertyName)); });
        }
    }
    return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
}

bool JSDOMStringMap::deletePropertyByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index)
{
    UNUSED_PARAM(lexicalGlobalObject);
    auto& thisObject = *jsCast<JSDOMStringMap*>(cell);
    auto& impl = thisObject.wrapped();
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto propertyName = Identifier::from(vm, index);
    if (impl.isSupportedPropertyName(propertyNameToString(propertyName))) {
        if (isVisibleNamedProperty<LegacyOverrideBuiltIns::Yes>(*lexicalGlobalObject, thisObject, propertyName)) {
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
            using ReturnType = decltype(impl.deleteNamedProperty(propertyNameToString(propertyName)));
            static_assert(std::is_same_v<ReturnType, ExceptionOr<bool>> || std::is_same_v<ReturnType, bool>, "The implementation of named deleters without an identifier must return either bool or ExceptionOr<bool>.");
            return performLegacyPlatformObjectDeleteOperation(*lexicalGlobalObject, [&] { return impl.deleteNamedProperty(propertyNameToString(propertyName)); });
        }
    }
    return JSObject::deletePropertyByIndex(cell, lexicalGlobalObject, index);
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMStringMapConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMStringMapPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMStringMap::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSDOMStringMap::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMStringMap, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMStringMap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMStringMap = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMStringMap.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMStringMap = std::forward<decltype(space)>(space); }
    );
}

void JSDOMStringMap::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMStringMapOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsDOMStringMap = jsCast<JSDOMStringMap*>(handle.slot()->asCell());
    Element* owner = WTF::getPtr(jsDOMStringMap->wrapped().element());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from DOMStringMapOwner"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSDOMStringMapOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMStringMap = static_cast<JSDOMStringMap*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMStringMap->protectedWrapped().ptr(), jsDOMStringMap);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMStringMap>&& impl)
{
    return createWrapper<DOMStringMap>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMStringMap& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMStringMap* JSDOMStringMap::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMStringMap*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
