/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMValue.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMValue_cssText);
static JSC_DECLARE_CUSTOM_SETTER(setJSDeprecatedCSSOMValue_cssText);
static JSC_DECLARE_CUSTOM_GETTER(jsDeprecatedCSSOMValue_cssValueType);

class JSDeprecatedCSSOMValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMValuePrototype>(vm)) JSDeprecatedCSSOMValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMValuePrototype, JSDeprecatedCSSOMValuePrototype::Base);

using JSDeprecatedCSSOMValueDOMConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMValue>;

/* Hash table for constructor */

static const HashTableValue JSDeprecatedCSSOMValueConstructorTableValues[] =
{
    { "CSS_INHERIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "CSS_PRIMITIVE_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "CSS_VALUE_LIST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "CSS_CUSTOM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
};

static_assert(DeprecatedCSSOMValue::CSS_INHERIT == 0, "CSS_INHERIT in DeprecatedCSSOMValue does not match value from IDL");
static_assert(DeprecatedCSSOMValue::CSS_PRIMITIVE_VALUE == 1, "CSS_PRIMITIVE_VALUE in DeprecatedCSSOMValue does not match value from IDL");
static_assert(DeprecatedCSSOMValue::CSS_VALUE_LIST == 2, "CSS_VALUE_LIST in DeprecatedCSSOMValue does not match value from IDL");
static_assert(DeprecatedCSSOMValue::CSS_CUSTOM == 3, "CSS_CUSTOM in DeprecatedCSSOMValue does not match value from IDL");

template<> const ClassInfo JSDeprecatedCSSOMValueDOMConstructor::s_info = { "CSSValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValueDOMConstructor) };

template<> JSValue JSDeprecatedCSSOMValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDeprecatedCSSOMValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDeprecatedCSSOMValue::info(), JSDeprecatedCSSOMValueConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMValuePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMValueConstructor, 0 } },
    { "cssText"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMValue_cssText, setJSDeprecatedCSSOMValue_cssText } },
    { "cssValueType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDeprecatedCSSOMValue_cssValueType, 0 } },
    { "CSS_INHERIT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "CSS_PRIMITIVE_VALUE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "CSS_VALUE_LIST"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "CSS_CUSTOM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
};

const ClassInfo JSDeprecatedCSSOMValuePrototype::s_info = { "CSSValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValuePrototype) };

void JSDeprecatedCSSOMValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMValue::info(), JSDeprecatedCSSOMValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDeprecatedCSSOMValue::s_info = { "CSSValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValue) };

JSDeprecatedCSSOMValue::JSDeprecatedCSSOMValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMValue>&& impl)
    : JSDOMWrapper<DeprecatedCSSOMValue>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDeprecatedCSSOMValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDeprecatedCSSOMValuePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDeprecatedCSSOMValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDeprecatedCSSOMValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMValue>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMValueDOMConstructor, DOMConstructorID::DeprecatedCSSOMValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDeprecatedCSSOMValue::destroy(JSC::JSCell* cell)
{
    JSDeprecatedCSSOMValue* thisObject = static_cast<JSDeprecatedCSSOMValue*>(cell);
    thisObject->JSDeprecatedCSSOMValue::~JSDeprecatedCSSOMValue();
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMValue::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDeprecatedCSSOMValue_cssTextGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMValue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.cssText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMValue_cssText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMValue>::get<jsDeprecatedCSSOMValue_cssTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSDeprecatedCSSOMValue_cssTextSetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMValue& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCssText(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSDeprecatedCSSOMValue_cssText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMValue>::set<setJSDeprecatedCSSOMValue_cssTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsDeprecatedCSSOMValue_cssValueTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMValue& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.cssValueType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDeprecatedCSSOMValue_cssValueType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDeprecatedCSSOMValue>::get<jsDeprecatedCSSOMValue_cssValueTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSDeprecatedCSSOMValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDeprecatedCSSOMValue, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDeprecatedCSSOMValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDeprecatedCSSOMValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDeprecatedCSSOMValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDeprecatedCSSOMValue = std::forward<decltype(space)>(space); }
    );
}

void JSDeprecatedCSSOMValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

void JSDeprecatedCSSOMValueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDeprecatedCSSOMValue = static_cast<JSDeprecatedCSSOMValue*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDeprecatedCSSOMValue->protectedWrapped().ptr(), jsDeprecatedCSSOMValue);
}

DeprecatedCSSOMValue* JSDeprecatedCSSOMValue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDeprecatedCSSOMValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
