/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTPolygonOffsetClamp.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsEXTPolygonOffsetClampPrototypeFunction_polygonOffsetClampEXT);

class JSEXTPolygonOffsetClampPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTPolygonOffsetClampPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTPolygonOffsetClampPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTPolygonOffsetClampPrototype>(vm)) JSEXTPolygonOffsetClampPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTPolygonOffsetClampPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTPolygonOffsetClampPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTPolygonOffsetClampPrototype, JSEXTPolygonOffsetClampPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTPolygonOffsetClampPrototypeTableValues[] =
{
    { "polygonOffsetClampEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTPolygonOffsetClampPrototypeFunction_polygonOffsetClampEXT, 3 } },
    { "POLYGON_OFFSET_CLAMP_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E1B } },
};

const ClassInfo JSEXTPolygonOffsetClampPrototype::s_info = { "EXTPolygonOffsetClamp"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTPolygonOffsetClampPrototype) };

void JSEXTPolygonOffsetClampPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTPolygonOffsetClamp::info(), JSEXTPolygonOffsetClampPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTPolygonOffsetClamp::s_info = { "EXTPolygonOffsetClamp"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTPolygonOffsetClamp) };

JSEXTPolygonOffsetClamp::JSEXTPolygonOffsetClamp(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTPolygonOffsetClamp>&& impl)
    : JSDOMWrapper<EXTPolygonOffsetClamp>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTPolygonOffsetClamp>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTPolygonOffsetClamp::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTPolygonOffsetClampPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTPolygonOffsetClampPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTPolygonOffsetClamp::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTPolygonOffsetClamp>(vm, globalObject);
}

void JSEXTPolygonOffsetClamp::destroy(JSC::JSCell* cell)
{
    JSEXTPolygonOffsetClamp* thisObject = static_cast<JSEXTPolygonOffsetClamp*>(cell);
    thisObject->JSEXTPolygonOffsetClamp::~JSEXTPolygonOffsetClamp();
}

static inline JSC::EncodedJSValue jsEXTPolygonOffsetClampPrototypeFunction_polygonOffsetClampEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTPolygonOffsetClamp>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto factorConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(factorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto unitsConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(unitsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto clampConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(clampConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.polygonOffsetClampEXT(factorConversionResult.releaseReturnValue(), unitsConversionResult.releaseReturnValue(), clampConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTPolygonOffsetClampPrototypeFunction_polygonOffsetClampEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTPolygonOffsetClamp>::call<jsEXTPolygonOffsetClampPrototypeFunction_polygonOffsetClampEXTBody>(*lexicalGlobalObject, *callFrame, "polygonOffsetClampEXT");
}

JSC::GCClient::IsoSubspace* JSEXTPolygonOffsetClamp::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTPolygonOffsetClamp, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTPolygonOffsetClamp.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTPolygonOffsetClamp = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTPolygonOffsetClamp.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTPolygonOffsetClamp = std::forward<decltype(space)>(space); }
    );
}

void JSEXTPolygonOffsetClamp::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTPolygonOffsetClamp*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTPolygonOffsetClampOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTPolygonOffsetClamp = jsCast<JSEXTPolygonOffsetClamp*>(handle.slot()->asCell());
    auto& owner = jsEXTPolygonOffsetClamp->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsEXTPolygonOffsetClamp"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTPolygonOffsetClampOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTPolygonOffsetClamp = static_cast<JSEXTPolygonOffsetClamp*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTPolygonOffsetClamp->protectedWrapped().ptr(), jsEXTPolygonOffsetClamp);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTPolygonOffsetClamp@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21EXTPolygonOffsetClampE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, EXTPolygonOffsetClamp>, void>> static inline void verifyVTable(EXTPolygonOffsetClamp* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTPolygonOffsetClamp@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21EXTPolygonOffsetClampE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTPolygonOffsetClamp has subclasses. If EXTPolygonOffsetClamp has subclasses that get passed
        // to toJS() we currently require EXTPolygonOffsetClamp you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTPolygonOffsetClamp>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTPolygonOffsetClamp>(impl.ptr());
#endif
    return createWrapper<EXTPolygonOffsetClamp>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTPolygonOffsetClamp& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTPolygonOffsetClamp* JSEXTPolygonOffsetClamp::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTPolygonOffsetClamp*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
