/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequestInit.h"

#include "JSBlob.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMFormData.h"
#include "JSFetchReferrerPolicy.h"
#include "JSFetchRequestCache.h"
#include "JSFetchRequestCredentials.h"
#include "JSFetchRequestMode.h"
#include "JSFetchRequestRedirect.h"
#include "JSReadableStream.h"
#include "JSRequestPriority.h"
#include "JSURLSearchParams.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<FetchRequestInit>> convertDictionary<FetchRequestInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FetchRequestInit result;
    JSValue bodyValue;
    if (isNullOrUndefined)
        bodyValue = jsUndefined();
    else {
        bodyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "body"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bodyValue.isUndefined()) {
        auto bodyConversionResult = convert<IDLNullable<IDLUnion<IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLInterface<URLSearchParams>, IDLInterface<ReadableStream>, IDLUSVString>>>(lexicalGlobalObject, bodyValue);
        if (UNLIKELY(bodyConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.body = bodyConversionResult.releaseReturnValue();
    }
    JSValue cacheValue;
    if (isNullOrUndefined)
        cacheValue = jsUndefined();
    else {
        cacheValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cache"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!cacheValue.isUndefined()) {
        auto cacheConversionResult = convert<IDLEnumeration<FetchRequestCache>>(lexicalGlobalObject, cacheValue);
        if (UNLIKELY(cacheConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.cache = cacheConversionResult.releaseReturnValue();
    }
    JSValue credentialsValue;
    if (isNullOrUndefined)
        credentialsValue = jsUndefined();
    else {
        credentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "credentials"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!credentialsValue.isUndefined()) {
        auto credentialsConversionResult = convert<IDLEnumeration<FetchRequestCredentials>>(lexicalGlobalObject, credentialsValue);
        if (UNLIKELY(credentialsConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.credentials = credentialsConversionResult.releaseReturnValue();
    }
    JSValue headersValue;
    if (isNullOrUndefined)
        headersValue = jsUndefined();
    else {
        headersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headers"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!headersValue.isUndefined()) {
        auto headersConversionResult = convert<IDLUnion<IDLSequence<IDLSequence<IDLByteString>>, IDLRecord<IDLByteString, IDLByteString>>>(lexicalGlobalObject, headersValue);
        if (UNLIKELY(headersConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.headers = headersConversionResult.releaseReturnValue();
    }
    JSValue integrityValue;
    if (isNullOrUndefined)
        integrityValue = jsUndefined();
    else {
        integrityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "integrity"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!integrityValue.isUndefined()) {
        auto integrityConversionResult = convert<IDLDOMString>(lexicalGlobalObject, integrityValue);
        if (UNLIKELY(integrityConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.integrity = integrityConversionResult.releaseReturnValue();
    }
    JSValue keepaliveValue;
    if (isNullOrUndefined)
        keepaliveValue = jsUndefined();
    else {
        keepaliveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keepalive"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!keepaliveValue.isUndefined()) {
        auto keepaliveConversionResult = convert<IDLBoolean>(lexicalGlobalObject, keepaliveValue);
        if (UNLIKELY(keepaliveConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.keepalive = keepaliveConversionResult.releaseReturnValue();
    }
    JSValue methodValue;
    if (isNullOrUndefined)
        methodValue = jsUndefined();
    else {
        methodValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "method"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!methodValue.isUndefined()) {
        auto methodConversionResult = convert<IDLByteString>(lexicalGlobalObject, methodValue);
        if (UNLIKELY(methodConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.method = methodConversionResult.releaseReturnValue();
    }
    JSValue modeValue;
    if (isNullOrUndefined)
        modeValue = jsUndefined();
    else {
        modeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!modeValue.isUndefined()) {
        auto modeConversionResult = convert<IDLEnumeration<FetchRequestMode>>(lexicalGlobalObject, modeValue);
        if (UNLIKELY(modeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.mode = modeConversionResult.releaseReturnValue();
    }
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().fetchPriorityEnabled) {
        JSValue priorityValue;
        if (isNullOrUndefined)
            priorityValue = jsUndefined();
        else {
            priorityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "priority"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!priorityValue.isUndefined()) {
            auto priorityConversionResult = convert<IDLEnumeration<RequestPriority>>(lexicalGlobalObject, priorityValue);
            if (UNLIKELY(priorityConversionResult.hasException(throwScope)))
                return ConversionResultException { };
            result.priority = priorityConversionResult.releaseReturnValue();
        }
    }
    JSValue redirectValue;
    if (isNullOrUndefined)
        redirectValue = jsUndefined();
    else {
        redirectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "redirect"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!redirectValue.isUndefined()) {
        auto redirectConversionResult = convert<IDLEnumeration<FetchRequestRedirect>>(lexicalGlobalObject, redirectValue);
        if (UNLIKELY(redirectConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.redirect = redirectConversionResult.releaseReturnValue();
    }
    JSValue referrerValue;
    if (isNullOrUndefined)
        referrerValue = jsUndefined();
    else {
        referrerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referrer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!referrerValue.isUndefined()) {
        auto referrerConversionResult = convert<IDLUSVString>(lexicalGlobalObject, referrerValue);
        if (UNLIKELY(referrerConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.referrer = referrerConversionResult.releaseReturnValue();
    }
    JSValue referrerPolicyValue;
    if (isNullOrUndefined)
        referrerPolicyValue = jsUndefined();
    else {
        referrerPolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referrerPolicy"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!referrerPolicyValue.isUndefined()) {
        auto referrerPolicyConversionResult = convert<IDLEnumeration<FetchReferrerPolicy>>(lexicalGlobalObject, referrerPolicyValue);
        if (UNLIKELY(referrerPolicyConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.referrerPolicy = referrerPolicyConversionResult.releaseReturnValue();
    }
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto signalConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, signalValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (UNLIKELY(signalConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.signal = signalConversionResult.releaseReturnValue();
    JSValue windowValue;
    if (isNullOrUndefined)
        windowValue = jsUndefined();
    else {
        windowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "window"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto windowConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, windowValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (UNLIKELY(windowConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.window = windowConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
