/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUColorTargetState.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUBlendState.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUColorTargetState>> convertDictionary<GPUColorTargetState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUColorTargetState result;
    JSValue blendValue;
    if (isNullOrUndefined)
        blendValue = jsUndefined();
    else {
        blendValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "blend"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!blendValue.isUndefined()) {
        auto blendConversionResult = convert<IDLDictionary<GPUBlendState>>(lexicalGlobalObject, blendValue);
        if (UNLIKELY(blendConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.blend = blendConversionResult.releaseReturnValue();
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (formatValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format"_s, "GPUColorTargetState"_s, "GPUTextureFormat"_s);
        return ConversionResultException { };
    }
    auto formatConversionResult = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
    if (UNLIKELY(formatConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    JSValue writeMaskValue;
    if (isNullOrUndefined)
        writeMaskValue = jsUndefined();
    else {
        writeMaskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "writeMask"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto writeMaskConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, writeMaskValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0xF }; });
    if (UNLIKELY(writeMaskConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.writeMask = writeMaskConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
