/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUComputePassEncoder.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUBindGroup.h"
#include "JSGPUBuffer.h"
#include "JSGPUComputePipeline.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_setPipeline);
static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroups);
static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroupsIndirect);
static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_end);
static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_pushDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_popDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_insertDebugMarker);
static JSC_DECLARE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_setBindGroup);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUComputePassEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUComputePassEncoder_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPUComputePassEncoder_label);

class JSGPUComputePassEncoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUComputePassEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUComputePassEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUComputePassEncoderPrototype>(vm)) JSGPUComputePassEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUComputePassEncoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUComputePassEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUComputePassEncoderPrototype, JSGPUComputePassEncoderPrototype::Base);

using JSGPUComputePassEncoderDOMConstructor = JSDOMConstructorNotConstructable<JSGPUComputePassEncoder>;

template<> const ClassInfo JSGPUComputePassEncoderDOMConstructor::s_info = { "GPUComputePassEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUComputePassEncoderDOMConstructor) };

template<> JSValue JSGPUComputePassEncoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUComputePassEncoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUComputePassEncoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUComputePassEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUComputePassEncoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUComputePassEncoderConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUComputePassEncoder_label, setJSGPUComputePassEncoder_label } },
    { "setPipeline"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_setPipeline, 1 } },
    { "dispatchWorkgroups"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroups, 1 } },
    { "dispatchWorkgroupsIndirect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroupsIndirect, 2 } },
    { "end"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_end, 0 } },
    { "pushDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_pushDebugGroup, 1 } },
    { "popDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_popDebugGroup, 0 } },
    { "insertDebugMarker"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_insertDebugMarker, 1 } },
    { "setBindGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUComputePassEncoderPrototypeFunction_setBindGroup, 2 } },
};

const ClassInfo JSGPUComputePassEncoderPrototype::s_info = { "GPUComputePassEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUComputePassEncoderPrototype) };

void JSGPUComputePassEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUComputePassEncoder::info(), JSGPUComputePassEncoderPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pushDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "popDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "insertDebugMarker"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setBindGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUComputePassEncoder::s_info = { "GPUComputePassEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUComputePassEncoder) };

JSGPUComputePassEncoder::JSGPUComputePassEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUComputePassEncoder>&& impl)
    : JSDOMWrapper<GPUComputePassEncoder>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUComputePassEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUComputePassEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUComputePassEncoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUComputePassEncoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUComputePassEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUComputePassEncoder>(vm, globalObject);
}

JSValue JSGPUComputePassEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUComputePassEncoderDOMConstructor, DOMConstructorID::GPUComputePassEncoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUComputePassEncoder::destroy(JSC::JSCell* cell)
{
    JSGPUComputePassEncoder* thisObject = static_cast<JSGPUComputePassEncoder*>(cell);
    thisObject->JSGPUComputePassEncoder::~JSGPUComputePassEncoder();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUComputePassEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUComputePassEncoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUComputePassEncoder::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUComputePassEncoder_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPUComputePassEncoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUComputePassEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUComputePassEncoder>::get<jsGPUComputePassEncoder_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPUComputePassEncoder_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPUComputePassEncoder& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPUComputePassEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUComputePassEncoder>::set<setJSGPUComputePassEncoder_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_setPipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pipelineConversionResult = convert<IDLInterface<GPUComputePipeline>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "pipeline"_s, "GPUComputePassEncoder"_s, "setPipeline"_s, "GPUComputePipeline"_s); });
    if (UNLIKELY(pipelineConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPipeline(*pipelineConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_setPipeline, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_setPipelineBody>(*lexicalGlobalObject, *callFrame, "setPipeline");
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroupsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto workgroupCountXConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(workgroupCountXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto workgroupCountYConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(workgroupCountYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto workgroupCountZConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(workgroupCountZConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.dispatchWorkgroups(workgroupCountXConversionResult.releaseReturnValue(), workgroupCountYConversionResult.releaseReturnValue(), workgroupCountZConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroups, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroupsBody>(*lexicalGlobalObject, *callFrame, "dispatchWorkgroups");
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroupsIndirectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indirectBufferConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "indirectBuffer"_s, "GPUComputePassEncoder"_s, "dispatchWorkgroupsIndirect"_s, "GPUBuffer"_s); });
    if (UNLIKELY(indirectBufferConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indirectOffsetConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(indirectOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.dispatchWorkgroupsIndirect(*indirectBufferConversionResult.releaseReturnValue(), indirectOffsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroupsIndirect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_dispatchWorkgroupsIndirectBody>(*lexicalGlobalObject, *callFrame, "dispatchWorkgroupsIndirect");
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_endBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.end(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_end, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_endBody>(*lexicalGlobalObject, *callFrame, "end");
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_pushDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto groupLabelConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(groupLabelConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pushDebugGroup(groupLabelConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_pushDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_pushDebugGroupBody>(*lexicalGlobalObject, *callFrame, "pushDebugGroup");
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_popDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.popDebugGroup(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_popDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_popDebugGroupBody>(*lexicalGlobalObject, *callFrame, "popDebugGroup");
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_insertDebugMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto markerLabelConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(markerLabelConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.insertDebugMarker(markerLabelConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_insertDebugMarker, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_insertDebugMarkerBody>(*lexicalGlobalObject, *callFrame, "insertDebugMarker");
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_setBindGroup1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bindGroupConversionResult = convert<IDLInterface<GPUBindGroup>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "bindGroup"_s, "GPUComputePassEncoder"_s, "setBindGroup"_s, "GPUBindGroup"_s); });
    if (UNLIKELY(bindGroupConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto dynamicOffsetsConversionResult = convertOptionalWithDefault<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>> { return Converter<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>::ReturnType { }; });
    if (UNLIKELY(dynamicOffsetsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindGroup(indexConversionResult.releaseReturnValue(), *bindGroupConversionResult.releaseReturnValue(), dynamicOffsetsConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_setBindGroup2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bindGroupConversionResult = convert<IDLInterface<GPUBindGroup>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "bindGroup"_s, "GPUComputePassEncoder"_s, "setBindGroup"_s, "GPUBindGroup"_s); });
    if (UNLIKELY(bindGroupConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dynamicOffsetsDataConversionResult = convert<IDLUint32Array>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "dynamicOffsetsData"_s, "GPUComputePassEncoder"_s, "setBindGroup"_s, "Uint32Array"_s); });
    if (UNLIKELY(dynamicOffsetsDataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dynamicOffsetsDataStartConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(dynamicOffsetsDataStartConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto dynamicOffsetsDataLengthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(dynamicOffsetsDataLengthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindGroup(indexConversionResult.releaseReturnValue(), *bindGroupConversionResult.releaseReturnValue(), dynamicOffsetsDataConversionResult.releaseReturnValue(), dynamicOffsetsDataStartConversionResult.releaseReturnValue(), dynamicOffsetsDataLengthConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsGPUComputePassEncoderPrototypeFunction_setBindGroupOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUComputePassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsGPUComputePassEncoderPrototypeFunction_setBindGroup1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsGPUComputePassEncoderPrototypeFunction_setBindGroup1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 5) {
        RELEASE_AND_RETURN(throwScope, (jsGPUComputePassEncoderPrototypeFunction_setBindGroup2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsGPUComputePassEncoderPrototypeFunction_setBindGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUComputePassEncoder>::call<jsGPUComputePassEncoderPrototypeFunction_setBindGroupOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setBindGroup");
}

JSC::GCClient::IsoSubspace* JSGPUComputePassEncoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUComputePassEncoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUComputePassEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUComputePassEncoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUComputePassEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUComputePassEncoder = std::forward<decltype(space)>(space); }
    );
}

void JSGPUComputePassEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUComputePassEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUComputePassEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUComputePassEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUComputePassEncoder = static_cast<JSGPUComputePassEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUComputePassEncoder->protectedWrapped().ptr(), jsGPUComputePassEncoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUComputePassEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21GPUComputePassEncoderE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPUComputePassEncoder>, void>> static inline void verifyVTable(GPUComputePassEncoder* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUComputePassEncoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21GPUComputePassEncoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUComputePassEncoder has subclasses. If GPUComputePassEncoder has subclasses that get passed
        // to toJS() we currently require GPUComputePassEncoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUComputePassEncoder>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUComputePassEncoder>(impl.ptr());
#endif
    return createWrapper<GPUComputePassEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUComputePassEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUComputePassEncoder* JSGPUComputePassEncoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUComputePassEncoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
