/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUImageCopyBuffer.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUBuffer.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUImageCopyBuffer>> convertDictionary<GPUImageCopyBuffer>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUImageCopyBuffer result;
    JSValue bytesPerRowValue;
    if (isNullOrUndefined)
        bytesPerRowValue = jsUndefined();
    else {
        bytesPerRowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bytesPerRow"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bytesPerRowValue.isUndefined()) {
        auto bytesPerRowConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, bytesPerRowValue);
        if (UNLIKELY(bytesPerRowConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.bytesPerRow = bytesPerRowConversionResult.releaseReturnValue();
    }
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto offsetConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, offsetValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>::ReturnType { 0 }; });
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.offset = offsetConversionResult.releaseReturnValue();
    JSValue rowsPerImageValue;
    if (isNullOrUndefined)
        rowsPerImageValue = jsUndefined();
    else {
        rowsPerImageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rowsPerImage"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!rowsPerImageValue.isUndefined()) {
        auto rowsPerImageConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, rowsPerImageValue);
        if (UNLIKELY(rowsPerImageConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.rowsPerImage = rowsPerImageConversionResult.releaseReturnValue();
    }
    JSValue bufferValue;
    if (isNullOrUndefined)
        bufferValue = jsUndefined();
    else {
        bufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (bufferValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "buffer"_s, "GPUImageCopyBuffer"_s, "GPUBuffer"_s);
        return ConversionResultException { };
    }
    auto bufferConversionResult = convert<IDLInterface<GPUBuffer>>(lexicalGlobalObject, bufferValue);
    if (UNLIKELY(bufferConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.buffer = bufferConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
