/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUMapMode.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUMapModeConstructor);

class JSGPUMapModePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUMapModePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUMapModePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUMapModePrototype>(vm)) JSGPUMapModePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUMapModePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUMapModePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUMapModePrototype, JSGPUMapModePrototype::Base);

using JSGPUMapModeDOMConstructor = JSDOMConstructorNotConstructable<JSGPUMapMode>;

/* Hash table for constructor */

static const HashTableValue JSGPUMapModeConstructorTableValues[] =
{
    { "READ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0001 } },
    { "WRITE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0002 } },
};

static_assert(GPUMapMode::READ == 0x0001, "READ in GPUMapMode does not match value from IDL");
static_assert(GPUMapMode::WRITE == 0x0002, "WRITE in GPUMapMode does not match value from IDL");

template<> const ClassInfo JSGPUMapModeDOMConstructor::s_info = { "GPUMapMode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUMapModeDOMConstructor) };

template<> JSValue JSGPUMapModeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUMapModeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUMapMode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUMapMode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSGPUMapMode::info(), JSGPUMapModeConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSGPUMapModePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUMapModeConstructor, 0 } },
    { "READ"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0001 } },
    { "WRITE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0002 } },
};

const ClassInfo JSGPUMapModePrototype::s_info = { "GPUMapMode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUMapModePrototype) };

void JSGPUMapModePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUMapMode::info(), JSGPUMapModePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUMapMode::s_info = { "GPUMapMode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUMapMode) };

JSGPUMapMode::JSGPUMapMode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUMapMode>&& impl)
    : JSDOMWrapper<GPUMapMode>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUMapMode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUMapMode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUMapModePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUMapModePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUMapMode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUMapMode>(vm, globalObject);
}

JSValue JSGPUMapMode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUMapModeDOMConstructor, DOMConstructorID::GPUMapMode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUMapMode::destroy(JSC::JSCell* cell)
{
    JSGPUMapMode* thisObject = static_cast<JSGPUMapMode*>(cell);
    thisObject->JSGPUMapMode::~JSGPUMapMode();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUMapModeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUMapModePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUMapMode::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSGPUMapMode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUMapMode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUMapMode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUMapMode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUMapMode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUMapMode = std::forward<decltype(space)>(space); }
    );
}

void JSGPUMapMode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUMapMode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUMapModeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUMapModeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUMapMode = static_cast<JSGPUMapMode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUMapMode->protectedWrapped().ptr(), jsGPUMapMode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUMapMode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10GPUMapModeE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPUMapMode>, void>> static inline void verifyVTable(GPUMapMode* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUMapMode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10GPUMapModeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUMapMode has subclasses. If GPUMapMode has subclasses that get passed
        // to toJS() we currently require GPUMapMode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUMapMode>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUMapMode>(impl.ptr());
#endif
    return createWrapper<GPUMapMode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUMapMode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUMapMode* JSGPUMapMode::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUMapMode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
