/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTreeWalker.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_parentNode);
static JSC_DECLARE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_firstChild);
static JSC_DECLARE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_lastChild);
static JSC_DECLARE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_previousSibling);
static JSC_DECLARE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_nextSibling);
static JSC_DECLARE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_previousNode);
static JSC_DECLARE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_nextNode);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTreeWalkerConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsTreeWalker_root);
static JSC_DECLARE_CUSTOM_GETTER(jsTreeWalker_whatToShow);
static JSC_DECLARE_CUSTOM_GETTER(jsTreeWalker_filter);
static JSC_DECLARE_CUSTOM_GETTER(jsTreeWalker_currentNode);
static JSC_DECLARE_CUSTOM_SETTER(setJSTreeWalker_currentNode);

class JSTreeWalkerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTreeWalkerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTreeWalkerPrototype* ptr = new (NotNull, JSC::allocateCell<JSTreeWalkerPrototype>(vm)) JSTreeWalkerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTreeWalkerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTreeWalkerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTreeWalkerPrototype, JSTreeWalkerPrototype::Base);

using JSTreeWalkerDOMConstructor = JSDOMConstructorNotConstructable<JSTreeWalker>;

template<> const ClassInfo JSTreeWalkerDOMConstructor::s_info = { "TreeWalker"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTreeWalkerDOMConstructor) };

template<> JSValue JSTreeWalkerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTreeWalkerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TreeWalker"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTreeWalker::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTreeWalkerPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsTreeWalkerConstructor, 0 } },
    { "root"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTreeWalker_root, 0 } },
    { "whatToShow"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTreeWalker_whatToShow, 0 } },
    { "filter"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTreeWalker_filter, 0 } },
    { "currentNode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsTreeWalker_currentNode, setJSTreeWalker_currentNode } },
    { "parentNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTreeWalkerPrototypeFunction_parentNode, 0 } },
    { "firstChild"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTreeWalkerPrototypeFunction_firstChild, 0 } },
    { "lastChild"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTreeWalkerPrototypeFunction_lastChild, 0 } },
    { "previousSibling"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTreeWalkerPrototypeFunction_previousSibling, 0 } },
    { "nextSibling"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTreeWalkerPrototypeFunction_nextSibling, 0 } },
    { "previousNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTreeWalkerPrototypeFunction_previousNode, 0 } },
    { "nextNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsTreeWalkerPrototypeFunction_nextNode, 0 } },
};

const ClassInfo JSTreeWalkerPrototype::s_info = { "TreeWalker"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTreeWalkerPrototype) };

void JSTreeWalkerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTreeWalker::info(), JSTreeWalkerPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTreeWalker::s_info = { "TreeWalker"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTreeWalker) };

JSTreeWalker::JSTreeWalker(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TreeWalker>&& impl)
    : JSDOMWrapper<TreeWalker>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, TreeWalker>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSTreeWalker::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSTreeWalkerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSTreeWalkerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSTreeWalker::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTreeWalker>(vm, globalObject);
}

JSValue JSTreeWalker::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTreeWalkerDOMConstructor, DOMConstructorID::TreeWalker>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSTreeWalker::destroy(JSC::JSCell* cell)
{
    JSTreeWalker* thisObject = static_cast<JSTreeWalker*>(cell);
    thisObject->JSTreeWalker::~JSTreeWalker();
}

JSC_DEFINE_CUSTOM_GETTER(jsTreeWalkerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTreeWalkerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTreeWalker::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsTreeWalker_rootGetter(JSGlobalObject& lexicalGlobalObject, JSTreeWalker& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.root())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTreeWalker_root, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTreeWalker>::get<jsTreeWalker_rootGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTreeWalker_whatToShowGetter(JSGlobalObject& lexicalGlobalObject, JSTreeWalker& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.whatToShow())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTreeWalker_whatToShow, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTreeWalker>::get<jsTreeWalker_whatToShowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTreeWalker_filterGetter(JSGlobalObject& lexicalGlobalObject, JSTreeWalker& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLCallbackInterface<JSNodeFilter>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.filter())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTreeWalker_filter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTreeWalker>::get<jsTreeWalker_filterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTreeWalker_currentNodeGetter(JSGlobalObject& lexicalGlobalObject, JSTreeWalker& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTreeWalker_currentNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTreeWalker>::get<jsTreeWalker_currentNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSTreeWalker_currentNodeSetter(JSGlobalObject& lexicalGlobalObject, JSTreeWalker& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLInterface<Node>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "TreeWalker"_s, "currentNode"_s, "Node"_s); });
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCurrentNode(*nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSTreeWalker_currentNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSTreeWalker>::set<setJSTreeWalker_currentNodeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsTreeWalkerPrototypeFunction_parentNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTreeWalker>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.parentNode())));
}

JSC_DEFINE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_parentNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTreeWalker>::call<jsTreeWalkerPrototypeFunction_parentNodeBody>(*lexicalGlobalObject, *callFrame, "parentNode");
}

static inline JSC::EncodedJSValue jsTreeWalkerPrototypeFunction_firstChildBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTreeWalker>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.firstChild())));
}

JSC_DEFINE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_firstChild, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTreeWalker>::call<jsTreeWalkerPrototypeFunction_firstChildBody>(*lexicalGlobalObject, *callFrame, "firstChild");
}

static inline JSC::EncodedJSValue jsTreeWalkerPrototypeFunction_lastChildBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTreeWalker>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.lastChild())));
}

JSC_DEFINE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_lastChild, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTreeWalker>::call<jsTreeWalkerPrototypeFunction_lastChildBody>(*lexicalGlobalObject, *callFrame, "lastChild");
}

static inline JSC::EncodedJSValue jsTreeWalkerPrototypeFunction_previousSiblingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTreeWalker>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.previousSibling())));
}

JSC_DEFINE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_previousSibling, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTreeWalker>::call<jsTreeWalkerPrototypeFunction_previousSiblingBody>(*lexicalGlobalObject, *callFrame, "previousSibling");
}

static inline JSC::EncodedJSValue jsTreeWalkerPrototypeFunction_nextSiblingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTreeWalker>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.nextSibling())));
}

JSC_DEFINE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_nextSibling, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTreeWalker>::call<jsTreeWalkerPrototypeFunction_nextSiblingBody>(*lexicalGlobalObject, *callFrame, "nextSibling");
}

static inline JSC::EncodedJSValue jsTreeWalkerPrototypeFunction_previousNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTreeWalker>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.previousNode())));
}

JSC_DEFINE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_previousNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTreeWalker>::call<jsTreeWalkerPrototypeFunction_previousNodeBody>(*lexicalGlobalObject, *callFrame, "previousNode");
}

static inline JSC::EncodedJSValue jsTreeWalkerPrototypeFunction_nextNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTreeWalker>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.nextNode())));
}

JSC_DEFINE_HOST_FUNCTION(jsTreeWalkerPrototypeFunction_nextNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTreeWalker>::call<jsTreeWalkerPrototypeFunction_nextNodeBody>(*lexicalGlobalObject, *callFrame, "nextNode");
}

JSC::GCClient::IsoSubspace* JSTreeWalker::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTreeWalker, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTreeWalker.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTreeWalker = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTreeWalker.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTreeWalker = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSTreeWalker::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTreeWalker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSTreeWalker);

template<typename Visitor>
void JSTreeWalker::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSTreeWalker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSTreeWalker::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSTreeWalker::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSTreeWalker::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTreeWalker*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSTreeWalkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSTreeWalkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTreeWalker = static_cast<JSTreeWalker*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTreeWalker->protectedWrapped().ptr(), jsTreeWalker);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TreeWalker@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10TreeWalkerE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, TreeWalker>, void>> static inline void verifyVTable(TreeWalker* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TreeWalker@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10TreeWalkerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TreeWalker has subclasses. If TreeWalker has subclasses that get passed
        // to toJS() we currently require TreeWalker you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TreeWalker>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<TreeWalker>(impl.ptr());
#endif
    return createWrapper<TreeWalker>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TreeWalker& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

TreeWalker* JSTreeWalker::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTreeWalker*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
