/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSViewTimeline.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSViewTimelineOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsViewTimelineConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsViewTimeline_subject);
static JSC_DECLARE_CUSTOM_GETTER(jsViewTimeline_startOffset);
static JSC_DECLARE_CUSTOM_GETTER(jsViewTimeline_endOffset);

class JSViewTimelinePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSViewTimelinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSViewTimelinePrototype* ptr = new (NotNull, JSC::allocateCell<JSViewTimelinePrototype>(vm)) JSViewTimelinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSViewTimelinePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSViewTimelinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSViewTimelinePrototype, JSViewTimelinePrototype::Base);

using JSViewTimelineDOMConstructor = JSDOMConstructor<JSViewTimeline>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSViewTimelineDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSViewTimelineDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<ViewTimelineOptions>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = ViewTimeline::create(optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ViewTimeline>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ViewTimeline>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSViewTimelineDOMConstructorConstruct, JSViewTimelineDOMConstructor::construct);

template<> const ClassInfo JSViewTimelineDOMConstructor::s_info = { "ViewTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSViewTimelineDOMConstructor) };

template<> JSValue JSViewTimelineDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSScrollTimeline::getConstructor(vm, &globalObject);
}

template<> void JSViewTimelineDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ViewTimeline"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSViewTimeline::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSViewTimelinePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTimelineConstructor, 0 } },
    { "subject"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTimeline_subject, 0 } },
    { "startOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTimeline_startOffset, 0 } },
    { "endOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTimeline_endOffset, 0 } },
};

const ClassInfo JSViewTimelinePrototype::s_info = { "ViewTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSViewTimelinePrototype) };

void JSViewTimelinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSViewTimeline::info(), JSViewTimelinePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSViewTimeline::s_info = { "ViewTimeline"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSViewTimeline) };

JSViewTimeline::JSViewTimeline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ViewTimeline>&& impl)
    : JSScrollTimeline(structure, globalObject, WTFMove(impl))
{
}

Ref<ViewTimeline> JSViewTimeline::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, ViewTimeline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSViewTimeline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSViewTimelinePrototype::createStructure(vm, &globalObject, JSScrollTimeline::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSViewTimelinePrototype::create(vm, &globalObject, structure);
}

JSObject* JSViewTimeline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSViewTimeline>(vm, globalObject);
}

JSValue JSViewTimeline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSViewTimelineDOMConstructor, DOMConstructorID::ViewTimeline>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTimelineConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSViewTimelinePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSViewTimeline::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsViewTimeline_subjectGetter(JSGlobalObject& lexicalGlobalObject, JSViewTimeline& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.subject())));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTimeline_subject, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTimeline>::get<jsViewTimeline_subjectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsViewTimeline_startOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSViewTimeline& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSNumericValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.startOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTimeline_startOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTimeline>::get<jsViewTimeline_startOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsViewTimeline_endOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSViewTimeline& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSNumericValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.endOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTimeline_endOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTimeline>::get<jsViewTimeline_endOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSViewTimeline::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSViewTimeline, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForViewTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForViewTimeline = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForViewTimeline.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForViewTimeline = std::forward<decltype(space)>(space); }
    );
}

void JSViewTimeline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSViewTimeline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ViewTimeline@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12ViewTimelineE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, ViewTimeline>, void>> static inline void verifyVTable(ViewTimeline* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ViewTimeline@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12ViewTimelineE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ViewTimeline has subclasses. If ViewTimeline has subclasses that get passed
        // to toJS() we currently require ViewTimeline you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ViewTimeline>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ViewTimeline>(impl.ptr());
#endif
    return createWrapper<ViewTimeline>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ViewTimeline& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
