/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSViewTransition.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSViewTransitionTypeSet.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsViewTransitionPrototypeFunction_skipTransition);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsViewTransitionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsViewTransition_updateCallbackDone);
static JSC_DECLARE_CUSTOM_GETTER(jsViewTransition_ready);
static JSC_DECLARE_CUSTOM_GETTER(jsViewTransition_finished);
static JSC_DECLARE_CUSTOM_GETTER(jsViewTransition_types);
static JSC_DECLARE_CUSTOM_SETTER(setJSViewTransition_types);

class JSViewTransitionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSViewTransitionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSViewTransitionPrototype* ptr = new (NotNull, JSC::allocateCell<JSViewTransitionPrototype>(vm)) JSViewTransitionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSViewTransitionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSViewTransitionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSViewTransitionPrototype, JSViewTransitionPrototype::Base);

using JSViewTransitionDOMConstructor = JSDOMConstructorNotConstructable<JSViewTransition>;

template<> const ClassInfo JSViewTransitionDOMConstructor::s_info = { "ViewTransition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSViewTransitionDOMConstructor) };

template<> JSValue JSViewTransitionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSViewTransitionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ViewTransition"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSViewTransition::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSViewTransitionPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTransitionConstructor, 0 } },
    { "updateCallbackDone"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTransition_updateCallbackDone, 0 } },
    { "ready"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTransition_ready, 0 } },
    { "finished"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTransition_finished, 0 } },
    { "types"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsViewTransition_types, setJSViewTransition_types } },
    { "skipTransition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsViewTransitionPrototypeFunction_skipTransition, 0 } },
};

const ClassInfo JSViewTransitionPrototype::s_info = { "ViewTransition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSViewTransitionPrototype) };

void JSViewTransitionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSViewTransition::info(), JSViewTransitionPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().viewTransitionTypesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "types"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSViewTransition::s_info = { "ViewTransition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSViewTransition) };

JSViewTransition::JSViewTransition(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ViewTransition>&& impl)
    : JSDOMWrapper<ViewTransition>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, ViewTransition>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSViewTransition::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSViewTransitionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSViewTransitionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSViewTransition::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSViewTransition>(vm, globalObject);
}

JSValue JSViewTransition::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSViewTransitionDOMConstructor, DOMConstructorID::ViewTransition>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSViewTransition::destroy(JSC::JSCell* cell)
{
    JSViewTransition* thisObject = static_cast<JSViewTransition*>(cell);
    thisObject->JSViewTransition::~JSViewTransition();
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTransitionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSViewTransitionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSViewTransition::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsViewTransition_updateCallbackDoneGetter(JSGlobalObject& lexicalGlobalObject, JSViewTransition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLUndefined>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.updateCallbackDone(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTransition_updateCallbackDone, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTransition>::get<jsViewTransition_updateCallbackDoneGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsViewTransition_readyGetter(JSGlobalObject& lexicalGlobalObject, JSViewTransition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLUndefined>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.ready(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTransition_ready, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTransition>::get<jsViewTransition_readyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsViewTransition_finishedGetter(JSGlobalObject& lexicalGlobalObject, JSViewTransition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLUndefined>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.finished(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTransition_finished, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTransition>::get<jsViewTransition_finishedGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsViewTransition_typesGetter(JSGlobalObject& lexicalGlobalObject, JSViewTransition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ViewTransitionTypeSet>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.types())));
}

JSC_DEFINE_CUSTOM_GETTER(jsViewTransition_types, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTransition>::get<jsViewTransition_typesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSViewTransition_typesSetter(JSGlobalObject& lexicalGlobalObject, JSViewTransition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLInterface<ViewTransitionTypeSet>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "ViewTransition"_s, "types"_s, "ViewTransitionTypeSet"_s); });
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTypes(*nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSViewTransition_types, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSViewTransition>::set<setJSViewTransition_typesSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsViewTransitionPrototypeFunction_skipTransitionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSViewTransition>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.skipTransition(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsViewTransitionPrototypeFunction_skipTransition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSViewTransition>::call<jsViewTransitionPrototypeFunction_skipTransitionBody>(*lexicalGlobalObject, *callFrame, "skipTransition");
}

JSC::GCClient::IsoSubspace* JSViewTransition::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSViewTransition, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForViewTransition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForViewTransition = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForViewTransition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForViewTransition = std::forward<decltype(space)>(space); }
    );
}

void JSViewTransition::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSViewTransition*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSViewTransitionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsViewTransition = jsCast<JSViewTransition*>(handle.slot()->asCell());
    auto& wrapped = jsViewTransition->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSViewTransitionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsViewTransition = static_cast<JSViewTransition*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsViewTransition->protectedWrapped().ptr(), jsViewTransition);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ViewTransition@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14ViewTransitionE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, ViewTransition>, void>> static inline void verifyVTable(ViewTransition* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ViewTransition@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14ViewTransitionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ViewTransition has subclasses. If ViewTransition has subclasses that get passed
        // to toJS() we currently require ViewTransition you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ViewTransition>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ViewTransition>(impl.ptr());
#endif
    return createWrapper<ViewTransition>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ViewTransition& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ViewTransition* JSViewTransition::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSViewTransition*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
