/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "NodeName.h"

#include "HTMLNames.h"
#include "MathMLNames.h"
#include "SVGNames.h"
#include "XLinkNames.h"
#include "XMLNames.h"
#include "XMLNSNames.h"
#include "Namespace.h"
#include <wtf/text/FastCharacterComparison.h>

namespace WebCore {

template <typename characterType>
static inline NodeName findNoNamespaceNodeName(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 1: {
        switch (buffer[0]) {
        case 'd': {
            return NodeName::dAttr;
        }
        case 'k': {
            return NodeName::kAttr;
        }
        case 'r': {
            return NodeName::rAttr;
        }
        case 'x': {
            return NodeName::xAttr;
        }
        case 'y': {
            return NodeName::yAttr;
        }
        case 'z': {
            return NodeName::zAttr;
        }
        default:
            break;
        }
        break;
    }
    case 2: {
        switch (buffer[0]) {
        case 'a': {
            if (buffer[1] == 's') {
                return NodeName::asAttr;
            }
            break;
        }
        case 'b': {
            if (buffer[1] == 'y') {
                return NodeName::byAttr;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'x': {
                return NodeName::cxAttr;
            }
            case 'y': {
                return NodeName::cyAttr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'x': {
                return NodeName::dxAttr;
            }
            case 'y': {
                return NodeName::dyAttr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'r': {
                return NodeName::frAttr;
            }
            case 'x': {
                return NodeName::fxAttr;
            }
            case 'y': {
                return NodeName::fyAttr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'g': {
            switch (buffer[1]) {
            case '1': {
                return NodeName::g1Attr;
            }
            case '2': {
                return NodeName::g2Attr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'd': {
                return NodeName::idAttr;
            }
            case 'n': {
                return NodeName::inAttr;
            }
            case 's': {
                return NodeName::isAttr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'k': {
            switch (buffer[1]) {
            case '1': {
                return NodeName::k1Attr;
            }
            case '2': {
                return NodeName::k2Attr;
            }
            case '3': {
                return NodeName::k3Attr;
            }
            case '4': {
                return NodeName::k4Attr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'x': {
                return NodeName::rxAttr;
            }
            case 'y': {
                return NodeName::ryAttr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (buffer[1] == 'o') {
                return NodeName::toAttr;
            }
            break;
        }
        case 'u': {
            switch (buffer[1]) {
            case '1': {
                return NodeName::u1Attr;
            }
            case '2': {
                return NodeName::u2Attr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'x': {
            switch (buffer[1]) {
            case '1': {
                return NodeName::x1Attr;
            }
            case '2': {
                return NodeName::x2Attr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'y': {
            switch (buffer[1]) {
            case '1': {
                return NodeName::y1Attr;
            }
            case '2': {
                return NodeName::y2Attr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 3: {
        switch (buffer[0]) {
        case 'a': {
            if (compareCharacters(buffer.data() + 1, 'l', 't')) {
                return NodeName::altAttr;
            }
            break;
        }
        case 'c': {
            if (compareCharacters(buffer.data() + 1, 'u', 'e')) {
                return NodeName::cueAttr;
            }
            break;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'i': {
                if (buffer[2] == 'r') {
                    return NodeName::dirAttr;
                }
                break;
            }
            case 'u': {
                if (buffer[2] == 'r') {
                    return NodeName::durAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'n', 'd')) {
                return NodeName::endAttr;
            }
            break;
        }
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'o', 'r')) {
                return NodeName::forAttr;
            }
            break;
        }
        case 'i': {
            if (compareCharacters(buffer.data() + 1, 'n', '2')) {
                return NodeName::in2Attr;
            }
            break;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'o', 'w')) {
                return NodeName::lowAttr;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (buffer[2] == 'x') {
                    return NodeName::maxAttr;
                }
                break;
            }
            case 'i': {
                if (buffer[2] == 'n') {
                    return NodeName::minAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'l': {
                    return NodeName::relAttr;
                }
                case 'v': {
                    return NodeName::revAttr;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            if (compareCharacters(buffer.data() + 1, 'r', 'c')) {
                return NodeName::srcAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 4: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'b', 'r')) {
                    return NodeName::abbrAttr;
                }
                break;
            }
            case 'x': {
                if (compareCharacters(buffer.data() + 2, 'i', 's')) {
                    return NodeName::axisAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'i', 'a', 's')) {
                return NodeName::biasAttr;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'h': {
                if (compareCharacters(buffer.data() + 2, 'a', 'r')) {
                    return NodeName::charAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 't', 'e')) {
                    return NodeName::citeAttr;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'i', 'p')) {
                    return NodeName::clipAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'd': {
                    if (buffer[3] == 'e') {
                        return NodeName::codeAttr;
                    }
                    break;
                }
                case 'l': {
                    if (buffer[3] == 's') {
                        return NodeName::colsAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'a', 't', 'a')) {
                return NodeName::dataAttr;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'c', 'e')) {
                    return NodeName::faceAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'l', 'l')) {
                    return NodeName::fillAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'r', 'm')) {
                    return NodeName::formAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'm')) {
                    return NodeName::fromAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'g', 'h')) {
                    return NodeName::highAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'e', 'f')) {
                    return NodeName::hrefAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'k': {
            if (compareCharacters(buffer.data() + 1, 'i', 'n', 'd')) {
                return NodeName::kindAttr;
            }
            break;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'n', 'g')) {
                    return NodeName::langAttr;
                }
                break;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'n': {
                    if (buffer[3] == 'k') {
                        return NodeName::linkAttr;
                    }
                    break;
                }
                case 's': {
                    if (buffer[3] == 't') {
                        return NodeName::listAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'o', 'p')) {
                    return NodeName::loopAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 's', 'k')) {
                    return NodeName::maskAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'd', 'e')) {
                    return NodeName::modeAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'a', 'm', 'e')) {
                return NodeName::nameAttr;
            }
            break;
        }
        case 'o': {
            if (compareCharacters(buffer.data() + 1, 'p', 'e', 'n')) {
                return NodeName::openAttr;
            }
            break;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'r': {
                    if (buffer[3] == 't') {
                        return NodeName::partAttr;
                    }
                    break;
                }
                case 't': {
                    if (buffer[3] == 'h') {
                        return NodeName::pathAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'n', 'g')) {
                    return NodeName::pingAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'f': {
                    switch (buffer[3]) {
                    case 'X': {
                        return NodeName::refXAttr;
                    }
                    case 'Y': {
                        return NodeName::refYAttr;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'l': {
                    if (buffer[3] == 'e') {
                        return NodeName::roleAttr;
                    }
                    break;
                }
                case 'w': {
                    if (buffer[3] == 's') {
                        return NodeName::rowsAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'v', 'e')) {
                    return NodeName::saveAttr;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'e', 'd')) {
                    return NodeName::seedAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'z', 'e')) {
                    return NodeName::sizeAttr;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'o', 't')) {
                    return NodeName::slotAttr;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'a', 'n')) {
                    return NodeName::spanAttr;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'e', 'p')) {
                    return NodeName::stepAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'x', 't')) {
                    return NodeName::textAttr;
                }
                break;
            }
            case 'y': {
                if (compareCharacters(buffer.data() + 2, 'p', 'e')) {
                    return NodeName::typeAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'w': {
            if (compareCharacters(buffer.data() + 1, 'r', 'a', 'p')) {
                return NodeName::wrapAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 5: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'l': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'g': {
                        if (buffer[4] == 'n') {
                            return NodeName::alignAttr;
                        }
                        break;
                    }
                    case 'n': {
                        if (buffer[4] == 'k') {
                            return NodeName::alinkAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'w')) {
                        return NodeName::allowAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'y', 'n', 'c')) {
                    return NodeName::asyncAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'e', 'g', 'i', 'n')) {
                return NodeName::beginAttr;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'l': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 's', 's')) {
                        return NodeName::classAttr;
                    }
                    break;
                }
                case 'e': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'r')) {
                        return NodeName::clearAttr;
                    }
                    break;
                }
                case 'o': {
                    if (compareCharacters(buffer.data() + 3, 's', 'e')) {
                        return NodeName::closeAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'l', 'o', 'r')) {
                    return NodeName::colorAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'f': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r')) {
                        return NodeName::deferAttr;
                    }
                    break;
                }
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 't', 'h')) {
                        return NodeName::depthAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'v', 'e', 'n', 't')) {
                return NodeName::eventAttr;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'n', 'c', 'e')) {
                    return NodeName::fenceAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'a', 'm', 'e')) {
                    return NodeName::frameAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'n': {
                if (compareCharacters(buffer.data() + 2, 'e', 'r', 't')) {
                    return NodeName::inertAttr;
                }
                break;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'm', 'a', 'p')) {
                    return NodeName::ismapAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'b', 'e', 'l')) {
                    return NodeName::labelAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'c', 'a', 'l')) {
                    return NodeName::localAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'd', 'i', 'a')) {
                    return NodeName::mediaAttr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 't', 'e', 'd')) {
                    return NodeName::mutedAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'o', 'n', 'c', 'e')) {
                return NodeName::nonceAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'u', 't')) {
                        return NodeName::oncutAttr;
                    }
                    break;
                }
                case 'e': {
                    if (compareCharacters(buffer.data() + 3, 'n', 'd')) {
                        return NodeName::onendAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'd', 'e', 'r')) {
                    return NodeName::orderAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            if (compareCharacters(buffer.data() + 1, 'u', 'l', 'e', 's')) {
                return NodeName::rulesAttr;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'e')) {
                        return NodeName::scaleAttr;
                    }
                    break;
                }
                case 'o': {
                    if (compareCharacters(buffer.data() + 3, 'p', 'e')) {
                        return NodeName::scopeAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'h': {
                if (compareCharacters(buffer.data() + 2, 'a', 'p', 'e')) {
                    return NodeName::shapeAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'z', 'e', 's')) {
                    return NodeName::sizesAttr;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'o', 'p', 'e')) {
                    return NodeName::slopeAttr;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'r', 't')) {
                        return NodeName::startAttr;
                    }
                    break;
                }
                case 'y': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'e')) {
                        return NodeName::styleAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (compareCharacters(buffer.data() + 1, 'i', 't', 'l', 'e')) {
                return NodeName::titleAttr;
            }
            break;
        }
        case 'v': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'l', 'u', 'e')) {
                    return NodeName::valueAttr;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'i', 'n', 'k')) {
                    return NodeName::vlinkAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'w': {
            if (compareCharacters(buffer.data() + 1, 'i', 'd', 't', 'h')) {
                return NodeName::widthAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 6: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                switch (buffer[2]) {
                case 'c': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'n': {
                            if (buffer[5] == 't') {
                                return NodeName::accentAttr;
                            }
                            break;
                        }
                        case 'p': {
                            if (buffer[5] == 't') {
                                return NodeName::acceptAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'i', 'o', 'n')) {
                        return NodeName::actionAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'c', 'e', 'n', 't')) {
                    return NodeName::ascentAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'o', 'r', 'd', 'e', 'r')) {
                return NodeName::borderAttr;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'o', 'r', 'd', 's')) {
                    return NodeName::coordsAttr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'r', 's', 'o', 'r')) {
                    return NodeName::cursorAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'l', 't', 'e', 'r')) {
                    return NodeName::filterAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'r', 'm', 'a', 't')) {
                    return NodeName::formatAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'i', 'g', 'h', 't')) {
                    return NodeName::heightAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'd', 'd', 'e', 'n')) {
                    return NodeName::hiddenAttr;
                }
                break;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'p', 'a', 'c', 'e')) {
                    return NodeName::hspaceAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'w', 's', 'r', 'c')) {
                    return NodeName::lowsrcAttr;
                }
                break;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'p', 'a', 'c', 'e')) {
                    return NodeName::lspaceAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 'e', 't', 'h', 'o', 'd')) {
                return NodeName::methodAttr;
            }
            break;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'h': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'e', 'f')) {
                        return NodeName::nohrefAttr;
                    }
                    break;
                }
                case 'w': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'a', 'p')) {
                        return NodeName::nowrapAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'j', 'e', 'c', 't')) {
                    return NodeName::objectAttr;
                }
                break;
            }
            case 'f': {
                if (compareCharacters(buffer.data() + 2, 'f', 's', 'e', 't')) {
                    return NodeName::offsetAttr;
                }
                break;
            }
            case 'n': {
                switch (buffer[2]) {
                case 'b': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'u', 'r')) {
                        return NodeName::onblurAttr;
                    }
                    break;
                }
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'p', 'y')) {
                        return NodeName::oncopyAttr;
                    }
                    break;
                }
                case 'd': {
                    switch (buffer[3]) {
                    case 'r': {
                        switch (buffer[4]) {
                        case 'a': {
                            if (buffer[5] == 'g') {
                                return NodeName::ondragAttr;
                            }
                            break;
                        }
                        case 'o': {
                            if (buffer[5] == 'p') {
                                return NodeName::ondropAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'a', 'd')) {
                        return NodeName::onloadAttr;
                    }
                    break;
                }
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'a', 'y')) {
                        return NodeName::onplayAttr;
                    }
                    break;
                }
                case 'z': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'o', 'm')) {
                        return NodeName::onzoomAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'e': {
                        if (compareCharacters(buffer.data() + 4, 'n', 't')) {
                            return NodeName::orientAttr;
                        }
                        break;
                    }
                    case 'g': {
                        if (compareCharacters(buffer.data() + 4, 'i', 'n')) {
                            return NodeName::originAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'i': {
                    if (compareCharacters(buffer.data() + 3, 'n', 't', 's')) {
                        return NodeName::pointsAttr;
                    }
                    break;
                }
                case 's': {
                    if (compareCharacters(buffer.data() + 3, 't', 'e', 'r')) {
                        return NodeName::posterAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'd', 'i', 'u', 's')) {
                    return NodeName::radiusAttr;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 's', 'u', 'l', 't')) {
                    return NodeName::resultAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 't', 'a', 't', 'e')) {
                    return NodeName::rotateAttr;
                }
                break;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'p', 'a', 'c', 'e')) {
                    return NodeName::rspaceAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'h', 'e', 'm', 'e')) {
                    return NodeName::schemeAttr;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'l', 'e', 'c', 't')) {
                    return NodeName::selectAttr;
                }
                break;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'c': {
                    switch (buffer[3]) {
                    case 'd': {
                        if (compareCharacters(buffer.data() + 4, 'o', 'c')) {
                            return NodeName::srcdocAttr;
                        }
                        break;
                    }
                    case 's': {
                        if (compareCharacters(buffer.data() + 4, 'e', 't')) {
                            return NodeName::srcsetAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'r', 'o', 'k', 'e')) {
                    return NodeName::strokeAttr;
                }
                break;
            }
            case 'w': {
                if (compareCharacters(buffer.data() + 2, 'i', 't', 'c', 'h')) {
                    return NodeName::switchAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (compareCharacters(buffer.data() + 1, 'a', 'r', 'g', 'e', 't')) {
                return NodeName::targetAttr;
            }
            break;
        }
        case 'u': {
            if (compareCharacters(buffer.data() + 1, 's', 'e', 'm', 'a', 'p')) {
                return NodeName::usemapAttr;
            }
            break;
        }
        case 'v': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'l': {
                    switch (buffer[3]) {
                    case 'i': {
                        if (compareCharacters(buffer.data() + 4, 'g', 'n')) {
                            return NodeName::valignAttr;
                        }
                        break;
                    }
                    case 'u': {
                        if (compareCharacters(buffer.data() + 4, 'e', 's')) {
                            return NodeName::valuesAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'p', 'a', 'c', 'e')) {
                    return NodeName::vspaceAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 7: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 't', 't', 'e', 'x', 't')) {
                    return NodeName::alttextAttr;
                }
                break;
            }
            case 'n': {
                if (compareCharacters(buffer.data() + 2, 'i', 'm', 'a', 't', 'e')) {
                    return NodeName::animateAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'c', 'h', 'i', 'v', 'e')) {
                    return NodeName::archiveAttr;
                }
                break;
            }
            case 'z': {
                if (compareCharacters(buffer.data() + 2, 'i', 'm', 'u', 't', 'h')) {
                    return NodeName::azimuthAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'g', 'c', 'o', 'l', 'o', 'r')) {
                return NodeName::bgcolorAttr;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'p', 't', 'u', 'r', 'e')) {
                    return NodeName::captureAttr;
                }
                break;
            }
            case 'h': {
                switch (buffer[2]) {
                case 'a': {
                    switch (buffer[3]) {
                    case 'r': {
                        switch (buffer[4]) {
                        case 'o': {
                            if (compareCharacters(buffer.data() + 5, 'f', 'f')) {
                                return NodeName::charoffAttr;
                            }
                            break;
                        }
                        case 's': {
                            if (compareCharacters(buffer.data() + 5, 'e', 't')) {
                                return NodeName::charsetAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'e': {
                    if (compareCharacters(buffer.data() + 3, 'c', 'k', 'e', 'd')) {
                        return NodeName::checkedAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'a', 's', 's', 'i', 'd')) {
                    return NodeName::classidAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 's', 'p', 'a', 'n')) {
                        return NodeName::colspanAttr;
                    }
                    break;
                }
                case 'm': {
                    switch (buffer[3]) {
                    case 'm': {
                        if (compareCharacters(buffer.data() + 4, 'a', 'n', 'd')) {
                            return NodeName::commandAttr;
                        }
                        break;
                    }
                    case 'p': {
                        if (compareCharacters(buffer.data() + 4, 'a', 'c', 't')) {
                            return NodeName::compactAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'n': {
                    if (compareCharacters(buffer.data() + 3, 't', 'e', 'n', 't')) {
                        return NodeName::contentAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'a', 'r', 'e')) {
                        return NodeName::declareAttr;
                    }
                    break;
                }
                case 'f': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'u', 'l', 't')) {
                        return NodeName::defaultAttr;
                    }
                    break;
                }
                case 's': {
                    if (compareCharacters(buffer.data() + 3, 'c', 'e', 'n', 't')) {
                        return NodeName::descentAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'n', 'a', 'm', 'e')) {
                        return NodeName::dirnameAttr;
                    }
                    break;
                }
                case 's': {
                    if (compareCharacters(buffer.data() + 3, 'p', 'l', 'a', 'y')) {
                        return NodeName::displayAttr;
                    }
                    break;
                }
                case 'v': {
                    if (compareCharacters(buffer.data() + 3, 'i', 's', 'o', 'r')) {
                        return NodeName::divisorAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'n', 'c', 't', 'y', 'p', 'e')) {
                return NodeName::enctypeAttr;
            }
            break;
        }
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'o', 'c', 'u', 's', 'e', 'd')) {
                return NodeName::focusedAttr;
            }
            break;
        }
        case 'h': {
            if (compareCharacters(buffer.data() + 1, 'e', 'a', 'd', 'e', 'r', 's')) {
                return NodeName::headersAttr;
            }
            break;
        }
        case 'k': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'n', 'i', 'n', 'g')) {
                        return NodeName::kerningAttr;
                    }
                    break;
                }
                case 'y': {
                    if (compareCharacters(buffer.data() + 3, 't', 'y', 'p', 'e')) {
                        return NodeName::keytypeAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'r', 'g', 'e', 'o', 'p')) {
                    return NodeName::largeopAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'd', 'i', 'n', 'g')) {
                        return NodeName::loadingAttr;
                    }
                    break;
                }
                case 'o': {
                    if (compareCharacters(buffer.data() + 3, 'p', 'e', 'n', 'd')) {
                        return NodeName::loopendAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'x', 's', 'i', 'z', 'e')) {
                    return NodeName::maxsizeAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'n', 's', 'i', 'z', 'e')) {
                    return NodeName::minsizeAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'o', 's', 'h', 'a', 'd', 'e')) {
                return NodeName::noshadeAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'b', 'o', 'r', 't')) {
                        return NodeName::onabortAttr;
                    }
                    break;
                }
                case 'b': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'g', 'i', 'n')) {
                        return NodeName::onbeginAttr;
                    }
                    break;
                }
                case 'c': {
                    switch (buffer[3]) {
                    case 'l': {
                        switch (buffer[4]) {
                        case 'i': {
                            if (compareCharacters(buffer.data() + 5, 'c', 'k')) {
                                return NodeName::onclickAttr;
                            }
                            break;
                        }
                        case 'o': {
                            if (compareCharacters(buffer.data() + 5, 's', 'e')) {
                                return NodeName::oncloseAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'e': {
                    switch (buffer[3]) {
                    case 'n': {
                        if (compareCharacters(buffer.data() + 4, 'd', 'e', 'd')) {
                            return NodeName::onendedAttr;
                        }
                        break;
                    }
                    case 'r': {
                        if (compareCharacters(buffer.data() + 4, 'r', 'o', 'r')) {
                            return NodeName::onerrorAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'f': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'c', 'u', 's')) {
                        return NodeName::onfocusAttr;
                    }
                    break;
                }
                case 'i': {
                    if (compareCharacters(buffer.data() + 3, 'n', 'p', 'u', 't')) {
                        return NodeName::oninputAttr;
                    }
                    break;
                }
                case 'k': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'y', 'u', 'p')) {
                        return NodeName::onkeyupAttr;
                    }
                    break;
                }
                case 'p': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case 's': {
                            if (compareCharacters(buffer.data() + 5, 't', 'e')) {
                                return NodeName::onpasteAttr;
                            }
                            break;
                        }
                        case 'u': {
                            if (compareCharacters(buffer.data() + 5, 's', 'e')) {
                                return NodeName::onpauseAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'e', 's', 'e', 't')) {
                        return NodeName::onresetAttr;
                    }
                    break;
                }
                case 'w': {
                    if (compareCharacters(buffer.data() + 3, 'h', 'e', 'e', 'l')) {
                        return NodeName::onwheelAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'p': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'c', 'i', 't', 'y')) {
                        return NodeName::opacityAttr;
                    }
                    break;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'i', 'm', 'u', 'm')) {
                        return NodeName::optimumAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 't', 't', 'e', 'r', 'n')) {
                    return NodeName::patternAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'p', 'o', 'v', 'e', 'r')) {
                    return NodeName::popoverAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'e', 'l', 'o', 'a', 'd')) {
                    return NodeName::preloadAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 's': {
                    switch (buffer[3]) {
                    case 't': {
                        if (compareCharacters(buffer.data() + 4, 'a', 'r', 't')) {
                            return NodeName::restartAttr;
                        }
                        break;
                    }
                    case 'u': {
                        if (compareCharacters(buffer.data() + 4, 'l', 't', 's')) {
                            return NodeName::resultsAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'w', 's', 'p', 'a', 'n')) {
                    return NodeName::rowspanAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'n', 'd', 'b', 'o', 'x')) {
                    return NodeName::sandboxAttr;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'a', 'c', 'i', 'n', 'g')) {
                    return NodeName::spacingAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'c', 'l', 'a', 'n', 'g')) {
                    return NodeName::srclangAttr;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'a', 'n', 'd', 'b', 'y')) {
                    return NodeName::standbyAttr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'm', 'm', 'a', 'r', 'y')) {
                    return NodeName::summaryAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'g': {
                        switch (buffer[4]) {
                        case 'e': {
                            switch (buffer[5]) {
                            case 't': {
                                switch (buffer[6]) {
                                case 'X': {
                                    return NodeName::targetXAttr;
                                }
                                case 'Y': {
                                    return NodeName::targetYAttr;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'u': {
            if (compareCharacters(buffer.data() + 1, 'n', 'i', 'c', 'o', 'd', 'e')) {
                return NodeName::unicodeAttr;
            }
            break;
        }
        case 'v': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'r', 's', 'i', 'o', 'n')) {
                    return NodeName::versionAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'e', 'w', 'B', 'o', 'x')) {
                    return NodeName::viewBoxAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'f', 'f', 's', 'e', 't')) {
                    return NodeName::voffsetAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 8: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'd': {
                if (compareCharacters(buffer.data() + 2, 'd', 'i', 't', 'i', 'v', 'e')) {
                    return NodeName::additiveAttr;
                }
                break;
            }
            case 'u': {
                switch (buffer[2]) {
                case 't': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'p': {
                            if (compareCharacters(buffer.data() + 5, 'l', 'a', 'y')) {
                                return NodeName::autoplayAttr;
                            }
                            break;
                        }
                        case 's': {
                            if (compareCharacters(buffer.data() + 5, 'a', 'v', 'e')) {
                                return NodeName::autosaveAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'h', 'a', 'v', 'i', 'o', 'r')) {
                    return NodeName::behaviorAttr;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'o', 'c', 'k', 'i', 'n', 'g')) {
                    return NodeName::blockingAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'l', 'c', 'M', 'o', 'd', 'e')) {
                    return NodeName::calcModeAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'd': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'b': {
                            if (compareCharacters(buffer.data() + 5, 'a', 's', 'e')) {
                                return NodeName::codebaseAttr;
                            }
                            break;
                        }
                        case 't': {
                            if (compareCharacters(buffer.data() + 5, 'y', 'p', 'e')) {
                                return NodeName::codetypeAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'n': {
                    if (compareCharacters(buffer.data() + 3, 't', 'r', 'o', 'l', 's')) {
                        return NodeName::controlsAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 't', 'e', 't', 'i', 'm', 'e')) {
                    return NodeName::datetimeAttr;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'c', 'o', 'd', 'i', 'n', 'g')) {
                    return NodeName::decodingAttr;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 's', 'a', 'b', 'l', 'e', 'd')) {
                    return NodeName::disabledAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'w', 'n', 'l', 'o', 'a', 'd')) {
                    return NodeName::downloadAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'p', 'z', 'o', 'n', 'e')) {
                    return NodeName::dropzoneAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            switch (buffer[1]) {
            case 'd': {
                if (compareCharacters(buffer.data() + 2, 'g', 'e', 'M', 'o', 'd', 'e')) {
                    return NodeName::edgeModeAttr;
                }
                break;
            }
            case 'n': {
                if (compareCharacters(buffer.data() + 2, 'c', 'o', 'd', 'i', 'n', 'g')) {
                    return NodeName::encodingAttr;
                }
                break;
            }
            case 'x': {
                switch (buffer[2]) {
                case 'p': {
                    switch (buffer[3]) {
                    case 'a': {
                        if (compareCharacters(buffer.data() + 4, 'n', 'd', 'e', 'd')) {
                            return NodeName::expandedAttr;
                        }
                        break;
                    }
                    case 'o': {
                        if (compareCharacters(buffer.data() + 4, 'n', 'e', 'n', 't')) {
                            return NodeName::exponentAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'l', 'e', 'n', 'a', 'm', 'e')) {
                    return NodeName::filenameAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'n', 't', 's', 'i', 'z', 'e')) {
                    return NodeName::fontsizeAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'g': {
            if (compareCharacters(buffer.data() + 1, 'l', 'y', 'p', 'h', 'R', 'e', 'f')) {
                return NodeName::glyphRefAttr;
            }
            break;
        }
        case 'h': {
            if (compareCharacters(buffer.data() + 1, 'r', 'e', 'f', 'l', 'a', 'n', 'g')) {
                return NodeName::hreflangAttr;
            }
            break;
        }
        case 'k': {
            if (compareCharacters(buffer.data() + 1, 'e', 'y', 'T', 'i', 'm', 'e', 's')) {
                return NodeName::keyTimesAttr;
            }
            break;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'n', 'g', 'u', 'a', 'g', 'e')) {
                    return NodeName::languageAttr;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'n', 'g', 'd', 'e', 's', 'c')) {
                    return NodeName::longdescAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 't', 'h', 's', 'i', 'z', 'e')) {
                    return NodeName::mathsizeAttr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'l', 't', 'i', 'p', 'l', 'e')) {
                    return NodeName::multipleAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'm': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'd', 'u', 'l', 'e')) {
                        return NodeName::nomoduleAttr;
                    }
                    break;
                }
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'e', 's', 'i', 'z', 'e')) {
                        return NodeName::noresizeAttr;
                    }
                    break;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'a', 't', 'i', 'o', 'n')) {
                        return NodeName::notationAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'm', 'a', 'l', 'i', 'g', 'n')) {
                    return NodeName::numalignAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'c': {
                    switch (buffer[3]) {
                    case 'a': {
                        if (compareCharacters(buffer.data() + 4, 'n', 'c', 'e', 'l')) {
                            return NodeName::oncancelAttr;
                        }
                        break;
                    }
                    case 'h': {
                        if (compareCharacters(buffer.data() + 4, 'a', 'n', 'g', 'e')) {
                            return NodeName::onchangeAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'o': {
                    if (compareCharacters(buffer.data() + 3, 'n', 'l', 'i', 'n', 'e')) {
                        return NodeName::ononlineAttr;
                    }
                    break;
                }
                case 'r': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'd': {
                            if (compareCharacters(buffer.data() + 5, 'r', 'a', 'w')) {
                                return NodeName::onredrawAttr;
                            }
                            break;
                        }
                        case 's': {
                            if (compareCharacters(buffer.data() + 5, 'i', 'z', 'e')) {
                                return NodeName::onresizeAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 's': {
                    switch (buffer[3]) {
                    case 'c': {
                        if (compareCharacters(buffer.data() + 4, 'r', 'o', 'l', 'l')) {
                            return NodeName::onscrollAttr;
                        }
                        break;
                    }
                    case 'e': {
                        switch (buffer[4]) {
                        case 'a': {
                            if (compareCharacters(buffer.data() + 5, 'r', 'c', 'h')) {
                                return NodeName::onsearchAttr;
                            }
                            break;
                        }
                        case 'e': {
                            if (compareCharacters(buffer.data() + 5, 'k', 'e', 'd')) {
                                return NodeName::onseekedAttr;
                            }
                            break;
                        }
                        case 'l': {
                            if (compareCharacters(buffer.data() + 5, 'e', 'c', 't')) {
                                return NodeName::onselectAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    case 'u': {
                        if (compareCharacters(buffer.data() + 4, 'b', 'm', 'i', 't')) {
                            return NodeName::onsubmitAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'g', 'g', 'l', 'e')) {
                        return NodeName::ontoggleAttr;
                    }
                    break;
                }
                case 'u': {
                    if (compareCharacters(buffer.data() + 3, 'n', 'l', 'o', 'a', 'd')) {
                        return NodeName::onunloadAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'e', 'r', 'a', 't', 'o', 'r')) {
                    return NodeName::operatorAttr;
                }
                break;
            }
            case 'v': {
                if (compareCharacters(buffer.data() + 2, 'e', 'r', 'f', 'l', 'o', 'w')) {
                    return NodeName::overflowAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'n', 'o', 's', 'e', '-', '1')) {
                    return NodeName::panose_1Attr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'g', 'r', 'e', 's', 's')) {
                    return NodeName::progressAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'd', 'o', 'n', 'l', 'y')) {
                        return NodeName::readonlyAttr;
                    }
                    break;
                }
                case 'q': {
                    if (compareCharacters(buffer.data() + 3, 'u', 'i', 'r', 'e', 'd')) {
                        return NodeName::requiredAttr;
                    }
                    break;
                }
                case 'v': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r', 's', 'e', 'd')) {
                        return NodeName::reversedAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'l', 'e', 'c', 't', 'e', 'd')) {
                    return NodeName::selectedAttr;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'r', 'e', 't', 'c', 'h', 'y')) {
                    return NodeName::stretchyAttr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'b', 't', 'i', 't', 'l', 'e')) {
                    return NodeName::subtitleAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (compareCharacters(buffer.data() + 1, 'a', 'b', 'i', 'n', 'd', 'e', 'x')) {
                return NodeName::tabindexAttr;
            }
            break;
        }
        case 'x': {
            if (compareCharacters(buffer.data() + 1, '-', 'h', 'e', 'i', 'g', 'h', 't')) {
                return NodeName::x_heightAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 9: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'c', 'e', 's', 's', 'k', 'e', 'y')) {
                    return NodeName::accesskeyAttr;
                }
                break;
            }
            case 'm': {
                if (compareCharacters(buffer.data() + 2, 'p', 'l', 'i', 't', 'u', 'd', 'e')) {
                    return NodeName::amplitudeAttr;
                }
                break;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'b': {
                                if (compareCharacters(buffer.data() + 6, 'u', 's', 'y')) {
                                    return NodeName::aria_busyAttr;
                                }
                                break;
                            }
                            case 'h': {
                                if (compareCharacters(buffer.data() + 6, 'e', 'l', 'p')) {
                                    return NodeName::aria_helpAttr;
                                }
                                break;
                            }
                            case 'l': {
                                if (compareCharacters(buffer.data() + 6, 'i', 'v', 'e')) {
                                    return NodeName::aria_liveAttr;
                                }
                                break;
                            }
                            case 'o': {
                                if (compareCharacters(buffer.data() + 6, 'w', 'n', 's')) {
                                    return NodeName::aria_ownsAttr;
                                }
                                break;
                            }
                            case 's': {
                                if (compareCharacters(buffer.data() + 6, 'o', 'r', 't')) {
                                    return NodeName::aria_sortAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 't', 'o', 'f', 'o', 'c', 'u', 's')) {
                    return NodeName::autofocusAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'h': {
                if (compareCharacters(buffer.data() + 2, 'a', 'l', 'l', 'e', 'n', 'g', 'e')) {
                    return NodeName::challengeAttr;
                }
                break;
            }
            case 'l': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'p': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'p': {
                                if (compareCharacters(buffer.data() + 6, 'a', 't', 'h')) {
                                    return NodeName::clip_pathAttr;
                                }
                                break;
                            }
                            case 'r': {
                                if (compareCharacters(buffer.data() + 6, 'u', 'l', 'e')) {
                                    return NodeName::clip_ruleAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'm', 'p', 'o', 's', 'i', 't', 'e')) {
                    return NodeName::compositeAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'r', 'e', 'c', 't', 'i', 'o', 'n')) {
                    return NodeName::directionAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'a', 'g', 'g', 'a', 'b', 'l', 'e')) {
                    return NodeName::draggableAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'l', 'e', 'v', 'a', 't', 'i', 'o', 'n')) {
                return NodeName::elevationAttr;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'l', 'l', '-', 'r', 'u', 'l', 'e')) {
                    return NodeName::fill_ruleAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            if (compareCharacters(buffer.data() + 5, 's', 'i', 'z', 'e')) {
                                return NodeName::font_sizeAttr;
                            }
                            break;
                        }
                        case 's': {
                            if (compareCharacters(buffer.data() + 5, 't', 'y', 'l', 'e')) {
                                return NodeName::fontstyleAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 'u', 't', 'm', 'o', 'd', 'e')) {
                        return NodeName::inputmodeAttr;
                    }
                    break;
                }
                case 't': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'g': {
                            if (compareCharacters(buffer.data() + 5, 'r', 'i', 't', 'y')) {
                                return NodeName::integrityAttr;
                            }
                            break;
                        }
                        case 'r': {
                            if (compareCharacters(buffer.data() + 5, 'c', 'e', 'p', 't')) {
                                return NodeName::interceptAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'k': {
            if (compareCharacters(buffer.data() + 1, 'e', 'y', 'P', 'o', 'i', 'n', 't', 's')) {
                return NodeName::keyPointsAttr;
            }
            break;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'o', 'o', 'p', 's', 't', 'a', 'r', 't')) {
                return NodeName::loopstartAttr;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 's': {
                    switch (buffer[3]) {
                    case 'k': {
                        switch (buffer[4]) {
                        case '-': {
                            if (compareCharacters(buffer.data() + 5, 't', 'y', 'p', 'e')) {
                                return NodeName::mask_typeAttr;
                            }
                            break;
                        }
                        case 'U': {
                            if (compareCharacters(buffer.data() + 5, 'n', 'i', 't', 's')) {
                                return NodeName::maskUnitsAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'h', 'c', 'o', 'l', 'o', 'r')) {
                        return NodeName::mathcolorAttr;
                    }
                    break;
                }
                case 'x': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'e', 'n', 'g', 't', 'h')) {
                        return NodeName::maxlengthAttr;
                    }
                    break;
                }
                case 'y': {
                    if (compareCharacters(buffer.data() + 3, 's', 'c', 'r', 'i', 'p', 't')) {
                        return NodeName::mayscriptAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'n', 'l', 'e', 'n', 'g', 't', 'h')) {
                    return NodeName::minlengthAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'n', 'p', 'l', 'a', 'y')) {
                        return NodeName::oncanplayAttr;
                    }
                    break;
                }
                case 'd': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'a', 'g', 'e', 'n', 'd')) {
                        return NodeName::ondragendAttr;
                    }
                    break;
                }
                case 'e': {
                    if (compareCharacters(buffer.data() + 3, 'm', 'p', 't', 'i', 'e', 'd')) {
                        return NodeName::onemptiedAttr;
                    }
                    break;
                }
                case 'f': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'c', 'u', 's', 'i', 'n')) {
                        return NodeName::onfocusinAttr;
                    }
                    break;
                }
                case 'i': {
                    if (compareCharacters(buffer.data() + 3, 'n', 'v', 'a', 'l', 'i', 'd')) {
                        return NodeName::oninvalidAttr;
                    }
                    break;
                }
                case 'k': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'y', 'd', 'o', 'w', 'n')) {
                        return NodeName::onkeydownAttr;
                    }
                    break;
                }
                case 'm': {
                    switch (buffer[3]) {
                    case 'e': {
                        if (compareCharacters(buffer.data() + 4, 's', 's', 'a', 'g', 'e')) {
                            return NodeName::onmessageAttr;
                        }
                        break;
                    }
                    case 'o': {
                        if (compareCharacters(buffer.data() + 4, 'u', 's', 'e', 'u', 'p')) {
                            return NodeName::onmouseupAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'o': {
                    if (compareCharacters(buffer.data() + 3, 'f', 'f', 'l', 'i', 'n', 'e')) {
                        return NodeName::onofflineAttr;
                    }
                    break;
                }
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'a', 'y', 'i', 'n', 'g')) {
                        return NodeName::onplayingAttr;
                    }
                    break;
                }
                case 's': {
                    switch (buffer[3]) {
                    case 'e': {
                        if (compareCharacters(buffer.data() + 4, 'e', 'k', 'i', 'n', 'g')) {
                            return NodeName::onseekingAttr;
                        }
                        break;
                    }
                    case 't': {
                        switch (buffer[4]) {
                        case 'a': {
                            if (compareCharacters(buffer.data() + 5, 'l', 'l', 'e', 'd')) {
                                return NodeName::onstalledAttr;
                            }
                            break;
                        }
                        case 'o': {
                            if (compareCharacters(buffer.data() + 5, 'r', 'a', 'g', 'e')) {
                                return NodeName::onstorageAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    case 'u': {
                        if (compareCharacters(buffer.data() + 4, 's', 'p', 'e', 'n', 'd')) {
                            return NodeName::onsuspendAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'w': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'i', 't', 'i', 'n', 'g')) {
                        return NodeName::onwaitingAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'a', 'y', 'c', 'o', 'u', 'n', 't')) {
                    return NodeName::playcountAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'n': {
                        switch (buffer[4]) {
                        case 't': {
                            switch (buffer[5]) {
                            case 's': {
                                switch (buffer[6]) {
                                case 'A': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'X': {
                                            return NodeName::pointsAtXAttr;
                                        }
                                        case 'Y': {
                                            return NodeName::pointsAtYAttr;
                                        }
                                        case 'Z': {
                                            return NodeName::pointsAtZAttr;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            if (compareCharacters(buffer.data() + 1, 'e', 'p', 'e', 'a', 't', 'D', 'u', 'r')) {
                return NodeName::repeatDurAttr;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'r', 'o', 'l', 'l', 'i', 'n', 'g')) {
                    return NodeName::scrollingAttr;
                }
                break;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'c', 't', 'i', 'o', 'n')) {
                        return NodeName::selectionAttr;
                    }
                    break;
                }
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'r', 'a', 't', 'o', 'r')) {
                        return NodeName::separatorAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'y': {
                if (compareCharacters(buffer.data() + 2, 'm', 'm', 'e', 't', 'r', 'i', 'c')) {
                    return NodeName::symmetricAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'p', 'm', 'a', 'r', 'g', 'i', 'n')) {
                    return NodeName::topmarginAttr;
                }
                break;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'a': {
                    switch (buffer[3]) {
                    case 'n': {
                        switch (buffer[4]) {
                        case 's': {
                            switch (buffer[5]) {
                            case 'f': {
                                if (compareCharacters(buffer.data() + 6, 'o', 'r', 'm')) {
                                    return NodeName::transformAttr;
                                }
                                break;
                            }
                            case 'l': {
                                if (compareCharacters(buffer.data() + 6, 'a', 't', 'e')) {
                                    return NodeName::translateAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'u': {
                    if (compareCharacters(buffer.data() + 3, 'e', 's', 'p', 'e', 'e', 'd')) {
                        return NodeName::truespeedAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'u': {
            if (compareCharacters(buffer.data() + 1, 'i', 'a', 'c', 't', 'i', 'o', 'n', 's')) {
                return NodeName::uiactionsAttr;
            }
            break;
        }
        case 'v': {
            if (compareCharacters(buffer.data() + 1, 'a', 'l', 'u', 'e', 't', 'y', 'p', 'e')) {
                return NodeName::valuetypeAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 10: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'u', 'm', 'u', 'l', 'a', 't', 'e')) {
                        return NodeName::accumulateAttr;
                    }
                    break;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'i', 'o', 'n', 't', 'y', 'p', 'e')) {
                        return NodeName::actiontypeAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'l': {
                                switch (buffer[6]) {
                                case 'a': {
                                    if (compareCharacters(buffer.data() + 7, 'b', 'e', 'l')) {
                                        return NodeName::aria_labelAttr;
                                    }
                                    break;
                                }
                                case 'e': {
                                    if (compareCharacters(buffer.data() + 7, 'v', 'e', 'l')) {
                                        return NodeName::aria_levelAttr;
                                    }
                                    break;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            case 'm': {
                                if (compareCharacters(buffer.data() + 6, 'o', 'd', 'a', 'l')) {
                                    return NodeName::aria_modalAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (WTF::equal(buffer.data() + 1, "ackground"_span)) {
                return NodeName::backgroundAttr;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'p', '-', 'h', 'e', 'i', 'g', 'h', 't')) {
                    return NodeName::cap_heightAttr;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'l', 'l', 'b', 'o', 'r', 'd', 'e', 'r')) {
                    return NodeName::cellborderAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'u', 'm', 'n', 's', 'p', 'a', 'n')) {
                        return NodeName::columnspanAttr;
                    }
                    break;
                }
                case 'm': {
                    if (compareCharacters(buffer.data() + 3, 'm', 'a', 'n', 'd', 'f', 'o', 'r')) {
                        return NodeName::commandforAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            if (WTF::equal(buffer.data() + 1, "enomalign"_span)) {
                return NodeName::denomalignAttr;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            if (compareCharacters(buffer.data() + 5, 's', 't', 'y', 'l', 'e')) {
                                return NodeName::font_styleAttr;
                            }
                            break;
                        }
                        case 'f': {
                            if (compareCharacters(buffer.data() + 5, 'a', 'm', 'i', 'l', 'y')) {
                                return NodeName::fontfamilyAttr;
                            }
                            break;
                        }
                        case 'w': {
                            if (compareCharacters(buffer.data() + 5, 'e', 'i', 'g', 'h', 't')) {
                                return NodeName::fontweightAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'r': {
                    switch (buffer[3]) {
                    case 'm': {
                        switch (buffer[4]) {
                        case 'a': {
                            if (compareCharacters(buffer.data() + 5, 'c', 't', 'i', 'o', 'n')) {
                                return NodeName::formactionAttr;
                            }
                            break;
                        }
                        case 'm': {
                            if (compareCharacters(buffer.data() + 5, 'e', 't', 'h', 'o', 'd')) {
                                return NodeName::formmethodAttr;
                            }
                            break;
                        }
                        case 't': {
                            if (compareCharacters(buffer.data() + 5, 'a', 'r', 'g', 'e', 't')) {
                                return NodeName::formtargetAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'g': {
            if (WTF::equal(buffer.data() + 1, "lyph-name"_span)) {
                return NodeName::glyph_nameAttr;
            }
            break;
        }
        case 'h': {
            if (WTF::equal(buffer.data() + 1, "ttp-equiv"_span)) {
                return NodeName::http_equivAttr;
            }
            break;
        }
        case 'i': {
            if (WTF::equal(buffer.data() + 1, "magesizes"_span)) {
                return NodeName::imagesizesAttr;
            }
            break;
        }
        case 'k': {
            if (WTF::equal(buffer.data() + 1, "eySplines"_span)) {
                return NodeName::keySplinesAttr;
            }
            break;
        }
        case 'l': {
            if (WTF::equal(buffer.data() + 1, "eftmargin"_span)) {
                return NodeName::leftmarginAttr;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'k': {
                        switch (buffer[4]) {
                        case 'e': {
                            switch (buffer[5]) {
                            case 'r': {
                                switch (buffer[6]) {
                                case '-': {
                                    switch (buffer[7]) {
                                    case 'e': {
                                        if (compareCharacters(buffer.data() + 8, 'n', 'd')) {
                                            return NodeName::marker_endAttr;
                                        }
                                        break;
                                    }
                                    case 'm': {
                                        if (compareCharacters(buffer.data() + 8, 'i', 'd')) {
                                            return NodeName::marker_midAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'd', 'i', 'a', 'g', 'r', 'o', 'u', 'p')) {
                    return NodeName::mediagroupAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'v', 'a', 'l', 'i', 'd', 'a', 't', 'e')) {
                    return NodeName::novalidateAttr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'm', 'O', 'c', 't', 'a', 'v', 'e', 's')) {
                    return NodeName::numOctavesAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'u', 'x', 'c', 'l', 'i', 'c', 'k')) {
                        return NodeName::onauxclickAttr;
                    }
                    break;
                }
                case 'd': {
                    switch (buffer[3]) {
                    case 'b': {
                        if (compareCharacters(buffer.data() + 4, 'l', 'c', 'l', 'i', 'c', 'k')) {
                            return NodeName::ondblclickAttr;
                        }
                        break;
                    }
                    case 'r': {
                        if (compareCharacters(buffer.data() + 4, 'a', 'g', 'o', 'v', 'e', 'r')) {
                            return NodeName::ondragoverAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'f': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'c': {
                            if (compareCharacters(buffer.data() + 5, 'u', 's', 'o', 'u', 't')) {
                                return NodeName::onfocusoutAttr;
                            }
                            break;
                        }
                        case 'r': {
                            if (compareCharacters(buffer.data() + 5, 'm', 'd', 'a', 't', 'a')) {
                                return NodeName::onformdataAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'k': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'y', 'p', 'r', 'e', 's', 's')) {
                        return NodeName::onkeypressAttr;
                    }
                    break;
                }
                case 'm': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'u', 's', 'e', 'o', 'u', 't')) {
                        return NodeName::onmouseoutAttr;
                    }
                    break;
                }
                case 'p': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case 'g': {
                            switch (buffer[5]) {
                            case 'e': {
                                switch (buffer[6]) {
                                case 'h': {
                                    if (compareCharacters(buffer.data() + 7, 'i', 'd', 'e')) {
                                        return NodeName::onpagehideAttr;
                                    }
                                    break;
                                }
                                case 's': {
                                    switch (buffer[7]) {
                                    case 'h': {
                                        if (compareCharacters(buffer.data() + 8, 'o', 'w')) {
                                            return NodeName::onpageshowAttr;
                                        }
                                        break;
                                    }
                                    case 'w': {
                                        if (compareCharacters(buffer.data() + 8, 'a', 'p')) {
                                            return NodeName::onpageswapAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    case 'o': {
                        if (compareCharacters(buffer.data() + 4, 'p', 's', 't', 'a', 't', 'e')) {
                            return NodeName::onpopstateAttr;
                        }
                        break;
                    }
                    case 'r': {
                        if (compareCharacters(buffer.data() + 4, 'o', 'g', 'r', 'e', 's', 's')) {
                            return NodeName::onprogressAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'u', 'c', 'h', 'e', 'n', 'd')) {
                        return NodeName::ontouchendAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            if (WTF::equal(buffer.data() + 1, "athLength"_span)) {
                return NodeName::pathLengthAttr;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'p', 'a', 'r', 'a', 't', 'o', 'r', 's')) {
                    return NodeName::separatorsAttr;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'e', 'l', 'l', 'c', 'h', 'e', 'c', 'k')) {
                    return NodeName::spellcheckAttr;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'o', 'p', '-', 'c', 'o', 'l', 'o', 'r')) {
                    return NodeName::stop_colorAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (WTF::equal(buffer.data() + 1, "extLength"_span)) {
                return NodeName::textLengthAttr;
            }
            break;
        }
        case 'v': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'r', 't', '-', 'a', 'd', 'v', '-', 'y')) {
                    return NodeName::vert_adv_yAttr;
                }
                break;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'e': {
                    if (compareCharacters(buffer.data() + 3, 'w', 'T', 'a', 'r', 'g', 'e', 't')) {
                        return NodeName::viewTargetAttr;
                    }
                    break;
                }
                case 's': {
                    if (compareCharacters(buffer.data() + 3, 'i', 'b', 'i', 'l', 'i', 't', 'y')) {
                        return NodeName::visibilityAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'z': {
            if (WTF::equal(buffer.data() + 1, "oomAndPan"_span)) {
                return NodeName::zoomAndPanAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 11: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                if (WTF::equal(buffer.data() + 2, "centunder"_span)) {
                    return NodeName::accentunderAttr;
                }
                break;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'b', 'i', 'c', '-', 'f', 'o', 'r', 'm')) {
                        return NodeName::arabic_formAttr;
                    }
                    break;
                }
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'a': {
                                if (compareCharacters(buffer.data() + 6, 't', 'o', 'm', 'i', 'c')) {
                                    return NodeName::aria_atomicAttr;
                                }
                                break;
                            }
                            case 'f': {
                                if (compareCharacters(buffer.data() + 6, 'l', 'o', 'w', 't', 'o')) {
                                    return NodeName::aria_flowtoAttr;
                                }
                                break;
                            }
                            case 'h': {
                                if (compareCharacters(buffer.data() + 6, 'i', 'd', 'd', 'e', 'n')) {
                                    return NodeName::aria_hiddenAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "tocorrect"_span)) {
                    return NodeName::autocorrectAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            switch (buffer[1]) {
            case 'a': {
                if (WTF::equal(buffer.data() + 2, "seProfile"_span)) {
                    return NodeName::baseProfileAttr;
                }
                break;
            }
            case 'o': {
                if (WTF::equal(buffer.data() + 2, "rdercolor"_span)) {
                    return NodeName::bordercolorAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'l': {
                    switch (buffer[3]) {
                    case 'l': {
                        switch (buffer[4]) {
                        case 'p': {
                            if (compareCharacters(buffer.data() + 5, 'a', 'd', 'd', 'i', 'n', 'g')) {
                                return NodeName::cellpaddingAttr;
                            }
                            break;
                        }
                        case 's': {
                            if (compareCharacters(buffer.data() + 5, 'p', 'a', 'c', 'i', 'n', 'g')) {
                                return NodeName::cellspacingAttr;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'r': {
                if (WTF::equal(buffer.data() + 2, "ossorigin"_span)) {
                    return NodeName::crossoriginAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            if (WTF::equal(buffer.data() + 1, "xportparts"_span)) {
                return NodeName::exportpartsAttr;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'i': {
                if (WTF::equal(buffer.data() + 2, "lterUnits"_span)) {
                    return NodeName::filterUnitsAttr;
                }
                break;
            }
            case 'l': {
                if (WTF::equal(buffer.data() + 2, "ood-color"_span)) {
                    return NodeName::flood_colorAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'f': {
                                if (compareCharacters(buffer.data() + 6, 'a', 'm', 'i', 'l', 'y')) {
                                    return NodeName::font_familyAttr;
                                }
                                break;
                            }
                            case 'w': {
                                if (compareCharacters(buffer.data() + 6, 'e', 'i', 'g', 'h', 't')) {
                                    return NodeName::font_weightAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'm', 'e', 'n', 'c', 't', 'y', 'p', 'e')) {
                        return NodeName::formenctypeAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'r': {
                if (WTF::equal(buffer.data() + 2, "ameborder"_span)) {
                    return NodeName::frameborderAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'h': {
            if (WTF::equal(buffer.data() + 1, "oriz-adv-x"_span)) {
                return NodeName::horiz_adv_xAttr;
            }
            break;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'm': {
                if (WTF::equal(buffer.data() + 2, "agesrcset"_span)) {
                    return NodeName::imagesrcsetAttr;
                }
                break;
            }
            case 'n': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'e', 'm', 'e', 'n', 't', 'a', 'l')) {
                        return NodeName::incrementalAttr;
                    }
                    break;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r', 'a', 'c', 't', 'i', 'v', 'e')) {
                        return NodeName::interactiveAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'g': {
                        if (compareCharacters(buffer.data() + 4, 'i', 'n', 'w', 'i', 'd', 't', 'h')) {
                            return NodeName::marginwidthAttr;
                        }
                        break;
                    }
                    case 'k': {
                        switch (buffer[4]) {
                        case 'e': {
                            switch (buffer[5]) {
                            case 'r': {
                                switch (buffer[6]) {
                                case 'U': {
                                    if (compareCharacters(buffer.data() + 7, 'n', 'i', 't', 's')) {
                                        return NodeName::markerUnitsAttr;
                                    }
                                    break;
                                }
                                case 'W': {
                                    if (compareCharacters(buffer.data() + 7, 'i', 'd', 't', 'h')) {
                                        return NodeName::markerWidthAttr;
                                    }
                                    break;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'h', 'v', 'a', 'r', 'i', 'a', 'n', 't')) {
                        return NodeName::mathvariantAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'b': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'f', 'o', 'r', 'e', 'c', 'u', 't')) {
                        return NodeName::onbeforecutAttr;
                    }
                    break;
                }
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'u', 'e', 'c', 'h', 'a', 'n', 'g', 'e')) {
                        return NodeName::oncuechangeAttr;
                    }
                    break;
                }
                case 'd': {
                    switch (buffer[3]) {
                    case 'r': {
                        switch (buffer[4]) {
                        case 'a': {
                            switch (buffer[5]) {
                            case 'g': {
                                switch (buffer[6]) {
                                case 'e': {
                                    if (compareCharacters(buffer.data() + 7, 'n', 't', 'e', 'r')) {
                                        return NodeName::ondragenterAttr;
                                    }
                                    break;
                                }
                                case 'l': {
                                    if (compareCharacters(buffer.data() + 7, 'e', 'a', 'v', 'e')) {
                                        return NodeName::ondragleaveAttr;
                                    }
                                    break;
                                }
                                case 's': {
                                    if (compareCharacters(buffer.data() + 7, 't', 'a', 'r', 't')) {
                                        return NodeName::ondragstartAttr;
                                    }
                                    break;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'a', 'd', 's', 't', 'a', 'r', 't')) {
                        return NodeName::onloadstartAttr;
                    }
                    break;
                }
                case 'm': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'u': {
                            switch (buffer[5]) {
                            case 's': {
                                switch (buffer[6]) {
                                case 'e': {
                                    switch (buffer[7]) {
                                    case 'd': {
                                        if (compareCharacters(buffer.data() + 8, 'o', 'w', 'n')) {
                                            return NodeName::onmousedownAttr;
                                        }
                                        break;
                                    }
                                    case 'm': {
                                        if (compareCharacters(buffer.data() + 8, 'o', 'v', 'e')) {
                                            return NodeName::onmousemoveAttr;
                                        }
                                        break;
                                    }
                                    case 'o': {
                                        if (compareCharacters(buffer.data() + 8, 'v', 'e', 'r')) {
                                            return NodeName::onmouseoverAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'i', 'n', 't', 'e', 'r', 'u', 'p')) {
                        return NodeName::onpointerupAttr;
                    }
                    break;
                }
                case 't': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'u', 'c', 'h', 'm', 'o', 'v', 'e')) {
                        return NodeName::ontouchmoveAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                if (WTF::equal(buffer.data() + 2, "int-order"_span)) {
                    return NodeName::paint_orderAttr;
                }
                break;
            }
            case 'l': {
                switch (buffer[2]) {
                case 'a': {
                    switch (buffer[3]) {
                    case 'c': {
                        if (compareCharacters(buffer.data() + 4, 'e', 'h', 'o', 'l', 'd', 'e', 'r')) {
                            return NodeName::placeholderAttr;
                        }
                        break;
                    }
                    case 'y': {
                        if (compareCharacters(buffer.data() + 4, 's', 'i', 'n', 'l', 'i', 'n', 'e')) {
                            return NodeName::playsinlineAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            if (WTF::equal(buffer.data() + 1, "epeatCount"_span)) {
                return NodeName::repeatCountAttr;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                if (WTF::equal(buffer.data() + 2, "rolldelay"_span)) {
                    return NodeName::scrolldelayAttr;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'r', 't', 'O', 'f', 'f', 's', 'e', 't')) {
                        return NodeName::startOffsetAttr;
                    }
                    break;
                }
                case 'i': {
                    if (compareCharacters(buffer.data() + 3, 't', 'c', 'h', 'T', 'i', 'l', 'e', 's')) {
                        return NodeName::stitchTilesAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'a': {
                if (WTF::equal(buffer.data() + 2, "bleValues"_span)) {
                    return NodeName::tableValuesAttr;
                }
                break;
            }
            case 'e': {
                if (WTF::equal(buffer.data() + 2, "xt-anchor"_span)) {
                    return NodeName::text_anchorAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 12: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'c': {
                                switch (buffer[6]) {
                                case 'h': {
                                    if (compareCharacters(buffer.data() + 7, 'e', 'c', 'k', 'e', 'd')) {
                                        return NodeName::aria_checkedAttr;
                                    }
                                    break;
                                }
                                case 'o': {
                                    if (compareCharacters(buffer.data() + 7, 'l', 's', 'p', 'a', 'n')) {
                                        return NodeName::aria_colspanAttr;
                                    }
                                    break;
                                }
                                case 'u': {
                                    if (compareCharacters(buffer.data() + 7, 'r', 'r', 'e', 'n', 't')) {
                                        return NodeName::aria_currentAttr;
                                    }
                                    break;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            case 'd': {
                                if (compareCharacters(buffer.data() + 6, 'e', 't', 'a', 'i', 'l', 's')) {
                                    return NodeName::aria_detailsAttr;
                                }
                                break;
                            }
                            case 'g': {
                                if (compareCharacters(buffer.data() + 6, 'r', 'a', 'b', 'b', 'e', 'd')) {
                                    return NodeName::aria_grabbedAttr;
                                }
                                break;
                            }
                            case 'i': {
                                if (compareCharacters(buffer.data() + 6, 'n', 'v', 'a', 'l', 'i', 'd')) {
                                    return NodeName::aria_invalidAttr;
                                }
                                break;
                            }
                            case 'p': {
                                if (compareCharacters(buffer.data() + 6, 'r', 'e', 's', 's', 'e', 'd')) {
                                    return NodeName::aria_pressedAttr;
                                }
                                break;
                            }
                            case 'r': {
                                if (compareCharacters(buffer.data() + 6, 'o', 'w', 's', 'p', 'a', 'n')) {
                                    return NodeName::aria_rowspanAttr;
                                }
                                break;
                            }
                            case 's': {
                                if (compareCharacters(buffer.data() + 6, 'e', 't', 's', 'i', 'z', 'e')) {
                                    return NodeName::aria_setsizeAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "tocomplete"_span)) {
                    return NodeName::autocompleteAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            if (WTF::equal(buffer.data() + 1, "isplaystyle"_span)) {
                return NodeName::displaystyleAttr;
            }
            break;
        }
        case 'e': {
            if (WTF::equal(buffer.data() + 1, "nterkeyhint"_span)) {
                return NodeName::enterkeyhintAttr;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'i': {
                if (WTF::equal(buffer.data() + 2, "ll-opacity"_span)) {
                    return NodeName::fill_opacityAttr;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 's': {
                                if (compareCharacters(buffer.data() + 6, 't', 'r', 'e', 't', 'c', 'h')) {
                                    return NodeName::font_stretchAttr;
                                }
                                break;
                            }
                            case 'v': {
                                if (compareCharacters(buffer.data() + 6, 'a', 'r', 'i', 'a', 'n', 't')) {
                                    return NodeName::font_variantAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'k': {
            if (WTF::equal(buffer.data() + 1, "ernelMatrix"_span)) {
                return NodeName::kernelMatrixAttr;
            }
            break;
        }
        case 'l': {
            if (WTF::equal(buffer.data() + 1, "engthAdjust"_span)) {
                return NodeName::lengthAdjustAttr;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'g': {
                        if (compareCharacters(buffer.data() + 4, 'i', 'n', 'h', 'e', 'i', 'g', 'h', 't')) {
                            return NodeName::marginheightAttr;
                        }
                        break;
                    }
                    case 'k': {
                        switch (buffer[4]) {
                        case 'e': {
                            switch (buffer[5]) {
                            case 'r': {
                                switch (buffer[6]) {
                                case '-': {
                                    if (compareCharacters(buffer.data() + 7, 's', 't', 'a', 'r', 't')) {
                                        return NodeName::marker_startAttr;
                                    }
                                    break;
                                }
                                case 'H': {
                                    if (compareCharacters(buffer.data() + 7, 'e', 'i', 'g', 'h', 't')) {
                                        return NodeName::markerHeightAttr;
                                    }
                                    break;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    if (WTF::equal(buffer.data() + 3, "fterprint"_span)) {
                        return NodeName::onafterprintAttr;
                    }
                    break;
                }
                case 'b': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'f': {
                            switch (buffer[5]) {
                            case 'o': {
                                switch (buffer[6]) {
                                case 'r': {
                                    switch (buffer[7]) {
                                    case 'e': {
                                        switch (buffer[8]) {
                                        case 'c': {
                                            if (compareCharacters(buffer.data() + 9, 'o', 'p', 'y')) {
                                                return NodeName::onbeforecopyAttr;
                                            }
                                            break;
                                        }
                                        case 'l': {
                                            if (compareCharacters(buffer.data() + 9, 'o', 'a', 'd')) {
                                                return NodeName::onbeforeloadAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'g': {
                    if (WTF::equal(buffer.data() + 3, "estureend"_span)) {
                        return NodeName::ongestureendAttr;
                    }
                    break;
                }
                case 'h': {
                    if (WTF::equal(buffer.data() + 3, "ashchange"_span)) {
                        return NodeName::onhashchangeAttr;
                    }
                    break;
                }
                case 'l': {
                    if (WTF::equal(buffer.data() + 3, "oadeddata"_span)) {
                        return NodeName::onloadeddataAttr;
                    }
                    break;
                }
                case 'm': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'u': {
                            switch (buffer[5]) {
                            case 's': {
                                switch (buffer[6]) {
                                case 'e': {
                                    switch (buffer[7]) {
                                    case 'e': {
                                        if (compareCharacters(buffer.data() + 8, 'n', 't', 'e', 'r')) {
                                            return NodeName::onmouseenterAttr;
                                        }
                                        break;
                                    }
                                    case 'l': {
                                        if (compareCharacters(buffer.data() + 8, 'e', 'a', 'v', 'e')) {
                                            return NodeName::onmouseleaveAttr;
                                        }
                                        break;
                                    }
                                    case 'w': {
                                        if (compareCharacters(buffer.data() + 8, 'h', 'e', 'e', 'l')) {
                                            return NodeName::onmousewheelAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'p': {
                    switch (buffer[3]) {
                    case 'a': {
                        if (compareCharacters(buffer.data() + 4, 'g', 'e', 'r', 'e', 'v', 'e', 'a', 'l')) {
                            return NodeName::onpagerevealAttr;
                        }
                        break;
                    }
                    case 'o': {
                        if (compareCharacters(buffer.data() + 4, 'i', 'n', 't', 'e', 'r', 'o', 'u', 't')) {
                            return NodeName::onpointeroutAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'r': {
                    if (WTF::equal(buffer.data() + 3, "atechange"_span)) {
                        return NodeName::onratechangeAttr;
                    }
                    break;
                }
                case 's': {
                    if (WTF::equal(buffer.data() + 3, "lotchange"_span)) {
                        return NodeName::onslotchangeAttr;
                    }
                    break;
                }
                case 't': {
                    switch (buffer[3]) {
                    case 'i': {
                        if (compareCharacters(buffer.data() + 4, 'm', 'e', 'u', 'p', 'd', 'a', 't', 'e')) {
                            return NodeName::ontimeupdateAttr;
                        }
                        break;
                    }
                    case 'o': {
                        if (compareCharacters(buffer.data() + 4, 'u', 'c', 'h', 's', 't', 'a', 'r', 't')) {
                            return NodeName::ontouchstartAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            if (WTF::equal(buffer.data() + 1, "atternUnits"_span)) {
                return NodeName::patternUnitsAttr;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                if (WTF::equal(buffer.data() + 2, "rollamount"_span)) {
                    return NodeName::scrollamountAttr;
                }
                break;
            }
            case 'p': {
                if (WTF::equal(buffer.data() + 2, "readMethod"_span)) {
                    return NodeName::spreadMethodAttr;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'd': {
                    if (WTF::equal(buffer.data() + 3, "Deviation"_span)) {
                        return NodeName::stdDeviationAttr;
                    }
                    break;
                }
                case 'o': {
                    if (WTF::equal(buffer.data() + 3, "p-opacity"_span)) {
                        return NodeName::stop_opacityAttr;
                    }
                    break;
                }
                case 'r': {
                    if (WTF::equal(buffer.data() + 3, "oke-width"_span)) {
                        return NodeName::stroke_widthAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "rfaceScale"_span)) {
                    return NodeName::surfaceScaleAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'u': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'c': {
                        if (compareCharacters(buffer.data() + 4, 'o', 'd', 'e', '-', 'b', 'i', 'd', 'i')) {
                            return NodeName::unicode_bidiAttr;
                        }
                        break;
                    }
                    case 't': {
                        if (compareCharacters(buffer.data() + 4, 's', '-', 'p', 'e', 'r', '-', 'e', 'm')) {
                            return NodeName::units_per_emAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'w': {
            switch (buffer[1]) {
            case 'o': {
                if (WTF::equal(buffer.data() + 2, "rd-spacing"_span)) {
                    return NodeName::word_spacingAttr;
                }
                break;
            }
            case 'r': {
                if (WTF::equal(buffer.data() + 2, "iting-mode"_span)) {
                    return NodeName::writing_modeAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 13: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'c': {
                                switch (buffer[6]) {
                                case 'o': {
                                    switch (buffer[7]) {
                                    case 'l': {
                                        switch (buffer[8]) {
                                        case 'c': {
                                            if (compareCharacters(buffer.data() + 9, 'o', 'u', 'n', 't')) {
                                                return NodeName::aria_colcountAttr;
                                            }
                                            break;
                                        }
                                        case 'i': {
                                            if (compareCharacters(buffer.data() + 9, 'n', 'd', 'e', 'x')) {
                                                return NodeName::aria_colindexAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    case 'n': {
                                        if (compareCharacters(buffer.data() + 8, 't', 'r', 'o', 'l', 's')) {
                                            return NodeName::aria_controlsAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            case 'd': {
                                if (compareCharacters(buffer.data() + 6, 'i', 's', 'a', 'b', 'l', 'e', 'd')) {
                                    return NodeName::aria_disabledAttr;
                                }
                                break;
                            }
                            case 'e': {
                                if (compareCharacters(buffer.data() + 6, 'x', 'p', 'a', 'n', 'd', 'e', 'd')) {
                                    return NodeName::aria_expandedAttr;
                                }
                                break;
                            }
                            case 'h': {
                                if (compareCharacters(buffer.data() + 6, 'a', 's', 'p', 'o', 'p', 'u', 'p')) {
                                    return NodeName::aria_haspopupAttr;
                                }
                                break;
                            }
                            case 'p': {
                                if (compareCharacters(buffer.data() + 6, 'o', 's', 'i', 'n', 's', 'e', 't')) {
                                    return NodeName::aria_posinsetAttr;
                                }
                                break;
                            }
                            case 'r': {
                                switch (buffer[6]) {
                                case 'e': {
                                    switch (buffer[7]) {
                                    case 'a': {
                                        if (compareCharacters(buffer.data() + 8, 'd', 'o', 'n', 'l', 'y')) {
                                            return NodeName::aria_readonlyAttr;
                                        }
                                        break;
                                    }
                                    case 'l': {
                                        if (compareCharacters(buffer.data() + 8, 'e', 'v', 'a', 'n', 't')) {
                                            return NodeName::aria_relevantAttr;
                                        }
                                        break;
                                    }
                                    case 'q': {
                                        if (compareCharacters(buffer.data() + 8, 'u', 'i', 'r', 'e', 'd')) {
                                            return NodeName::aria_requiredAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                case 'o': {
                                    switch (buffer[7]) {
                                    case 'w': {
                                        switch (buffer[8]) {
                                        case 'c': {
                                            if (compareCharacters(buffer.data() + 9, 'o', 'u', 'n', 't')) {
                                                return NodeName::aria_rowcountAttr;
                                            }
                                            break;
                                        }
                                        case 'i': {
                                            if (compareCharacters(buffer.data() + 9, 'n', 'd', 'e', 'x')) {
                                                return NodeName::aria_rowindexAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            case 's': {
                                if (compareCharacters(buffer.data() + 6, 'e', 'l', 'e', 'c', 't', 'e', 'd')) {
                                    return NodeName::aria_selectedAttr;
                                }
                                break;
                            }
                            case 'v': {
                                switch (buffer[6]) {
                                case 'a': {
                                    switch (buffer[7]) {
                                    case 'l': {
                                        switch (buffer[8]) {
                                        case 'u': {
                                            switch (buffer[9]) {
                                            case 'e': {
                                                switch (buffer[10]) {
                                                case 'm': {
                                                    switch (buffer[11]) {
                                                    case 'a': {
                                                        if (buffer[12] == 'x') {
                                                            return NodeName::aria_valuemaxAttr;
                                                        }
                                                        break;
                                                    }
                                                    case 'i': {
                                                        if (buffer[12] == 'n') {
                                                            return NodeName::aria_valueminAttr;
                                                        }
                                                        break;
                                                    }
                                                    default:
                                                        break;
                                                    }
                                                    return NodeName::Unknown;
                                                }
                                                case 'n': {
                                                    if (compareCharacters(buffer.data() + 11, 'o', 'w')) {
                                                        return NodeName::aria_valuenowAttr;
                                                    }
                                                    break;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 't': {
                switch (buffer[2]) {
                case 't': {
                    switch (buffer[3]) {
                    case 'r': {
                        switch (buffer[4]) {
                        case 'i': {
                            switch (buffer[5]) {
                            case 'b': {
                                switch (buffer[6]) {
                                case 'u': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'e': {
                                            switch (buffer[9]) {
                                            case 'N': {
                                                if (compareCharacters(buffer.data() + 10, 'a', 'm', 'e')) {
                                                    return NodeName::attributeNameAttr;
                                                }
                                                break;
                                            }
                                            case 'T': {
                                                if (compareCharacters(buffer.data() + 10, 'y', 'p', 'e')) {
                                                    return NodeName::attributeTypeAttr;
                                                }
                                                break;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (WTF::equal(buffer.data() + 1, "aseFrequency"_span)) {
                return NodeName::baseFrequencyAttr;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'l': {
                if (WTF::equal(buffer.data() + 2, "ipPathUnits"_span)) {
                    return NodeName::clipPathUnitsAttr;
                }
                break;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "ebackground"_span)) {
                    return NodeName::cuebackgroundAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            if (WTF::equal(buffer.data() + 1, "efinitionURL"_span)) {
                return NodeName::definitionURLAttr;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                if (WTF::equal(buffer.data() + 2, "tchpriority"_span)) {
                    return NodeName::fetchpriorityAttr;
                }
                break;
            }
            case 'l': {
                if (WTF::equal(buffer.data() + 2, "ood-opacity"_span)) {
                    return NodeName::flood_opacityAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'g': {
            if (WTF::equal(buffer.data() + 1, "radientUnits"_span)) {
                return NodeName::gradientUnitsAttr;
            }
            break;
        }
        case 'l': {
            if (WTF::equal(buffer.data() + 1, "inethickness"_span)) {
                return NodeName::linethicknessAttr;
            }
            break;
        }
        case 'm': {
            if (WTF::equal(buffer.data() + 1, "ovablelimits"_span)) {
                return NodeName::movablelimitsAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'b': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'f': {
                            switch (buffer[5]) {
                            case 'o': {
                                switch (buffer[6]) {
                                case 'r': {
                                    switch (buffer[7]) {
                                    case 'e': {
                                        switch (buffer[8]) {
                                        case 'i': {
                                            if (compareCharacters(buffer.data() + 9, 'n', 'p', 'u', 't')) {
                                                return NodeName::onbeforeinputAttr;
                                            }
                                            break;
                                        }
                                        case 'p': {
                                            switch (buffer[9]) {
                                            case 'a': {
                                                if (compareCharacters(buffer.data() + 10, 's', 't', 'e')) {
                                                    return NodeName::onbeforepasteAttr;
                                                }
                                                break;
                                            }
                                            case 'r': {
                                                if (compareCharacters(buffer.data() + 10, 'i', 'n', 't')) {
                                                    return NodeName::onbeforeprintAttr;
                                                }
                                                break;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'c': {
                    if (WTF::equal(buffer.data() + 3, "ontextmenu"_span)) {
                        return NodeName::oncontextmenuAttr;
                    }
                    break;
                }
                case 'p': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'i': {
                            switch (buffer[5]) {
                            case 'n': {
                                switch (buffer[6]) {
                                case 't': {
                                    switch (buffer[7]) {
                                    case 'e': {
                                        switch (buffer[8]) {
                                        case 'r': {
                                            switch (buffer[9]) {
                                            case 'd': {
                                                if (compareCharacters(buffer.data() + 10, 'o', 'w', 'n')) {
                                                    return NodeName::onpointerdownAttr;
                                                }
                                                break;
                                            }
                                            case 'm': {
                                                if (compareCharacters(buffer.data() + 10, 'o', 'v', 'e')) {
                                                    return NodeName::onpointermoveAttr;
                                                }
                                                break;
                                            }
                                            case 'o': {
                                                if (compareCharacters(buffer.data() + 10, 'v', 'e', 'r')) {
                                                    return NodeName::onpointeroverAttr;
                                                }
                                                break;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 's': {
                    if (WTF::equal(buffer.data() + 3, "electstart"_span)) {
                        return NodeName::onselectstartAttr;
                    }
                    break;
                }
                case 't': {
                    if (WTF::equal(buffer.data() + 3, "ouchcancel"_span)) {
                        return NodeName::ontouchcancelAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'o': {
                if (WTF::equal(buffer.data() + 2, "povertarget"_span)) {
                    return NodeName::popovertargetAttr;
                }
                break;
            }
            case 'r': {
                if (WTF::equal(buffer.data() + 2, "eserveAlpha"_span)) {
                    return NodeName::preserveAlphaAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'u': {
            if (WTF::equal(buffer.data() + 1, "seragentpart"_span)) {
                return NodeName::useragentpartAttr;
            }
            break;
        }
        case 'v': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'c': {
                    if (WTF::equal(buffer.data() + 3, "tor-effect"_span)) {
                        return NodeName::vector_effectAttr;
                    }
                    break;
                }
                case 'r': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'o': {
                                switch (buffer[6]) {
                                case 'r': {
                                    switch (buffer[7]) {
                                    case 'i': {
                                        switch (buffer[8]) {
                                        case 'g': {
                                            switch (buffer[9]) {
                                            case 'i': {
                                                switch (buffer[10]) {
                                                case 'n': {
                                                    switch (buffer[11]) {
                                                    case '-': {
                                                        switch (buffer[12]) {
                                                        case 'x': {
                                                            return NodeName::vert_origin_xAttr;
                                                        }
                                                        case 'y': {
                                                            return NodeName::vert_origin_yAttr;
                                                        }
                                                        default:
                                                            break;
                                                        }
                                                        return NodeName::Unknown;
                                                    }
                                                    default:
                                                        break;
                                                    }
                                                    return NodeName::Unknown;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 14: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                if (WTF::equal(buffer.data() + 2, "cept-charset"_span)) {
                    return NodeName::accept_charsetAttr;
                }
                break;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'l': {
                                if (compareCharacters(buffer.data() + 6, 'a', 'b', 'e', 'l', 'e', 'd', 'b', 'y')) {
                                    return NodeName::aria_labeledbyAttr;
                                }
                                break;
                            }
                            case 'm': {
                                if (compareCharacters(buffer.data() + 6, 'u', 'l', 't', 'i', 'l', 'i', 'n', 'e')) {
                                    return NodeName::aria_multilineAttr;
                                }
                                break;
                            }
                            case 'v': {
                                if (compareCharacters(buffer.data() + 6, 'a', 'l', 'u', 'e', 't', 'e', 'x', 't')) {
                                    return NodeName::aria_valuetextAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "tocapitalize"_span)) {
                    return NodeName::autocapitalizeAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (WTF::equal(buffer.data() + 1, "aseline-shift"_span)) {
                return NodeName::baseline_shiftAttr;
            }
            break;
        }
        case 'f': {
            if (WTF::equal(buffer.data() + 1, "ormnovalidate"_span)) {
                return NodeName::formnovalidateAttr;
            }
            break;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'i': {
                        switch (buffer[4]) {
                        case 'z': {
                            switch (buffer[5]) {
                            case '-': {
                                switch (buffer[6]) {
                                case 'o': {
                                    switch (buffer[7]) {
                                    case 'r': {
                                        switch (buffer[8]) {
                                        case 'i': {
                                            switch (buffer[9]) {
                                            case 'g': {
                                                switch (buffer[10]) {
                                                case 'i': {
                                                    switch (buffer[11]) {
                                                    case 'n': {
                                                        switch (buffer[12]) {
                                                        case '-': {
                                                            switch (buffer[13]) {
                                                            case 'x': {
                                                                return NodeName::horiz_origin_xAttr;
                                                            }
                                                            case 'y': {
                                                                return NodeName::horiz_origin_yAttr;
                                                            }
                                                            default:
                                                                break;
                                                            }
                                                            return NodeName::Unknown;
                                                        }
                                                        default:
                                                            break;
                                                        }
                                                        return NodeName::Unknown;
                                                    }
                                                    default:
                                                        break;
                                                    }
                                                    return NodeName::Unknown;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            switch (buffer[1]) {
            case 'e': {
                if (WTF::equal(buffer.data() + 2, "tter-spacing"_span)) {
                    return NodeName::letter_spacingAttr;
                }
                break;
            }
            case 'i': {
                if (WTF::equal(buffer.data() + 2, "ghting-color"_span)) {
                    return NodeName::lighting_colorAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            if (WTF::equal(buffer.data() + 1, "athbackground"_span)) {
                return NodeName::mathbackgroundAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    switch (buffer[3]) {
                    case 'n': {
                        if (WTF::equal(buffer.data() + 4, "imationend"_span)) {
                            return NodeName::onanimationendAttr;
                        }
                        break;
                    }
                    case 'u': {
                        if (WTF::equal(buffer.data() + 4, "tocomplete"_span)) {
                            return NodeName::onautocompleteAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'b': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'f': {
                            switch (buffer[5]) {
                            case 'o': {
                                switch (buffer[6]) {
                                case 'r': {
                                    switch (buffer[7]) {
                                    case 'e': {
                                        switch (buffer[8]) {
                                        case 't': {
                                            if (compareCharacters(buffer.data() + 9, 'o', 'g', 'g', 'l', 'e')) {
                                                return NodeName::onbeforetoggleAttr;
                                            }
                                            break;
                                        }
                                        case 'u': {
                                            if (compareCharacters(buffer.data() + 9, 'n', 'l', 'o', 'a', 'd')) {
                                                return NodeName::onbeforeunloadAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'd': {
                    if (WTF::equal(buffer.data() + 3, "evicechange"_span)) {
                        return NodeName::ondevicechangeAttr;
                    }
                    break;
                }
                case 'g': {
                    if (WTF::equal(buffer.data() + 3, "esturestart"_span)) {
                        return NodeName::ongesturestartAttr;
                    }
                    break;
                }
                case 'm': {
                    if (WTF::equal(buffer.data() + 3, "essageerror"_span)) {
                        return NodeName::onmessageerrorAttr;
                    }
                    break;
                }
                case 'p': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'i': {
                            switch (buffer[5]) {
                            case 'n': {
                                switch (buffer[6]) {
                                case 't': {
                                    switch (buffer[7]) {
                                    case 'e': {
                                        switch (buffer[8]) {
                                        case 'r': {
                                            switch (buffer[9]) {
                                            case 'e': {
                                                if (compareCharacters(buffer.data() + 10, 'n', 't', 'e', 'r')) {
                                                    return NodeName::onpointerenterAttr;
                                                }
                                                break;
                                            }
                                            case 'l': {
                                                if (compareCharacters(buffer.data() + 10, 'e', 'a', 'v', 'e')) {
                                                    return NodeName::onpointerleaveAttr;
                                                }
                                                break;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'v': {
                    if (WTF::equal(buffer.data() + 3, "olumechange"_span)) {
                        return NodeName::onvolumechangeAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'o': {
                if (WTF::equal(buffer.data() + 2, "inter-events"_span)) {
                    return NodeName::pointer_eventsAttr;
                }
                break;
            }
            case 'r': {
                if (WTF::equal(buffer.data() + 2, "imitiveUnits"_span)) {
                    return NodeName::primitiveUnitsAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            if (WTF::equal(buffer.data() + 1, "eferrerpolicy"_span)) {
                return NodeName::referrerpolicyAttr;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'h': {
                if (WTF::equal(buffer.data() + 2, "adowrootmode"_span)) {
                    return NodeName::shadowrootmodeAttr;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'k': {
                            switch (buffer[5]) {
                            case 'e': {
                                switch (buffer[6]) {
                                case '-': {
                                    switch (buffer[7]) {
                                    case 'l': {
                                        if (compareCharacters(buffer.data() + 8, 'i', 'n', 'e', 'c', 'a', 'p')) {
                                            return NodeName::stroke_linecapAttr;
                                        }
                                        break;
                                    }
                                    case 'o': {
                                        if (compareCharacters(buffer.data() + 8, 'p', 'a', 'c', 'i', 't', 'y')) {
                                            return NodeName::stroke_opacityAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "bscriptshift"_span)) {
                    return NodeName::subscriptshiftAttr;
                }
                break;
            }
            case 'y': {
                if (WTF::equal(buffer.data() + 2, "stemLanguage"_span)) {
                    return NodeName::systemLanguageAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (WTF::equal(buffer.data() + 1, "ext-rendering"_span)) {
                return NodeName::text_renderingAttr;
            }
            break;
        }
        case 'w': {
            if (WTF::equal(buffer.data() + 1, "ebkitdropzone"_span)) {
                return NodeName::webkitdropzoneAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 15: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'l': {
                if (WTF::equal(buffer.data() + 2, "lowfullscreen"_span)) {
                    return NodeName::allowfullscreenAttr;
                }
                break;
            }
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'd': {
                                if (WTF::equal(buffer.data() + 6, "ropeffect"_span)) {
                                    return NodeName::aria_dropeffectAttr;
                                }
                                break;
                            }
                            case 'l': {
                                if (WTF::equal(buffer.data() + 6, "abelledby"_span)) {
                                    return NodeName::aria_labelledbyAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'c': {
            if (WTF::equal(buffer.data() + 1, "ontenteditable"_span)) {
                return NodeName::contenteditableAttr;
            }
            break;
        }
        case 'd': {
            if (WTF::equal(buffer.data() + 1, "iffuseConstant"_span)) {
                return NodeName::diffuseConstantAttr;
            }
            break;
        }
        case 'i': {
            if (WTF::equal(buffer.data() + 1, "mage-rendering"_span)) {
                return NodeName::image_renderingAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'g': {
                    if (WTF::equal(buffer.data() + 3, "esturechange"_span)) {
                        return NodeName::ongesturechangeAttr;
                    }
                    break;
                }
                case 'p': {
                    if (WTF::equal(buffer.data() + 3, "ointercancel"_span)) {
                        return NodeName::onpointercancelAttr;
                    }
                    break;
                }
                case 't': {
                    switch (buffer[3]) {
                    case 'r': {
                        switch (buffer[4]) {
                        case 'a': {
                            switch (buffer[5]) {
                            case 'n': {
                                switch (buffer[6]) {
                                case 's': {
                                    switch (buffer[7]) {
                                    case 'i': {
                                        switch (buffer[8]) {
                                        case 't': {
                                            switch (buffer[9]) {
                                            case 'i': {
                                                switch (buffer[10]) {
                                                case 'o': {
                                                    switch (buffer[11]) {
                                                    case 'n': {
                                                        switch (buffer[12]) {
                                                        case 'e': {
                                                            if (compareCharacters(buffer.data() + 13, 'n', 'd')) {
                                                                return NodeName::ontransitionendAttr;
                                                            }
                                                            break;
                                                        }
                                                        case 'r': {
                                                            if (compareCharacters(buffer.data() + 13, 'u', 'n')) {
                                                                return NodeName::ontransitionrunAttr;
                                                            }
                                                            break;
                                                        }
                                                        default:
                                                            break;
                                                        }
                                                        return NodeName::Unknown;
                                                    }
                                                    default:
                                                        break;
                                                    }
                                                    return NodeName::Unknown;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'w': {
                    if (WTF::equal(buffer.data() + 3, "ebkitneedkey"_span)) {
                        return NodeName::onwebkitneedkeyAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'h': {
                if (WTF::equal(buffer.data() + 2, "ape-rendering"_span)) {
                    return NodeName::shape_renderingAttr;
                }
                break;
            }
            case 't': {
                if (WTF::equal(buffer.data() + 2, "roke-linejoin"_span)) {
                    return NodeName::stroke_linejoinAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (WTF::equal(buffer.data() + 1, "ext-decoration"_span)) {
                return NodeName::text_decorationAttr;
            }
            break;
        }
        case 'w': {
            if (WTF::equal(buffer.data() + 1, "ebkitdirectory"_span)) {
                return NodeName::webkitdirectoryAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 16: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'd': {
                                switch (buffer[6]) {
                                case 'e': {
                                    switch (buffer[7]) {
                                    case 's': {
                                        switch (buffer[8]) {
                                        case 'c': {
                                            switch (buffer[9]) {
                                            case 'r': {
                                                switch (buffer[10]) {
                                                case 'i': {
                                                    switch (buffer[11]) {
                                                    case 'b': {
                                                        if (compareCharacters(buffer.data() + 12, 'e', 'd', 'b', 'y')) {
                                                            return NodeName::aria_describedbyAttr;
                                                        }
                                                        break;
                                                    }
                                                    case 'p': {
                                                        if (compareCharacters(buffer.data() + 12, 't', 'i', 'o', 'n')) {
                                                            return NodeName::aria_descriptionAttr;
                                                        }
                                                        break;
                                                    }
                                                    default:
                                                        break;
                                                    }
                                                    return NodeName::Unknown;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            case 'o': {
                                if (WTF::equal(buffer.data() + 6, "rientation"_span)) {
                                    return NodeName::aria_orientationAttr;
                                }
                                break;
                            }
                            case 'p': {
                                if (WTF::equal(buffer.data() + 6, "laceholder"_span)) {
                                    return NodeName::aria_placeholderAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'f': {
            if (WTF::equal(buffer.data() + 1, "ont-size-adjust"_span)) {
                return NodeName::font_size_adjustAttr;
            }
            break;
        }
        case 'k': {
            if (WTF::equal(buffer.data() + 1, "ernelUnitLength"_span)) {
                return NodeName::kernelUnitLengthAttr;
            }
            break;
        }
        case 'm': {
            if (WTF::equal(buffer.data() + 1, "askContentUnits"_span)) {
                return NodeName::maskContentUnitsAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    if (WTF::equal(buffer.data() + 3, "nimationstart"_span)) {
                        return NodeName::onanimationstartAttr;
                    }
                    break;
                }
                case 'c': {
                    if (WTF::equal(buffer.data() + 3, "anplaythrough"_span)) {
                        return NodeName::oncanplaythroughAttr;
                    }
                    break;
                }
                case 'd': {
                    if (WTF::equal(buffer.data() + 3, "urationchange"_span)) {
                        return NodeName::ondurationchangeAttr;
                    }
                    break;
                }
                case 'l': {
                    switch (buffer[3]) {
                    case 'a': {
                        if (WTF::equal(buffer.data() + 4, "nguagechange"_span)) {
                            return NodeName::onlanguagechangeAttr;
                        }
                        break;
                    }
                    case 'o': {
                        if (WTF::equal(buffer.data() + 4, "adedmetadata"_span)) {
                            return NodeName::onloadedmetadataAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'w': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'b': {
                            switch (buffer[5]) {
                            case 'k': {
                                switch (buffer[6]) {
                                case 'i': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'k': {
                                            switch (buffer[9]) {
                                            case 'e': {
                                                switch (buffer[10]) {
                                                case 'y': {
                                                    switch (buffer[11]) {
                                                    case 'a': {
                                                        if (compareCharacters(buffer.data() + 12, 'd', 'd', 'e', 'd')) {
                                                            return NodeName::onwebkitkeyaddedAttr;
                                                        }
                                                        break;
                                                    }
                                                    case 'e': {
                                                        if (compareCharacters(buffer.data() + 12, 'r', 'r', 'o', 'r')) {
                                                            return NodeName::onwebkitkeyerrorAttr;
                                                        }
                                                        break;
                                                    }
                                                    default:
                                                        break;
                                                    }
                                                    return NodeName::Unknown;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            if (WTF::equal(buffer.data() + 1, "atternTransform"_span)) {
                return NodeName::patternTransformAttr;
            }
            break;
        }
        case 'r': {
            if (WTF::equal(buffer.data() + 1, "equiredFeatures"_span)) {
                return NodeName::requiredFeaturesAttr;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'p': {
                switch (buffer[2]) {
                case 'e': {
                    switch (buffer[3]) {
                    case 'c': {
                        switch (buffer[4]) {
                        case 'u': {
                            switch (buffer[5]) {
                            case 'l': {
                                switch (buffer[6]) {
                                case 'a': {
                                    switch (buffer[7]) {
                                    case 'r': {
                                        switch (buffer[8]) {
                                        case 'C': {
                                            if (compareCharacters(buffer.data() + 9, 'o', 'n', 's', 't', 'a', 'n', 't')) {
                                                return NodeName::specularConstantAttr;
                                            }
                                            break;
                                        }
                                        case 'E': {
                                            if (compareCharacters(buffer.data() + 9, 'x', 'p', 'o', 'n', 'e', 'n', 't')) {
                                                return NodeName::specularExponentAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 't': {
                if (WTF::equal(buffer.data() + 2, "roke-dasharray"_span)) {
                    return NodeName::stroke_dasharrayAttr;
                }
                break;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "perscriptshift"_span)) {
                    return NodeName::superscriptshiftAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (WTF::equal(buffer.data() + 1, "ransform-origin"_span)) {
                return NodeName::transform_originAttr;
            }
            break;
        }
        case 'x': {
            switch (buffer[1]) {
            case '-': {
                if (WTF::equal(buffer.data() + 2, "webkit-airplay"_span)) {
                    return NodeName::webkitairplayAttr;
                }
                break;
            }
            case 'C': {
                if (WTF::equal(buffer.data() + 2, "hannelSelector"_span)) {
                    return NodeName::xChannelSelectorAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'y': {
            if (WTF::equal(buffer.data() + 1, "ChannelSelector"_span)) {
                return NodeName::yChannelSelectorAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 17: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'a': {
                                if (WTF::equal(buffer.data() + 6, "utocomplete"_span)) {
                                    return NodeName::aria_autocompleteAttr;
                                }
                                break;
                            }
                            case 'b': {
                                if (WTF::equal(buffer.data() + 6, "raillelabel"_span)) {
                                    return NodeName::aria_braillelabelAttr;
                                }
                                break;
                            }
                            case 'e': {
                                if (WTF::equal(buffer.data() + 6, "rrormessage"_span)) {
                                    return NodeName::aria_errormessageAttr;
                                }
                                break;
                            }
                            case 'k': {
                                if (WTF::equal(buffer.data() + 6, "eyshortcuts"_span)) {
                                    return NodeName::aria_keyshortcutsAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            if (WTF::equal(buffer.data() + 1, "ominant-baseline"_span)) {
                return NodeName::dominant_baselineAttr;
            }
            break;
        }
        case 'g': {
            if (WTF::equal(buffer.data() + 1, "radientTransform"_span)) {
                return NodeName::gradientTransformAttr;
            }
            break;
        }
        case 'l': {
            if (WTF::equal(buffer.data() + 1, "imitingConeAngle"_span)) {
                return NodeName::limitingConeAngleAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    if (WTF::equal(buffer.data() + 3, "nimationcancel"_span)) {
                        return NodeName::onanimationcancelAttr;
                    }
                    break;
                }
                case 'f': {
                    if (WTF::equal(buffer.data() + 3, "ullscreenerror"_span)) {
                        return NodeName::onfullscreenerrorAttr;
                    }
                    break;
                }
                case 's': {
                    if (WTF::equal(buffer.data() + 3, "electionchange"_span)) {
                        return NodeName::onselectionchangeAttr;
                    }
                    break;
                }
                case 't': {
                    if (WTF::equal(buffer.data() + 3, "ransitionstart"_span)) {
                        return NodeName::ontransitionstartAttr;
                    }
                    break;
                }
                case 'u': {
                    if (WTF::equal(buffer.data() + 3, "ncapturederror"_span)) {
                        return NodeName::onuncapturederrorAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 't': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'o': {
                        switch (buffer[4]) {
                        case 'k': {
                            switch (buffer[5]) {
                            case 'e': {
                                switch (buffer[6]) {
                                case '-': {
                                    switch (buffer[7]) {
                                    case 'd': {
                                        if (WTF::equal(buffer.data() + 8, "ashoffset"_span)) {
                                            return NodeName::stroke_dashoffsetAttr;
                                        }
                                        break;
                                    }
                                    case 'm': {
                                        if (WTF::equal(buffer.data() + 8, "iterlimit"_span)) {
                                            return NodeName::stroke_miterlimitAttr;
                                        }
                                        break;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 18: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "lignment-baseline"_span)) {
                return NodeName::alignment_baselineAttr;
            }
            break;
        }
        case 'b': {
            if (WTF::equal(buffer.data() + 1, "uffered-rendering"_span)) {
                return NodeName::buffered_renderingAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'f': {
                    if (WTF::equal(buffer.data() + 3, "ullscreenchange"_span)) {
                        return NodeName::onfullscreenchangeAttr;
                    }
                    break;
                }
                case 'g': {
                    if (WTF::equal(buffer.data() + 3, "amepadconnected"_span)) {
                        return NodeName::ongamepadconnectedAttr;
                    }
                    break;
                }
                case 'r': {
                    if (WTF::equal(buffer.data() + 3, "ejectionhandled"_span)) {
                        return NodeName::onrejectionhandledAttr;
                    }
                    break;
                }
                case 't': {
                    switch (buffer[3]) {
                    case 'o': {
                        if (WTF::equal(buffer.data() + 4, "uchforcechange"_span)) {
                            return NodeName::ontouchforcechangeAttr;
                        }
                        break;
                    }
                    case 'r': {
                        if (WTF::equal(buffer.data() + 4, "ansitioncancel"_span)) {
                            return NodeName::ontransitioncancelAttr;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'w': {
                    if (WTF::equal(buffer.data() + 3, "ebkitkeymessage"_span)) {
                        return NodeName::onwebkitkeymessageAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'r': {
            if (WTF::equal(buffer.data() + 1, "equiredExtensions"_span)) {
                return NodeName::requiredExtensionsAttr;
            }
            break;
        }
        case 's': {
            if (WTF::equal(buffer.data() + 1, "hadowrootclonable"_span)) {
                return NodeName::shadowrootclonableAttr;
            }
            break;
        }
        case 'w': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'b': {
                    switch (buffer[3]) {
                    case 'k': {
                        switch (buffer[4]) {
                        case 'i': {
                            switch (buffer[5]) {
                            case 't': {
                                switch (buffer[6]) {
                                case '-': {
                                    if (WTF::equal(buffer.data() + 7, "playsinline"_span)) {
                                        return NodeName::webkit_playsinlineAttr;
                                    }
                                    break;
                                }
                                case 'a': {
                                    if (WTF::equal(buffer.data() + 7, "ttachmentid"_span)) {
                                        return NodeName::webkitattachmentidAttr;
                                    }
                                    break;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'r': {
                if (WTF::equal(buffer.data() + 2, "itingsuggestions"_span)) {
                    return NodeName::writingsuggestionsAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 19: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "ttributionsourceid"_span)) {
                return NodeName::attributionsourceidAttr;
            }
            break;
        }
        case 'c': {
            if (WTF::equal(buffer.data() + 1, "olor-interpolation"_span)) {
                return NodeName::color_interpolationAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    if (WTF::equal(buffer.data() + 3, "utocompleteerror"_span)) {
                        return NodeName::onautocompleteerrorAttr;
                    }
                    break;
                }
                case 'g': {
                    if (WTF::equal(buffer.data() + 3, "otpointercapture"_span)) {
                        return NodeName::ongotpointercaptureAttr;
                    }
                    break;
                }
                case 'o': {
                    if (WTF::equal(buffer.data() + 3, "rientationchange"_span)) {
                        return NodeName::onorientationchangeAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                if (WTF::equal(buffer.data() + 2, "tternContentUnits"_span)) {
                    return NodeName::patternContentUnitsAttr;
                }
                break;
            }
            case 'o': {
                if (WTF::equal(buffer.data() + 2, "povertargetaction"_span)) {
                    return NodeName::popovertargetactionAttr;
                }
                break;
            }
            case 'r': {
                if (WTF::equal(buffer.data() + 2, "eserveAspectRatio"_span)) {
                    return NodeName::preserveAspectRatioAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 20: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'r': {
                switch (buffer[2]) {
                case 'i': {
                    switch (buffer[3]) {
                    case 'a': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'm': {
                                if (WTF::equal(buffer.data() + 6, "ultiselectable"_span)) {
                                    return NodeName::aria_multiselectableAttr;
                                }
                                break;
                            }
                            case 'r': {
                                if (WTF::equal(buffer.data() + 6, "oledescription"_span)) {
                                    return NodeName::aria_roledescriptionAttr;
                                }
                                break;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'u': {
                if (WTF::equal(buffer.data() + 2, "topictureinpicture"_span)) {
                    return NodeName::autopictureinpictureAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'a': {
                    if (WTF::equal(buffer.data() + 3, "nimationiteration"_span)) {
                        return NodeName::onanimationiterationAttr;
                    }
                    break;
                }
                case 'l': {
                    if (WTF::equal(buffer.data() + 3, "ostpointercapture"_span)) {
                        return NodeName::onlostpointercaptureAttr;
                    }
                    break;
                }
                case 'u': {
                    if (WTF::equal(buffer.data() + 3, "nhandledrejection"_span)) {
                        return NodeName::onunhandledrejectionAttr;
                    }
                    break;
                }
                case 'w': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'b': {
                            switch (buffer[5]) {
                            case 'k': {
                                switch (buffer[6]) {
                                case 'i': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'a': {
                                            if (WTF::equal(buffer.data() + 9, "nimationend"_span)) {
                                                return NodeName::onwebkitanimationendAttr;
                                            }
                                            break;
                                        }
                                        case 'm': {
                                            if (WTF::equal(buffer.data() + 9, "ouseforceup"_span)) {
                                                return NodeName::onwebkitmouseforceupAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'w': {
            if (WTF::equal(buffer.data() + 1, "ebkitattachmentpath"_span)) {
                return NodeName::webkitattachmentpathAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 21: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "ria-activedescendant"_span)) {
                return NodeName::aria_activedescendantAttr;
            }
            break;
        }
        case 'd': {
            if (WTF::equal(buffer.data() + 1, "isableremoteplayback"_span)) {
                return NodeName::disableremoteplaybackAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'g': {
                    if (WTF::equal(buffer.data() + 3, "amepaddisconnected"_span)) {
                        return NodeName::ongamepaddisconnectedAttr;
                    }
                    break;
                }
                case 'w': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'b': {
                            switch (buffer[5]) {
                            case 'k': {
                                switch (buffer[6]) {
                                case 'i': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'e': {
                                            if (WTF::equal(buffer.data() + 9, "ndfullscreen"_span)) {
                                                return NodeName::onwebkitendfullscreenAttr;
                                            }
                                            break;
                                        }
                                        case 't': {
                                            if (WTF::equal(buffer.data() + 9, "ransitionend"_span)) {
                                                return NodeName::onwebkittransitionendAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'w': {
            if (WTF::equal(buffer.data() + 1, "ebkitallowfullscreen"_span)) {
                return NodeName::webkitallowfullscreenAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 22: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 't': {
                switch (buffer[2]) {
                case 't': {
                    switch (buffer[3]) {
                    case 'r': {
                        switch (buffer[4]) {
                        case 'i': {
                            switch (buffer[5]) {
                            case 'b': {
                                switch (buffer[6]) {
                                case 'u': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'i': {
                                            switch (buffer[9]) {
                                            case 'o': {
                                                switch (buffer[10]) {
                                                case 'n': {
                                                    switch (buffer[11]) {
                                                    case 'd': {
                                                        if (WTF::equal(buffer.data() + 12, "estination"_span)) {
                                                            return NodeName::attributiondestinationAttr;
                                                        }
                                                        break;
                                                    }
                                                    case 's': {
                                                        if (WTF::equal(buffer.data() + 12, "ourcenonce"_span)) {
                                                            return NodeName::attributionsourcenonceAttr;
                                                        }
                                                        break;
                                                    }
                                                    default:
                                                        break;
                                                    }
                                                    return NodeName::Unknown;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'w': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'b': {
                            switch (buffer[5]) {
                            case 'k': {
                                switch (buffer[6]) {
                                case 'i': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'a': {
                                            if (WTF::equal(buffer.data() + 9, "nimationstart"_span)) {
                                                return NodeName::onwebkitanimationstartAttr;
                                            }
                                            break;
                                        }
                                        case 'm': {
                                            if (WTF::equal(buffer.data() + 9, "ouseforcedown"_span)) {
                                                return NodeName::onwebkitmouseforcedownAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            if (WTF::equal(buffer.data() + 1, "hadowrootserializable"_span)) {
                return NodeName::shadowrootserializableAttr;
            }
            break;
        }
        case 'x': {
            switch (buffer[1]) {
            case '-': {
                switch (buffer[2]) {
                case 'a': {
                    switch (buffer[3]) {
                    case 'p': {
                        switch (buffer[4]) {
                        case 'p': {
                            switch (buffer[5]) {
                            case 'l': {
                                switch (buffer[6]) {
                                case 'e': {
                                    switch (buffer[7]) {
                                    case '-': {
                                        switch (buffer[8]) {
                                        case 'd': {
                                            if (WTF::equal(buffer.data() + 9, "ata-detectors"_span)) {
                                                return NodeName::x_apple_data_detectorsAttr;
                                            }
                                            break;
                                        }
                                        case 'p': {
                                            if (WTF::equal(buffer.data() + 9, "df-annotation"_span)) {
                                                return NodeName::x_apple_pdf_annotationAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 23: {
        switch (buffer[0]) {
        case 'd': {
            if (WTF::equal(buffer.data() + 1, "isablepictureinpicture"_span)) {
                return NodeName::disablepictureinpictureAttr;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 'w': {
                    switch (buffer[3]) {
                    case 'e': {
                        switch (buffer[4]) {
                        case 'b': {
                            switch (buffer[5]) {
                            case 'k': {
                                switch (buffer[6]) {
                                case 'i': {
                                    switch (buffer[7]) {
                                    case 't': {
                                        switch (buffer[8]) {
                                        case 'b': {
                                            if (WTF::equal(buffer.data() + 9, "eginfullscreen"_span)) {
                                                return NodeName::onwebkitbeginfullscreenAttr;
                                            }
                                            break;
                                        }
                                        case 'f': {
                                            if (WTF::equal(buffer.data() + 9, "ullscreenerror"_span)) {
                                                return NodeName::onwebkitfullscreenerrorAttr;
                                            }
                                            break;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'w': {
            if (WTF::equal(buffer.data() + 1, "ebkitattachmentbloburl"_span)) {
                return NodeName::webkitattachmentbloburlAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 24: {
        switch (buffer[0]) {
        case 'o': {
            if (WTF::equal(buffer.data() + 1, "nwebkitfullscreenchange"_span)) {
                return NodeName::onwebkitfullscreenchangeAttr;
            }
            break;
        }
        case 's': {
            if (WTF::equal(buffer.data() + 1, "hadowrootdelegatesfocus"_span)) {
                return NodeName::shadowrootdelegatesfocusAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 25: {
        switch (buffer[0]) {
        case 'o': {
            switch (buffer[1]) {
            case 'n': {
                switch (buffer[2]) {
                case 's': {
                    if (WTF::equal(buffer.data() + 3, "ecuritypolicyviolation"_span)) {
                        return NodeName::onsecuritypolicyviolationAttr;
                    }
                    break;
                }
                case 'w': {
                    if (WTF::equal(buffer.data() + 3, "ebkitmouseforcechanged"_span)) {
                        return NodeName::onwebkitmouseforcechangedAttr;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 26: {
        switch (buffer[0]) {
        case 'g': {
            if (WTF::equal(buffer.data() + 1, "lyph-orientation-vertical"_span)) {
                return NodeName::glyph_orientation_verticalAttr;
            }
            break;
        }
        case 'o': {
            if (WTF::equal(buffer.data() + 1, "nwebkitanimationiteration"_span)) {
                return NodeName::onwebkitanimationiterationAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 27: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "ria-brailleroledescription"_span)) {
                return NodeName::aria_brailleroledescriptionAttr;
            }
            break;
        }
        case 'c': {
            if (WTF::equal(buffer.data() + 1, "olor-interpolation-filters"_span)) {
                return NodeName::color_interpolation_filtersAttr;
            }
            break;
        }
        case 'o': {
            if (WTF::equal(buffer.data() + 1, "nwebkitmouseforcewillbegin"_span)) {
                return NodeName::onwebkitmouseforcewillbeginAttr;
            }
            break;
        }
        case 'x': {
            if (WTF::equal(buffer.data() + 1, "-apple-data-detectors-type"_span)) {
                return NodeName::x_apple_data_detectors_typeAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 28: {
        if (WTF::equal(buffer.data(), "glyph-orientation-horizontal"_span)) {
            return NodeName::glyph_orientation_horizontalAttr;
        }
        break;
    }
    case 29: {
        if (WTF::equal(buffer.data(), "x-apple-data-detectors-result"_span)) {
            return NodeName::x_apple_data_detectors_resultAttr;
        }
        break;
    }
    case 31: {
        if (WTF::equal(buffer.data(), "onwebkitpresentationmodechanged"_span)) {
            return NodeName::onwebkitpresentationmodechangedAttr;
        }
        break;
    }
    case 34: {
        if (WTF::equal(buffer.data(), "oncontentvisibilityautostatechange"_span)) {
            return NodeName::oncontentvisibilityautostatechangeAttr;
        }
        break;
    }
    case 36: {
        if (WTF::equal(buffer.data(), "x-itunes-inherit-uri-query-component"_span)) {
            return NodeName::x_itunes_inherit_uri_query_componentAttr;
        }
        break;
    }
    case 38: {
        if (WTF::equal(buffer.data(), "x-webkit-wirelessvideoplaybackdisabled"_span)) {
            return NodeName::webkitwirelessvideoplaybackdisabledAttr;
        }
        break;
    }
    case 41: {
        if (WTF::equal(buffer.data(), "onwebkitplaybacktargetavailabilitychanged"_span)) {
            return NodeName::onwebkitplaybacktargetavailabilitychangedAttr;
        }
        break;
    }
    case 46: {
        if (WTF::equal(buffer.data(), "onwebkitcurrentplaybacktargetiswirelesschanged"_span)) {
            return NodeName::onwebkitcurrentplaybacktargetiswirelesschangedAttr;
        }
        break;
    }
    default:
        break;
    };
    return NodeName::Unknown;
}

template <typename characterType>
static inline NodeName findHTMLNodeName(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 1: {
        switch (buffer[0]) {
        case 'a': {
            return NodeName::HTML_a;
        }
        case 'b': {
            return NodeName::HTML_b;
        }
        case 'i': {
            return NodeName::HTML_i;
        }
        case 'p': {
            return NodeName::HTML_p;
        }
        case 'q': {
            return NodeName::HTML_q;
        }
        case 's': {
            return NodeName::HTML_s;
        }
        case 'u': {
            return NodeName::HTML_u;
        }
        default:
            break;
        }
        break;
    }
    case 2: {
        switch (buffer[0]) {
        case 'b': {
            if (buffer[1] == 'r') {
                return NodeName::HTML_br;
            }
            break;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'd': {
                return NodeName::HTML_dd;
            }
            case 'l': {
                return NodeName::HTML_dl;
            }
            case 't': {
                return NodeName::HTML_dt;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            if (buffer[1] == 'm') {
                return NodeName::HTML_em;
            }
            break;
        }
        case 'h': {
            switch (buffer[1]) {
            case '1': {
                return NodeName::HTML_h1;
            }
            case '2': {
                return NodeName::HTML_h2;
            }
            case '3': {
                return NodeName::HTML_h3;
            }
            case '4': {
                return NodeName::HTML_h4;
            }
            case '5': {
                return NodeName::HTML_h5;
            }
            case '6': {
                return NodeName::HTML_h6;
            }
            case 'r': {
                return NodeName::HTML_hr;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            if (buffer[1] == 'i') {
                return NodeName::HTML_li;
            }
            break;
        }
        case 'o': {
            if (buffer[1] == 'l') {
                return NodeName::HTML_ol;
            }
            break;
        }
        case 'r': {
            switch (buffer[1]) {
            case 'b': {
                return NodeName::HTML_rb;
            }
            case 'p': {
                return NodeName::HTML_rp;
            }
            case 't': {
                return NodeName::HTML_rt;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'd': {
                return NodeName::HTML_td;
            }
            case 'h': {
                return NodeName::HTML_th;
            }
            case 'r': {
                return NodeName::HTML_tr;
            }
            case 't': {
                return NodeName::HTML_tt;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'u': {
            if (buffer[1] == 'l') {
                return NodeName::HTML_ul;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 3: {
        switch (buffer[0]) {
        case 'b': {
            switch (buffer[1]) {
            case 'd': {
                switch (buffer[2]) {
                case 'i': {
                    return NodeName::HTML_bdi;
                }
                case 'o': {
                    return NodeName::HTML_bdo;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'i': {
                if (buffer[2] == 'g') {
                    return NodeName::HTML_big;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'c': {
            if (compareCharacters(buffer.data() + 1, 'o', 'l')) {
                return NodeName::HTML_col;
            }
            break;
        }
        case 'd': {
            switch (buffer[1]) {
            case 'e': {
                if (buffer[2] == 'l') {
                    return NodeName::HTML_del;
                }
                break;
            }
            case 'f': {
                if (buffer[2] == 'n') {
                    return NodeName::HTML_dfn;
                }
                break;
            }
            case 'i': {
                switch (buffer[2]) {
                case 'r': {
                    return NodeName::HTML_dir;
                }
                case 'v': {
                    return NodeName::HTML_div;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'm': {
                if (buffer[2] == 'g') {
                    return NodeName::HTML_img;
                }
                break;
            }
            case 'n': {
                if (buffer[2] == 's') {
                    return NodeName::HTML_ins;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'k': {
            if (compareCharacters(buffer.data() + 1, 'b', 'd')) {
                return NodeName::HTML_kbd;
            }
            break;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 'a', 'p')) {
                return NodeName::HTML_map;
            }
            break;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'a', 'v')) {
                return NodeName::HTML_nav;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'r', 'e')) {
                return NodeName::HTML_pre;
            }
            break;
        }
        case 'r': {
            if (compareCharacters(buffer.data() + 1, 't', 'c')) {
                return NodeName::HTML_rtc;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'u': {
                switch (buffer[2]) {
                case 'b': {
                    return NodeName::HTML_sub;
                }
                case 'p': {
                    return NodeName::HTML_sup;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'v': {
            if (compareCharacters(buffer.data() + 1, 'a', 'r')) {
                return NodeName::HTML_var;
            }
            break;
        }
        case 'w': {
            if (compareCharacters(buffer.data() + 1, 'b', 'r')) {
                return NodeName::HTML_wbr;
            }
            break;
        }
        case 'x': {
            if (compareCharacters(buffer.data() + 1, 'm', 'p')) {
                return NodeName::HTML_xmp;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 4: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'b', 'r')) {
                    return NodeName::HTML_abbr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'e', 'a')) {
                    return NodeName::HTML_area;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 's', 'e')) {
                    return NodeName::HTML_base;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'd', 'y')) {
                    return NodeName::HTML_body;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 't', 'e')) {
                    return NodeName::HTML_cite;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'd', 'e')) {
                    return NodeName::HTML_code;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'a', 't', 'a')) {
                return NodeName::HTML_data;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    if (buffer[3] == 't') {
                        return NodeName::HTML_font;
                    }
                    break;
                }
                case 'r': {
                    if (buffer[3] == 'm') {
                        return NodeName::HTML_form;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'a', 'd')) {
                    return NodeName::HTML_head;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'm', 'l')) {
                    return NodeName::HTML_html;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'i', 'n', 'k')) {
                return NodeName::HTML_link;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                switch (buffer[2]) {
                case 'i': {
                    if (buffer[3] == 'n') {
                        return NodeName::HTML_main;
                    }
                    break;
                }
                case 'r': {
                    if (buffer[3] == 'k') {
                        return NodeName::HTML_mark;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'n': {
                    if (buffer[3] == 'u') {
                        return NodeName::HTML_menu;
                    }
                    break;
                }
                case 't': {
                    if (buffer[3] == 'a') {
                        return NodeName::HTML_meta;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'o', 'b', 'r')) {
                return NodeName::HTML_nobr;
            }
            break;
        }
        case 'r': {
            if (compareCharacters(buffer.data() + 1, 'u', 'b', 'y')) {
                return NodeName::HTML_ruby;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'm', 'p')) {
                    return NodeName::HTML_samp;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'o', 't')) {
                    return NodeName::HTML_slot;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'a', 'n')) {
                    return NodeName::HTML_span;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            if (compareCharacters(buffer.data() + 1, 'i', 'm', 'e')) {
                return NodeName::HTML_time;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 5: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'i', 'd', 'e')) {
                    return NodeName::HTML_aside;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'd', 'i', 'o')) {
                    return NodeName::HTML_audio;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'm', 'b', 'e', 'd')) {
                return NodeName::HTML_embed;
            }
            break;
        }
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'r', 'a', 'm', 'e')) {
                return NodeName::HTML_frame;
            }
            break;
        }
        case 'i': {
            switch (buffer[1]) {
            case 'm': {
                if (compareCharacters(buffer.data() + 2, 'a', 'g', 'e')) {
                    return NodeName::HTML_image;
                }
                break;
            }
            case 'n': {
                if (compareCharacters(buffer.data() + 2, 'p', 'u', 't')) {
                    return NodeName::HTML_input;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'a', 'b', 'e', 'l')) {
                return NodeName::HTML_label;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 't', 'e', 'r')) {
                    return NodeName::HTML_meter;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'd', 'e', 'l')) {
                    return NodeName::HTML_model;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'a', 'r', 'a', 'm')) {
                return NodeName::HTML_param;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'm': {
                if (compareCharacters(buffer.data() + 2, 'a', 'l', 'l')) {
                    return NodeName::HTML_small;
                }
                break;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'y', 'l', 'e')) {
                    return NodeName::HTML_style;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 't': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'b', 'l', 'e')) {
                    return NodeName::HTML_table;
                }
                break;
            }
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'o', 'd', 'y')) {
                    return NodeName::HTML_tbody;
                }
                break;
            }
            case 'f': {
                if (compareCharacters(buffer.data() + 2, 'o', 'o', 't')) {
                    return NodeName::HTML_tfoot;
                }
                break;
            }
            case 'h': {
                if (compareCharacters(buffer.data() + 2, 'e', 'a', 'd')) {
                    return NodeName::HTML_thead;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 't', 'l', 'e')) {
                    return NodeName::HTML_title;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'a', 'c', 'k')) {
                    return NodeName::HTML_track;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'v': {
            if (compareCharacters(buffer.data() + 1, 'i', 'd', 'e', 'o')) {
                return NodeName::HTML_video;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 6: {
        switch (buffer[0]) {
        case 'a': {
            if (compareCharacters(buffer.data() + 1, 'p', 'p', 'l', 'e', 't')) {
                return NodeName::HTML_applet;
            }
            break;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'u', 't', 't', 'o', 'n')) {
                return NodeName::HTML_button;
            }
            break;
        }
        case 'c': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'n', 'v', 'a', 's')) {
                    return NodeName::HTML_canvas;
                }
                break;
            }
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'n', 't', 'e', 'r')) {
                    return NodeName::HTML_center;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'i', 'a', 'l', 'o', 'g')) {
                return NodeName::HTML_dialog;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'g', 'u', 'r', 'e')) {
                    return NodeName::HTML_figure;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'o', 't', 'e', 'r')) {
                    return NodeName::HTML_footer;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'h': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'a', 'd', 'e', 'r')) {
                    return NodeName::HTML_header;
                }
                break;
            }
            case 'g': {
                if (compareCharacters(buffer.data() + 2, 'r', 'o', 'u', 'p')) {
                    return NodeName::HTML_hgroup;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'i': {
            if (compareCharacters(buffer.data() + 1, 'f', 'r', 'a', 'm', 'e')) {
                return NodeName::HTML_iframe;
            }
            break;
        }
        case 'k': {
            if (compareCharacters(buffer.data() + 1, 'e', 'y', 'g', 'e', 'n')) {
                return NodeName::HTML_keygen;
            }
            break;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'e', 'g', 'e', 'n', 'd')) {
                return NodeName::HTML_legend;
            }
            break;
        }
        case 'o': {
            switch (buffer[1]) {
            case 'b': {
                if (compareCharacters(buffer.data() + 2, 'j', 'e', 'c', 't')) {
                    return NodeName::HTML_object;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 't', 'i', 'o', 'n')) {
                    return NodeName::HTML_option;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 't', 'p', 'u', 't')) {
                    return NodeName::HTML_output;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'r', 'i', 'p', 't')) {
                    return NodeName::HTML_script;
                }
                break;
            }
            case 'e': {
                switch (buffer[2]) {
                case 'a': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'c', 'h')) {
                        return NodeName::HTML_search;
                    }
                    break;
                }
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'c', 't')) {
                        return NodeName::HTML_select;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'u', 'r', 'c', 'e')) {
                    return NodeName::HTML_source;
                }
                break;
            }
            case 't': {
                switch (buffer[2]) {
                case 'r': {
                    switch (buffer[3]) {
                    case 'i': {
                        if (compareCharacters(buffer.data() + 4, 'k', 'e')) {
                            return NodeName::HTML_strike;
                        }
                        break;
                    }
                    case 'o': {
                        if (compareCharacters(buffer.data() + 4, 'n', 'g')) {
                            return NodeName::HTML_strong;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 7: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'r', 'o', 'n', 'y', 'm')) {
                    return NodeName::HTML_acronym;
                }
                break;
            }
            case 'd': {
                if (compareCharacters(buffer.data() + 2, 'd', 'r', 'e', 's', 's')) {
                    return NodeName::HTML_address;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 't', 'i', 'c', 'l', 'e')) {
                    return NodeName::HTML_article;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'g', 's', 'o', 'u', 'n', 'd')) {
                return NodeName::HTML_bgsound;
            }
            break;
        }
        case 'c': {
            if (compareCharacters(buffer.data() + 1, 'a', 'p', 't', 'i', 'o', 'n')) {
                return NodeName::HTML_caption;
            }
            break;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'e', 't', 'a', 'i', 'l', 's')) {
                return NodeName::HTML_details;
            }
            break;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'i', 's', 't', 'i', 'n', 'g')) {
                return NodeName::HTML_listing;
            }
            break;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 'a', 'r', 'q', 'u', 'e', 'e')) {
                return NodeName::HTML_marquee;
            }
            break;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'o', 'e', 'm', 'b', 'e', 'd')) {
                return NodeName::HTML_noembed;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'i', 'c', 't', 'u', 'r', 'e')) {
                return NodeName::HTML_picture;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'c', 't', 'i', 'o', 'n')) {
                    return NodeName::HTML_section;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'm', 'm', 'a', 'r', 'y')) {
                    return NodeName::HTML_summary;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 8: {
        switch (buffer[0]) {
        case 'b': {
            if (compareCharacters(buffer.data() + 1, 'a', 's', 'e', 'f', 'o', 'n', 't')) {
                return NodeName::HTML_basefont;
            }
            break;
        }
        case 'c': {
            if (compareCharacters(buffer.data() + 1, 'o', 'l', 'g', 'r', 'o', 'u', 'p')) {
                return NodeName::HTML_colgroup;
            }
            break;
        }
        case 'd': {
            if (compareCharacters(buffer.data() + 1, 'a', 't', 'a', 'l', 'i', 's', 't')) {
                return NodeName::HTML_datalist;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'e', 'l', 'd', 's', 'e', 't')) {
                    return NodeName::HTML_fieldset;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'a', 'm', 'e', 's', 'e', 't')) {
                    return NodeName::HTML_frameset;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'f': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'a', 'm', 'e', 's')) {
                        return NodeName::HTML_noframes;
                    }
                    break;
                }
                case 's': {
                    if (compareCharacters(buffer.data() + 3, 'c', 'r', 'i', 'p', 't')) {
                        return NodeName::HTML_noscript;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'o': {
            if (compareCharacters(buffer.data() + 1, 'p', 't', 'g', 'r', 'o', 'u', 'p')) {
                return NodeName::HTML_optgroup;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'r', 'o', 'g', 'r', 'e', 's', 's')) {
                return NodeName::HTML_progress;
            }
            break;
        }
        case 't': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'm': {
                    if (compareCharacters(buffer.data() + 3, 'p', 'l', 'a', 't', 'e')) {
                        return NodeName::HTML_template;
                    }
                    break;
                }
                case 'x': {
                    if (compareCharacters(buffer.data() + 3, 't', 'a', 'r', 'e', 'a')) {
                        return NodeName::HTML_textarea;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 9: {
        switch (buffer[0]) {
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'o', 'n', 't', '-', 'f', 'a', 'c', 'e')) {
                return NodeName::HTML_font_face;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'l', 'a', 'i', 'n', 't', 'e', 'x', 't')) {
                return NodeName::HTML_plaintext;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 10: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "ttachment"_span)) {
                return NodeName::HTML_attachment;
            }
            break;
        }
        case 'b': {
            if (WTF::equal(buffer.data() + 1, "lockquote"_span)) {
                return NodeName::HTML_blockquote;
            }
            break;
        }
        case 'f': {
            if (WTF::equal(buffer.data() + 1, "igcaption"_span)) {
                return NodeName::HTML_figcaption;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 13: {
        switch (buffer[0]) {
        case 'c': {
            if (WTF::equal(buffer.data() + 1, "olor-profile"_span)) {
                return NodeName::HTML_color_profile;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'f': {
                                switch (buffer[6]) {
                                case 'a': {
                                    switch (buffer[7]) {
                                    case 'c': {
                                        switch (buffer[8]) {
                                        case 'e': {
                                            switch (buffer[9]) {
                                            case '-': {
                                                switch (buffer[10]) {
                                                case 's': {
                                                    if (compareCharacters(buffer.data() + 11, 'r', 'c')) {
                                                        return NodeName::HTML_font_face_src;
                                                    }
                                                    break;
                                                }
                                                case 'u': {
                                                    if (compareCharacters(buffer.data() + 11, 'r', 'i')) {
                                                        return NodeName::HTML_font_face_uri;
                                                    }
                                                    break;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            if (WTF::equal(buffer.data() + 1, "issing-glyph"_span)) {
                return NodeName::HTML_missing_glyph;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 14: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "nnotation-xml"_span)) {
                return NodeName::HTML_annotation_xml;
            }
            break;
        }
        case 'f': {
            if (WTF::equal(buffer.data() + 1, "ont-face-name"_span)) {
                return NodeName::HTML_font_face_name;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 16: {
        if (WTF::equal(buffer.data(), "font-face-format"_span)) {
            return NodeName::HTML_font_face_format;
        }
        break;
    }
    default:
        break;
    };
    return NodeName::Unknown;
}

template <typename characterType>
static inline NodeName findMathMLNodeName(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 2: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 'i': {
                return NodeName::MathML_mi;
            }
            case 'n': {
                return NodeName::MathML_mn;
            }
            case 'o': {
                return NodeName::MathML_mo;
            }
            case 's': {
                return NodeName::MathML_ms;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 3: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 't': {
                switch (buffer[2]) {
                case 'd': {
                    return NodeName::MathML_mtd;
                }
                case 'r': {
                    return NodeName::MathML_mtr;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 4: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 't', 'h')) {
                    return NodeName::MathML_math;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'w')) {
                    return NodeName::MathML_mrow;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'u': {
                    switch (buffer[3]) {
                    case 'b': {
                        return NodeName::MathML_msub;
                    }
                    case 'p': {
                        return NodeName::MathML_msup;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'n': {
            if (compareCharacters(buffer.data() + 1, 'o', 'n', 'e')) {
                return NodeName::MathML_none;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 5: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 'f': {
                if (compareCharacters(buffer.data() + 2, 'r', 'a', 'c')) {
                    return NodeName::MathML_mfrac;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'v', 'e', 'r')) {
                    return NodeName::MathML_mover;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'o', 'o', 't')) {
                    return NodeName::MathML_mroot;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'q': {
                    if (compareCharacters(buffer.data() + 3, 'r', 't')) {
                        return NodeName::MathML_msqrt;
                    }
                    break;
                }
                case 'r': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'w')) {
                        return NodeName::MathML_msrow;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'e', 'x', 't')) {
                    return NodeName::MathML_mtext;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 6: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'r', 'r', 'o', 'r')) {
                    return NodeName::MathML_merror;
                }
                break;
            }
            case 'g': {
                if (compareCharacters(buffer.data() + 2, 'l', 'y', 'p', 'h')) {
                    return NodeName::MathML_mglyph;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'l': {
                    if (compareCharacters(buffer.data() + 3, 'i', 'n', 'e')) {
                        return NodeName::MathML_msline;
                    }
                    break;
                }
                case 'p': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'c', 'e')) {
                        return NodeName::MathML_mspace;
                    }
                    break;
                }
                case 't': {
                    switch (buffer[3]) {
                    case 'a': {
                        if (compareCharacters(buffer.data() + 4, 'c', 'k')) {
                            return NodeName::MathML_mstack;
                        }
                        break;
                    }
                    case 'y': {
                        if (compareCharacters(buffer.data() + 4, 'l', 'e')) {
                            return NodeName::MathML_mstyle;
                        }
                        break;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 't': {
                if (compareCharacters(buffer.data() + 2, 'a', 'b', 'l', 'e')) {
                    return NodeName::MathML_mtable;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'n', 'd', 'e', 'r')) {
                    return NodeName::MathML_munder;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 7: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'c', 't', 'i', 'o', 'n')) {
                    return NodeName::MathML_maction;
                }
                break;
            }
            case 'f': {
                if (compareCharacters(buffer.data() + 2, 'e', 'n', 'c', 'e', 'd')) {
                    return NodeName::MathML_mfenced;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'a', 'd', 'd', 'e', 'd')) {
                    return NodeName::MathML_mpadded;
                }
                break;
            }
            case 's': {
                switch (buffer[2]) {
                case 'c': {
                    if (compareCharacters(buffer.data() + 3, 'a', 'r', 'r', 'y')) {
                        return NodeName::MathML_mscarry;
                    }
                    break;
                }
                case 'g': {
                    if (compareCharacters(buffer.data() + 3, 'r', 'o', 'u', 'p')) {
                        return NodeName::MathML_msgroup;
                    }
                    break;
                }
                case 'u': {
                    if (compareCharacters(buffer.data() + 3, 'b', 's', 'u', 'p')) {
                        return NodeName::MathML_msubsup;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 8: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'n', 'c', 'l', 'o', 's', 'e')) {
                    return NodeName::MathML_menclose;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'o', 'n', 'g', 'd', 'i', 'v')) {
                    return NodeName::MathML_mlongdiv;
                }
                break;
            }
            case 'p': {
                if (compareCharacters(buffer.data() + 2, 'h', 'a', 'n', 't', 'o', 'm')) {
                    return NodeName::MathML_mphantom;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 9: {
        switch (buffer[0]) {
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 's', 'c', 'a', 'r', 'r', 'i', 'e', 's')) {
                return NodeName::MathML_mscarries;
            }
            break;
        }
        case 's': {
            if (compareCharacters(buffer.data() + 1, 'e', 'm', 'a', 'n', 't', 'i', 'c', 's')) {
                return NodeName::MathML_semantics;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 10: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "nnotation"_span)) {
                return NodeName::MathML_annotation;
            }
            break;
        }
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 'l', 'i', 'g', 'n', 'm', 'a', 'r', 'k')) {
                    return NodeName::MathML_malignmark;
                }
                break;
            }
            case 'l': {
                if (compareCharacters(buffer.data() + 2, 'a', 'b', 'e', 'l', 'e', 'd', 't', 'r')) {
                    return NodeName::MathML_mlabeledtr;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'n', 'd', 'e', 'r', 'o', 'v', 'e', 'r')) {
                    return NodeName::MathML_munderover;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 11: {
        switch (buffer[0]) {
        case 'm': {
            switch (buffer[1]) {
            case 'a': {
                if (WTF::equal(buffer.data() + 2, "ligngroup"_span)) {
                    return NodeName::MathML_maligngroup;
                }
                break;
            }
            case 'p': {
                if (WTF::equal(buffer.data() + 2, "rescripts"_span)) {
                    return NodeName::MathML_mprescripts;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 13: {
        if (WTF::equal(buffer.data(), "mmultiscripts"_span)) {
            return NodeName::MathML_mmultiscripts;
        }
        break;
    }
    case 14: {
        if (WTF::equal(buffer.data(), "annotation-xml"_span)) {
            return NodeName::MathML_annotation_xml;
        }
        break;
    }
    default:
        break;
    };
    return NodeName::Unknown;
}

template <typename characterType>
static inline NodeName findSVGNodeName(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 1: {
        switch (buffer[0]) {
        case 'a': {
            return NodeName::SVG_a;
        }
        case 'g': {
            return NodeName::SVG_g;
        }
        default:
            break;
        }
        break;
    }
    case 3: {
        switch (buffer[0]) {
        case 's': {
            switch (buffer[1]) {
            case 'e': {
                if (buffer[2] == 't') {
                    return NodeName::SVG_set;
                }
                break;
            }
            case 'v': {
                if (buffer[2] == 'g') {
                    return NodeName::SVG_svg;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'u': {
            if (compareCharacters(buffer.data() + 1, 's', 'e')) {
                return NodeName::SVG_use;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 4: {
        switch (buffer[0]) {
        case 'd': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'f': {
                    if (buffer[3] == 's') {
                        return NodeName::SVG_defs;
                    }
                    break;
                }
                case 's': {
                    if (buffer[3] == 'c') {
                        return NodeName::SVG_desc;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'o', 'n', 't')) {
                return NodeName::SVG_font;
            }
            break;
        }
        case 'l': {
            if (compareCharacters(buffer.data() + 1, 'i', 'n', 'e')) {
                return NodeName::SVG_line;
            }
            break;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 'a', 's', 'k')) {
                return NodeName::SVG_mask;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'a', 't', 'h')) {
                return NodeName::SVG_path;
            }
            break;
        }
        case 'r': {
            if (compareCharacters(buffer.data() + 1, 'e', 'c', 't')) {
                return NodeName::SVG_rect;
            }
            break;
        }
        case 's': {
            if (compareCharacters(buffer.data() + 1, 't', 'o', 'p')) {
                return NodeName::SVG_stop;
            }
            break;
        }
        case 't': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'x', 't')) {
                    return NodeName::SVG_text;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'e', 'f')) {
                    return NodeName::SVG_tref;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'v': {
            if (compareCharacters(buffer.data() + 1, 'i', 'e', 'w')) {
                return NodeName::SVG_view;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 5: {
        switch (buffer[0]) {
        case 'g': {
            if (compareCharacters(buffer.data() + 1, 'l', 'y', 'p', 'h')) {
                return NodeName::SVG_glyph;
            }
            break;
        }
        case 'h': {
            if (compareCharacters(buffer.data() + 1, 'k', 'e', 'r', 'n')) {
                return NodeName::SVG_hkern;
            }
            break;
        }
        case 'i': {
            if (compareCharacters(buffer.data() + 1, 'm', 'a', 'g', 'e')) {
                return NodeName::SVG_image;
            }
            break;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 'p', 'a', 't', 'h')) {
                return NodeName::SVG_mpath;
            }
            break;
        }
        case 's': {
            if (compareCharacters(buffer.data() + 1, 't', 'y', 'l', 'e')) {
                return NodeName::SVG_style;
            }
            break;
        }
        case 't': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 't', 'l', 'e')) {
                    return NodeName::SVG_title;
                }
                break;
            }
            case 's': {
                if (compareCharacters(buffer.data() + 2, 'p', 'a', 'n')) {
                    return NodeName::SVG_tspan;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'v': {
            if (compareCharacters(buffer.data() + 1, 'k', 'e', 'r', 'n')) {
                return NodeName::SVG_vkern;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 6: {
        switch (buffer[0]) {
        case 'c': {
            switch (buffer[1]) {
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'r', 'c', 'l', 'e')) {
                    return NodeName::SVG_circle;
                }
                break;
            }
            case 'u': {
                if (compareCharacters(buffer.data() + 2, 'r', 's', 'o', 'r')) {
                    return NodeName::SVG_cursor;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                if (compareCharacters(buffer.data() + 2, 'T', 'i', 'l', 'e')) {
                    return NodeName::SVG_feTile;
                }
                break;
            }
            case 'i': {
                if (compareCharacters(buffer.data() + 2, 'l', 't', 'e', 'r')) {
                    return NodeName::SVG_filter;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 'a', 'r', 'k', 'e', 'r')) {
                return NodeName::SVG_marker;
            }
            break;
        }
        case 's': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 'r', 'i', 'p', 't')) {
                    return NodeName::SVG_script;
                }
                break;
            }
            case 'w': {
                if (compareCharacters(buffer.data() + 2, 'i', 't', 'c', 'h')) {
                    return NodeName::SVG_switch;
                }
                break;
            }
            case 'y': {
                if (compareCharacters(buffer.data() + 2, 'm', 'b', 'o', 'l')) {
                    return NodeName::SVG_symbol;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 7: {
        switch (buffer[0]) {
        case 'a': {
            if (compareCharacters(buffer.data() + 1, 'n', 'i', 'm', 'a', 't', 'e')) {
                return NodeName::SVG_animate;
            }
            break;
        }
        case 'e': {
            if (compareCharacters(buffer.data() + 1, 'l', 'l', 'i', 'p', 's', 'e')) {
                return NodeName::SVG_ellipse;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'B': {
                    if (compareCharacters(buffer.data() + 3, 'l', 'e', 'n', 'd')) {
                        return NodeName::SVG_feBlend;
                    }
                    break;
                }
                case 'F': {
                    switch (buffer[3]) {
                    case 'l': {
                        if (compareCharacters(buffer.data() + 4, 'o', 'o', 'd')) {
                            return NodeName::SVG_feFlood;
                        }
                        break;
                    }
                    case 'u': {
                        switch (buffer[4]) {
                        case 'n': {
                            switch (buffer[5]) {
                            case 'c': {
                                switch (buffer[6]) {
                                case 'A': {
                                    return NodeName::SVG_feFuncA;
                                }
                                case 'B': {
                                    return NodeName::SVG_feFuncB;
                                }
                                case 'G': {
                                    return NodeName::SVG_feFuncG;
                                }
                                case 'R': {
                                    return NodeName::SVG_feFuncR;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'I': {
                    if (compareCharacters(buffer.data() + 3, 'm', 'a', 'g', 'e')) {
                        return NodeName::SVG_feImage;
                    }
                    break;
                }
                case 'M': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r', 'g', 'e')) {
                        return NodeName::SVG_feMerge;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'p': {
            switch (buffer[1]) {
            case 'a': {
                if (compareCharacters(buffer.data() + 2, 't', 't', 'e', 'r', 'n')) {
                    return NodeName::SVG_pattern;
                }
                break;
            }
            case 'o': {
                if (compareCharacters(buffer.data() + 2, 'l', 'y', 'g', 'o', 'n')) {
                    return NodeName::SVG_polygon;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 8: {
        switch (buffer[0]) {
        case 'a': {
            if (compareCharacters(buffer.data() + 1, 'l', 't', 'G', 'l', 'y', 'p', 'h')) {
                return NodeName::SVG_altGlyph;
            }
            break;
        }
        case 'c': {
            if (compareCharacters(buffer.data() + 1, 'l', 'i', 'p', 'P', 'a', 't', 'h')) {
                return NodeName::SVG_clipPath;
            }
            break;
        }
        case 'f': {
            if (compareCharacters(buffer.data() + 1, 'e', 'O', 'f', 'f', 's', 'e', 't')) {
                return NodeName::SVG_feOffset;
            }
            break;
        }
        case 'g': {
            if (compareCharacters(buffer.data() + 1, 'l', 'y', 'p', 'h', 'R', 'e', 'f')) {
                return NodeName::SVG_glyphRef;
            }
            break;
        }
        case 'm': {
            if (compareCharacters(buffer.data() + 1, 'e', 't', 'a', 'd', 'a', 't', 'a')) {
                return NodeName::SVG_metadata;
            }
            break;
        }
        case 'p': {
            if (compareCharacters(buffer.data() + 1, 'o', 'l', 'y', 'l', 'i', 'n', 'e')) {
                return NodeName::SVG_polyline;
            }
            break;
        }
        case 't': {
            if (compareCharacters(buffer.data() + 1, 'e', 'x', 't', 'P', 'a', 't', 'h')) {
                return NodeName::SVG_textPath;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 9: {
        if (WTF::equal(buffer.data(), "font-face"_span)) {
            return NodeName::SVG_font_face;
        }
        break;
    }
    case 11: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "ltGlyphDef"_span)) {
                return NodeName::SVG_altGlyphDef;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'C': {
                    if (compareCharacters(buffer.data() + 3, 'o', 'm', 'p', 'o', 's', 'i', 't', 'e')) {
                        return NodeName::SVG_feComposite;
                    }
                    break;
                }
                case 'M': {
                    if (compareCharacters(buffer.data() + 3, 'e', 'r', 'g', 'e', 'N', 'o', 'd', 'e')) {
                        return NodeName::SVG_feMergeNode;
                    }
                    break;
                }
                case 'S': {
                    if (compareCharacters(buffer.data() + 3, 'p', 'o', 't', 'L', 'i', 'g', 'h', 't')) {
                        return NodeName::SVG_feSpotLight;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 12: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'l': {
                if (WTF::equal(buffer.data() + 2, "tGlyphItem"_span)) {
                    return NodeName::SVG_altGlyphItem;
                }
                break;
            }
            case 'n': {
                if (WTF::equal(buffer.data() + 2, "imateColor"_span)) {
                    return NodeName::SVG_animateColor;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'D': {
                    if (WTF::equal(buffer.data() + 3, "ropShadow"_span)) {
                        return NodeName::SVG_feDropShadow;
                    }
                    break;
                }
                case 'M': {
                    if (WTF::equal(buffer.data() + 3, "orphology"_span)) {
                        return NodeName::SVG_feMorphology;
                    }
                    break;
                }
                case 'P': {
                    if (WTF::equal(buffer.data() + 3, "ointLight"_span)) {
                        return NodeName::SVG_fePointLight;
                    }
                    break;
                }
                case 'T': {
                    if (WTF::equal(buffer.data() + 3, "urbulence"_span)) {
                        return NodeName::SVG_feTurbulence;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 13: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "nimateMotion"_span)) {
                return NodeName::SVG_animateMotion;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                if (WTF::equal(buffer.data() + 2, "ColorMatrix"_span)) {
                    return NodeName::SVG_feColorMatrix;
                }
                break;
            }
            case 'o': {
                switch (buffer[2]) {
                case 'n': {
                    switch (buffer[3]) {
                    case 't': {
                        switch (buffer[4]) {
                        case '-': {
                            switch (buffer[5]) {
                            case 'f': {
                                switch (buffer[6]) {
                                case 'a': {
                                    switch (buffer[7]) {
                                    case 'c': {
                                        switch (buffer[8]) {
                                        case 'e': {
                                            switch (buffer[9]) {
                                            case '-': {
                                                switch (buffer[10]) {
                                                case 's': {
                                                    if (compareCharacters(buffer.data() + 11, 'r', 'c')) {
                                                        return NodeName::SVG_font_face_src;
                                                    }
                                                    break;
                                                }
                                                case 'u': {
                                                    if (compareCharacters(buffer.data() + 11, 'r', 'i')) {
                                                        return NodeName::SVG_font_face_uri;
                                                    }
                                                    break;
                                                }
                                                default:
                                                    break;
                                                }
                                                return NodeName::Unknown;
                                            }
                                            default:
                                                break;
                                            }
                                            return NodeName::Unknown;
                                        }
                                        default:
                                            break;
                                        }
                                        return NodeName::Unknown;
                                    }
                                    default:
                                        break;
                                    }
                                    return NodeName::Unknown;
                                }
                                default:
                                    break;
                                }
                                return NodeName::Unknown;
                            }
                            default:
                                break;
                            }
                            return NodeName::Unknown;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                case 'r': {
                    if (WTF::equal(buffer.data() + 3, "eignObject"_span)) {
                        return NodeName::SVG_foreignObject;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'm': {
            if (WTF::equal(buffer.data() + 1, "issing-glyph"_span)) {
                return NodeName::SVG_missing_glyph;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 14: {
        switch (buffer[0]) {
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'D': {
                    if (WTF::equal(buffer.data() + 3, "istantLight"_span)) {
                        return NodeName::SVG_feDistantLight;
                    }
                    break;
                }
                case 'G': {
                    if (WTF::equal(buffer.data() + 3, "aussianBlur"_span)) {
                        return NodeName::SVG_feGaussianBlur;
                    }
                    break;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            case 'o': {
                if (WTF::equal(buffer.data() + 2, "nt-face-name"_span)) {
                    return NodeName::SVG_font_face_name;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        case 'l': {
            if (WTF::equal(buffer.data() + 1, "inearGradient"_span)) {
                return NodeName::SVG_linearGradient;
            }
            break;
        }
        case 'r': {
            if (WTF::equal(buffer.data() + 1, "adialGradient"_span)) {
                return NodeName::SVG_radialGradient;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 16: {
        switch (buffer[0]) {
        case 'a': {
            if (WTF::equal(buffer.data() + 1, "nimateTransform"_span)) {
                return NodeName::SVG_animateTransform;
            }
            break;
        }
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                if (WTF::equal(buffer.data() + 2, "ConvolveMatrix"_span)) {
                    return NodeName::SVG_feConvolveMatrix;
                }
                break;
            }
            case 'o': {
                if (WTF::equal(buffer.data() + 2, "nt-face-format"_span)) {
                    return NodeName::SVG_font_face_format;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 17: {
        switch (buffer[0]) {
        case 'f': {
            switch (buffer[1]) {
            case 'e': {
                switch (buffer[2]) {
                case 'D': {
                    switch (buffer[3]) {
                    case 'i': {
                        switch (buffer[4]) {
                        case 'f': {
                            if (WTF::equal(buffer.data() + 5, "fuseLighting"_span)) {
                                return NodeName::SVG_feDiffuseLighting;
                            }
                            break;
                        }
                        case 's': {
                            if (WTF::equal(buffer.data() + 5, "placementMap"_span)) {
                                return NodeName::SVG_feDisplacementMap;
                            }
                            break;
                        }
                        default:
                            break;
                        }
                        return NodeName::Unknown;
                    }
                    default:
                        break;
                    }
                    return NodeName::Unknown;
                }
                default:
                    break;
                }
                return NodeName::Unknown;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    case 18: {
        if (WTF::equal(buffer.data(), "feSpecularLighting"_span)) {
            return NodeName::SVG_feSpecularLighting;
        }
        break;
    }
    case 19: {
        if (WTF::equal(buffer.data(), "feComponentTransfer"_span)) {
            return NodeName::SVG_feComponentTransfer;
        }
        break;
    }
    default:
        break;
    };
    return NodeName::Unknown;
}

template <typename characterType>
static inline NodeName findXLinkNodeName(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 4: {
        switch (buffer[0]) {
        case 'h': {
            if (compareCharacters(buffer.data() + 1, 'r', 'e', 'f')) {
                return NodeName::XLink_hrefAttr;
            }
            break;
        }
        case 'r': {
            if (compareCharacters(buffer.data() + 1, 'o', 'l', 'e')) {
                return NodeName::XLink_roleAttr;
            }
            break;
        }
        case 's': {
            if (compareCharacters(buffer.data() + 1, 'h', 'o', 'w')) {
                return NodeName::XLink_showAttr;
            }
            break;
        }
        case 't': {
            if (compareCharacters(buffer.data() + 1, 'y', 'p', 'e')) {
                return NodeName::XLink_typeAttr;
            }
            break;
        }
        default:
            break;
        }
        break;
    }
    case 5: {
        if (compareCharacters(buffer.data(), 't', 'i', 't', 'l', 'e')) {
            return NodeName::XLink_titleAttr;
        }
        break;
    }
    case 7: {
        switch (buffer[0]) {
        case 'a': {
            switch (buffer[1]) {
            case 'c': {
                if (compareCharacters(buffer.data() + 2, 't', 'u', 'a', 't', 'e')) {
                    return NodeName::XLink_actuateAttr;
                }
                break;
            }
            case 'r': {
                if (compareCharacters(buffer.data() + 2, 'c', 'r', 'o', 'l', 'e')) {
                    return NodeName::XLink_arcroleAttr;
                }
                break;
            }
            default:
                break;
            }
            return NodeName::Unknown;
        }
        default:
            break;
        }
        break;
    }
    default:
        break;
    };
    return NodeName::Unknown;
}

template <typename characterType>
static inline NodeName findXMLNodeName(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 4: {
        if (compareCharacters(buffer.data(), 'l', 'a', 'n', 'g')) {
            return NodeName::XML_langAttr;
        }
        break;
    }
    case 5: {
        if (compareCharacters(buffer.data(), 's', 'p', 'a', 'c', 'e')) {
            return NodeName::XML_spaceAttr;
        }
        break;
    }
    default:
        break;
    };
    return NodeName::Unknown;
}

template <typename characterType>
static inline NodeName findXMLNSNodeName(std::span<const characterType> buffer)
{
    switch (buffer.size()) {
    case 5: {
        if (compareCharacters(buffer.data(), 'x', 'm', 'l', 'n', 's')) {
            return NodeName::XMLNS_xmlnsAttr;
        }
        break;
    }
    default:
        break;
    };
    return NodeName::Unknown;
}

template <typename characterType>
static inline NodeName findNodeNameFromBuffer(Namespace ns, std::span<const characterType> buffer)
{
    switch (ns) {
    case Namespace::None:
        return findNoNamespaceNodeName(buffer);
    case Namespace::HTML:
        return findHTMLNodeName(buffer);
    case Namespace::MathML:
        return findMathMLNodeName(buffer);
    case Namespace::SVG:
        return findSVGNodeName(buffer);
    case Namespace::XLink:
        return findXLinkNodeName(buffer);
    case Namespace::XML:
        return findXMLNodeName(buffer);
    case Namespace::XMLNS:
        return findXMLNSNodeName(buffer);
    default:
        return NodeName::Unknown;
    }
}

NodeName findNodeName(Namespace ns, const String& name)
{
    if (name.is8Bit())
        return findNodeNameFromBuffer(ns, name.span8());
    return findNodeNameFromBuffer(ns, name.span16());
}

ElementName findHTMLElementName(std::span<const LChar> buffer)
{
    return findHTMLNodeName(buffer);
}

ElementName findHTMLElementName(std::span<const UChar> buffer)
{
    return findHTMLNodeName(buffer);
}

ElementName findHTMLElementName(const String& name)
{
    if (name.is8Bit())
        return findHTMLNodeName(name.span8());
    return findHTMLNodeName(name.span16());
}

ElementName findSVGElementName(const String& name)
{
    if (name.is8Bit())
        return findSVGNodeName(name.span8());
    return findSVGNodeName(name.span16());
}

ElementName findMathMLElementName(const String& name)
{
    if (name.is8Bit())
        return findMathMLNodeName(name.span8());
    return findMathMLNodeName(name.span16());
}

const QualifiedName& qualifiedNameForNodeName(NodeName nodeName)
{
    ASSERT(nodeName != NodeName::Unknown);
    switch (nodeName) {
    case NodeName::Unknown:
        break;
    case NodeName::HTML_abbr:
        return HTMLNames::abbrTag;
    case NodeName::HTML_acronym:
        return HTMLNames::acronymTag;
    case NodeName::HTML_address:
        return HTMLNames::addressTag;
    case NodeName::HTML_applet:
        return HTMLNames::appletTag;
    case NodeName::HTML_area:
        return HTMLNames::areaTag;
    case NodeName::HTML_article:
        return HTMLNames::articleTag;
    case NodeName::HTML_aside:
        return HTMLNames::asideTag;
    case NodeName::HTML_attachment:
        return HTMLNames::attachmentTag;
    case NodeName::HTML_audio:
        return HTMLNames::audioTag;
    case NodeName::HTML_b:
        return HTMLNames::bTag;
    case NodeName::HTML_base:
        return HTMLNames::baseTag;
    case NodeName::HTML_basefont:
        return HTMLNames::basefontTag;
    case NodeName::HTML_bdi:
        return HTMLNames::bdiTag;
    case NodeName::HTML_bdo:
        return HTMLNames::bdoTag;
    case NodeName::HTML_bgsound:
        return HTMLNames::bgsoundTag;
    case NodeName::HTML_big:
        return HTMLNames::bigTag;
    case NodeName::HTML_blockquote:
        return HTMLNames::blockquoteTag;
    case NodeName::HTML_body:
        return HTMLNames::bodyTag;
    case NodeName::HTML_br:
        return HTMLNames::brTag;
    case NodeName::HTML_button:
        return HTMLNames::buttonTag;
    case NodeName::HTML_canvas:
        return HTMLNames::canvasTag;
    case NodeName::HTML_caption:
        return HTMLNames::captionTag;
    case NodeName::HTML_center:
        return HTMLNames::centerTag;
    case NodeName::HTML_cite:
        return HTMLNames::citeTag;
    case NodeName::HTML_code:
        return HTMLNames::codeTag;
    case NodeName::HTML_col:
        return HTMLNames::colTag;
    case NodeName::HTML_colgroup:
        return HTMLNames::colgroupTag;
    case NodeName::HTML_color_profile:
        return HTMLNames::color_profileTag;
    case NodeName::HTML_data:
        return HTMLNames::dataTag;
    case NodeName::HTML_datalist:
        return HTMLNames::datalistTag;
    case NodeName::HTML_dd:
        return HTMLNames::ddTag;
    case NodeName::HTML_del:
        return HTMLNames::delTag;
    case NodeName::HTML_details:
        return HTMLNames::detailsTag;
    case NodeName::HTML_dfn:
        return HTMLNames::dfnTag;
    case NodeName::HTML_dialog:
        return HTMLNames::dialogTag;
    case NodeName::HTML_dir:
        return HTMLNames::dirTag;
    case NodeName::HTML_div:
        return HTMLNames::divTag;
    case NodeName::HTML_dl:
        return HTMLNames::dlTag;
    case NodeName::HTML_dt:
        return HTMLNames::dtTag;
    case NodeName::HTML_em:
        return HTMLNames::emTag;
    case NodeName::HTML_embed:
        return HTMLNames::embedTag;
    case NodeName::HTML_fieldset:
        return HTMLNames::fieldsetTag;
    case NodeName::HTML_figcaption:
        return HTMLNames::figcaptionTag;
    case NodeName::HTML_figure:
        return HTMLNames::figureTag;
    case NodeName::HTML_footer:
        return HTMLNames::footerTag;
    case NodeName::HTML_form:
        return HTMLNames::formTag;
    case NodeName::HTML_frame:
        return HTMLNames::frameTag;
    case NodeName::HTML_frameset:
        return HTMLNames::framesetTag;
    case NodeName::HTML_h1:
        return HTMLNames::h1Tag;
    case NodeName::HTML_h2:
        return HTMLNames::h2Tag;
    case NodeName::HTML_h3:
        return HTMLNames::h3Tag;
    case NodeName::HTML_h4:
        return HTMLNames::h4Tag;
    case NodeName::HTML_h5:
        return HTMLNames::h5Tag;
    case NodeName::HTML_h6:
        return HTMLNames::h6Tag;
    case NodeName::HTML_head:
        return HTMLNames::headTag;
    case NodeName::HTML_header:
        return HTMLNames::headerTag;
    case NodeName::HTML_hgroup:
        return HTMLNames::hgroupTag;
    case NodeName::HTML_hr:
        return HTMLNames::hrTag;
    case NodeName::HTML_html:
        return HTMLNames::htmlTag;
    case NodeName::HTML_i:
        return HTMLNames::iTag;
    case NodeName::HTML_iframe:
        return HTMLNames::iframeTag;
    case NodeName::HTML_img:
        return HTMLNames::imgTag;
    case NodeName::HTML_input:
        return HTMLNames::inputTag;
    case NodeName::HTML_ins:
        return HTMLNames::insTag;
    case NodeName::HTML_kbd:
        return HTMLNames::kbdTag;
    case NodeName::HTML_keygen:
        return HTMLNames::keygenTag;
    case NodeName::HTML_label:
        return HTMLNames::labelTag;
    case NodeName::HTML_legend:
        return HTMLNames::legendTag;
    case NodeName::HTML_li:
        return HTMLNames::liTag;
    case NodeName::HTML_link:
        return HTMLNames::linkTag;
    case NodeName::HTML_listing:
        return HTMLNames::listingTag;
    case NodeName::HTML_main:
        return HTMLNames::mainTag;
    case NodeName::HTML_map:
        return HTMLNames::mapTag;
    case NodeName::HTML_mark:
        return HTMLNames::markTag;
    case NodeName::HTML_marquee:
        return HTMLNames::marqueeTag;
    case NodeName::HTML_menu:
        return HTMLNames::menuTag;
    case NodeName::HTML_meta:
        return HTMLNames::metaTag;
    case NodeName::HTML_meter:
        return HTMLNames::meterTag;
    case NodeName::HTML_model:
        return HTMLNames::modelTag;
    case NodeName::HTML_nav:
        return HTMLNames::navTag;
    case NodeName::HTML_nobr:
        return HTMLNames::nobrTag;
    case NodeName::HTML_noembed:
        return HTMLNames::noembedTag;
    case NodeName::HTML_noframes:
        return HTMLNames::noframesTag;
    case NodeName::HTML_noscript:
        return HTMLNames::noscriptTag;
    case NodeName::HTML_object:
        return HTMLNames::objectTag;
    case NodeName::HTML_ol:
        return HTMLNames::olTag;
    case NodeName::HTML_optgroup:
        return HTMLNames::optgroupTag;
    case NodeName::HTML_option:
        return HTMLNames::optionTag;
    case NodeName::HTML_output:
        return HTMLNames::outputTag;
    case NodeName::HTML_p:
        return HTMLNames::pTag;
    case NodeName::HTML_param:
        return HTMLNames::paramTag;
    case NodeName::HTML_picture:
        return HTMLNames::pictureTag;
    case NodeName::HTML_plaintext:
        return HTMLNames::plaintextTag;
    case NodeName::HTML_pre:
        return HTMLNames::preTag;
    case NodeName::HTML_progress:
        return HTMLNames::progressTag;
    case NodeName::HTML_q:
        return HTMLNames::qTag;
    case NodeName::HTML_rb:
        return HTMLNames::rbTag;
    case NodeName::HTML_rp:
        return HTMLNames::rpTag;
    case NodeName::HTML_rt:
        return HTMLNames::rtTag;
    case NodeName::HTML_rtc:
        return HTMLNames::rtcTag;
    case NodeName::HTML_ruby:
        return HTMLNames::rubyTag;
    case NodeName::HTML_s:
        return HTMLNames::sTag;
    case NodeName::HTML_samp:
        return HTMLNames::sampTag;
    case NodeName::HTML_search:
        return HTMLNames::searchTag;
    case NodeName::HTML_section:
        return HTMLNames::sectionTag;
    case NodeName::HTML_select:
        return HTMLNames::selectTag;
    case NodeName::HTML_slot:
        return HTMLNames::slotTag;
    case NodeName::HTML_small:
        return HTMLNames::smallTag;
    case NodeName::HTML_source:
        return HTMLNames::sourceTag;
    case NodeName::HTML_span:
        return HTMLNames::spanTag;
    case NodeName::HTML_strike:
        return HTMLNames::strikeTag;
    case NodeName::HTML_strong:
        return HTMLNames::strongTag;
    case NodeName::HTML_sub:
        return HTMLNames::subTag;
    case NodeName::HTML_summary:
        return HTMLNames::summaryTag;
    case NodeName::HTML_sup:
        return HTMLNames::supTag;
    case NodeName::HTML_table:
        return HTMLNames::tableTag;
    case NodeName::HTML_tbody:
        return HTMLNames::tbodyTag;
    case NodeName::HTML_td:
        return HTMLNames::tdTag;
    case NodeName::HTML_template:
        return HTMLNames::templateTag;
    case NodeName::HTML_textarea:
        return HTMLNames::textareaTag;
    case NodeName::HTML_tfoot:
        return HTMLNames::tfootTag;
    case NodeName::HTML_th:
        return HTMLNames::thTag;
    case NodeName::HTML_thead:
        return HTMLNames::theadTag;
    case NodeName::HTML_time:
        return HTMLNames::timeTag;
    case NodeName::HTML_tr:
        return HTMLNames::trTag;
    case NodeName::HTML_track:
        return HTMLNames::trackTag;
    case NodeName::HTML_tt:
        return HTMLNames::ttTag;
    case NodeName::HTML_u:
        return HTMLNames::uTag;
    case NodeName::HTML_ul:
        return HTMLNames::ulTag;
    case NodeName::HTML_var:
        return HTMLNames::varTag;
    case NodeName::HTML_video:
        return HTMLNames::videoTag;
    case NodeName::HTML_wbr:
        return HTMLNames::wbrTag;
    case NodeName::HTML_xmp:
        return HTMLNames::xmpTag;
    case NodeName::MathML_annotation:
        return MathMLNames::annotationTag;
    case NodeName::MathML_maction:
        return MathMLNames::mactionTag;
    case NodeName::MathML_maligngroup:
        return MathMLNames::maligngroupTag;
    case NodeName::MathML_malignmark:
        return MathMLNames::malignmarkTag;
    case NodeName::MathML_math:
        return MathMLNames::mathTag;
    case NodeName::MathML_menclose:
        return MathMLNames::mencloseTag;
    case NodeName::MathML_merror:
        return MathMLNames::merrorTag;
    case NodeName::MathML_mfenced:
        return MathMLNames::mfencedTag;
    case NodeName::MathML_mfrac:
        return MathMLNames::mfracTag;
    case NodeName::MathML_mglyph:
        return MathMLNames::mglyphTag;
    case NodeName::MathML_mi:
        return MathMLNames::miTag;
    case NodeName::MathML_mlabeledtr:
        return MathMLNames::mlabeledtrTag;
    case NodeName::MathML_mlongdiv:
        return MathMLNames::mlongdivTag;
    case NodeName::MathML_mmultiscripts:
        return MathMLNames::mmultiscriptsTag;
    case NodeName::MathML_mn:
        return MathMLNames::mnTag;
    case NodeName::MathML_mo:
        return MathMLNames::moTag;
    case NodeName::MathML_mover:
        return MathMLNames::moverTag;
    case NodeName::MathML_mpadded:
        return MathMLNames::mpaddedTag;
    case NodeName::MathML_mphantom:
        return MathMLNames::mphantomTag;
    case NodeName::MathML_mprescripts:
        return MathMLNames::mprescriptsTag;
    case NodeName::MathML_mroot:
        return MathMLNames::mrootTag;
    case NodeName::MathML_mrow:
        return MathMLNames::mrowTag;
    case NodeName::MathML_ms:
        return MathMLNames::msTag;
    case NodeName::MathML_mscarries:
        return MathMLNames::mscarriesTag;
    case NodeName::MathML_mscarry:
        return MathMLNames::mscarryTag;
    case NodeName::MathML_msgroup:
        return MathMLNames::msgroupTag;
    case NodeName::MathML_msline:
        return MathMLNames::mslineTag;
    case NodeName::MathML_mspace:
        return MathMLNames::mspaceTag;
    case NodeName::MathML_msqrt:
        return MathMLNames::msqrtTag;
    case NodeName::MathML_msrow:
        return MathMLNames::msrowTag;
    case NodeName::MathML_mstack:
        return MathMLNames::mstackTag;
    case NodeName::MathML_mstyle:
        return MathMLNames::mstyleTag;
    case NodeName::MathML_msub:
        return MathMLNames::msubTag;
    case NodeName::MathML_msubsup:
        return MathMLNames::msubsupTag;
    case NodeName::MathML_msup:
        return MathMLNames::msupTag;
    case NodeName::MathML_mtable:
        return MathMLNames::mtableTag;
    case NodeName::MathML_mtd:
        return MathMLNames::mtdTag;
    case NodeName::MathML_mtext:
        return MathMLNames::mtextTag;
    case NodeName::MathML_mtr:
        return MathMLNames::mtrTag;
    case NodeName::MathML_munder:
        return MathMLNames::munderTag;
    case NodeName::MathML_munderover:
        return MathMLNames::munderoverTag;
    case NodeName::MathML_none:
        return MathMLNames::noneTag;
    case NodeName::MathML_semantics:
        return MathMLNames::semanticsTag;
    case NodeName::SVG_altGlyph:
        return SVGNames::altGlyphTag;
    case NodeName::SVG_altGlyphDef:
        return SVGNames::altGlyphDefTag;
    case NodeName::SVG_altGlyphItem:
        return SVGNames::altGlyphItemTag;
    case NodeName::SVG_animate:
        return SVGNames::animateTag;
    case NodeName::SVG_animateColor:
        return SVGNames::animateColorTag;
    case NodeName::SVG_animateMotion:
        return SVGNames::animateMotionTag;
    case NodeName::SVG_animateTransform:
        return SVGNames::animateTransformTag;
    case NodeName::SVG_circle:
        return SVGNames::circleTag;
    case NodeName::SVG_clipPath:
        return SVGNames::clipPathTag;
    case NodeName::SVG_cursor:
        return SVGNames::cursorTag;
    case NodeName::SVG_defs:
        return SVGNames::defsTag;
    case NodeName::SVG_desc:
        return SVGNames::descTag;
    case NodeName::SVG_ellipse:
        return SVGNames::ellipseTag;
    case NodeName::SVG_feBlend:
        return SVGNames::feBlendTag;
    case NodeName::SVG_feColorMatrix:
        return SVGNames::feColorMatrixTag;
    case NodeName::SVG_feComponentTransfer:
        return SVGNames::feComponentTransferTag;
    case NodeName::SVG_feComposite:
        return SVGNames::feCompositeTag;
    case NodeName::SVG_feConvolveMatrix:
        return SVGNames::feConvolveMatrixTag;
    case NodeName::SVG_feDiffuseLighting:
        return SVGNames::feDiffuseLightingTag;
    case NodeName::SVG_feDisplacementMap:
        return SVGNames::feDisplacementMapTag;
    case NodeName::SVG_feDistantLight:
        return SVGNames::feDistantLightTag;
    case NodeName::SVG_feDropShadow:
        return SVGNames::feDropShadowTag;
    case NodeName::SVG_feFlood:
        return SVGNames::feFloodTag;
    case NodeName::SVG_feFuncA:
        return SVGNames::feFuncATag;
    case NodeName::SVG_feFuncB:
        return SVGNames::feFuncBTag;
    case NodeName::SVG_feFuncG:
        return SVGNames::feFuncGTag;
    case NodeName::SVG_feFuncR:
        return SVGNames::feFuncRTag;
    case NodeName::SVG_feGaussianBlur:
        return SVGNames::feGaussianBlurTag;
    case NodeName::SVG_feImage:
        return SVGNames::feImageTag;
    case NodeName::SVG_feMerge:
        return SVGNames::feMergeTag;
    case NodeName::SVG_feMergeNode:
        return SVGNames::feMergeNodeTag;
    case NodeName::SVG_feMorphology:
        return SVGNames::feMorphologyTag;
    case NodeName::SVG_feOffset:
        return SVGNames::feOffsetTag;
    case NodeName::SVG_fePointLight:
        return SVGNames::fePointLightTag;
    case NodeName::SVG_feSpecularLighting:
        return SVGNames::feSpecularLightingTag;
    case NodeName::SVG_feSpotLight:
        return SVGNames::feSpotLightTag;
    case NodeName::SVG_feTile:
        return SVGNames::feTileTag;
    case NodeName::SVG_feTurbulence:
        return SVGNames::feTurbulenceTag;
    case NodeName::SVG_filter:
        return SVGNames::filterTag;
    case NodeName::SVG_foreignObject:
        return SVGNames::foreignObjectTag;
    case NodeName::SVG_g:
        return SVGNames::gTag;
    case NodeName::SVG_glyph:
        return SVGNames::glyphTag;
    case NodeName::SVG_glyphRef:
        return SVGNames::glyphRefTag;
    case NodeName::SVG_hkern:
        return SVGNames::hkernTag;
    case NodeName::SVG_line:
        return SVGNames::lineTag;
    case NodeName::SVG_linearGradient:
        return SVGNames::linearGradientTag;
    case NodeName::SVG_marker:
        return SVGNames::markerTag;
    case NodeName::SVG_mask:
        return SVGNames::maskTag;
    case NodeName::SVG_metadata:
        return SVGNames::metadataTag;
    case NodeName::SVG_mpath:
        return SVGNames::mpathTag;
    case NodeName::SVG_path:
        return SVGNames::pathTag;
    case NodeName::SVG_pattern:
        return SVGNames::patternTag;
    case NodeName::SVG_polygon:
        return SVGNames::polygonTag;
    case NodeName::SVG_polyline:
        return SVGNames::polylineTag;
    case NodeName::SVG_radialGradient:
        return SVGNames::radialGradientTag;
    case NodeName::SVG_rect:
        return SVGNames::rectTag;
    case NodeName::SVG_set:
        return SVGNames::setTag;
    case NodeName::SVG_stop:
        return SVGNames::stopTag;
    case NodeName::SVG_svg:
        return SVGNames::svgTag;
    case NodeName::SVG_switch:
        return SVGNames::switchTag;
    case NodeName::SVG_symbol:
        return SVGNames::symbolTag;
    case NodeName::SVG_text:
        return SVGNames::textTag;
    case NodeName::SVG_textPath:
        return SVGNames::textPathTag;
    case NodeName::SVG_tref:
        return SVGNames::trefTag;
    case NodeName::SVG_tspan:
        return SVGNames::tspanTag;
    case NodeName::SVG_use:
        return SVGNames::useTag;
    case NodeName::SVG_view:
        return SVGNames::viewTag;
    case NodeName::SVG_vkern:
        return SVGNames::vkernTag;
    case NodeName::HTML_a:
        return HTMLNames::aTag;
    case NodeName::HTML_annotation_xml:
        return HTMLNames::annotation_xmlTag;
    case NodeName::HTML_font:
        return HTMLNames::fontTag;
    case NodeName::HTML_font_face:
        return HTMLNames::font_faceTag;
    case NodeName::HTML_font_face_format:
        return HTMLNames::font_face_formatTag;
    case NodeName::HTML_font_face_name:
        return HTMLNames::font_face_nameTag;
    case NodeName::HTML_font_face_src:
        return HTMLNames::font_face_srcTag;
    case NodeName::HTML_font_face_uri:
        return HTMLNames::font_face_uriTag;
    case NodeName::HTML_image:
        return HTMLNames::imageTag;
    case NodeName::HTML_missing_glyph:
        return HTMLNames::missing_glyphTag;
    case NodeName::HTML_script:
        return HTMLNames::scriptTag;
    case NodeName::HTML_style:
        return HTMLNames::styleTag;
    case NodeName::HTML_title:
        return HTMLNames::titleTag;
    case NodeName::MathML_annotation_xml:
        return MathMLNames::annotation_xmlTag;
    case NodeName::SVG_a:
        return SVGNames::aTag;
    case NodeName::SVG_font:
        return SVGNames::fontTag;
    case NodeName::SVG_font_face:
        return SVGNames::font_faceTag;
    case NodeName::SVG_font_face_format:
        return SVGNames::font_face_formatTag;
    case NodeName::SVG_font_face_name:
        return SVGNames::font_face_nameTag;
    case NodeName::SVG_font_face_src:
        return SVGNames::font_face_srcTag;
    case NodeName::SVG_font_face_uri:
        return SVGNames::font_face_uriTag;
    case NodeName::SVG_image:
        return SVGNames::imageTag;
    case NodeName::SVG_missing_glyph:
        return SVGNames::missing_glyphTag;
    case NodeName::SVG_script:
        return SVGNames::scriptTag;
    case NodeName::SVG_style:
        return SVGNames::styleTag;
    case NodeName::SVG_title:
        return SVGNames::titleTag;
    case NodeName::XLink_actuateAttr:
        return XLinkNames::actuateAttr;
    case NodeName::XLink_arcroleAttr:
        return XLinkNames::arcroleAttr;
    case NodeName::XLink_showAttr:
        return XLinkNames::showAttr;
    case NodeName::XMLNS_xmlnsAttr:
        return XMLNSNames::xmlnsAttr;
    case NodeName::XML_spaceAttr:
        return XMLNames::spaceAttr;
    case NodeName::abbrAttr:
        return HTMLNames::abbrAttr;
    case NodeName::accentAttr:
        return MathMLNames::accentAttr;
    case NodeName::accentunderAttr:
        return MathMLNames::accentunderAttr;
    case NodeName::acceptAttr:
        return HTMLNames::acceptAttr;
    case NodeName::accept_charsetAttr:
        return HTMLNames::accept_charsetAttr;
    case NodeName::accesskeyAttr:
        return HTMLNames::accesskeyAttr;
    case NodeName::accumulateAttr:
        return SVGNames::accumulateAttr;
    case NodeName::actionAttr:
        return HTMLNames::actionAttr;
    case NodeName::actiontypeAttr:
        return MathMLNames::actiontypeAttr;
    case NodeName::additiveAttr:
        return SVGNames::additiveAttr;
    case NodeName::alignAttr:
        return HTMLNames::alignAttr;
    case NodeName::alignment_baselineAttr:
        return SVGNames::alignment_baselineAttr;
    case NodeName::alinkAttr:
        return HTMLNames::alinkAttr;
    case NodeName::allowAttr:
        return HTMLNames::allowAttr;
    case NodeName::allowfullscreenAttr:
        return HTMLNames::allowfullscreenAttr;
    case NodeName::altAttr:
        return HTMLNames::altAttr;
    case NodeName::alttextAttr:
        return MathMLNames::alttextAttr;
    case NodeName::amplitudeAttr:
        return SVGNames::amplitudeAttr;
    case NodeName::animateAttr:
        return SVGNames::animateAttr;
    case NodeName::arabic_formAttr:
        return SVGNames::arabic_formAttr;
    case NodeName::archiveAttr:
        return HTMLNames::archiveAttr;
    case NodeName::aria_activedescendantAttr:
        return HTMLNames::aria_activedescendantAttr;
    case NodeName::aria_atomicAttr:
        return HTMLNames::aria_atomicAttr;
    case NodeName::aria_autocompleteAttr:
        return HTMLNames::aria_autocompleteAttr;
    case NodeName::aria_braillelabelAttr:
        return HTMLNames::aria_braillelabelAttr;
    case NodeName::aria_brailleroledescriptionAttr:
        return HTMLNames::aria_brailleroledescriptionAttr;
    case NodeName::aria_busyAttr:
        return HTMLNames::aria_busyAttr;
    case NodeName::aria_checkedAttr:
        return HTMLNames::aria_checkedAttr;
    case NodeName::aria_colcountAttr:
        return HTMLNames::aria_colcountAttr;
    case NodeName::aria_colindexAttr:
        return HTMLNames::aria_colindexAttr;
    case NodeName::aria_colspanAttr:
        return HTMLNames::aria_colspanAttr;
    case NodeName::aria_controlsAttr:
        return HTMLNames::aria_controlsAttr;
    case NodeName::aria_currentAttr:
        return HTMLNames::aria_currentAttr;
    case NodeName::aria_describedbyAttr:
        return HTMLNames::aria_describedbyAttr;
    case NodeName::aria_descriptionAttr:
        return HTMLNames::aria_descriptionAttr;
    case NodeName::aria_detailsAttr:
        return HTMLNames::aria_detailsAttr;
    case NodeName::aria_disabledAttr:
        return HTMLNames::aria_disabledAttr;
    case NodeName::aria_dropeffectAttr:
        return HTMLNames::aria_dropeffectAttr;
    case NodeName::aria_errormessageAttr:
        return HTMLNames::aria_errormessageAttr;
    case NodeName::aria_expandedAttr:
        return HTMLNames::aria_expandedAttr;
    case NodeName::aria_flowtoAttr:
        return HTMLNames::aria_flowtoAttr;
    case NodeName::aria_grabbedAttr:
        return HTMLNames::aria_grabbedAttr;
    case NodeName::aria_haspopupAttr:
        return HTMLNames::aria_haspopupAttr;
    case NodeName::aria_helpAttr:
        return HTMLNames::aria_helpAttr;
    case NodeName::aria_hiddenAttr:
        return HTMLNames::aria_hiddenAttr;
    case NodeName::aria_invalidAttr:
        return HTMLNames::aria_invalidAttr;
    case NodeName::aria_keyshortcutsAttr:
        return HTMLNames::aria_keyshortcutsAttr;
    case NodeName::aria_labelAttr:
        return HTMLNames::aria_labelAttr;
    case NodeName::aria_labeledbyAttr:
        return HTMLNames::aria_labeledbyAttr;
    case NodeName::aria_labelledbyAttr:
        return HTMLNames::aria_labelledbyAttr;
    case NodeName::aria_levelAttr:
        return HTMLNames::aria_levelAttr;
    case NodeName::aria_liveAttr:
        return HTMLNames::aria_liveAttr;
    case NodeName::aria_modalAttr:
        return HTMLNames::aria_modalAttr;
    case NodeName::aria_multilineAttr:
        return HTMLNames::aria_multilineAttr;
    case NodeName::aria_multiselectableAttr:
        return HTMLNames::aria_multiselectableAttr;
    case NodeName::aria_orientationAttr:
        return HTMLNames::aria_orientationAttr;
    case NodeName::aria_ownsAttr:
        return HTMLNames::aria_ownsAttr;
    case NodeName::aria_placeholderAttr:
        return HTMLNames::aria_placeholderAttr;
    case NodeName::aria_posinsetAttr:
        return HTMLNames::aria_posinsetAttr;
    case NodeName::aria_pressedAttr:
        return HTMLNames::aria_pressedAttr;
    case NodeName::aria_readonlyAttr:
        return HTMLNames::aria_readonlyAttr;
    case NodeName::aria_relevantAttr:
        return HTMLNames::aria_relevantAttr;
    case NodeName::aria_requiredAttr:
        return HTMLNames::aria_requiredAttr;
    case NodeName::aria_roledescriptionAttr:
        return HTMLNames::aria_roledescriptionAttr;
    case NodeName::aria_rowcountAttr:
        return HTMLNames::aria_rowcountAttr;
    case NodeName::aria_rowindexAttr:
        return HTMLNames::aria_rowindexAttr;
    case NodeName::aria_rowspanAttr:
        return HTMLNames::aria_rowspanAttr;
    case NodeName::aria_selectedAttr:
        return HTMLNames::aria_selectedAttr;
    case NodeName::aria_setsizeAttr:
        return HTMLNames::aria_setsizeAttr;
    case NodeName::aria_sortAttr:
        return HTMLNames::aria_sortAttr;
    case NodeName::aria_valuemaxAttr:
        return HTMLNames::aria_valuemaxAttr;
    case NodeName::aria_valueminAttr:
        return HTMLNames::aria_valueminAttr;
    case NodeName::aria_valuenowAttr:
        return HTMLNames::aria_valuenowAttr;
    case NodeName::aria_valuetextAttr:
        return HTMLNames::aria_valuetextAttr;
    case NodeName::asAttr:
        return HTMLNames::asAttr;
    case NodeName::ascentAttr:
        return SVGNames::ascentAttr;
    case NodeName::asyncAttr:
        return HTMLNames::asyncAttr;
    case NodeName::attributeNameAttr:
        return SVGNames::attributeNameAttr;
    case NodeName::attributeTypeAttr:
        return SVGNames::attributeTypeAttr;
    case NodeName::attributiondestinationAttr:
        return HTMLNames::attributiondestinationAttr;
    case NodeName::attributionsourceidAttr:
        return HTMLNames::attributionsourceidAttr;
    case NodeName::attributionsourcenonceAttr:
        return HTMLNames::attributionsourcenonceAttr;
    case NodeName::autocapitalizeAttr:
        return HTMLNames::autocapitalizeAttr;
    case NodeName::autocompleteAttr:
        return HTMLNames::autocompleteAttr;
    case NodeName::autocorrectAttr:
        return HTMLNames::autocorrectAttr;
    case NodeName::autofocusAttr:
        return HTMLNames::autofocusAttr;
    case NodeName::autopictureinpictureAttr:
        return HTMLNames::autopictureinpictureAttr;
    case NodeName::autoplayAttr:
        return HTMLNames::autoplayAttr;
    case NodeName::autosaveAttr:
        return HTMLNames::autosaveAttr;
    case NodeName::axisAttr:
        return HTMLNames::axisAttr;
    case NodeName::azimuthAttr:
        return SVGNames::azimuthAttr;
    case NodeName::backgroundAttr:
        return HTMLNames::backgroundAttr;
    case NodeName::baseFrequencyAttr:
        return SVGNames::baseFrequencyAttr;
    case NodeName::baseProfileAttr:
        return SVGNames::baseProfileAttr;
    case NodeName::baseline_shiftAttr:
        return SVGNames::baseline_shiftAttr;
    case NodeName::beginAttr:
        return SVGNames::beginAttr;
    case NodeName::behaviorAttr:
        return HTMLNames::behaviorAttr;
    case NodeName::bgcolorAttr:
        return HTMLNames::bgcolorAttr;
    case NodeName::biasAttr:
        return SVGNames::biasAttr;
    case NodeName::blockingAttr:
        return HTMLNames::blockingAttr;
    case NodeName::borderAttr:
        return HTMLNames::borderAttr;
    case NodeName::bordercolorAttr:
        return HTMLNames::bordercolorAttr;
    case NodeName::buffered_renderingAttr:
        return SVGNames::buffered_renderingAttr;
    case NodeName::byAttr:
        return SVGNames::byAttr;
    case NodeName::calcModeAttr:
        return SVGNames::calcModeAttr;
    case NodeName::cap_heightAttr:
        return SVGNames::cap_heightAttr;
    case NodeName::captureAttr:
        return HTMLNames::captureAttr;
    case NodeName::cellborderAttr:
        return HTMLNames::cellborderAttr;
    case NodeName::cellpaddingAttr:
        return HTMLNames::cellpaddingAttr;
    case NodeName::cellspacingAttr:
        return HTMLNames::cellspacingAttr;
    case NodeName::challengeAttr:
        return HTMLNames::challengeAttr;
    case NodeName::charAttr:
        return HTMLNames::charAttr;
    case NodeName::charoffAttr:
        return HTMLNames::charoffAttr;
    case NodeName::charsetAttr:
        return HTMLNames::charsetAttr;
    case NodeName::checkedAttr:
        return HTMLNames::checkedAttr;
    case NodeName::citeAttr:
        return HTMLNames::citeAttr;
    case NodeName::classAttr:
        return HTMLNames::classAttr;
    case NodeName::classidAttr:
        return HTMLNames::classidAttr;
    case NodeName::clearAttr:
        return HTMLNames::clearAttr;
    case NodeName::clipAttr:
        return SVGNames::clipAttr;
    case NodeName::clipPathUnitsAttr:
        return SVGNames::clipPathUnitsAttr;
    case NodeName::clip_pathAttr:
        return SVGNames::clip_pathAttr;
    case NodeName::clip_ruleAttr:
        return SVGNames::clip_ruleAttr;
    case NodeName::closeAttr:
        return MathMLNames::closeAttr;
    case NodeName::codeAttr:
        return HTMLNames::codeAttr;
    case NodeName::codebaseAttr:
        return HTMLNames::codebaseAttr;
    case NodeName::codetypeAttr:
        return HTMLNames::codetypeAttr;
    case NodeName::colorAttr:
        return HTMLNames::colorAttr;
    case NodeName::color_interpolationAttr:
        return SVGNames::color_interpolationAttr;
    case NodeName::color_interpolation_filtersAttr:
        return SVGNames::color_interpolation_filtersAttr;
    case NodeName::colsAttr:
        return HTMLNames::colsAttr;
    case NodeName::colspanAttr:
        return HTMLNames::colspanAttr;
    case NodeName::columnspanAttr:
        return MathMLNames::columnspanAttr;
    case NodeName::commandAttr:
        return HTMLNames::commandAttr;
    case NodeName::commandforAttr:
        return HTMLNames::commandforAttr;
    case NodeName::compactAttr:
        return HTMLNames::compactAttr;
    case NodeName::compositeAttr:
        return HTMLNames::compositeAttr;
    case NodeName::contentAttr:
        return HTMLNames::contentAttr;
    case NodeName::contenteditableAttr:
        return HTMLNames::contenteditableAttr;
    case NodeName::controlsAttr:
        return HTMLNames::controlsAttr;
    case NodeName::coordsAttr:
        return HTMLNames::coordsAttr;
    case NodeName::crossoriginAttr:
        return HTMLNames::crossoriginAttr;
    case NodeName::cueAttr:
        return HTMLNames::cueAttr;
    case NodeName::cuebackgroundAttr:
        return HTMLNames::cuebackgroundAttr;
    case NodeName::cursorAttr:
        return SVGNames::cursorAttr;
    case NodeName::cxAttr:
        return SVGNames::cxAttr;
    case NodeName::cyAttr:
        return SVGNames::cyAttr;
    case NodeName::dAttr:
        return SVGNames::dAttr;
    case NodeName::dataAttr:
        return HTMLNames::dataAttr;
    case NodeName::datetimeAttr:
        return HTMLNames::datetimeAttr;
    case NodeName::declareAttr:
        return HTMLNames::declareAttr;
    case NodeName::decodingAttr:
        return HTMLNames::decodingAttr;
    case NodeName::defaultAttr:
        return HTMLNames::defaultAttr;
    case NodeName::deferAttr:
        return HTMLNames::deferAttr;
    case NodeName::definitionURLAttr:
        return MathMLNames::definitionURLAttr;
    case NodeName::denomalignAttr:
        return MathMLNames::denomalignAttr;
    case NodeName::depthAttr:
        return MathMLNames::depthAttr;
    case NodeName::descentAttr:
        return SVGNames::descentAttr;
    case NodeName::diffuseConstantAttr:
        return SVGNames::diffuseConstantAttr;
    case NodeName::dirAttr:
        return HTMLNames::dirAttr;
    case NodeName::directionAttr:
        return HTMLNames::directionAttr;
    case NodeName::dirnameAttr:
        return HTMLNames::dirnameAttr;
    case NodeName::disabledAttr:
        return HTMLNames::disabledAttr;
    case NodeName::disablepictureinpictureAttr:
        return HTMLNames::disablepictureinpictureAttr;
    case NodeName::disableremoteplaybackAttr:
        return HTMLNames::disableremoteplaybackAttr;
    case NodeName::displayAttr:
        return MathMLNames::displayAttr;
    case NodeName::displaystyleAttr:
        return MathMLNames::displaystyleAttr;
    case NodeName::divisorAttr:
        return SVGNames::divisorAttr;
    case NodeName::dominant_baselineAttr:
        return SVGNames::dominant_baselineAttr;
    case NodeName::downloadAttr:
        return HTMLNames::downloadAttr;
    case NodeName::draggableAttr:
        return HTMLNames::draggableAttr;
    case NodeName::dropzoneAttr:
        return HTMLNames::dropzoneAttr;
    case NodeName::durAttr:
        return SVGNames::durAttr;
    case NodeName::dxAttr:
        return SVGNames::dxAttr;
    case NodeName::dyAttr:
        return SVGNames::dyAttr;
    case NodeName::edgeModeAttr:
        return SVGNames::edgeModeAttr;
    case NodeName::elevationAttr:
        return SVGNames::elevationAttr;
    case NodeName::encodingAttr:
        return MathMLNames::encodingAttr;
    case NodeName::enctypeAttr:
        return HTMLNames::enctypeAttr;
    case NodeName::endAttr:
        return HTMLNames::endAttr;
    case NodeName::enterkeyhintAttr:
        return HTMLNames::enterkeyhintAttr;
    case NodeName::eventAttr:
        return HTMLNames::eventAttr;
    case NodeName::expandedAttr:
        return HTMLNames::expandedAttr;
    case NodeName::exponentAttr:
        return SVGNames::exponentAttr;
    case NodeName::exportpartsAttr:
        return HTMLNames::exportpartsAttr;
    case NodeName::faceAttr:
        return HTMLNames::faceAttr;
    case NodeName::fenceAttr:
        return MathMLNames::fenceAttr;
    case NodeName::fetchpriorityAttr:
        return HTMLNames::fetchpriorityAttr;
    case NodeName::filenameAttr:
        return HTMLNames::filenameAttr;
    case NodeName::fillAttr:
        return SVGNames::fillAttr;
    case NodeName::fill_opacityAttr:
        return SVGNames::fill_opacityAttr;
    case NodeName::fill_ruleAttr:
        return SVGNames::fill_ruleAttr;
    case NodeName::filterAttr:
        return SVGNames::filterAttr;
    case NodeName::filterUnitsAttr:
        return SVGNames::filterUnitsAttr;
    case NodeName::flood_colorAttr:
        return SVGNames::flood_colorAttr;
    case NodeName::flood_opacityAttr:
        return SVGNames::flood_opacityAttr;
    case NodeName::focusedAttr:
        return HTMLNames::focusedAttr;
    case NodeName::font_familyAttr:
        return SVGNames::font_familyAttr;
    case NodeName::font_sizeAttr:
        return SVGNames::font_sizeAttr;
    case NodeName::font_size_adjustAttr:
        return SVGNames::font_size_adjustAttr;
    case NodeName::font_stretchAttr:
        return SVGNames::font_stretchAttr;
    case NodeName::font_styleAttr:
        return SVGNames::font_styleAttr;
    case NodeName::font_variantAttr:
        return SVGNames::font_variantAttr;
    case NodeName::font_weightAttr:
        return SVGNames::font_weightAttr;
    case NodeName::fontfamilyAttr:
        return MathMLNames::fontfamilyAttr;
    case NodeName::fontsizeAttr:
        return MathMLNames::fontsizeAttr;
    case NodeName::fontstyleAttr:
        return MathMLNames::fontstyleAttr;
    case NodeName::fontweightAttr:
        return MathMLNames::fontweightAttr;
    case NodeName::forAttr:
        return HTMLNames::forAttr;
    case NodeName::formAttr:
        return HTMLNames::formAttr;
    case NodeName::formactionAttr:
        return HTMLNames::formactionAttr;
    case NodeName::formatAttr:
        return SVGNames::formatAttr;
    case NodeName::formenctypeAttr:
        return HTMLNames::formenctypeAttr;
    case NodeName::formmethodAttr:
        return HTMLNames::formmethodAttr;
    case NodeName::formnovalidateAttr:
        return HTMLNames::formnovalidateAttr;
    case NodeName::formtargetAttr:
        return HTMLNames::formtargetAttr;
    case NodeName::frAttr:
        return SVGNames::frAttr;
    case NodeName::frameAttr:
        return HTMLNames::frameAttr;
    case NodeName::frameborderAttr:
        return HTMLNames::frameborderAttr;
    case NodeName::fromAttr:
        return SVGNames::fromAttr;
    case NodeName::fxAttr:
        return SVGNames::fxAttr;
    case NodeName::fyAttr:
        return SVGNames::fyAttr;
    case NodeName::g1Attr:
        return SVGNames::g1Attr;
    case NodeName::g2Attr:
        return SVGNames::g2Attr;
    case NodeName::glyphRefAttr:
        return SVGNames::glyphRefAttr;
    case NodeName::glyph_nameAttr:
        return SVGNames::glyph_nameAttr;
    case NodeName::glyph_orientation_horizontalAttr:
        return SVGNames::glyph_orientation_horizontalAttr;
    case NodeName::glyph_orientation_verticalAttr:
        return SVGNames::glyph_orientation_verticalAttr;
    case NodeName::gradientTransformAttr:
        return SVGNames::gradientTransformAttr;
    case NodeName::gradientUnitsAttr:
        return SVGNames::gradientUnitsAttr;
    case NodeName::headersAttr:
        return HTMLNames::headersAttr;
    case NodeName::heightAttr:
        return HTMLNames::heightAttr;
    case NodeName::hiddenAttr:
        return HTMLNames::hiddenAttr;
    case NodeName::highAttr:
        return HTMLNames::highAttr;
    case NodeName::horiz_adv_xAttr:
        return SVGNames::horiz_adv_xAttr;
    case NodeName::horiz_origin_xAttr:
        return SVGNames::horiz_origin_xAttr;
    case NodeName::horiz_origin_yAttr:
        return SVGNames::horiz_origin_yAttr;
    case NodeName::hreflangAttr:
        return HTMLNames::hreflangAttr;
    case NodeName::hspaceAttr:
        return HTMLNames::hspaceAttr;
    case NodeName::http_equivAttr:
        return HTMLNames::http_equivAttr;
    case NodeName::idAttr:
        return HTMLNames::idAttr;
    case NodeName::image_renderingAttr:
        return SVGNames::image_renderingAttr;
    case NodeName::imagesizesAttr:
        return HTMLNames::imagesizesAttr;
    case NodeName::imagesrcsetAttr:
        return HTMLNames::imagesrcsetAttr;
    case NodeName::in2Attr:
        return SVGNames::in2Attr;
    case NodeName::inAttr:
        return SVGNames::inAttr;
    case NodeName::incrementalAttr:
        return HTMLNames::incrementalAttr;
    case NodeName::inertAttr:
        return HTMLNames::inertAttr;
    case NodeName::inputmodeAttr:
        return HTMLNames::inputmodeAttr;
    case NodeName::integrityAttr:
        return HTMLNames::integrityAttr;
    case NodeName::interactiveAttr:
        return HTMLNames::interactiveAttr;
    case NodeName::interceptAttr:
        return SVGNames::interceptAttr;
    case NodeName::isAttr:
        return HTMLNames::isAttr;
    case NodeName::ismapAttr:
        return HTMLNames::ismapAttr;
    case NodeName::k1Attr:
        return SVGNames::k1Attr;
    case NodeName::k2Attr:
        return SVGNames::k2Attr;
    case NodeName::k3Attr:
        return SVGNames::k3Attr;
    case NodeName::k4Attr:
        return SVGNames::k4Attr;
    case NodeName::kAttr:
        return SVGNames::kAttr;
    case NodeName::kernelMatrixAttr:
        return SVGNames::kernelMatrixAttr;
    case NodeName::kernelUnitLengthAttr:
        return SVGNames::kernelUnitLengthAttr;
    case NodeName::kerningAttr:
        return SVGNames::kerningAttr;
    case NodeName::keyPointsAttr:
        return SVGNames::keyPointsAttr;
    case NodeName::keySplinesAttr:
        return SVGNames::keySplinesAttr;
    case NodeName::keyTimesAttr:
        return SVGNames::keyTimesAttr;
    case NodeName::keytypeAttr:
        return HTMLNames::keytypeAttr;
    case NodeName::kindAttr:
        return HTMLNames::kindAttr;
    case NodeName::labelAttr:
        return HTMLNames::labelAttr;
    case NodeName::languageAttr:
        return HTMLNames::languageAttr;
    case NodeName::largeopAttr:
        return MathMLNames::largeopAttr;
    case NodeName::leftmarginAttr:
        return HTMLNames::leftmarginAttr;
    case NodeName::lengthAdjustAttr:
        return SVGNames::lengthAdjustAttr;
    case NodeName::letter_spacingAttr:
        return SVGNames::letter_spacingAttr;
    case NodeName::lighting_colorAttr:
        return SVGNames::lighting_colorAttr;
    case NodeName::limitingConeAngleAttr:
        return SVGNames::limitingConeAngleAttr;
    case NodeName::linethicknessAttr:
        return MathMLNames::linethicknessAttr;
    case NodeName::linkAttr:
        return HTMLNames::linkAttr;
    case NodeName::listAttr:
        return HTMLNames::listAttr;
    case NodeName::loadingAttr:
        return HTMLNames::loadingAttr;
    case NodeName::localAttr:
        return SVGNames::localAttr;
    case NodeName::longdescAttr:
        return HTMLNames::longdescAttr;
    case NodeName::loopAttr:
        return HTMLNames::loopAttr;
    case NodeName::loopendAttr:
        return HTMLNames::loopendAttr;
    case NodeName::loopstartAttr:
        return HTMLNames::loopstartAttr;
    case NodeName::lowAttr:
        return HTMLNames::lowAttr;
    case NodeName::lowsrcAttr:
        return HTMLNames::lowsrcAttr;
    case NodeName::lspaceAttr:
        return MathMLNames::lspaceAttr;
    case NodeName::marginheightAttr:
        return HTMLNames::marginheightAttr;
    case NodeName::marginwidthAttr:
        return HTMLNames::marginwidthAttr;
    case NodeName::markerHeightAttr:
        return SVGNames::markerHeightAttr;
    case NodeName::markerUnitsAttr:
        return SVGNames::markerUnitsAttr;
    case NodeName::markerWidthAttr:
        return SVGNames::markerWidthAttr;
    case NodeName::marker_endAttr:
        return SVGNames::marker_endAttr;
    case NodeName::marker_midAttr:
        return SVGNames::marker_midAttr;
    case NodeName::marker_startAttr:
        return SVGNames::marker_startAttr;
    case NodeName::maskAttr:
        return SVGNames::maskAttr;
    case NodeName::maskContentUnitsAttr:
        return SVGNames::maskContentUnitsAttr;
    case NodeName::maskUnitsAttr:
        return SVGNames::maskUnitsAttr;
    case NodeName::mask_typeAttr:
        return SVGNames::mask_typeAttr;
    case NodeName::mathbackgroundAttr:
        return MathMLNames::mathbackgroundAttr;
    case NodeName::mathcolorAttr:
        return MathMLNames::mathcolorAttr;
    case NodeName::mathsizeAttr:
        return MathMLNames::mathsizeAttr;
    case NodeName::mathvariantAttr:
        return MathMLNames::mathvariantAttr;
    case NodeName::maxAttr:
        return HTMLNames::maxAttr;
    case NodeName::maxlengthAttr:
        return HTMLNames::maxlengthAttr;
    case NodeName::maxsizeAttr:
        return MathMLNames::maxsizeAttr;
    case NodeName::mayscriptAttr:
        return HTMLNames::mayscriptAttr;
    case NodeName::mediaAttr:
        return HTMLNames::mediaAttr;
    case NodeName::mediagroupAttr:
        return HTMLNames::mediagroupAttr;
    case NodeName::methodAttr:
        return HTMLNames::methodAttr;
    case NodeName::minAttr:
        return HTMLNames::minAttr;
    case NodeName::minlengthAttr:
        return HTMLNames::minlengthAttr;
    case NodeName::minsizeAttr:
        return MathMLNames::minsizeAttr;
    case NodeName::modeAttr:
        return SVGNames::modeAttr;
    case NodeName::movablelimitsAttr:
        return MathMLNames::movablelimitsAttr;
    case NodeName::multipleAttr:
        return HTMLNames::multipleAttr;
    case NodeName::mutedAttr:
        return HTMLNames::mutedAttr;
    case NodeName::nameAttr:
        return HTMLNames::nameAttr;
    case NodeName::nohrefAttr:
        return HTMLNames::nohrefAttr;
    case NodeName::nomoduleAttr:
        return HTMLNames::nomoduleAttr;
    case NodeName::nonceAttr:
        return HTMLNames::nonceAttr;
    case NodeName::noresizeAttr:
        return HTMLNames::noresizeAttr;
    case NodeName::noshadeAttr:
        return HTMLNames::noshadeAttr;
    case NodeName::notationAttr:
        return MathMLNames::notationAttr;
    case NodeName::novalidateAttr:
        return HTMLNames::novalidateAttr;
    case NodeName::nowrapAttr:
        return HTMLNames::nowrapAttr;
    case NodeName::numOctavesAttr:
        return SVGNames::numOctavesAttr;
    case NodeName::numalignAttr:
        return MathMLNames::numalignAttr;
    case NodeName::objectAttr:
        return HTMLNames::objectAttr;
    case NodeName::offsetAttr:
        return SVGNames::offsetAttr;
    case NodeName::onabortAttr:
        return HTMLNames::onabortAttr;
    case NodeName::onafterprintAttr:
        return HTMLNames::onafterprintAttr;
    case NodeName::onanimationcancelAttr:
        return HTMLNames::onanimationcancelAttr;
    case NodeName::onanimationendAttr:
        return HTMLNames::onanimationendAttr;
    case NodeName::onanimationiterationAttr:
        return HTMLNames::onanimationiterationAttr;
    case NodeName::onanimationstartAttr:
        return HTMLNames::onanimationstartAttr;
    case NodeName::onautocompleteAttr:
        return HTMLNames::onautocompleteAttr;
    case NodeName::onautocompleteerrorAttr:
        return HTMLNames::onautocompleteerrorAttr;
    case NodeName::onauxclickAttr:
        return HTMLNames::onauxclickAttr;
    case NodeName::onbeforecopyAttr:
        return HTMLNames::onbeforecopyAttr;
    case NodeName::onbeforecutAttr:
        return HTMLNames::onbeforecutAttr;
    case NodeName::onbeforeinputAttr:
        return HTMLNames::onbeforeinputAttr;
    case NodeName::onbeforeloadAttr:
        return HTMLNames::onbeforeloadAttr;
    case NodeName::onbeforepasteAttr:
        return HTMLNames::onbeforepasteAttr;
    case NodeName::onbeforeprintAttr:
        return HTMLNames::onbeforeprintAttr;
    case NodeName::onbeforetoggleAttr:
        return HTMLNames::onbeforetoggleAttr;
    case NodeName::onbeforeunloadAttr:
        return HTMLNames::onbeforeunloadAttr;
    case NodeName::onbeginAttr:
        return SVGNames::onbeginAttr;
    case NodeName::onblurAttr:
        return HTMLNames::onblurAttr;
    case NodeName::oncancelAttr:
        return HTMLNames::oncancelAttr;
    case NodeName::oncanplayAttr:
        return HTMLNames::oncanplayAttr;
    case NodeName::oncanplaythroughAttr:
        return HTMLNames::oncanplaythroughAttr;
    case NodeName::onchangeAttr:
        return HTMLNames::onchangeAttr;
    case NodeName::onclickAttr:
        return HTMLNames::onclickAttr;
    case NodeName::oncloseAttr:
        return HTMLNames::oncloseAttr;
    case NodeName::oncontentvisibilityautostatechangeAttr:
        return HTMLNames::oncontentvisibilityautostatechangeAttr;
    case NodeName::oncontextmenuAttr:
        return HTMLNames::oncontextmenuAttr;
    case NodeName::oncopyAttr:
        return HTMLNames::oncopyAttr;
    case NodeName::oncuechangeAttr:
        return HTMLNames::oncuechangeAttr;
    case NodeName::oncutAttr:
        return HTMLNames::oncutAttr;
    case NodeName::ondblclickAttr:
        return HTMLNames::ondblclickAttr;
    case NodeName::ondevicechangeAttr:
        return HTMLNames::ondevicechangeAttr;
    case NodeName::ondragAttr:
        return HTMLNames::ondragAttr;
    case NodeName::ondragendAttr:
        return HTMLNames::ondragendAttr;
    case NodeName::ondragenterAttr:
        return HTMLNames::ondragenterAttr;
    case NodeName::ondragleaveAttr:
        return HTMLNames::ondragleaveAttr;
    case NodeName::ondragoverAttr:
        return HTMLNames::ondragoverAttr;
    case NodeName::ondragstartAttr:
        return HTMLNames::ondragstartAttr;
    case NodeName::ondropAttr:
        return HTMLNames::ondropAttr;
    case NodeName::ondurationchangeAttr:
        return HTMLNames::ondurationchangeAttr;
    case NodeName::onemptiedAttr:
        return HTMLNames::onemptiedAttr;
    case NodeName::onendAttr:
        return SVGNames::onendAttr;
    case NodeName::onendedAttr:
        return HTMLNames::onendedAttr;
    case NodeName::onerrorAttr:
        return HTMLNames::onerrorAttr;
    case NodeName::onfocusAttr:
        return HTMLNames::onfocusAttr;
    case NodeName::onfocusinAttr:
        return HTMLNames::onfocusinAttr;
    case NodeName::onfocusoutAttr:
        return HTMLNames::onfocusoutAttr;
    case NodeName::onformdataAttr:
        return HTMLNames::onformdataAttr;
    case NodeName::onfullscreenchangeAttr:
        return HTMLNames::onfullscreenchangeAttr;
    case NodeName::onfullscreenerrorAttr:
        return HTMLNames::onfullscreenerrorAttr;
    case NodeName::ongamepadconnectedAttr:
        return HTMLNames::ongamepadconnectedAttr;
    case NodeName::ongamepaddisconnectedAttr:
        return HTMLNames::ongamepaddisconnectedAttr;
    case NodeName::ongesturechangeAttr:
        return HTMLNames::ongesturechangeAttr;
    case NodeName::ongestureendAttr:
        return HTMLNames::ongestureendAttr;
    case NodeName::ongesturestartAttr:
        return HTMLNames::ongesturestartAttr;
    case NodeName::ongotpointercaptureAttr:
        return HTMLNames::ongotpointercaptureAttr;
    case NodeName::onhashchangeAttr:
        return HTMLNames::onhashchangeAttr;
    case NodeName::oninputAttr:
        return HTMLNames::oninputAttr;
    case NodeName::oninvalidAttr:
        return HTMLNames::oninvalidAttr;
    case NodeName::onkeydownAttr:
        return HTMLNames::onkeydownAttr;
    case NodeName::onkeypressAttr:
        return HTMLNames::onkeypressAttr;
    case NodeName::onkeyupAttr:
        return HTMLNames::onkeyupAttr;
    case NodeName::onlanguagechangeAttr:
        return HTMLNames::onlanguagechangeAttr;
    case NodeName::onloadAttr:
        return HTMLNames::onloadAttr;
    case NodeName::onloadeddataAttr:
        return HTMLNames::onloadeddataAttr;
    case NodeName::onloadedmetadataAttr:
        return HTMLNames::onloadedmetadataAttr;
    case NodeName::onloadstartAttr:
        return HTMLNames::onloadstartAttr;
    case NodeName::onlostpointercaptureAttr:
        return HTMLNames::onlostpointercaptureAttr;
    case NodeName::onmessageAttr:
        return HTMLNames::onmessageAttr;
    case NodeName::onmessageerrorAttr:
        return HTMLNames::onmessageerrorAttr;
    case NodeName::onmousedownAttr:
        return HTMLNames::onmousedownAttr;
    case NodeName::onmouseenterAttr:
        return HTMLNames::onmouseenterAttr;
    case NodeName::onmouseleaveAttr:
        return HTMLNames::onmouseleaveAttr;
    case NodeName::onmousemoveAttr:
        return HTMLNames::onmousemoveAttr;
    case NodeName::onmouseoutAttr:
        return HTMLNames::onmouseoutAttr;
    case NodeName::onmouseoverAttr:
        return HTMLNames::onmouseoverAttr;
    case NodeName::onmouseupAttr:
        return HTMLNames::onmouseupAttr;
    case NodeName::onmousewheelAttr:
        return HTMLNames::onmousewheelAttr;
    case NodeName::onofflineAttr:
        return HTMLNames::onofflineAttr;
    case NodeName::ononlineAttr:
        return HTMLNames::ononlineAttr;
    case NodeName::onorientationchangeAttr:
        return HTMLNames::onorientationchangeAttr;
    case NodeName::onpagehideAttr:
        return HTMLNames::onpagehideAttr;
    case NodeName::onpagerevealAttr:
        return HTMLNames::onpagerevealAttr;
    case NodeName::onpageshowAttr:
        return HTMLNames::onpageshowAttr;
    case NodeName::onpageswapAttr:
        return HTMLNames::onpageswapAttr;
    case NodeName::onpasteAttr:
        return HTMLNames::onpasteAttr;
    case NodeName::onpauseAttr:
        return HTMLNames::onpauseAttr;
    case NodeName::onplayAttr:
        return HTMLNames::onplayAttr;
    case NodeName::onplayingAttr:
        return HTMLNames::onplayingAttr;
    case NodeName::onpointercancelAttr:
        return HTMLNames::onpointercancelAttr;
    case NodeName::onpointerdownAttr:
        return HTMLNames::onpointerdownAttr;
    case NodeName::onpointerenterAttr:
        return HTMLNames::onpointerenterAttr;
    case NodeName::onpointerleaveAttr:
        return HTMLNames::onpointerleaveAttr;
    case NodeName::onpointermoveAttr:
        return HTMLNames::onpointermoveAttr;
    case NodeName::onpointeroutAttr:
        return HTMLNames::onpointeroutAttr;
    case NodeName::onpointeroverAttr:
        return HTMLNames::onpointeroverAttr;
    case NodeName::onpointerupAttr:
        return HTMLNames::onpointerupAttr;
    case NodeName::onpopstateAttr:
        return HTMLNames::onpopstateAttr;
    case NodeName::onprogressAttr:
        return HTMLNames::onprogressAttr;
    case NodeName::onratechangeAttr:
        return HTMLNames::onratechangeAttr;
    case NodeName::onredrawAttr:
        return HTMLNames::onredrawAttr;
    case NodeName::onrejectionhandledAttr:
        return HTMLNames::onrejectionhandledAttr;
    case NodeName::onresetAttr:
        return HTMLNames::onresetAttr;
    case NodeName::onresizeAttr:
        return HTMLNames::onresizeAttr;
    case NodeName::onscrollAttr:
        return HTMLNames::onscrollAttr;
    case NodeName::onsearchAttr:
        return HTMLNames::onsearchAttr;
    case NodeName::onsecuritypolicyviolationAttr:
        return HTMLNames::onsecuritypolicyviolationAttr;
    case NodeName::onseekedAttr:
        return HTMLNames::onseekedAttr;
    case NodeName::onseekingAttr:
        return HTMLNames::onseekingAttr;
    case NodeName::onselectAttr:
        return HTMLNames::onselectAttr;
    case NodeName::onselectionchangeAttr:
        return HTMLNames::onselectionchangeAttr;
    case NodeName::onselectstartAttr:
        return HTMLNames::onselectstartAttr;
    case NodeName::onslotchangeAttr:
        return HTMLNames::onslotchangeAttr;
    case NodeName::onstalledAttr:
        return HTMLNames::onstalledAttr;
    case NodeName::onstorageAttr:
        return HTMLNames::onstorageAttr;
    case NodeName::onsubmitAttr:
        return HTMLNames::onsubmitAttr;
    case NodeName::onsuspendAttr:
        return HTMLNames::onsuspendAttr;
    case NodeName::ontimeupdateAttr:
        return HTMLNames::ontimeupdateAttr;
    case NodeName::ontoggleAttr:
        return HTMLNames::ontoggleAttr;
    case NodeName::ontouchcancelAttr:
        return HTMLNames::ontouchcancelAttr;
    case NodeName::ontouchendAttr:
        return HTMLNames::ontouchendAttr;
    case NodeName::ontouchforcechangeAttr:
        return HTMLNames::ontouchforcechangeAttr;
    case NodeName::ontouchmoveAttr:
        return HTMLNames::ontouchmoveAttr;
    case NodeName::ontouchstartAttr:
        return HTMLNames::ontouchstartAttr;
    case NodeName::ontransitioncancelAttr:
        return HTMLNames::ontransitioncancelAttr;
    case NodeName::ontransitionendAttr:
        return HTMLNames::ontransitionendAttr;
    case NodeName::ontransitionrunAttr:
        return HTMLNames::ontransitionrunAttr;
    case NodeName::ontransitionstartAttr:
        return HTMLNames::ontransitionstartAttr;
    case NodeName::onuncapturederrorAttr:
        return HTMLNames::onuncapturederrorAttr;
    case NodeName::onunhandledrejectionAttr:
        return HTMLNames::onunhandledrejectionAttr;
    case NodeName::onunloadAttr:
        return HTMLNames::onunloadAttr;
    case NodeName::onvolumechangeAttr:
        return HTMLNames::onvolumechangeAttr;
    case NodeName::onwaitingAttr:
        return HTMLNames::onwaitingAttr;
    case NodeName::onwebkitanimationendAttr:
        return HTMLNames::onwebkitanimationendAttr;
    case NodeName::onwebkitanimationiterationAttr:
        return HTMLNames::onwebkitanimationiterationAttr;
    case NodeName::onwebkitanimationstartAttr:
        return HTMLNames::onwebkitanimationstartAttr;
    case NodeName::onwebkitbeginfullscreenAttr:
        return HTMLNames::onwebkitbeginfullscreenAttr;
    case NodeName::onwebkitcurrentplaybacktargetiswirelesschangedAttr:
        return HTMLNames::onwebkitcurrentplaybacktargetiswirelesschangedAttr;
    case NodeName::onwebkitendfullscreenAttr:
        return HTMLNames::onwebkitendfullscreenAttr;
    case NodeName::onwebkitfullscreenchangeAttr:
        return HTMLNames::onwebkitfullscreenchangeAttr;
    case NodeName::onwebkitfullscreenerrorAttr:
        return HTMLNames::onwebkitfullscreenerrorAttr;
    case NodeName::onwebkitkeyaddedAttr:
        return HTMLNames::onwebkitkeyaddedAttr;
    case NodeName::onwebkitkeyerrorAttr:
        return HTMLNames::onwebkitkeyerrorAttr;
    case NodeName::onwebkitkeymessageAttr:
        return HTMLNames::onwebkitkeymessageAttr;
    case NodeName::onwebkitmouseforcechangedAttr:
        return HTMLNames::onwebkitmouseforcechangedAttr;
    case NodeName::onwebkitmouseforcedownAttr:
        return HTMLNames::onwebkitmouseforcedownAttr;
    case NodeName::onwebkitmouseforceupAttr:
        return HTMLNames::onwebkitmouseforceupAttr;
    case NodeName::onwebkitmouseforcewillbeginAttr:
        return HTMLNames::onwebkitmouseforcewillbeginAttr;
    case NodeName::onwebkitneedkeyAttr:
        return HTMLNames::onwebkitneedkeyAttr;
    case NodeName::onwebkitplaybacktargetavailabilitychangedAttr:
        return HTMLNames::onwebkitplaybacktargetavailabilitychangedAttr;
    case NodeName::onwebkitpresentationmodechangedAttr:
        return HTMLNames::onwebkitpresentationmodechangedAttr;
    case NodeName::onwebkittransitionendAttr:
        return HTMLNames::onwebkittransitionendAttr;
    case NodeName::onwheelAttr:
        return HTMLNames::onwheelAttr;
    case NodeName::onzoomAttr:
        return SVGNames::onzoomAttr;
    case NodeName::opacityAttr:
        return SVGNames::opacityAttr;
    case NodeName::openAttr:
        return HTMLNames::openAttr;
    case NodeName::operatorAttr:
        return SVGNames::operatorAttr;
    case NodeName::optimumAttr:
        return HTMLNames::optimumAttr;
    case NodeName::orderAttr:
        return SVGNames::orderAttr;
    case NodeName::orientAttr:
        return SVGNames::orientAttr;
    case NodeName::originAttr:
        return SVGNames::originAttr;
    case NodeName::overflowAttr:
        return SVGNames::overflowAttr;
    case NodeName::paint_orderAttr:
        return SVGNames::paint_orderAttr;
    case NodeName::panose_1Attr:
        return SVGNames::panose_1Attr;
    case NodeName::partAttr:
        return HTMLNames::partAttr;
    case NodeName::pathAttr:
        return SVGNames::pathAttr;
    case NodeName::pathLengthAttr:
        return SVGNames::pathLengthAttr;
    case NodeName::patternAttr:
        return HTMLNames::patternAttr;
    case NodeName::patternContentUnitsAttr:
        return SVGNames::patternContentUnitsAttr;
    case NodeName::patternTransformAttr:
        return SVGNames::patternTransformAttr;
    case NodeName::patternUnitsAttr:
        return SVGNames::patternUnitsAttr;
    case NodeName::pingAttr:
        return HTMLNames::pingAttr;
    case NodeName::placeholderAttr:
        return HTMLNames::placeholderAttr;
    case NodeName::playcountAttr:
        return HTMLNames::playcountAttr;
    case NodeName::playsinlineAttr:
        return HTMLNames::playsinlineAttr;
    case NodeName::pointer_eventsAttr:
        return SVGNames::pointer_eventsAttr;
    case NodeName::pointsAtXAttr:
        return SVGNames::pointsAtXAttr;
    case NodeName::pointsAtYAttr:
        return SVGNames::pointsAtYAttr;
    case NodeName::pointsAtZAttr:
        return SVGNames::pointsAtZAttr;
    case NodeName::pointsAttr:
        return SVGNames::pointsAttr;
    case NodeName::popoverAttr:
        return HTMLNames::popoverAttr;
    case NodeName::popovertargetAttr:
        return HTMLNames::popovertargetAttr;
    case NodeName::popovertargetactionAttr:
        return HTMLNames::popovertargetactionAttr;
    case NodeName::posterAttr:
        return HTMLNames::posterAttr;
    case NodeName::preloadAttr:
        return HTMLNames::preloadAttr;
    case NodeName::preserveAlphaAttr:
        return SVGNames::preserveAlphaAttr;
    case NodeName::preserveAspectRatioAttr:
        return SVGNames::preserveAspectRatioAttr;
    case NodeName::primitiveUnitsAttr:
        return SVGNames::primitiveUnitsAttr;
    case NodeName::progressAttr:
        return HTMLNames::progressAttr;
    case NodeName::rAttr:
        return SVGNames::rAttr;
    case NodeName::radiusAttr:
        return SVGNames::radiusAttr;
    case NodeName::readonlyAttr:
        return HTMLNames::readonlyAttr;
    case NodeName::refXAttr:
        return SVGNames::refXAttr;
    case NodeName::refYAttr:
        return SVGNames::refYAttr;
    case NodeName::referrerpolicyAttr:
        return HTMLNames::referrerpolicyAttr;
    case NodeName::relAttr:
        return HTMLNames::relAttr;
    case NodeName::repeatCountAttr:
        return SVGNames::repeatCountAttr;
    case NodeName::repeatDurAttr:
        return SVGNames::repeatDurAttr;
    case NodeName::requiredAttr:
        return HTMLNames::requiredAttr;
    case NodeName::requiredExtensionsAttr:
        return SVGNames::requiredExtensionsAttr;
    case NodeName::requiredFeaturesAttr:
        return SVGNames::requiredFeaturesAttr;
    case NodeName::restartAttr:
        return SVGNames::restartAttr;
    case NodeName::resultAttr:
        return SVGNames::resultAttr;
    case NodeName::resultsAttr:
        return HTMLNames::resultsAttr;
    case NodeName::revAttr:
        return HTMLNames::revAttr;
    case NodeName::reversedAttr:
        return HTMLNames::reversedAttr;
    case NodeName::rotateAttr:
        return SVGNames::rotateAttr;
    case NodeName::rowsAttr:
        return HTMLNames::rowsAttr;
    case NodeName::rowspanAttr:
        return HTMLNames::rowspanAttr;
    case NodeName::rspaceAttr:
        return MathMLNames::rspaceAttr;
    case NodeName::rulesAttr:
        return HTMLNames::rulesAttr;
    case NodeName::rxAttr:
        return SVGNames::rxAttr;
    case NodeName::ryAttr:
        return SVGNames::ryAttr;
    case NodeName::sandboxAttr:
        return HTMLNames::sandboxAttr;
    case NodeName::saveAttr:
        return HTMLNames::saveAttr;
    case NodeName::scaleAttr:
        return SVGNames::scaleAttr;
    case NodeName::schemeAttr:
        return HTMLNames::schemeAttr;
    case NodeName::scopeAttr:
        return HTMLNames::scopeAttr;
    case NodeName::scrollamountAttr:
        return HTMLNames::scrollamountAttr;
    case NodeName::scrolldelayAttr:
        return HTMLNames::scrolldelayAttr;
    case NodeName::scrollingAttr:
        return HTMLNames::scrollingAttr;
    case NodeName::seedAttr:
        return SVGNames::seedAttr;
    case NodeName::selectAttr:
        return HTMLNames::selectAttr;
    case NodeName::selectedAttr:
        return HTMLNames::selectedAttr;
    case NodeName::selectionAttr:
        return MathMLNames::selectionAttr;
    case NodeName::separatorAttr:
        return MathMLNames::separatorAttr;
    case NodeName::separatorsAttr:
        return MathMLNames::separatorsAttr;
    case NodeName::shadowrootclonableAttr:
        return HTMLNames::shadowrootclonableAttr;
    case NodeName::shadowrootdelegatesfocusAttr:
        return HTMLNames::shadowrootdelegatesfocusAttr;
    case NodeName::shadowrootmodeAttr:
        return HTMLNames::shadowrootmodeAttr;
    case NodeName::shadowrootserializableAttr:
        return HTMLNames::shadowrootserializableAttr;
    case NodeName::shapeAttr:
        return HTMLNames::shapeAttr;
    case NodeName::shape_renderingAttr:
        return SVGNames::shape_renderingAttr;
    case NodeName::sizeAttr:
        return HTMLNames::sizeAttr;
    case NodeName::sizesAttr:
        return HTMLNames::sizesAttr;
    case NodeName::slopeAttr:
        return SVGNames::slopeAttr;
    case NodeName::slotAttr:
        return HTMLNames::slotAttr;
    case NodeName::spacingAttr:
        return SVGNames::spacingAttr;
    case NodeName::spanAttr:
        return HTMLNames::spanAttr;
    case NodeName::specularConstantAttr:
        return SVGNames::specularConstantAttr;
    case NodeName::specularExponentAttr:
        return SVGNames::specularExponentAttr;
    case NodeName::spellcheckAttr:
        return HTMLNames::spellcheckAttr;
    case NodeName::spreadMethodAttr:
        return SVGNames::spreadMethodAttr;
    case NodeName::srcAttr:
        return HTMLNames::srcAttr;
    case NodeName::srcdocAttr:
        return HTMLNames::srcdocAttr;
    case NodeName::srclangAttr:
        return HTMLNames::srclangAttr;
    case NodeName::srcsetAttr:
        return HTMLNames::srcsetAttr;
    case NodeName::standbyAttr:
        return HTMLNames::standbyAttr;
    case NodeName::startAttr:
        return HTMLNames::startAttr;
    case NodeName::startOffsetAttr:
        return SVGNames::startOffsetAttr;
    case NodeName::stdDeviationAttr:
        return SVGNames::stdDeviationAttr;
    case NodeName::stepAttr:
        return HTMLNames::stepAttr;
    case NodeName::stitchTilesAttr:
        return SVGNames::stitchTilesAttr;
    case NodeName::stop_colorAttr:
        return SVGNames::stop_colorAttr;
    case NodeName::stop_opacityAttr:
        return SVGNames::stop_opacityAttr;
    case NodeName::stretchyAttr:
        return MathMLNames::stretchyAttr;
    case NodeName::strokeAttr:
        return SVGNames::strokeAttr;
    case NodeName::stroke_dasharrayAttr:
        return SVGNames::stroke_dasharrayAttr;
    case NodeName::stroke_dashoffsetAttr:
        return SVGNames::stroke_dashoffsetAttr;
    case NodeName::stroke_linecapAttr:
        return SVGNames::stroke_linecapAttr;
    case NodeName::stroke_linejoinAttr:
        return SVGNames::stroke_linejoinAttr;
    case NodeName::stroke_miterlimitAttr:
        return SVGNames::stroke_miterlimitAttr;
    case NodeName::stroke_opacityAttr:
        return SVGNames::stroke_opacityAttr;
    case NodeName::stroke_widthAttr:
        return SVGNames::stroke_widthAttr;
    case NodeName::styleAttr:
        return HTMLNames::styleAttr;
    case NodeName::subscriptshiftAttr:
        return MathMLNames::subscriptshiftAttr;
    case NodeName::subtitleAttr:
        return HTMLNames::subtitleAttr;
    case NodeName::summaryAttr:
        return HTMLNames::summaryAttr;
    case NodeName::superscriptshiftAttr:
        return MathMLNames::superscriptshiftAttr;
    case NodeName::surfaceScaleAttr:
        return SVGNames::surfaceScaleAttr;
    case NodeName::switchAttr:
        return HTMLNames::switchAttr;
    case NodeName::symmetricAttr:
        return MathMLNames::symmetricAttr;
    case NodeName::systemLanguageAttr:
        return SVGNames::systemLanguageAttr;
    case NodeName::tabindexAttr:
        return HTMLNames::tabindexAttr;
    case NodeName::tableValuesAttr:
        return SVGNames::tableValuesAttr;
    case NodeName::targetAttr:
        return HTMLNames::targetAttr;
    case NodeName::targetXAttr:
        return SVGNames::targetXAttr;
    case NodeName::targetYAttr:
        return SVGNames::targetYAttr;
    case NodeName::textAttr:
        return HTMLNames::textAttr;
    case NodeName::textLengthAttr:
        return SVGNames::textLengthAttr;
    case NodeName::text_anchorAttr:
        return SVGNames::text_anchorAttr;
    case NodeName::text_decorationAttr:
        return SVGNames::text_decorationAttr;
    case NodeName::text_renderingAttr:
        return SVGNames::text_renderingAttr;
    case NodeName::toAttr:
        return SVGNames::toAttr;
    case NodeName::topmarginAttr:
        return HTMLNames::topmarginAttr;
    case NodeName::transformAttr:
        return SVGNames::transformAttr;
    case NodeName::transform_originAttr:
        return SVGNames::transform_originAttr;
    case NodeName::translateAttr:
        return HTMLNames::translateAttr;
    case NodeName::truespeedAttr:
        return HTMLNames::truespeedAttr;
    case NodeName::u1Attr:
        return SVGNames::u1Attr;
    case NodeName::u2Attr:
        return SVGNames::u2Attr;
    case NodeName::uiactionsAttr:
        return HTMLNames::uiactionsAttr;
    case NodeName::unicodeAttr:
        return SVGNames::unicodeAttr;
    case NodeName::unicode_bidiAttr:
        return SVGNames::unicode_bidiAttr;
    case NodeName::units_per_emAttr:
        return SVGNames::units_per_emAttr;
    case NodeName::usemapAttr:
        return HTMLNames::usemapAttr;
    case NodeName::useragentpartAttr:
        return HTMLNames::useragentpartAttr;
    case NodeName::valignAttr:
        return HTMLNames::valignAttr;
    case NodeName::valueAttr:
        return HTMLNames::valueAttr;
    case NodeName::valuesAttr:
        return SVGNames::valuesAttr;
    case NodeName::valuetypeAttr:
        return HTMLNames::valuetypeAttr;
    case NodeName::vector_effectAttr:
        return SVGNames::vector_effectAttr;
    case NodeName::versionAttr:
        return HTMLNames::versionAttr;
    case NodeName::vert_adv_yAttr:
        return SVGNames::vert_adv_yAttr;
    case NodeName::vert_origin_xAttr:
        return SVGNames::vert_origin_xAttr;
    case NodeName::vert_origin_yAttr:
        return SVGNames::vert_origin_yAttr;
    case NodeName::viewBoxAttr:
        return SVGNames::viewBoxAttr;
    case NodeName::viewTargetAttr:
        return SVGNames::viewTargetAttr;
    case NodeName::visibilityAttr:
        return SVGNames::visibilityAttr;
    case NodeName::vlinkAttr:
        return HTMLNames::vlinkAttr;
    case NodeName::voffsetAttr:
        return MathMLNames::voffsetAttr;
    case NodeName::vspaceAttr:
        return HTMLNames::vspaceAttr;
    case NodeName::webkit_playsinlineAttr:
        return HTMLNames::webkit_playsinlineAttr;
    case NodeName::webkitairplayAttr:
        return HTMLNames::webkitairplayAttr;
    case NodeName::webkitallowfullscreenAttr:
        return HTMLNames::webkitallowfullscreenAttr;
    case NodeName::webkitattachmentbloburlAttr:
        return HTMLNames::webkitattachmentbloburlAttr;
    case NodeName::webkitattachmentidAttr:
        return HTMLNames::webkitattachmentidAttr;
    case NodeName::webkitattachmentpathAttr:
        return HTMLNames::webkitattachmentpathAttr;
    case NodeName::webkitdirectoryAttr:
        return HTMLNames::webkitdirectoryAttr;
    case NodeName::webkitdropzoneAttr:
        return HTMLNames::webkitdropzoneAttr;
    case NodeName::webkitwirelessvideoplaybackdisabledAttr:
        return HTMLNames::webkitwirelessvideoplaybackdisabledAttr;
    case NodeName::widthAttr:
        return HTMLNames::widthAttr;
    case NodeName::word_spacingAttr:
        return SVGNames::word_spacingAttr;
    case NodeName::wrapAttr:
        return HTMLNames::wrapAttr;
    case NodeName::writing_modeAttr:
        return SVGNames::writing_modeAttr;
    case NodeName::writingsuggestionsAttr:
        return HTMLNames::writingsuggestionsAttr;
    case NodeName::x1Attr:
        return SVGNames::x1Attr;
    case NodeName::x2Attr:
        return SVGNames::x2Attr;
    case NodeName::xAttr:
        return SVGNames::xAttr;
    case NodeName::xChannelSelectorAttr:
        return SVGNames::xChannelSelectorAttr;
    case NodeName::x_apple_data_detectorsAttr:
        return HTMLNames::x_apple_data_detectorsAttr;
    case NodeName::x_apple_data_detectors_resultAttr:
        return HTMLNames::x_apple_data_detectors_resultAttr;
    case NodeName::x_apple_data_detectors_typeAttr:
        return HTMLNames::x_apple_data_detectors_typeAttr;
    case NodeName::x_apple_pdf_annotationAttr:
        return HTMLNames::x_apple_pdf_annotationAttr;
    case NodeName::x_heightAttr:
        return SVGNames::x_heightAttr;
    case NodeName::x_itunes_inherit_uri_query_componentAttr:
        return HTMLNames::x_itunes_inherit_uri_query_componentAttr;
    case NodeName::y1Attr:
        return SVGNames::y1Attr;
    case NodeName::y2Attr:
        return SVGNames::y2Attr;
    case NodeName::yAttr:
        return SVGNames::yAttr;
    case NodeName::yChannelSelectorAttr:
        return SVGNames::yChannelSelectorAttr;
    case NodeName::zAttr:
        return SVGNames::zAttr;
    case NodeName::zoomAndPanAttr:
        return SVGNames::zoomAndPanAttr;
    case NodeName::XLink_hrefAttr:
        return XLinkNames::hrefAttr;
    case NodeName::XLink_roleAttr:
        return XLinkNames::roleAttr;
    case NodeName::XLink_titleAttr:
        return XLinkNames::titleAttr;
    case NodeName::XLink_typeAttr:
        return XLinkNames::typeAttr;
    case NodeName::XML_langAttr:
        return XMLNames::langAttr;
    case NodeName::hrefAttr:
        return HTMLNames::hrefAttr;
    case NodeName::langAttr:
        return HTMLNames::langAttr;
    case NodeName::roleAttr:
        return HTMLNames::roleAttr;
    case NodeName::titleAttr:
        return HTMLNames::titleAttr;
    case NodeName::typeAttr:
        return HTMLNames::typeAttr;
    }
    return nullQName();
}

} // namespace WebCore
