The build system is built around an Automake-replacing Makefile
snippet system for GNU Make that I (lukeshu) wrote, called Autothing.
It is documented in `build-aux/Makfile.README.txt`.  It provides all
of the standard targets and such; you tell it what to do by setting a
series of `at.whatever` or `module.whatever` variables.

There are a couple of variables that get automatically set from Git.
This happens by `include`ing a hidden makefile that sets them; if
`$(topsrcdir)/.git` exists, it knows to use Git to generate it;
otherwise it expects the file to exist:

| variable             | file                                     |
|----------------------+------------------------------------------|
| `files.src.src`      | `$(topsrcdir)/.srcfiles.mk`              |
| `LIBRETOOLS_VERSION` | `$(topsrcdir)/.srcversion-libretools.mk` |
| `LIBRETOOLS_COMMIT`  | `$(topsrcdir)/.srcversion-libretools.mk` |
| `DEVTOOLS_VERSION`   | `$(topsrcdir)/.srcversion-devtools.mk`   |
| `DEVTOOLS_COMMIT`    | `$(topsrcdir)/.srcversion-devtools.mk`   |

Now, the `Makefile`s in each directory are pretty bare.  Most of
everything can be guesses by inspecting `$(files.src.src)` (Want to
add a shell program?  Just commit the executable; the Makefile will
see it.)  So, most of the real Makefile stuff is in the files
`build-aux/Makefile.*/??-libretools.mk`.

<!--
  Copyright (C) 2016-2017, 2024  Luke T. Shumaker <lukeshu@parabola.nu>

  SPDX-License-Identifier: GPL-2.0-or-later

  This file is part of Parabola Libretools.

  Libretools is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  Libretools is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
