`SOURCE_DATE_EPOCH` / clamp-mtime
=================================

`librefetch` respects `SOURCE_DATE_EPOCH`[1] for reproducible builds,
and has had this behavior from the start (though the variable name
wasn't there from the start, that came later).  But how can this be!?
If you asked h01ger (the guy heading up reproducible builds in Debian
and Fedora), tar needs to support `--clamp-mtime` to do this, and that
flag wasn't in any tar implementation when librefetch came into
existence.  The flag not yet being in upstream GNU tar was for a long
time the biggest blocker to most of upstream Debian being
reproducible!

While it is a nice flag that I'm surprised wasn't added years ago,
it's trivial to just adjust the input files first:

    find . -exec touch --no-dereference --date=DATE -- {} +`

Of course, `--clamp-mtime`/`--mtime` is now in upstream GNU tar.  So
librefetch supporting this is no longer impressive.  But, librefetch
still isn't using `--mtime`.  Why?  Well, because it uses libarchive
`bsdtar`, not GNU tar, and bsdtar still doesn't have the flag.

I wrote this document mostly because I expect that sometime in the
future I'll think to myself "I should simplify the code and just use
`--mtime`", not remembering the differences between tars.

[1]: https://reproducible-builds.org/specs/source-date-epoch/

-- lukeshu

program flow
============

This is the internal `libremakepkg` program flow for a `PKGBUILD` with
`mksource()`.

Given:

  * a PKGBUILD with a `mksource()` function and a repo.parabola.nu URL
    in `source=()`
  * `/etc/makepkg.conf.d/librefetch.conf` is sourced by makepkg
  * the checksum has be generated with: `librefetch -g`, and added to
    `mksha256sums=()`
  * `mk*sums=()` is populated with a checksum for each `mksource=()`
    (use: `librefetch -g`)
  * `*sums=()` is populated with `'SKIP'` for each `source=()` (add it
    before publishing the `PKGBUILD`)

Then:

 * `/usr/bin/libremakepkg`:
    - `msg 'Starting pre-build activities...'`
    - `msg 'Downloading sources...'`
    - `/usr/lib/libretools/chroot/makechrootpkg.sh::download_sources()`

 * `/usr/lib/libretools/chroot/makechrootpkg.sh::download_sources()`:
    - `/usr/bin/makepkg --allsource` (w/ special ENV and in-chroot makepkg.conf)

 * `/usr/bin/makepkg --allsource` ($SOURCEONLY == 2):
    - `msg "Making package:"`
    - `/usr/share/makepkg/source.sh::download_sources('allarch')`

 * `/usr/share/makepkg/source.sh::download_sources()`:
    - `msg "Retrieving sources..."`
    - (`/usr/bin/librefetch` is download agent)

 * `/usr/bin/librefetch::doit()`:
    - 'download' mode ($src == PKGBUILD::source() , $inmirror == true)
       * if found
          - return to `/usr/bin/makepkg`
       * if not found
          - 'create' mode
          - `/tmp/<SPECIAL>/makepkg -p /tmp/<SPECIAL>/PKGBUILD`

 * `/tmp/<SPECIAL>/makepkg` (SOURCEONLY == 0):
    - `msg "Making source:"`
    - `msg "Checking source dependencies..."`
    - `/tmp/<SPECIAL>/source.sh::download_sources('allarch')`

 * `/tmp/<SPECIAL>/source.sh::download_sources()`:
    - `msg "Retrieving sources..."`
    - (`/usr/bin/librefetch` is download agent)

 * `/usr/bin/librefetch::doit()`:
    - 'download' mode ($src == PKGBUILD::mksource() , $inmirror == false)
    - return to `/tmp/<SPECIAL>/makepkg`

 * `/tmp/<SPECIAL>/makepkg` (post-return from `/usr/bin/librefetch)`:
    - NOTE: all standard `PKGBUILD` functions are stubbed out, with
      the only purpose to run the real `PKGBUILD::mksource()` the
      standard functions in the real `PKGBUILD` will run later in the
      chroot.
    - `msg "Validating source files"`
    - `msg "Extracting sources..."`
    - `msg "Starting prepare()"`
    - `msg "Starting build()"`
       * `msg "Starting mksource()"`
       * `PKGBUILD::mksource()`
    - `msg "Starting check()"`
    - `msg "Starting package()"`
    - `msg "Creating package"`
    - `msg "Finished making:"`

 * NOTE: here we rewind back to
   `/usr/lib/libretools/chroot/makechrootpkg.sh::download_sources()`
   to get/create the source-ball signature

 * `/usr/bin/librefetch::doit()`:
    - 'download' mode
       - if not found
          * 'create' mode ($src == PKGBUILD::source() , $inmirror == true)
             - `/usr/bin/librefetch::create_signature()`

 * `/usr/bin/librefetch::create_signature()`
    - `msg "Signing package..."`
    - `/usr/share/makepkg/integrity.sh::check_source_integrity()`
       * `/usr/share/makepkg/integrity/verify_checksum.sh`
          - `msg "Validating source files"`
       * `/usr/share/makepkg/integrity/verify_signature.sh`
          - `msg "Verifying source file signatures with gpg"`

 * NOTE: here we rewind back to `/tmp/<SPECIAL>/makepkg`

 * `/tmp/<SPECIAL>/makepkg`:
    - `msg "Source package created:"`
    - `exit`

 * NOTE: then we rewind back to
   `/usr/lib/libretools/chroot/makechrootpkg.sh::download_sources()`
   which returns to `/usr/bin/libremakepkg`

 * `/usr/bin/libremakepkg`:
    - `msg "Starting to build the package"`
    - NOTE: build package in the normal way

-- bill-auger

<!--
  Copyright (C) 2016, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
  Copyright (C) 2020  Bill Auger <bill-auger@programmer.net>

  SPDX-License-Identifier: GPL-2.0-or-later

  This file is part of Parabola Libretools.

  Libretools is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  Libretools is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
