Translations for programs are provided in files with the `.po` suffix. These are
created by copying PO-template (`.pot`) files, and filling in the missing
"msgstr" values.

To add a translation, you'll first (1) need to create the `.pot` files if you
don't already have them, and then (2) copy them and (3) fill them in.


## 1. Create the `.pot` files

If you are working from a release source tarball, you can skip this step (the
`.pot` files are included in the tarball); if you are working from Git, read on.

libretools' .pot files are not tracked in Git; they are created by running
`make`.  You'll need a checkout of both 'devtools-par' and 'libretools' to run
`make` if building from Git. The 'devtools-par' and 'libretools' source root
directories should have the same parent directory.

    $ git clone https://git.parabola.nu/packages/libretools.git/
    $ git clone https://git.parabola.nu/packages/devtools-par.git/
    $ cd libretools
    $ make po/files.generate
    $ cd po/
    $ ls
    gitget.pot
    librelib.pot
    libretools.pot

NOTE: If you have modified the libretools source code, that may cause errors
during translation; especially if you have modified any of the translatable
strings. The failure will be evident by the error message:

    msgcmp: found N fatal errors

If you see this error, refer to the "Updating translations" section below.


## 2. Create the `.po` Files

Create a folder under `po/` with the two-letter language code[^1] you want to
add.  Then, copy the `.pot` files to that folder, changing the file extension to
`.po`.  Finally, link the `subdir.mk` file as the Makefile for that directory.
For example:

    $ mkdir es
    $ for file in *.pot; do cp $file es/${file%t}; done
    $ ln -s ../subdir.mk es/Makefile

[^1]: See the language code table: <http://www.lingoes.net/en/translator/langcode.htm>


## 3. Fill the `.po` Files

From there you can open each .po file in your favorite text editor, and fill in
the `msgstr` values with translations of the associated `msgid` keys.


## 4. Synchronizing/Updating Translations

Normally, the translations are prepared as part of the dist make target
(the same command used to generate the release source-ball). Eg:

    $ make dist

However, if you have modified the libretools source code significantly or
modified any translatable strings, it is likely that the `make` command will
fail, due to the translation files being mis-aligned with the latest changes.
You will need to run `msgmerge` to merge the newly generated .pot templates
into the existing .po files, as indicated by the `msgcmp` command traces in
the build log.

Eg: If the following error message appeers after this log trace:

    msgcmp --use-untranslated --use-fuzzy po/es/libretools.po po/libretools.pot
    ....
    msgcmp: found 42 fatal errors

then run:

    $ make msgmerge

Notice any red (fuzzy) lines. Those are relatively minor mis-matches, which the
tool was able to reconcile, but may need correction. Also notice any green,
commented-out, 'msgid'/'msgstr' line pairs. Those are unresolved mis-matches,
which definitely need correction. They may correspond to a new 'msgid'/'msgstr'
line pair in the `msgmerge` output, with the new text as 'msgid', and an empty
'msgstr'; but the changes were too significant for the tool to determine the
correlation. The standard output of `msgmerge` is the raw text for a new
replacemnt .po file. Next, direct the output to a file, make the corrections
to the replacemnt .po file, using the `msgmerge` output as a guide; then replace
the failed .po file with the new corrected file.

    $ msgmerge --indent --no-location po/es/libretools.po po/libretools.pot > po/es/libretools.po-merged
    $ mv po/es/libretools.po{-merged,}

Alternatively, a merge tool such as `meld`, is especially helpful for this task.
A merge tool should highlight the same merge conflicts, shown in the the
`msgmerge` output, as a side-by-side comparison, allowing you to merge the
changes from the generated '-merged' file, into the tracked .po file, in-place.
In order to minimize the possible merge conflict next time, it is best to merge
all of the changes, especially the comments with line numbers.

    $ meld po/es/libretools.po{-merged,}

Once `make clean && make` is able to complete successfully, commit the new .po
file to the VCS.

    $ git commit -m 'sync translations' po/es/libretools.po

<!--
  Copyright (C) 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
  Copyright (C) 2020, 2022  Bill Auger <bill-auger@programmer.net>

  SPDX-License-Identifier: GPL-2.0-or-later

  This file is part of Parabola Libretools.

  Libretools is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  Libretools is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
