libretools release process
==========================

This is the release process that I (LukeShu) follow (up-to-date as of
2024-05-10):

Go through these steps; if any step fails, then jump to the "error
handling" section.

  1. Ensure that the tests pass; as described in [./testing.md][], I
     run the tests as

         sudo echo && TMPDIR=/var/lib/archbuild/tmp make check

     where `/var/lib/archbuild/tmp` is a directory owned by my normal
     (non-root) user on a btrfs volume.  I do not bother to run the
     tests on a non-btrfs volume, although I arguably should.

  2. Look over the commits going into the release, and draft a release
     announcement email.  I try to follow the same general format for
     each announcement; check the mailing list archives for that
     format.

  3. Create a local `vYYYYMMDD[.N]` tag in libretools.git.  The ".N"
     suffix is for if this isn't the first release of the day.

  4. If the devtools-par.git commit has changed since the last
     libretools release: Create a corresponding local
     `libretools-YYYYMMDD[.N]` tag in devtools-par.git.

  5. Run `make dist` in the libretools.git checkout.

  6. Copy the resulting `libretools-*.tar.gz` file to
     `makepkg.conf:SRCDEST` (on my machine, that's
     `~/packages/srcdest/`).

  7. Update `libre/libretools/PKGBUILD` in abslibre.git.  Running
     `updpkgsums` will prompt me for my GnuPG credentials to create a
     `.sig` for that tarball.

  8. Run `sudo libremakepkg`.

  9. Install the built packages from `makepkg.conf:PKGDEST` (on my
     machine, that's `~/packages/pkgdest/`)

 10. Do any additional manual testing that is relevant to changes in
     this particular release.

 11. Run `librestage` and `librerelease`.  Doing this *after*
     installing them in step 9 at least verifies that the new
     libretools release is able to release itself.

 12. Push any Git refs (tags/branches) from `libretools.git`,
     `devtools-par.git`, or `abslibre.git`.

 13. Hit "send" on the release announcement email.

## Error handling

If any of the normal steps fails and I need to edit what's in the
release, I:

  1. Delete any local Git tags that I created.

  2. Delete any files from `makepkg.conf:SRCDEST` (on my machine,
     that's `~/packages/srcdest/`).

  3. Make whatever commits I need to.

  4. Start the process over.

<!--
  Copyright (C) 2024  Luke T. Shumaker <lukeshu@parabola.nu>

  SPDX-License-Identifier: GPL-2.0-or-later

  This file is part of Parabola Libretools.

  Libretools is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  Libretools is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
