Testing
=======

Please write unit tests for new things.  Tests can be run with `make check`,
which just runs `./testenv bats cases` in the `test/` directory.  You will need
the `bats` tool and the `bats-assert` and `bats-file` support libraries (the
`bats-assert` and `bats-file` Parabola package) in order to run the tests.
`bats` can be given `--filter-tags !network,!sudo,!btrfs,!locale-es` to disable
tests which require those things.  `make check` can be made to pass those flags
in by setting `BATS_FLAGS`.  If `!btrfs` is not given, then TMPDIR *must* be on
btrfs partition (or else the tests that need btrfs will fail).  If `!locale-es`
is not given, then an `es_*` locale must be enabled in `/etc/locale.gen`.  If
neither `!network` nor `!sudo` is given, then I *strongly* recommend setting
TMPDIR to somewhere on a btrfs partition; otherwise the chroot tests will take
forever.  I mean, they already take long on btrfs, but without it... _dang_.

> I (LukeShu) run the tests with:
>
>     sudo echo && TMPDIR=/var/lib/archbuild/tmp make check
>
> The `sudo echo` is so that I don't get prompted for my password in
> the middle of the run.  The `TMPDIR` is to point it at a btrfs
> volume with sufficient free space--my normal `/tmp` or `$TMPDIR` are
> too small for the tests.

<!--
  Copyright (C) 2013-2016, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
  Copyright (C) 2024  Bill Auger <bill-auger@programmer.net>

  SPDX-License-Identifier: GPL-2.0-or-later

  This file is part of Parabola Libretools.

  Libretools is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  Libretools is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
