The 'auto-thing' build-system is quite magical. Gererally, it is not
necessary to modify any of the Makefiles. New files are detected and handled
automagically, based on the VCS. The only caveat of building from VCS
is the weird dependence on the 'devtools-par' source code.

The build system will look for 'devtools-par' in a sibling directory
($(topdir)/../devtools-par) and copy the relevant files into the
libretools directory.  This can be changed by adjusting the
`devtoolsdir` configuration variable, see "Configuration" in the main
INSTALL file.  If the `$(devtoolsdir)` directory does not exist, but
all of the copied files exist in the libretools directory, they will
simply be used. The distribution tarball includes the copies of the
devtools files, so it is not necessary to download the devtools source
separately when using the tarball.

Once you have the devtools source taken care of, you can build and
install like normal.

  $ make clean
  $ make

Both `make clean` and `make ` are important if the sources have been modified
significantly, in order to pick-up new scripts, documentation changes, and new
translation strings. if you get errors, read [./HACKING/dir-translations.md][].

To generate the libretools source-ball expected by the libretools PKGBUILD,
ensure that a versioned git tag exists of the form: vYYYYMMDD (e.g. v20190907)
on the currently checked-out branch of the libretools git repo. If the
'devtools-par' code has also changed, ensure that a versioned git tag exists of
the form: libretools-YYYYMMDD on the currently checked-out branch of
'devtools-par'. Then build the source tarball with a command of this form:

  $ make clean
  $ make
  $ make dist

Again, run `make clean` and `make` if you have made significant code changes,
including to 'devtools-par', to ensure that everything is in-sync.

This will produce two archives named as one of the following forms:
  libretools-YYYYMMDD.tar{,.gz}
  libretools-YYYYMMDD-N-XXXXXXXX.tar{,.gz}

where: 'YYYYMMDD' is taken from the git tag
       'N' is the number of commits on above the tag
       'XXXXXXXX' is the git hash of the branch tip

Two stamps will also be created:

  $ cat ./.srcversion-*
  DEVTOOLS_VERSION = YYYYMMDD
  DEVTOOLS_COMMIT = XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
  LIBRETOOLS_VERSION = YYYYMMDD
  LIBRETOOLS_COMMIT = XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

Normally, we want a source-ball named of the first form uploaded
to the repo server. That is what the PKGBUILD source expects; so
the ideal situation is when the version tag is on the tip of the
branch. In that case, the 'N' and the git hash are not appended
to the filename. If necessary, you can specify a name of the
outputs explicitly:

  $ make clean
  $ make
  $ make dist LIBRETOOLS_VERSION=YYYYMMDD

But that would probably imply replacing the existing source-ball
with the same name on the server (the initial release); so it
would be better to adjust the PKGBUILD, for minor revisions, to
expect the new revision filename instead.

<!--
  Copyright (C) 2016, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
  Copyright (C) 2020, 2022  Bill Auger <bill-auger@programmer.net>

  SPDX-License-Identifier: GPL-2.0-or-later

  This file is part of Parabola Libretools.

  Libretools is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  Libretools is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
