Installation of libretools is pretty straight-forward:

  $ make
  # make install

As a caveat, by default, if the directory `devtools-par` exists in the
same directory as the `libretools-${version}` directory, and contains
newer files than the libretools directory, they will be copied into
the libretools directory.  See INSTALL-VCS for more details.


Dependencies
------------

Unlike a lot of software, run-time dependencies are not required at
build-time.

Libretools is mostly shell scripts.  It very specifically targets
Parabola GNU/Linux-libre; there are a lot of dependencies, most of
which are undocumented.  Switching away from a GNU user-land is bound
to cause issues.

## Build dependencies

The "unusual" build-time dependencies are:

-------------------------------------------------------------------------------------------
| build dependency | parabola package | notes                                             |
|------------------|------------------|---------------------------------------------------|
| devtools-par     | n/a              | https://git.parabola.nu/packages/devtools-par.git |
| GNU Make         | 'make'           | strict requirement of the AutoThing build system  |
| sed              | 'sed'            | must support Extended Regular Expressions         |
| ronn             | 'ruby-ronn-ng'   | a markdown-to-manpage converter                   |
-------------------------------------------------------------------------------------------

Whether or not to build the manpages is controlled by whether
config.mk:enable_manpages is empty (disable) or non-empty (enable).
If it is disabled, then `ronn` is not needed.

Additionally, other usual "core utilities" are required:

    cat, chmod, cp, echo, false, find, install, ln, msguniq, rm, tr,
    xgettext

Also, `/bin/sh` must support `{brace,expansion}`.  If it doesn't, find
a shell that does, and configure `make` to use it.  Though, because
libretools is mostly shell scripts, if you deviate too much from a GNU
command-line environment, I suspect that you will run into more
issues.  If I were targeting anything other than Parabola, this would
be a bigger issue.

## Test suite dependencies

If you wish to run the test suite, you will need the "BATS" shell unit
testing program, as well as the `bats-assert` and `bats-file` support
libraries.  On Parabola GNU/Linux-libre these are called "bats",
"bats-assert", and "bats-file" respectively.  If your operating system
doesn't have these, they are available at
<https://github.com/bats-core/bats-core>,
<https://github.com/bats-core/bats-assert>, and
<https://github.com/bats-core/bats-file> respectively.

## Run-time dependencies

Being mostly shell scripts, many external program are used.  The
dependencies of the Parabola GNU/Linux 'parabola-base' meta-package,
are assumed to be implicit dependencies of this script.  If something
isn't used now, that doesn't mean it won't be in the future.

Additionally, the following per-subpackage dependencies are needed:

----------------------------------------------------------------------------------------------
| librelib dependency   | parabola package  | usage                                          |
|-----------------------|-------------------|------------------------------------------------|
| wget                  | 'wget'            | (optional) used by `blacklist.sh`              |
----------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------
| gitget dependency     | parabola package  | usage                                          |
|-----------------------|-------------------|------------------------------------------------|
| git                   | 'git'             | core functionality                             |
| librelib              | provided          | ubiquitous use of `librelib` confs and helpers |
----------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------
| libretools dependency | parabola package  | usage                                          |
|-----------------------|-------------------|------------------------------------------------|
| arch-install-scripts  | 'base'            | used by `mkarchroot`->`pacstrap`               |
| binutils              | 'binutils'        | used by `libremakepkg`->`makepkg`->`strip`     |
| expac                 | 'expac'           | used by `libredbdiff`                          |
| fakeroot              | 'fakeroot'        | used by `libremakepkg`->`makepkg`->`fakeroot`  |
| gitget                | provided          | used by `createworkdir`                        |
| librelib              | provided          | ubiquitous use of `librelib` confs and helpers |
| GNU Make              | 'make'            | used by `librefetch`                           |
| pacman >= v5.0        | 'base'            | used by `libremakepkg`->`makepkg`              |
| pacman-contrib        | 'pacman-contrib'  | used by `librefetch`->`updpkgsums`             |
| namcap                | 'namcap'          | used by `libremakepkg` (currently disabled)    |
| rsync                 | 'rsync'           | used by `librerelease`,`makechrootpkg.sh`      |
| ssh client            | 'openssh'         | used by `librerelease`                         |
| subversion            | 'subversion'      | used by `diff-unfree`                          |
| systemd               | 'libre/base'      | used by arch-nspawn->systemd-nspawn            |
| chroot-nspawn         | 'nonsystemd/base' | used by arch-nspawn->systemd-nspawn            |
| tokyocabinet          | 'tokyocabinet'    | used by `toru`                                 |
----------------------------------------------------------------------------------------------


Configuration
-------------

This is not a GNU package, there is no `./configure` script.

There are two ways to set configuration variables:
 1. Edit config.mk
 2. Pass `VARIABLE=VALUE` to `make`

The configuration variables mostly match GNU packages, but default
values differ; libretools installs to `prefix=/usr` by default instead
of GNU's `prefix=/usr/local`.


Building and installing subpackages
-----------------------------------

There are several sub-packages you can build and install.

 - gitget     -- A git downloader
 - librelib   -- Generic libraries included
 - libretools -- The main libretools package

This is done by running:

  $ make build-<SUBPACKAGE>
  # make install-<SUBPACKAGE>

In addition to `build-*` and `install-*`, there are these general activities:

 - `copy`    -- copy necessary files from the devtools-par source code
 - `build`   -- build all programs and files
 - `clean`   -- remove generated files
 - `install` -- install everything

<!--
  Copyright (C) 2013-2014, 2016-2018, 2024, 2026  Luke T. Shumaker <lukeshu@parabola.nu>
  Copyright (C) 2020  Bill Auger <bill-auger@programmer.net>

  SPDX-License-Identifier: GPL-2.0-or-later

  This file is part of Parabola Libretools.

  Libretools is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  Libretools is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
