# Copyright (C) 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Libretools.  If not, see <http://www.gnu.org/licenses/>.

pkgconfdir    = $(sysconfdir)/libretools.d
pkglibexecdir = $(libexecdir)/libretools
pkglibdir     = $(libdir)/libretools

# Auto-detect ########################################################

libretools.pkg = libretools

libretools.src.devtools =

libretools.out.mans     = $(patsubst %.ronn,%,$(libretools.src.ronn))
libretools.out.bins     = $(libretools.src.exec)
libretools.out.libexecs =
libretools.out.libs     = $(libretools.src.sh)
libretools.out.docs     = $(libretools.src.md)
libretools.out.confs    = $(libretools.src.conf)

libretools.out  = $(if $(enable_manpages),$(libretools.out.mans))
libretools.out += $(libretools.out.bins)
libretools.out += $(libretools.out.libexecs)
libretools.out += $(libretools.out.libs)
libretools.out += $(libretools.out.docs)
libretools.out += $(libretools.out.confs)

libretools.pots  = $(libretools.out.bins)
libretools.pots += $(libretools.out.libexecs)
libretools.pots += $(libretools.out.libs)
