# Copyright (C) 2016-2017  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: AGPL-3.0-or-later
#
# This file is part of Autothing.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

mod.var.description = Depend on the values of variables
define mod.var.doc
# Inputs:
#   (user-defined)
# Outputs:
#   Target            : `$(outdir)/.var.%`
#   Directory variable: `at.targets`
#   Directory variable: `var.`
#
# It's a well-known secret that many files generated by a Makefile vary with
# the values of particular variables, but that GNU Make can't track these
# dependencies.  Well, with some cleverness, it actually can!
#
# With this module, to depend on the value of a variable, depend on
# `$(outdir)/.var.VARNAME`, or `$(var.)VARNAME` for short.
endef
mod.var.doc := $(value mod.var.doc)

var. = $(patsubst ./%,%,$(outdir)/.var.)

.PHONY: _var.FORCE
