# Copyright (C) 2016  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: AGPL-3.0-or-later
#
# This file is part of Autothing.
#
# Autothing is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Autothing is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

mod.write-ifchanged.description = `write-ifchanged` auxiliary build script
mod.write-ifchanged.files += $(topsrcdir)/build-aux/write-ifchanged
define mod.write-ifchanged.doc
# User variables:
#   - `WRITE_IFCHANGED ?= $(topsrcdir)/build-aux/write-ifchanged`
# Inputs:
#   (none)
# Outputs:
#   (none)
#
# The $(WRITE_IFCHANGED) program reads a file from stdin, and writes it to the
# file named in argv[1], but does so atomically, but more importantly, does so
# in a way that does not bump the file's ctime if the new content is the same
# as the old content.
#
# That is, the following lines are almost equivalient:
#
#     ... > $@
#     ... | $(WRITE_ATOMIC) $@
endef
mod.write-ifchanged.doc := $(value mod.write-ifchanged.doc)

WRITE_IFCHANGED ?= $(topsrcdir)/build-aux/write-ifchanged
