# Copyright (C) 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

include $(dir $(lastword $(MAKEFILE_LIST)))/../../config.mk
include $(topsrcdir)/build-aux/Makefile.head.mk

locale = $(notdir $(srcdir))
domains = $(patsubst %.po,%,$(filter %.po,$(files.src.src)))

$(outdir)/%.mo: $(srcdir)/%.po $(call at.path,$(srcdir)/../%.pot)
	msgcmp --use-untranslated --use-fuzzy $< $(word 2,$^)
	msgfmt -c --use-fuzzy -o $@ $<

$(DESTDIR)$(localedir)/$(locale)/LC_MESSAGES/%.mo: $(outdir)/%.mo
	install -T -Dm644 '$<' '$@'

define _domain_rule
files.out.$(domain) += $(domain).mo
files.sys.$(domain) += $(localedir)/$(locale)/LC_MESSAGES/$(domain).mo
endef
$(eval $(foreach domain,$(domains),$(_domain_rule)$(at.nl)))

$(outdir)/%.msgmerge: $(srcdir)/%.po $(call at.path,$(srcdir)/../%.pot)
	msgmerge --indent --no-location --update $< $(word 2,$^)
at.targets += $(outdir)/%.msgmerge
.PHONY: $(outdir)/%.msgmerge

$(outdir)/msgmerge: $(foreach domain,$(domains),$(outdir)/$(domain).msgmerge)
.PHONY: $(outdir)/msgmerge
at.targets += $(outdir)/msgmerge

at.subdirs += ..

include $(topsrcdir)/build-aux/Makefile.tail.mk
