# Copyright (C) 2018-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

# bats test_tags=locale-es
@test "gitget follows cli conventions and fails with 0 args" {
	assert_follows_cli_conventions gitget
	assert_fails_with_errusage gitget
}

@test "gitget forces url for bare" {
	mkdir "$tmpdir/src"
	cd "$tmpdir/src"
	git init .
	git config --local user.email 'libretools-test@localhost'
	git config --local user.name 'Test Suite'
	echo a >a
	git add .
	git commit -m 'initial commit'
	cd ..
	gitget bare src dst.git
	cd dst.git
	[[ "$(git config --get remote.origin.url)" == "$tmpdir/src" ]]
	cd ..
	gitget bare "file://$PWD/src" dst.git || status=$?
	[[ $status != 0 ]]
	gitget -f bare "file://$PWD/src" dst.git
	cd dst.git
	[[ "$(git config --get remote.origin.url)" == "file://$tmpdir/src" ]]
}

# bats test_tags=locale-es
@test "libregit follows cli conventions" {
	assert_follows_cli_conventions libregit
}
