# Copyright (C) 2013-2014, 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

# bats test_tags=locale-es
@test "is_built follows cli conventions" {
	assert_follows_cli_conventions is_built
}

@test "is_built fails with 0 args" {
	assert_fails_with_errusage is_built
}

@test "is_built succeeds with 1 arg" {
	is_built sh >$tmpdir/stdout 2>$tmpdir/stderr

	assert_file_empty $tmpdir/stdout
	assert_file_empty $tmpdir/stderr
}

@test "is_built returns 1 for non existent package" {
	is_built phony-ne-package 100 >$tmpdir/stdout 2>$tmpdir/stderr || status=$?

	[[ $status == 1 ]]
	assert_file_empty $tmpdir/stdout
	assert_file_empty $tmpdir/stderr
}

@test "is_built returns 1 for future packages" {
	# If emacs ever goes rapid release, we might need to change this :P
	is_built emacs 100 >$tmpdir/stdout 2>$tmpdir/stderr || status=$?

	[[ $status == 1 ]]
	assert_file_empty $tmpdir/stdout
	assert_file_empty $tmpdir/stderr
}

@test "is_built returns 0 for past packages" {
	# If emacs ever goes rapid release, we might need to change this :P
	is_built emacs 1 >$tmpdir/stdout 2>$tmpdir/stderr

	assert_file_empty $tmpdir/stdout
	assert_file_empty $tmpdir/stderr
}
