# Copyright (C) 2013, 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

@test "lib/conf.sh sets makepkg vars in custom file" {
	unset PKGDEST
	touch "$tmpdir/makepkg.conf"
	bash -c "$(printf '. $(librelib conf.sh); MAKEPKG_CONF=%q set_var makepkg PKGDEST /pkgdest' "$tmpdir/makepkg.conf")"
	. "$tmpdir/makepkg.conf"
	[[ $PKGDEST == /pkgdest ]]
}

# bats test_tags=sudo
@test "lib/conf.sh figures out HOME when root" {
	# This one is tricky, because it does the job too well, it will find
	# the actual HOME, instead of the test environment HOME.  Therefore, we
	# will just check that [[ $HOME != /root ]]
	cd "$tmpdir"
	echo '. $(librelib conf.sh); echo "$LIBREHOME"' >test.sh
	LIBREHOME=$(testsudo bash ./test.sh)
	[[ $LIBREHOME != /root ]]
}

# bats test_tags=sudo
@test "lib/conf.sh nests LIBREUSER" {
	[[ $USER != root ]]
	cd "$tmpdir"
	echo '. $(librelib conf.sh); echo "$LIBREUSER"' >test.sh

	LIBREUSER=$(testsudo bash ./test.sh)
	[[ $LIBREUSER == "$USER" ]]

	LIBREUSER=$(testsudo testsudo -u "$USER" bash ./test.sh)
	[[ $LIBREUSER == "$USER" ]]
}

@test "lib/conf.sh respects custom HOME" {
	cd "$tmpdir"
	echo '. $(librelib conf.sh); echo "$LIBREHOME"' >test.sh

	export HOME=/foo
	LIBREHOME=$(bash ./test.sh)

	[[ $LIBREHOME == /foo ]]
}
