# Copyright (C) 2013-2014, 2016-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

@test "libremessages can be included twice" {
	. libremessages
	. libremessages
}

@test "libremessages can be included with set euE" {
	( # use a subshell because BATS doesn't like `set -u`
		set -euE
		. libremessages
	)
}

@test "libremessages works with no color and set euE" {
	(
		unset TERM
		set -euE
		. libremessages
		msg Foo
	) >$tmpdir/stdout 2>$tmpdir/stderr

	assert_file_empty $tmpdir/stdout
	assert_file_not_empty $tmpdir/stderr
}

@test "libremessages can be called without including" {
	libremessages msg Foo >$tmpdir/stdout 2>$tmpdir/stderr

	assert_file_empty $tmpdir/stdout
	assert_file_not_empty $tmpdir/stderr
}

@test "libremessages fails with msg and no args" {
	libremessages msg || status=$?
	[[ $status != 0 ]]
}

@test "libremessages allows subheadings to flag" {
	# Note that old versions of `flag` panicked if given an odd
	# number of headings, so give an odd number here.
	libremessages flag \
		-a adesc \
		-b bdesc \
		Head1: \
		-c cdesc >$tmpdir/out
	cat >$tmpdir/exp <<-eot
		  -a            adesc
		  -b            bdesc
		 Head1:
		  -c            cdesc
	eot
	diff -u $tmpdir/exp $tmpdir/out
}

@test "libremessages is quiet on stdout on errs" {
	LC_ALL=C bash -euE -c '. libremessages; setup_traps; false' >"$tmpdir/stdout" 2>"$tmpdir/stderr" || status=$?

	[[ $status != 0 ]]
	assert_file_empty "$tmpdir/stdout"
	grep '==> ERROR:' "$tmpdir/stderr"
}

# bats test_tags=locale-es
@test "libremessages follows cli conventions" {
	assert_follows_cli_conventions libremessages
}
