# Copyright (C) 2017-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

setup() {
	libretools_common_per_test_setup

	install -Dm644 /dev/stdin "$XDG_CONFIG_HOME/libretools/libredbdiff.conf" <<-'eot'
		statedir="$PWD"
		mirror_prbl='https://repo.parabola.nu/$repo/os/$arch'
		mirror_arch='https://mirrors.kernel.org/archlinux/$repo/os/$arch'
		repos=(libre)
	eot
}

# bats test_tags=locale-es
@test "libredbdiff follows cli conventions" {
	assert_follows_cli_conventions libredbdiff
	assert_shows_usage libredbdiff --help --noupdate
	assert_shows_usage libredbdiff --noupdate --help
}

@test "libredbdiff handles packages with multiple provides explicit" {
	cd fixtures/libredbdiff/statedir

	libredbdiff -n libre >$tmpdir/stdout 2>$tmpdir/stderr

	assert_file_empty $tmpdir/stderr
	diff -w ../expected-explicit.txt $tmpdir/stdout
}

@test "libredbdiff handles packages with multiple provides implicit" {
	cd fixtures/libredbdiff/statedir

	libredbdiff -n >$tmpdir/stdout 2>$tmpdir/stderr

	assert_file_empty $tmpdir/stderr
	diff -w ../expected-implicit.txt $tmpdir/stdout
}

@test "libredbdiff fails on bad repo args" {
	cd fixtures/libredbdiff/statedir

	libredbdiff -n bogus >$tmpdir/stdout 2>$tmpdir/stderr || status=$?

	[[ $status != 0 ]]
	assert_file_empty $tmpdir/stdout
	assert_file_not_empty $tmpdir/stderr
}
