# Copyright (C) 2013-2014, 2016-2018, 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

# bats test_tags=locale-es
@test "librelib follows cli conventions and fails with not-1 args" {
	assert_follows_cli_conventions librelib
	assert_fails_with_errusage librelib
	assert_fails_with_errusage librelib a b
}

# Nothing in $(libdir) should be executable anymore (except that
# $(libexecdir)=$(libdir), and executable things go in there. But I
# digress, libremessages should not be executable anymore).
@test "librelib finds messages" {
	v1=$(librelib messages)
	v2=$(librelib libremessages)
	v3=$(librelib messages.sh)
	v4=$(librelib libremessages.sh)

	[[ -r $v1 && ! -x $v1 ]]
	[[ $v1 == "$v2" ]]
	[[ $v1 == "$v3" ]]
	[[ $v1 == "$v4" ]]
}

# conf.sh is non-executable
@test "librelib finds conf" {
	v1=$(librelib conf)
	v2=$(librelib libreconf)
	v3=$(librelib conf.sh)
	v4=$(librelib libreconf.sh)

	[[ -r $v1 && ! -x $v1 ]]
	[[ $v1 == "$v2" ]]
	[[ $v1 == "$v3" ]]
	[[ $v1 == "$v4" ]]
}

@test "librelib fails to find phony" {
	librelib phony >$tmpdir/stdout 2>$tmpdir/stderr || status=$?

	assert_file_empty $tmpdir/stdout
	assert_file_not_empty $tmpdir/stderr
	[[ $status != 0 ]]
}
