# Copyright (C) 2024  Bill Auger <bill-auger@programmer.net>
# Copyright (C) 2024  Luke T. Shumaker <lukeshu@parabola.nu>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of Parabola Libretools.
#
# Libretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Libretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Libretools.  If not, see <http://www.gnu.org/licenses/>.

load ../lib/common

release_notification() (
	. <(sed '/^main "$@"/d' "$(librelib librerelease-pbot-notify)")
	release_notification "$@"
)

@test "release_notification parses db-update log" {
	run release_notification tester <fixtures/librerelease-pbot-notify/librerelease-complete-log.log
	assert_success
	assert_equal "$output" "tester just published: (foo 1.2.3)->libre-testing/i686"
}

@test "release_notification parses db-update log - debug-pkg" {
	run release_notification tester <fixtures/librerelease-pbot-notify/librerelease-debug-pkg.log
	assert_success
	assert_equal "$output" "tester just published: (foo 1.2.3)->libre/i686"
}

@test "release_notification parses db-update log - multipkg-any" {
	run release_notification tester <fixtures/librerelease-pbot-notify/librerelease-multipkg-any.log
	assert_success
	assert_equal "$output" "tester just published: (gitget 20240221.1)->libre/armv7h (gitget 20240221.1)->libre/i686 (gitget 20240221.1)->libre/x86_64 (librelib 20240221.1)->libre/armv7h (librelib 20240221.1)->libre/i686 (librelib 20240221.1)->libre/x86_64 (libretools 20240221.1)->libre/armv7h (libretools 20240221.1)->libre/i686 (libretools 20240221.1)->libre/x86_64"
}

@test "release_notification parses db-update log - multipkg-multirepo-any" {
	run release_notification tester <fixtures/librerelease-pbot-notify/librerelease-multipkg-multirepo-any.log
	assert_success
	assert_equal "$output" "tester just published: (gitget 20240221.1)->libre-testing/i686 (gitget 20240221.1)->libre-testing/x86_64 (gitget 20240221.1)->libre/armv7h (librelib 20240221.1)->libre-testing/i686 (librelib 20240221.1)->libre-testing/x86_64 (librelib 20240221.1)->libre/armv7h (libretools 20240221.1)->libre-testing/i686 (libretools 20240221.1)->libre-testing/x86_64 (libretools 20240221.1)->libre/armv7h"
}

@test "release_notification parses db-update log - multipkg-multirepo-multiarch" {
	run release_notification tester <fixtures/librerelease-pbot-notify/librerelease-multipkg-multirepo-multiarch.log
	assert_success
	assert_equal "$output" "tester just published: (bar 1.2.3)->libre/i686 (foo 1.2.3)->libre-testing/x86_64"
}

@test "release_notification parses db-update log - multirepo-multiarch" {
	run release_notification tester <fixtures/librerelease-pbot-notify/librerelease-multirepo-multiarch.log
	assert_success
	assert_equal "$output" "tester just published: (foo 1.2.3)->libre-testing/x86_64 (foo 1.2.3)->libre/i686"
}
